/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape;

import com.miginfocom.ashape.interaction.AbstractInteractor;
import com.miginfocom.ashape.interaction.DefaultInteractionBroker;
import com.miginfocom.ashape.interaction.Interaction;
import com.miginfocom.ashape.interaction.MouseKeyInteractor;
import com.miginfocom.ashape.shapes.AShape;
import com.miginfocom.ashape.shapes.AbstractAShape;
import com.miginfocom.ashape.shapes.ContainerAShape;
import com.miginfocom.ashape.shapes.DrawAShape;
import com.miginfocom.ashape.shapes.FeatherAShape;
import com.miginfocom.ashape.shapes.FillAShape;
import com.miginfocom.ashape.shapes.RootAShape;
import com.miginfocom.ashape.shapes.TextAShape;
import com.miginfocom.calendar.activity.ActivityInteractor;
import com.miginfocom.calendar.activity.view.ActivityViewInteractionBroker;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.command.CommandSet;
import com.miginfocom.util.command.DefaultCommand;
import com.miginfocom.util.expression.AndExpression;
import com.miginfocom.util.expression.Expression;
import com.miginfocom.util.expression.LogicalExpression;
import com.miginfocom.util.expression.StaticExpression;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.RoundRectangle;
import com.miginfocom.util.gfx.SliceSpec;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.numbers.AtEnd;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import com.miginfocom.util.io.IOUtil;
import com.miginfocom.util.states.GenericStates;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class AShapeUtil {
    private static final IdentityHashMap a = new IdentityHashMap(16);
    public static final String DEFAULT_CONTAINER_SHAPE_NAME = "defaultContainer";
    public static final String DEFAULT_BACKGROUND_SHAPE_NAME = "defaultBackground";
    public static final String DEFAULT_TITLE_TEXT_SHAPE_NAME = "defaultTitleText";
    public static final String DEFAULT_MAIN_TEXT_SHAPE_NAME = "defaultMainText";
    public static final String DEFAULT_OUTLINE_SHAPE_NAME = "defaultOutline";
    public static final String DEFAULT_SHADOW_SHAPE_SHAPE_NAME = "defaultShadowShape";
    public static final String DEFAULT_SHADOW_SHAPE_NAME = "defaultShadow";

    public static final Map toPropertyKeyMap(Map map) {
        if (map == null || map.size() == 0) {
            return map;
        }
        Object object = map.keySet().iterator().next();
        if (!(object instanceof PropertyKey)) {
            IdentityHashMap identityHashMap = new IdentityHashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                object = entry.getKey();
                if (!(object instanceof PropertyKey)) {
                    object = PropertyKey.getKey(object != null ? object.toString() : "null");
                }
                identityHashMap.put(object, entry.getValue());
            }
            return identityHashMap;
        }
        return map;
    }

    public static void saveShape(RootAShape rootAShape, String string, boolean bl) throws IOException {
        FilterOutputStream filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        if (bl) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(filterOutputStream);
            zipOutputStream.setLevel(9);
            zipOutputStream.putNextEntry(new ZipEntry("AShape"));
            filterOutputStream = zipOutputStream;
        }
        IOUtil.writeXMLObject(filterOutputStream, rootAShape);
    }

    public static RootAShape loadShape(String string, boolean bl) throws IOException {
        return AShapeUtil.loadShape(new FileInputStream(string), bl);
    }

    public static RootAShape loadShape(InputStream inputStream, boolean bl) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream, 16384);
        }
        if (IOUtil.isZippedStream(inputStream, bl)) {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null && !zipEntry.getName().equals("AShape")) {
            }
            if (zipEntry == null) {
                throw new IOException("Theme does't contain an entry 'AShape'");
            }
            inputStream = zipInputStream;
        }
        return (RootAShape)new XMLDecoder(inputStream).readObject();
    }

    private static void a(RootAShape rootAShape) {
        if (rootAShape == null) {
            throw new IllegalArgumentException("Operation is not valid without a RootAShape at top of shape tree!");
        }
    }

    public static Insets getRepaintPadding(RootAShape[] rootAShapeArray, Insets insets) {
        for (int i = 0; i < rootAShapeArray.length; ++i) {
            GfxUtil.unionInsets(insets, rootAShapeArray[i].getRepaintPadding());
        }
        return insets;
    }

    public static void addMouseCommand(AShape aShape, PropertyKey propertyKey, boolean bl, CommandSet commandSet, CommandSet commandSet2, boolean bl2, boolean bl3) {
        LogicalExpression logicalExpression;
        int n;
        RootAShape rootAShape = aShape.getRoot();
        AShapeUtil.a(rootAShape);
        PropertyKey propertyKey2 = (PropertyKey)a.get(propertyKey);
        if (propertyKey2 == null) {
            throw new IllegalStateException("Unsupported trigger: " + propertyKey);
        }
        if (commandSet != null) {
            n = bl2 ? 9 : 7;
            logicalExpression = new LogicalExpression(propertyKey2, n, (Object)aShape.getName());
            rootAShape.addInteraction(new Interaction(propertyKey, bl, logicalExpression, commandSet, bl3));
        }
        if (commandSet2 != null) {
            n = bl2 ? 10 : 8;
            logicalExpression = new LogicalExpression(propertyKey2, n, (Object)aShape.getName());
            rootAShape.addInteraction(new Interaction(propertyKey, bl, logicalExpression, commandSet2, bl3));
        }
    }

    public static List addEnterExitCommands(AShape aShape, CommandSet commandSet, CommandSet commandSet2, boolean bl) {
        RootAShape rootAShape = aShape.getRoot();
        AShapeUtil.a(rootAShape);
        String string = aShape.getName();
        ArrayList<Interaction> arrayList = new ArrayList<Interaction>(2);
        if (bl) {
            LogicalExpression logicalExpression;
            PropertyKey propertyKey;
            PropertyKey propertyKey2 = MouseKeyInteractor.MOUSE_OVER_TOPMOST_CHANGE;
            int n = 0;
            if (commandSet2 != null) {
                propertyKey = MouseKeyInteractor.PROP_MOUSE_OVER_TOPMOST_EXIT;
                logicalExpression = new LogicalExpression(propertyKey, n, (Object)string);
                arrayList.add(new Interaction(propertyKey2, false, logicalExpression, commandSet2, false));
            }
            if (commandSet != null) {
                propertyKey = MouseKeyInteractor.PROP_MOUSE_OVER_TOPMOST_ENTER;
                logicalExpression = new LogicalExpression(propertyKey, n, (Object)string);
                arrayList.add(new Interaction(propertyKey2, true, logicalExpression, commandSet, false));
            }
        } else {
            LogicalExpression logicalExpression;
            PropertyKey propertyKey;
            PropertyKey propertyKey3 = MouseKeyInteractor.MOUSE_OVER_CHANGE;
            int n = 7;
            if (commandSet2 != null) {
                propertyKey = MouseKeyInteractor.PROP_MOUSE_EXIT_LIST;
                logicalExpression = new LogicalExpression(propertyKey, n, (Object)string);
                arrayList.add(new Interaction(propertyKey3, false, logicalExpression, commandSet2, false));
            }
            if (commandSet != null) {
                propertyKey = MouseKeyInteractor.PROP_MOUSE_ENTER_LIST;
                logicalExpression = new LogicalExpression(propertyKey, n, (Object)string);
                arrayList.add(new Interaction(propertyKey3, true, logicalExpression, commandSet, false));
            }
        }
        rootAShape.addInteractions(arrayList);
        return arrayList;
    }

    public static void addMouseEventBlock(AShape aShape, boolean bl, Integer n) {
        Serializable serializable;
        RootAShape rootAShape = aShape.getRoot();
        AShapeUtil.a(rootAShape);
        aShape.setAttribute(AShape.A_REPORT_HIT_AREA, Boolean.TRUE);
        Expression expression = null;
        LogicalExpression logicalExpression = new LogicalExpression(MouseKeyInteractor.PROP_MOUSE_MOVE_LIST, 7, (Object)aShape.getName());
        if (n != null) {
            serializable = new LogicalExpression(MouseKeyInteractor.PROP_EVENT_TYPE, 0, (Object)n);
            expression = new AndExpression((Expression)serializable, logicalExpression);
        } else {
            expression = logicalExpression;
        }
        serializable = bl ? MouseKeyInteractor.MOUSE_EVENT_PRE : MouseKeyInteractor.MOUSE_EVENT_POST;
        rootAShape.addInteraction(new Interaction((PropertyKey)serializable, true, expression, new DefaultCommand(), true));
    }

    public static void enableMouseOverState(AShape aShape) {
        PropertyKey propertyKey = ActivityViewInteractionBroker.CMD_SET_STATE;
        PropertyKey propertyKey2 = GenericStates.MOUSE_OVER;
        DefaultCommand defaultCommand = new DefaultCommand(propertyKey, propertyKey2, (Object)Boolean.TRUE, null);
        DefaultCommand defaultCommand2 = new DefaultCommand(propertyKey, propertyKey2, (Object)Boolean.FALSE, null);
        AShapeUtil.addEnterExitCommands(aShape, defaultCommand, defaultCommand2, false);
    }

    public static void enableMouseOverCursor(RootAShape rootAShape) {
        PropertyKey propertyKey = DefaultInteractionBroker.CMD_SET_CURSOR_FROM_ASHAPE;
        PropertyKey propertyKey2 = MouseKeyInteractor.PROP_MOUSE_OVER_LIST;
        LogicalExpression logicalExpression = new LogicalExpression(propertyKey2, 12, null);
        DefaultCommand defaultCommand = new DefaultCommand(propertyKey, propertyKey2, (Object)rootAShape, null);
        rootAShape.addInteraction(new Interaction(MouseKeyInteractor.MOUSE_MOVE, true, logicalExpression, defaultCommand, false));
    }

    public static void addMouseOverride(AShape aShape, AShape aShape2, PropertyKey propertyKey, PropertyKey propertyKey2, Object object, boolean bl, boolean bl2, boolean bl3) {
        PropertyKey propertyKey3 = DefaultInteractionBroker.CMD_ADD_OVERRIDE;
        PropertyKey propertyKey4 = DefaultInteractionBroker.CMD_REMOVE_OVERRIDE;
        DefaultCommand defaultCommand = new DefaultCommand(propertyKey3, propertyKey2, object, aShape2.getName());
        DefaultCommand defaultCommand2 = bl2 ? new DefaultCommand(propertyKey4, null, defaultCommand.getID(), null) : null;
        AShapeUtil.addMouseCommand(aShape, propertyKey, true, defaultCommand, defaultCommand2, bl, bl3);
    }

    public static void addMousePressedOverride(AShape aShape, AShape aShape2, PropertyKey propertyKey, Object object, boolean bl, boolean bl2) {
        PropertyKey propertyKey2 = DefaultInteractionBroker.CMD_ADD_OVERRIDE;
        PropertyKey propertyKey3 = DefaultInteractionBroker.CMD_REMOVE_OVERRIDE;
        DefaultCommand defaultCommand = new DefaultCommand(propertyKey2, propertyKey, object, aShape2.getName());
        DefaultCommand defaultCommand2 = new DefaultCommand(propertyKey3, null, defaultCommand.getID(), null);
        RootAShape rootAShape = aShape.getRoot();
        AShapeUtil.a(rootAShape);
        int n = bl ? 9 : 7;
        LogicalExpression logicalExpression = new LogicalExpression(MouseKeyInteractor.PROP_MOUSE_PRESS_LIST, n, (Object)aShape.getName());
        rootAShape.addInteraction(new Interaction(MouseKeyInteractor.MOUSE_PRESS, true, logicalExpression, defaultCommand, bl2));
        rootAShape.addInteraction(new Interaction(MouseKeyInteractor.MOUSE_RELEASE, false, new StaticExpression(true), defaultCommand2, bl2));
    }

    public static void addEnterExitOverride(AShape aShape, AShape aShape2, PropertyKey propertyKey, Object object, boolean bl, boolean bl2) {
        PropertyKey propertyKey2 = DefaultInteractionBroker.CMD_ADD_OVERRIDE;
        PropertyKey propertyKey3 = DefaultInteractionBroker.CMD_REMOVE_OVERRIDE;
        DefaultCommand defaultCommand = new DefaultCommand(propertyKey2, propertyKey, object, aShape2.getName());
        DefaultCommand defaultCommand2 = bl2 ? new DefaultCommand(propertyKey3, null, defaultCommand.getID(), null) : null;
        AShapeUtil.addEnterExitCommands(aShape, defaultCommand, defaultCommand2, bl);
    }

    public static void addMouseRemoveOverride(AShape aShape, AShape aShape2, PropertyKey propertyKey, boolean bl, PropertyKey propertyKey2, Object object, boolean bl2, boolean bl3) {
        PropertyKey propertyKey3 = DefaultInteractionBroker.CMD_REMOVE_OVERRIDE;
        DefaultCommand defaultCommand = new DefaultCommand(propertyKey3, propertyKey2, object, aShape2.getName());
        AShapeUtil.addMouseCommand(aShape, propertyKey, bl, defaultCommand, null, bl2, bl3);
    }

    public static void setStateOverride(AShape aShape, PropertyKey propertyKey, PropertyKey propertyKey2, Object object) {
        LogicalExpression logicalExpression = new LogicalExpression(propertyKey, 0, (Object)Boolean.TRUE);
        DefaultCommand defaultCommand = new DefaultCommand(DefaultInteractionBroker.CMD_ADD_OVERRIDE, propertyKey2, object, aShape.getName());
        aShape.getRoot().addInteraction(new Interaction(ActivityInteractor.STATE, true, logicalExpression, defaultCommand, false));
        LogicalExpression logicalExpression2 = new LogicalExpression(propertyKey, 1, (Object)Boolean.TRUE);
        DefaultCommand defaultCommand2 = new DefaultCommand(DefaultInteractionBroker.CMD_REMOVE_OVERRIDE, null, defaultCommand.getID(), null);
        aShape.getRoot().addInteraction(new Interaction(ActivityInteractor.STATE, true, logicalExpression2, defaultCommand2, false));
    }

    public static void addStaticOverride(AShape aShape, PropertyKey propertyKey, Object object) {
        StaticExpression staticExpression = new StaticExpression(true);
        DefaultCommand defaultCommand = new DefaultCommand(DefaultInteractionBroker.CMD_ADD_OVERRIDE, propertyKey, object, aShape.getName());
        aShape.getRoot().addInteraction(new Interaction(AbstractInteractor.TRIGGER_ONCE, true, staticExpression, defaultCommand, false));
    }

    public static void addMouseFireEvent(AShape aShape, PropertyKey propertyKey, Object object, boolean bl, boolean bl2, Integer n) {
        Serializable serializable;
        RootAShape rootAShape = aShape.getRoot();
        AShapeUtil.a(rootAShape);
        PropertyKey propertyKey2 = (PropertyKey)a.get(propertyKey);
        if (propertyKey2 == null) {
            throw new IllegalStateException("Unsupported trigger: " + propertyKey);
        }
        int n2 = bl ? 9 : 7;
        Expression expression = new LogicalExpression(propertyKey2, n2, (Object)aShape.getName());
        if (n != null) {
            serializable = new LogicalExpression(MouseKeyInteractor.PROP_MOUSE_BUTTON, 0, (Object)n);
            expression = new AndExpression(expression, (Expression)serializable);
        }
        serializable = new DefaultCommand(DefaultInteractionBroker.CMD_FIRE_INTERACTION_EVENT, null, object, null);
        rootAShape.addInteraction(new Interaction(propertyKey, true, expression, (CommandSet)serializable, bl2));
    }

    public static AShape[] setResizeBoxes(AShape aShape, int n, int n2) {
        Object object;
        boolean bl = n == 0;
        int n3 = bl ? 2 : 1;
        int n4 = bl ? 4 : 3;
        Integer n5 = n2;
        AShape[] aShapeArray = aShape.getSubShapes();
        for (int i = 0; i < aShapeArray.length; ++i) {
            object = aShapeArray[i].getName();
            if (object == null || !((String)object).startsWith("startResize@") && !((String)object).startsWith("endResize@")) continue;
            aShape.removeSubShape(aShapeArray[i]);
        }
        if (n != -1) {
            ContainerAShape containerAShape = new ContainerAShape("startResize@" + Math.random(), new AbsRect(n3, n5));
            object = new ContainerAShape("endResize@" + Math.random(), new AbsRect(n4, n5));
            Cursor cursor = Cursor.getPredefinedCursor(bl ? 11 : 8);
            Cursor cursor2 = Cursor.getPredefinedCursor(bl ? 10 : 9);
            containerAShape.setAttribute(AShape.A_REPORT_HIT_AREA, Boolean.TRUE);
            containerAShape.setAttribute(AShape.A_MOUSE_CURSOR, cursor);
            ((AbstractAShape)object).setAttribute(AShape.A_REPORT_HIT_AREA, Boolean.TRUE);
            ((AbstractAShape)object).setAttribute(AShape.A_MOUSE_CURSOR, cursor2);
            aShape.addSubShape(containerAShape);
            aShape.addSubShape((AShape)object);
            String string = "resizeStartPressed";
            String string2 = "resizeEndPressed";
            Integer n6 = new Integer(1);
            PropertyKey propertyKey = MouseKeyInteractor.MOUSE_PRESS;
            AShapeUtil.addMouseFireEvent(containerAShape, propertyKey, string, true, true, n6);
            AShapeUtil.addMouseFireEvent((AShape)object, propertyKey, string2, true, true, n6);
            return new AShape[]{containerAShape, object};
        }
        return null;
    }

    public static RootAShape createDefaultNoFitShape(String string) {
        AbsRect absRect = new AbsRect(new AtEnd(-15.0f), new AtEnd(-7.0f), null, null);
        Rectangle rectangle = new Rectangle(0, 0, 14, 6);
        DrawAShape drawAShape = new DrawAShape("noFitOutline", (Shape)rectangle, (PlaceRect)absRect, (Paint)new Color(120, 120, 120), (Stroke)new BasicStroke(1.0f), 0);
        FillAShape fillAShape = new FillAShape("noFitFill", (Shape)rectangle, (PlaceRect)absRect, (Paint)Color.WHITE, 1);
        Shape[] shapeArray = new Rectangle[]{new Rectangle(2, 2, 2, 2), new Rectangle(6, 2, 2, 2), new Rectangle(10, 2, 2, 2)};
        FillAShape fillAShape2 = new FillAShape("noFitDots", (Shape)rectangle, shapeArray, (PlaceRect)absRect, (Paint)new Color(100, 100, 100), 1);
        RootAShape rootAShape = new RootAShape();
        rootAShape.addSubShape(fillAShape);
        rootAShape.addSubShape(fillAShape2);
        rootAShape.addSubShape(drawAShape);
        Integer n = 1;
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_DOUBLE_CLICK, string, true, true, n);
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_CLICK, string, true, true, n);
        AShapeUtil.addEnterExitOverride(drawAShape, drawAShape, AShape.A_PAINT, Color.BLACK, true, true);
        drawAShape.setAttribute(AShape.A_REPORT_HIT_AREA, Boolean.TRUE);
        drawAShape.setAttribute(AShape.A_MOUSE_CURSOR, Cursor.getPredefinedCursor(12));
        AShapeUtil.enableMouseOverCursor(rootAShape);
        AShapeUtil.addMouseEventBlock(drawAShape, false, 503);
        return rootAShape;
    }

    public static RootAShape createDefault(int n) {
        return AShapeUtil.createDefault(n, "");
    }

    public static RootAShape createDefault(int n, String string) {
        if (string == null) {
            string = "";
        }
        Color color = new Color(200, 200, 200, 255);
        Color color2 = new Color(100, 100, 150);
        Color color3 = new Color(50, 50, 50);
        Paint paint = null;
        Font font = new Font("sansserif", 1, 11);
        RootAShape rootAShape = new RootAShape(string + "root");
        ContainerAShape containerAShape = new ContainerAShape(string + DEFAULT_CONTAINER_SHAPE_NAME, AbsRect.FILL);
        FillAShape fillAShape = new FillAShape(string + DEFAULT_BACKGROUND_SHAPE_NAME, (Shape)new RoundRectangle(0.0, 0.0, 1.0, 1.0, 8.0, 8.0), (PlaceRect)AbsRect.FILL_UPPER_LEFT, (Paint)color, 3);
        AbsRect absRect = new AbsRect(new AtStart(2.0f), new AtStart(1.0f), new AtEnd(0.0f), new AtStart(14.0f), null, null, null);
        TextAShape textAShape = new TextAShape(string + DEFAULT_TITLE_TEXT_SHAPE_NAME, "$startTime$ - $endTimeExcl$ ($timeZoneShort$)", (PlaceRect)absRect, 1, font, (Paint)color3, (AtRefRangeNumber)new AtStart(0.0f), (AtRefRangeNumber)new AtStart(-3.0f), 9);
        textAShape.setAttribute(AShape.A_CLIP_TYPE, "ParentBounds");
        AbsRect absRect2 = new AbsRect(new AtStart(2.0f), new AtStart(16.0f), new AtEnd(0.0f), new AtEnd(0.0f), null, null, null);
        TextAShape textAShape2 = new TextAShape(string + DEFAULT_MAIN_TEXT_SHAPE_NAME, "$summary$", (PlaceRect)absRect2, 0, font, (Paint)color3, (AtRefRangeNumber)new AtStart(0.0f), (AtRefRangeNumber)new AtStart(0.0f), 9);
        DrawAShape drawAShape = new DrawAShape(string + DEFAULT_OUTLINE_SHAPE_NAME, (Shape)new RoundRectangle(0.0, 0.0, 1.0, 1.0, 8.0, 8.0), (PlaceRect)AbsRect.FILL, (Paint)color2, (Stroke)new BasicStroke(1.0f), 3);
        drawAShape.setAttribute(AShape.A_MOUSE_CURSOR, Cursor.getPredefinedCursor(13));
        drawAShape.setAttribute(AShape.A_REPORT_HIT_AREA, Boolean.TRUE);
        AbsRect absRect3 = new AbsRect(new AtStart(0.0f), new AtStart(0.0f), new AtEnd(0.0f), new AtEnd(0.0f), null, null, new Insets(-2, -2, 2, 2));
        FillAShape fillAShape2 = new FillAShape(string + DEFAULT_SHADOW_SHAPE_SHAPE_NAME, (Shape)new RoundRectangle(0.0, 0.0, 1.0, 1.0, 5.0, 5.0), (PlaceRect)absRect3, paint, 3);
        SliceSpec sliceSpec = new SliceSpec(new Insets(10, 10, 10, 10), 101, SliceSpec.OPT_BORDER);
        FeatherAShape featherAShape = new FeatherAShape(string + DEFAULT_SHADOW_SHAPE_NAME, fillAShape2, new Color(255, 255, 255, 0), 5.0f, sliceSpec);
        fillAShape.addSubShape(textAShape);
        fillAShape.addSubShape(textAShape2);
        containerAShape.addSubShape(featherAShape);
        containerAShape.addSubShape(fillAShape);
        containerAShape.addSubShape(drawAShape);
        rootAShape.addSubShape(containerAShape);
        rootAShape.setRepaintPadding(new Insets(4, 4, 4, 4));
        AShapeUtil.enableMouseOverCursor(rootAShape);
        AShapeUtil.enableMouseOverState(drawAShape);
        AShapeUtil.setResizeBoxes(drawAShape, n, 4);
        Integer n2 = new Integer(1);
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_PRESS, "selectedPressed", true, false, n2);
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_PRESS, "dragPressed", true, true, n2);
        DefaultCommand defaultCommand = new DefaultCommand(DefaultInteractionBroker.CMD_FIRE_INTERACTION_EVENT, null, (Object)"mouseEntered", null);
        DefaultCommand defaultCommand2 = new DefaultCommand(DefaultInteractionBroker.CMD_FIRE_INTERACTION_EVENT, null, (Object)"mouseExited", null);
        AShapeUtil.addEnterExitCommands(drawAShape, defaultCommand, defaultCommand2, true);
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_CLICK, "clicked", true, false, n2);
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_DOUBLE_CLICK, "doubleClicked", true, true, n2);
        AShapeUtil.addMouseFireEvent(drawAShape, MouseKeyInteractor.MOUSE_POPUP_TRIGGER, "popupTriggger", true, true, null);
        DefaultCommand defaultCommand3 = new DefaultCommand(DefaultInteractionBroker.CMD_SET_OVERRIDE, AShape.A_UNDERLINE_HEIGHT, null, string + DEFAULT_MAIN_TEXT_SHAPE_NAME);
        DefaultCommand defaultCommand4 = new DefaultCommand(DefaultInteractionBroker.CMD_REMOVE_OVERRIDE, AShape.A_UNDERLINE_HEIGHT, null, string + DEFAULT_MAIN_TEXT_SHAPE_NAME);
        AShapeUtil.addEnterExitCommands(drawAShape, defaultCommand3, defaultCommand4, false);
        AShapeUtil.addMouseEventBlock(drawAShape, false, new Integer(503));
        return rootAShape;
    }

    static {
        a.put(MouseKeyInteractor.MOUSE_PRESS, MouseKeyInteractor.PROP_MOUSE_PRESS_LIST);
        a.put(MouseKeyInteractor.MOUSE_RELEASE, MouseKeyInteractor.PROP_MOUSE_RELEASE_LIST);
        a.put(MouseKeyInteractor.MOUSE_CLICK, MouseKeyInteractor.PROP_MOUSE_CLICK_LIST);
        a.put(MouseKeyInteractor.MOUSE_DOUBLE_CLICK, MouseKeyInteractor.PROP_MOUSE_DOUBLE_CLICK_LIST);
        a.put(MouseKeyInteractor.MOUSE_DRAG, MouseKeyInteractor.PROP_MOUSE_DRAG_LIST);
        a.put(MouseKeyInteractor.MOUSE_ENTER, MouseKeyInteractor.PROP_MOUSE_ENTER_LIST);
        a.put(MouseKeyInteractor.MOUSE_EXIT, MouseKeyInteractor.PROP_MOUSE_EXIT_LIST);
        a.put(MouseKeyInteractor.MOUSE_MOVE, MouseKeyInteractor.PROP_MOUSE_MOVE_LIST);
        a.put(MouseKeyInteractor.MOUSE_OVER_CHANGE, MouseKeyInteractor.PROP_MOUSE_OVER_LIST);
        a.put(MouseKeyInteractor.MOUSE_POPUP_TRIGGER, MouseKeyInteractor.PROP_MOUSE_POPUP_TRIGGER_LIST);
    }
}

