/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation;

import com.miginfocom.ashape.animation.Function;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class ExponentFunction
implements Function {
    private static final double[] a = new double[0];
    private final transient double b;
    private static final long serialVersionUID = 1L;

    public ExponentFunction(double d) {
        this.b = d;
    }

    @Override
    public final double f(double d) {
        return Math.pow(d, this.b);
    }

    @Override
    public final double[] solve(double d, Double d2, Double d3) {
        double d4 = Math.pow(d, 1.0 / this.b);
        if (d2 != null && (double)d2.intValue() > d4 || d3 != null && (double)d3.intValue() < d4) {
            return a;
        }
        return new double[]{d4};
    }

    public double getExponent() {
        return this.b;
    }

    @Override
    public boolean isSolvable() {
        return true;
    }

    @Override
    public Function cloneFunction() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExponentFunction)) {
            return false;
        }
        ExponentFunction exponentFunction = (ExponentFunction)object;
        return this.b == exponentFunction.b;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == ExponentFunction.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(ExponentFunction.class, new DefaultPersistenceDelegate(new String[]{"exponent"}));
    }
}

