/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation;

import com.miginfocom.ashape.animation.Function;
import com.miginfocom.ashape.animation.LinearFunction;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TimeLine
implements Serializable,
Cloneable {
    private static final Function a = new LinearFunction();
    public static final int REP_NONE = 0;
    public static final int REP_CYCLE = 1;
    public static final int REP_REVERSE = 2;
    protected final transient int duration;
    protected final transient int tickCount;
    protected final transient Function func;
    protected final transient int repeatType;
    protected final transient int repeatCount;
    protected final transient boolean isTimeBased;
    protected final transient int lastTick;
    private transient int b = 0;
    private transient long c = -1L;
    private transient int d = 1;
    private transient long e;
    private transient double f = 0.0;
    private transient double g = 0.0;
    private transient int h = 0;
    private static final Double i = null;
    private static final Double j = null;
    private transient int k;
    private static final long serialVersionUID = 1L;

    public TimeLine(int n, int n2) {
        this(n, n2, 0, 0, a, true);
    }

    public TimeLine(int n, int n2, Function function, boolean bl) {
        this(n, n2, 0, 0, function, bl);
    }

    public TimeLine(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, a, true);
    }

    public TimeLine(int n, int n2, int n3, int n4, Function function, boolean bl) {
        if (!bl && !function.isSolvable()) {
            throw new IllegalArgumentException("If value based the function must be solvable!");
        }
        this.duration = n;
        this.tickCount = n2;
        this.lastTick = n2 - 1;
        this.func = function;
        this.repeatType = n3;
        this.repeatCount = n4;
        this.isTimeBased = bl;
    }

    public synchronized void play(Double d, Integer n) {
        this.a(d, n, true);
    }

    public synchronized void pause(Double d, Integer n) {
        this.a(d, n, false);
    }

    private void a(Double d, Integer n, boolean bl) {
        this.a();
        this.freezeValues();
        if (n != null) {
            this.d = n;
        }
        if (d != null) {
            this.a(d);
        }
        this.a(bl);
        this.unfreezeValues();
    }

    private void a(boolean bl) {
        this.freezeValues();
        if (bl) {
            this.c = (long)((double)this.e - (double)this.duration * this.f * (double)this.d + 0.5);
        } else {
            this.c = -1L;
            this.b = 0;
        }
        this.unfreezeValues();
    }

    public synchronized Integer getDelayToNextTick() {
        Integer n = null;
        this.freezeValues();
        if (this.c != -1L) {
            double d = (double)(this.h + this.d) / (double)this.lastTick;
            if (this.isTimeBased) {
                int n2 = (int)((double)this.duration * (d - this.f) + 0.5);
                n = new Integer(Math.abs(n2));
            } else {
                if (d < 1.0E-5) {
                    d = 0.0;
                } else if (d > 0.99999) {
                    d = 1.0;
                }
                double[] dArray = this.func.solve(d, i, j);
                for (int i = 0; i < dArray.length; ++i) {
                    int n3 = (int)((double)this.duration * (dArray[i] - this.f) + 0.5);
                    if ((n3 *= this.d) < 0) continue;
                    n = new Integer(n3);
                    break;
                }
            }
        }
        this.unfreezeValues();
        return n;
    }

    public synchronized double getCurrentTick() {
        this.freezeValues();
        double d = this.g;
        this.unfreezeValues();
        return d;
    }

    public synchronized double getLastTick() {
        return this.d == 1 ? (double)this.lastTick : 0.0;
    }

    private void a(double d) {
        if (this.k != 1) {
            throw new IllegalStateException("setPosFz can only be called when the values are frozen!");
        }
        this.f = d;
        this.unfreezeValues();
        this.freezeValues();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TimeLine)) {
            return false;
        }
        TimeLine timeLine = (TimeLine)object;
        return this.duration == timeLine.duration && this.repeatCount == timeLine.repeatCount && this.repeatType == timeLine.repeatType && this.tickCount == timeLine.tickCount && MigUtil.equals(this.func, timeLine.func);
    }

    public synchronized void freezeValues() {
        if (this.k++ == 0) {
            this.e = System.currentTimeMillis();
            if (this.c != -1L) {
                this.f = (double)(this.e - this.c) / (double)this.duration;
                if (this.d == -1) {
                    this.f = -this.f;
                }
                if (this.f > 1.0 && this.f < 1.000001) {
                    this.f = 1.0;
                }
                if (this.f < 0.0 && this.f > -1.0E-6) {
                    this.f = 0.0;
                }
                this.b();
                if (this.f > 1.0) {
                    this.f = 1.0;
                    this.c = -1L;
                    this.b = 0;
                } else if (this.f < 0.0) {
                    this.f = 0.0;
                    this.c = -1L;
                    this.b = 0;
                }
            }
            this.g = this.func.f(this.f) * (double)this.lastTick;
            if (this.g < 0.0) {
                this.g = 0.0;
            } else if (this.g > (double)this.lastTick) {
                this.g = this.lastTick;
            }
            this.h = (int)(this.g + 0.5);
        }
    }

    public synchronized void unfreezeValues() {
        if (this.k < 1) {
            throw new IllegalStateException("Can't unfreeze not frozen time line!");
        }
        --this.k;
    }

    public synchronized boolean isFrozen() {
        return this.k > 0;
    }

    private void a() {
        if (this.isFrozen()) {
            throw new IllegalStateException("Operation illegal when values are frozen!");
        }
    }

    private void b() {
        if (this.repeatType == 0 || this.b >= this.repeatCount || this.f >= 0.0 && this.f <= 1.0) {
            return;
        }
        this.f = this.f < 0.5 ? (this.repeatType == 1 ? 1.0 : 0.0) : (this.repeatType == 1 ? 0.0 : 1.0);
        this.d = this.f == 0.0 ? 1 : -1;
        this.a(true);
        ++this.b;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public int getRepeatType() {
        return this.repeatType;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public Function getFunction() {
        return this.func;
    }

    public boolean isTimeBased() {
        return this.isTimeBased;
    }

    public boolean getTimeBased() {
        return this.isTimeBased();
    }

    public void showTimelineFrame() {
        int n = 700;
        int n2 = 700;
        JFrame jFrame = new JFrame("Time Line");
        jFrame.setSize(n, n2);
        jFrame.setLocationRelativeTo(null);
        jFrame.getContentPane().add(new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill(this.getBounds());
                graphics2D.setColor(Color.BLACK);
                for (double d = 0.0; d <= 1.0; d += 0.001) {
                    graphics2D.fillRect((int)Math.round(d * (double)n), n2 - (int)Math.round(TimeLine.this.func.f(d) * (double)n2), 1, 1);
                }
                if (TimeLine.this.isTimeBased) {
                    for (int i = 0; i < TimeLine.this.tickCount; ++i) {
                        double[] dArray = TimeLine.this.func.solve(1.0 / (double)(TimeLine.this.tickCount - 1) * (double)i, null, null);
                        for (int j = 0; j < dArray.length; ++j) {
                            graphics2D.fillRect((int)Math.round(dArray[j] * (double)n) - 4, n2 - Math.round((float)i / (float)(TimeLine.this.tickCount - 1) * (float)n2) - 4, 8, 8);
                        }
                    }
                } else {
                    for (int i = 0; i < TimeLine.this.tickCount; ++i) {
                        double d = (float)i / (float)(TimeLine.this.tickCount - 1);
                        graphics2D.fillRect((int)Math.round(d * (double)n) - 4, n2 - (int)Math.round(TimeLine.this.func.f(d) * (double)n2) - 4, 8, 8);
                    }
                }
            }
        });
        jFrame.setVisible(true);
    }

    protected Object clone() {
        return new TimeLine(this.duration, this.tickCount, this.repeatType, this.repeatCount, this.func.cloneFunction(), this.isTimeBased);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == TimeLine.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(TimeLine.class, new DefaultPersistenceDelegate(new String[]{"duration", "tickCount", "repeatType", "repeatCount", "function", "timeBased"}));
    }
}

