/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation.animations;

import com.miginfocom.ashape.animation.animations.AbstractAnimation;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.AtUtil;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.io.IOUtil;
import java.awt.Insets;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class AbsRectAnimation
extends AbstractAnimation {
    private final transient AbsRect a;
    private final transient AbsRect b;
    private static final Insets c = new Insets(0, 0, 0, 0);
    private static final long serialVersionUID = 1L;

    public AbsRectAnimation(AbsRect absRect, AbsRect absRect2) {
        this(absRect, absRect2, 0);
    }

    public AbsRectAnimation(AbsRect absRect, AbsRect absRect2, int n) {
        super(n, false);
        if (!this.checkRects(absRect, absRect2)) {
            throw new IllegalArgumentException("AbsRect values doesn't match their types!");
        }
        this.a = absRect;
        this.b = absRect2;
    }

    @Override
    public Object createObject(float f) {
        AbsRect absRect = (double)f < 1.0E-4 ? this.a : this.b;
        return new AbsRect(AtUtil.getCrossValue(this.a.getX1(), this.b.getX1(), f), AtUtil.getCrossValue(this.a.getY1(), this.b.getY1(), f), AtUtil.getCrossValue(this.a.getX2(), this.b.getX2(), f), AtUtil.getCrossValue(this.a.getY2(), this.b.getY2(), f), absRect.getHorizontalSizeConstraint(), absRect.getVerticalSizeConstraint(), this.getInsets(this.a.getResize(), this.b.getResize(), f));
    }

    protected Insets getInsets(Insets insets, Insets insets2, float f) {
        if (insets == insets2) {
            return insets == null ? null : (Insets)insets.clone();
        }
        if (insets == null) {
            insets = c;
        }
        if (insets2 == null) {
            insets2 = c;
        }
        return new Insets((int)((float)(insets2.top - insets.top) * f + (float)insets.top + 0.5f), (int)((float)(insets2.left - insets.left) * f + (float)insets.left + 0.5f), (int)((float)(insets2.bottom - insets.bottom) * f + (float)insets.bottom + 0.5f), (int)((float)(insets2.right - insets.right) * f + (float)insets.right + 0.5f));
    }

    protected boolean checkRects(AbsRect absRect, AbsRect absRect2) {
        return absRect.getX1().getClass().equals(absRect2.getX1().getClass()) && absRect.getY1().getClass().equals(absRect2.getY1().getClass()) && absRect.getX2().getClass().equals(absRect2.getX2().getClass()) && absRect.getY2().getClass().equals(absRect2.getY2().getClass());
    }

    public PlaceRect getStartRect() {
        return this.a;
    }

    public PlaceRect getEndRect() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbsRectAnimation)) {
            return false;
        }
        AbsRectAnimation absRectAnimation = (AbsRectAnimation)object;
        return super.equals(object) && MigUtil.equals(this.a, absRectAnimation.a) && MigUtil.equals(this.b, absRectAnimation.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AbsRectAnimation.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AbsRectAnimation.class, new DefaultPersistenceDelegate(new String[]{"startRect", "endRect", "frameCount"}));
    }
}

