/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation.animations;

import com.miginfocom.ashape.animation.animations.AbstractAnimation;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.BasicStroke;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class BasicStrokeAnimation
extends AbstractAnimation {
    private final transient BasicStroke a;
    private final transient BasicStroke b;
    private static final long serialVersionUID = 1L;

    public BasicStrokeAnimation(BasicStroke basicStroke, BasicStroke basicStroke2) {
        this(basicStroke, basicStroke2, 0);
    }

    public BasicStrokeAnimation(BasicStroke basicStroke, BasicStroke basicStroke2, int n) {
        super(n, false);
        this.assertCompatible(basicStroke, basicStroke2);
        this.a = basicStroke;
        this.b = basicStroke2;
    }

    @Override
    protected Object createObject(float f) {
        BasicStroke basicStroke = f < 0.9999f ? this.a : this.b;
        float f2 = GfxUtil.getCrossFloat(this.a.getLineWidth(), this.b.getLineWidth(), f);
        float f3 = GfxUtil.getCrossFloat(this.a.getMiterLimit(), this.b.getMiterLimit(), f);
        float f4 = GfxUtil.getCrossFloat(this.a.getDashPhase(), this.b.getDashPhase(), f);
        int n = basicStroke.getLineJoin();
        int n2 = basicStroke.getEndCap();
        float[] fArray = this.a.getDashArray();
        if (fArray != null) {
            float[] fArray2 = this.b.getDashArray();
            for (int i = 0; i < fArray2.length; ++i) {
                fArray[i] = GfxUtil.getCrossFloat(fArray[i], fArray2[i], f);
            }
        }
        return new BasicStroke(f2, n2, n, f3, fArray, f4);
    }

    protected void assertCompatible(BasicStroke basicStroke, BasicStroke basicStroke2) {
        float[] fArray;
        float[] fArray2 = basicStroke.getDashArray();
        if (fArray2 == (fArray = basicStroke2.getDashArray()) || fArray2 != null && fArray != null && fArray2.length == fArray.length) {
            return;
        }
        throw new IllegalArgumentException("Dash array length/null missmatch!");
    }

    public BasicStroke getStartValue() {
        return this.a;
    }

    public BasicStroke getEndValue() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BasicStrokeAnimation)) {
            return false;
        }
        BasicStrokeAnimation basicStrokeAnimation = (BasicStrokeAnimation)object;
        return super.equals(object) && MigUtil.equals(this.a, basicStrokeAnimation.a) && MigUtil.equals(this.b, basicStrokeAnimation.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == BasicStrokeAnimation.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(BasicStrokeAnimation.class, new DefaultPersistenceDelegate(new String[]{"startValue", "endValue", "frameCount"}));
    }
}

