/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation.animations;

import com.miginfocom.ashape.animation.animations.AbstractAnimation;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class ColorAnimation
extends AbstractAnimation {
    private final transient Color a;
    private final transient Color b;
    private static final long serialVersionUID = 1L;

    public ColorAnimation(Color color, Color color2) {
        this(color, color2, 0);
    }

    public ColorAnimation(Color color, Color color2, int n) {
        super(n, false);
        this.a = color;
        this.b = color2;
    }

    @Override
    protected Object createObject(float f) {
        return GfxUtil.getCrossColor(this.a, this.b, f);
    }

    public Color getStartColor() {
        return this.a;
    }

    public Color getEndColor() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColorAnimation)) {
            return false;
        }
        ColorAnimation colorAnimation = (ColorAnimation)object;
        return super.equals(object) && MigUtil.equals(this.a, colorAnimation.a) && MigUtil.equals(this.b, colorAnimation.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == ColorAnimation.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(ColorAnimation.class, new DefaultPersistenceDelegate(new String[]{"startColor", "endColor", "frameCount"}));
    }
}

