/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation.animations;

import com.miginfocom.ashape.animation.animations.AbstractAnimation;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class NumberAnimation
extends AbstractAnimation {
    private final transient Number a;
    private final transient Number b;
    private static final long serialVersionUID = 1L;

    public NumberAnimation(Number number, Number number2) {
        this(number, number2, 0);
    }

    public NumberAnimation(Number number, Number number2, int n) {
        super(n, false);
        this.assertCompatible(number, number2);
        this.a = number;
        this.b = number2;
    }

    @Override
    protected Object createObject(float f) {
        double d = GfxUtil.getCrossDouble(this.a.doubleValue(), this.b.doubleValue(), f);
        if (this.a instanceof Float) {
            return new Float(d);
        }
        if (this.a instanceof Double) {
            return new Double(d);
        }
        if (this.a instanceof Integer) {
            return new Integer((int)(d + 0.5));
        }
        return new Long((long)(d + 0.5));
    }

    protected void assertCompatible(Number number, Number number2) {
        if (!number.getClass().equals(number2.getClass())) {
            throw new IllegalArgumentException("AtRefRangeValues are not of same class type!");
        }
        if (!(number instanceof Float && number instanceof Double && number instanceof Integer && number instanceof Long)) {
            throw new IllegalArgumentException("Unsupported type: " + number.getClass());
        }
    }

    public Number getStartValue() {
        return this.a;
    }

    public Number getEndValue() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NumberAnimation)) {
            return false;
        }
        NumberAnimation numberAnimation = (NumberAnimation)object;
        return super.equals(object) && MigUtil.equals(this.a, numberAnimation.a) && MigUtil.equals(this.b, numberAnimation.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == NumberAnimation.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(NumberAnimation.class, new DefaultPersistenceDelegate(new String[]{"startValue", "endValue", "frameCount"}));
    }
}

