/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation.animations;

import com.miginfocom.ashape.animation.animations.AbstractAnimation;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.ShapeGradientPaint;
import com.miginfocom.util.gfx.geometry.AtUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class ShapeGradientPaintAnimation
extends AbstractAnimation {
    private final transient ShapeGradientPaint a;
    private final transient ShapeGradientPaint b;
    private static final long serialVersionUID = 1L;

    public ShapeGradientPaintAnimation(ShapeGradientPaint shapeGradientPaint, ShapeGradientPaint shapeGradientPaint2) {
        this(shapeGradientPaint, shapeGradientPaint2, 0);
    }

    public ShapeGradientPaintAnimation(ShapeGradientPaint shapeGradientPaint, ShapeGradientPaint shapeGradientPaint2, int n) {
        super(n, false);
        this.assertCompatible(shapeGradientPaint, shapeGradientPaint2);
        this.a = shapeGradientPaint;
        this.b = shapeGradientPaint2;
    }

    @Override
    protected Object createObject(float f) {
        Color color = GfxUtil.getCrossColor(this.a.getColor1(), this.b.getColor1(), f);
        Color color2 = GfxUtil.getCrossColor(this.a.getColor2(), this.b.getColor2(), f);
        if (this.a.getMode() == 0) {
            return new ShapeGradientPaint(color, color2, (this.b.getAngle() - this.a.getAngle()) * f + this.a.getAngle(), (this.b.getLength() - this.a.getLength()) * f + this.a.getLength(), (this.b.getAlignment() - this.a.getAlignment()) * f + this.a.getAlignment(), this.a.isCyclic());
        }
        return new ShapeGradientPaint(AtUtil.getCrossValue(this.a.getX1(), this.b.getX1(), f), AtUtil.getCrossValue(this.a.getY1(), this.b.getY1(), f), color, AtUtil.getCrossValue(this.a.getX2(), this.b.getX2(), f), AtUtil.getCrossValue(this.a.getY2(), this.b.getY2(), f), color2, this.a.isCyclic());
    }

    protected void assertCompatible(ShapeGradientPaint shapeGradientPaint, ShapeGradientPaint shapeGradientPaint2) {
        if (shapeGradientPaint.getMode() != shapeGradientPaint2.getMode() || shapeGradientPaint.isCyclic() != shapeGradientPaint2.isCyclic()) {
            throw new IllegalArgumentException("ShapeGradientPaints not compatible.");
        }
        if (!(shapeGradientPaint.getMode() != 1 || shapeGradientPaint.getX1().getClass().equals(shapeGradientPaint2.getX1().getClass()) && shapeGradientPaint.getX2().getClass().equals(shapeGradientPaint2.getX2().getClass()) && shapeGradientPaint.getY1().getClass().equals(shapeGradientPaint2.getY1().getClass()) && shapeGradientPaint.getY2().getClass().equals(shapeGradientPaint2.getY2().getClass()))) {
            throw new IllegalArgumentException("ShapeGradientPaints not compatible!");
        }
    }

    public ShapeGradientPaint getStartPaint() {
        return this.a;
    }

    public ShapeGradientPaint getEndPaint() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShapeGradientPaintAnimation)) {
            return false;
        }
        ShapeGradientPaintAnimation shapeGradientPaintAnimation = (ShapeGradientPaintAnimation)object;
        return super.equals(object) && MigUtil.equals(this.a, shapeGradientPaintAnimation.a) && MigUtil.equals(this.b, shapeGradientPaintAnimation.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == ShapeGradientPaintAnimation.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(ShapeGradientPaintAnimation.class, new DefaultPersistenceDelegate(new String[]{"startPaint", "endPaint", "frameCount"}));
    }
}

