/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.animation.animations;

import com.miginfocom.ashape.animation.animations.AbstractAnimation;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.TexturePaint;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class TexturePaintAnimation
extends AbstractAnimation {
    private final transient TexturePaint a;
    private final transient TexturePaint b;
    private static final long serialVersionUID = 1L;

    public TexturePaintAnimation(TexturePaint texturePaint, TexturePaint texturePaint2, int n) {
        super(n, false);
        this.a = texturePaint;
        this.b = texturePaint2;
        this.createCache(true);
    }

    @Override
    protected Object createObject(float f) {
        boolean bl = this.a == null || this.b == null || this.b.getTransparency() != 1;
        int n = bl ? 3 : 1;
        return GfxUtil.getCrossTexturePaint(this.a, this.b, f, n, bl);
    }

    public TexturePaint getStartPaint() {
        return this.a;
    }

    public TexturePaint getEndPaint() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TexturePaintAnimation)) {
            return false;
        }
        TexturePaintAnimation texturePaintAnimation = (TexturePaintAnimation)object;
        return super.equals(object) && MigUtil.equals(this.a, texturePaintAnimation.a) && MigUtil.equals(this.b, texturePaintAnimation.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == TexturePaintAnimation.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(TexturePaintAnimation.class, new DefaultPersistenceDelegate(new String[]{"startPaint", "endPaint", "frameCount"}));
    }
}

