/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.interaction;

import com.miginfocom.ashape.interaction.AbstractInteractionBroker;
import com.miginfocom.ashape.interaction.InteractionEvent;
import com.miginfocom.ashape.interaction.InteractionListener;
import com.miginfocom.ashape.interaction.Interactor;
import com.miginfocom.ashape.shapes.AShape;
import com.miginfocom.ashape.shapes.RootAShape;
import com.miginfocom.calendar.activity.ActivityInteractor;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.command.Command;
import com.miginfocom.util.command.DefaultCommand;
import com.miginfocom.util.gfx.GfxUtil;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;

public class DefaultInteractionBroker
extends AbstractInteractionBroker {
    public static final PropertyKey CMD_SET_CURSOR_FROM_ASHAPE = PropertyKey.getKey("setCursorFromAShape");
    public static final PropertyKey CMD_SET_CURSOR = PropertyKey.getKey("setCursor");
    public static final PropertyKey CMD_ADD_OVERRIDE = PropertyKey.getKey("addOverride");
    public static final PropertyKey CMD_SET_OVERRIDE = PropertyKey.getKey("setOverride");
    public static final PropertyKey CMD_REMOVE_OVERRIDE = PropertyKey.getKey("removeOverride");
    public static final PropertyKey CMD_TOGGLE_OVERRIDE = PropertyKey.getKey("toggleOverride");
    public static final PropertyKey CMD_CYCLE_OVERRIDE = PropertyKey.getKey("cycleOverride");
    public static final PropertyKey CMD_ANIMATOR_CONTROL = PropertyKey.getKey("animatorControl");
    public static final PropertyKey CMD_FIRE_INTERACTION_EVENT = PropertyKey.getKey("fireInteractionEvent");
    public static final PropertyKey CMD_CONSUME = PropertyKey.getKey("consume");
    private final WeakReference a;
    private final WeakReference[] b;

    public DefaultInteractionBroker(JComponent jComponent, InteractionListener interactionListener) {
        InteractionListener[] interactionListenerArray;
        if (interactionListener != null) {
            InteractionListener[] interactionListenerArray2 = new InteractionListener[1];
            interactionListenerArray = interactionListenerArray2;
            interactionListenerArray2[0] = interactionListener;
        } else {
            interactionListenerArray = null;
        }
        this(jComponent, interactionListenerArray);
    }

    public DefaultInteractionBroker(JComponent jComponent, InteractionListener[] interactionListenerArray) {
        this.a = new WeakReference<JComponent>(jComponent);
        WeakReference[] weakReferenceArray = this.b = interactionListenerArray != null ? new WeakReference[interactionListenerArray.length] : null;
        if (interactionListenerArray != null) {
            for (int i = 0; i < interactionListenerArray.length; ++i) {
                this.b[i] = new WeakReference<InteractionListener>(interactionListenerArray[i]);
            }
        }
    }

    @Override
    public boolean handleCommand(Interactor interactor, Command command, InputEvent inputEvent) {
        if (!(command instanceof DefaultCommand)) {
            return false;
        }
        DefaultCommand defaultCommand = (DefaultCommand)command;
        if (!defaultCommand.isEnabled()) {
            return false;
        }
        PropertyKey propertyKey = defaultCommand.getCommandKey();
        if (propertyKey == null) {
            return false;
        }
        PropertyKey propertyKey2 = defaultCommand.getPropertyKey();
        Object object = defaultCommand.getID();
        Object object2 = defaultCommand.getValue();
        if (propertyKey == CMD_FIRE_INTERACTION_EVENT) {
            if (this.b != null) {
                InteractionEvent interactionEvent = new InteractionEvent(interactor, this, defaultCommand, inputEvent);
                for (int i = 0; i < this.b.length; ++i) {
                    InteractionListener interactionListener = (InteractionListener)this.b[i].get();
                    if (interactionListener == null) continue;
                    interactionListener.interactionOccured(interactionEvent);
                }
            }
        } else if (propertyKey == CMD_ADD_OVERRIDE) {
            interactor.addOverride(defaultCommand.getTarget(), propertyKey2, object, object2);
        } else if (propertyKey == CMD_SET_OVERRIDE) {
            interactor.removeOverride(defaultCommand.getTarget(), propertyKey2, null);
            interactor.addOverride(defaultCommand.getTarget(), propertyKey2, object, object2);
        } else if (propertyKey == CMD_REMOVE_OVERRIDE) {
            interactor.removeOverride(defaultCommand.getTarget(), propertyKey2, object2);
        } else if (propertyKey == CMD_TOGGLE_OVERRIDE) {
            if (interactor.isOverridden(defaultCommand.getTarget(), propertyKey2)) {
                interactor.removeOverride(defaultCommand.getTarget(), propertyKey2, object);
            } else {
                interactor.addOverride(defaultCommand.getTarget(), propertyKey2, object, object2);
            }
        } else if (propertyKey == CMD_CYCLE_OVERRIDE) {
            List list = (List)object2;
            if (list == null || list.size() == 0) {
                throw new IllegalArgumentException("Cycle list empty: " + list);
            }
            Object object3 = interactor.getOverrideById(object, this);
            ListIterator listIterator = list.listIterator(0);
            while (listIterator.hasNext()) {
                if (listIterator.next() != object3 && listIterator.hasNext()) continue;
                Object e = listIterator.hasNext() ? listIterator.next() : list.get(0);
                interactor.addOverride(defaultCommand.getTarget(), propertyKey2, object, e);
                break;
            }
        } else if (propertyKey == CMD_SET_CURSOR) {
            JComponent jComponent = this.getComponent();
            if (jComponent != null) {
                jComponent.setCursor(GfxUtil.getCursor(object2));
            }
        } else if (propertyKey == CMD_SET_CURSOR_FROM_ASHAPE) {
            JComponent jComponent = this.getComponent();
            if (jComponent != null) {
                List list = (List)interactor.getProperty(propertyKey2);
                RootAShape rootAShape = (RootAShape)object2;
                Cursor cursor = null;
                if (list != null && list.size() > 0) {
                    ListIterator listIterator = list.listIterator(0);
                    while (listIterator.hasNext()) {
                        AShape aShape = rootAShape.getSubShapeDeep((String)listIterator.next());
                        Object object4 = aShape.getAttribute(AShape.A_MOUSE_CURSOR);
                        object4 = ActivityInteractor.getStaticOverride(null, aShape.getName(), AShape.A_MOUSE_CURSOR, object4);
                        cursor = GfxUtil.getCursor(object4);
                        if (cursor == null) continue;
                        break;
                    }
                }
                jComponent.setCursor(cursor);
            }
        } else if (propertyKey == CMD_CONSUME) {
            inputEvent.consume();
        } else {
            return false;
        }
        return true;
    }

    public JComponent getComponent() {
        return (JComponent)this.a.get();
    }
}

