/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.interaction;

import com.miginfocom.ashape.interaction.AbstractInteractor;
import com.miginfocom.ashape.interaction.Interaction;
import com.miginfocom.ashape.interaction.InteractionBroker;
import com.miginfocom.ashape.interaction.MouseInteractionEvent;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.NameValuePair;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.gfx.RepaintRegion;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class MouseKeyInteractor
extends AbstractInteractor {
    public static final PropertyKey MOUSE_EVENT_PRE = PropertyKey.getKey("MouseEventPre");
    public static final PropertyKey MOUSE_EVENT_POST = PropertyKey.getKey("MouseEventPost");
    public static final PropertyKey MOUSE_ENTER = PropertyKey.getKey("MouseEnter");
    public static final PropertyKey MOUSE_EXIT = PropertyKey.getKey("MouseExit");
    public static final PropertyKey MOUSE_OVER_CHANGE = PropertyKey.getKey("MouseOverChange");
    public static final PropertyKey MOUSE_OVER_TOPMOST_CHANGE = PropertyKey.getKey("MouseOverTopmostChange");
    public static final PropertyKey MOUSE_PRESS = PropertyKey.getKey("MousePress");
    public static final PropertyKey MOUSE_RELEASE = PropertyKey.getKey("MouseRelease");
    public static final PropertyKey MOUSE_POPUP_TRIGGER = PropertyKey.getKey("MousePopupTrigger");
    public static final PropertyKey MOUSE_CLICK = PropertyKey.getKey("MouseClick");
    public static final PropertyKey MOUSE_DOUBLE_CLICK = PropertyKey.getKey("MouseDoubleClick");
    public static final PropertyKey MOUSE_DRAG = PropertyKey.getKey("MouseDrag");
    public static final PropertyKey MOUSE_MOVE = PropertyKey.getKey("MouseMove");
    public static final PropertyKey KEY_EVENT_PRE = PropertyKey.getKey("KeyEventPre");
    public static final PropertyKey KEY_EVENT_POST = PropertyKey.getKey("KeyEventPost");
    public static final PropertyKey KEY_PRESS = PropertyKey.getKey("KeyPress");
    public static final PropertyKey KEY_RELEASE = PropertyKey.getKey("KeyRelease");
    public static final PropertyKey KEY_TYPE = PropertyKey.getKey("KeyType");
    public static final PropertyKey PROP_MOUSE_MOVE_LIST = PropertyKey.getKey("MouseMoveList");
    public static final PropertyKey PROP_MOUSE_DRAG_LIST = PropertyKey.getKey("MouseDragList");
    public static final PropertyKey PROP_MOUSE_OVER_LIST = PropertyKey.getKey("MouseOverList");
    public static final PropertyKey PROP_MOUSE_PRESS_LIST = PropertyKey.getKey("MousePressList");
    public static final PropertyKey PROP_MOUSE_RELEASE_LIST = PropertyKey.getKey("MouseReleaseList");
    public static final PropertyKey PROP_MOUSE_POPUP_TRIGGER_LIST = PropertyKey.getKey("MousePopupTriggerList");
    public static final PropertyKey PROP_MOUSE_CLICK_LIST = PropertyKey.getKey("MouseClickList");
    public static final PropertyKey PROP_MOUSE_DOUBLE_CLICK_LIST = PropertyKey.getKey("MouseDoubleClickList");
    public static final PropertyKey PROP_MOUSE_ENTER_LIST = PropertyKey.getKey("MouseEnterList");
    public static final PropertyKey PROP_MOUSE_EXIT_LIST = PropertyKey.getKey("MouseExitList");
    public static final PropertyKey PROP_MOUSE_OVER_TOPMOST_ENTER = PropertyKey.getKey("MouseOverTopmostEnter");
    public static final PropertyKey PROP_MOUSE_OVER_TOPMOST_EXIT = PropertyKey.getKey("MouseOverTopmostExit");
    public static final PropertyKey PROP_MOUSE_BUTTON = PropertyKey.getKey("MouseButton");
    public static final PropertyKey PROP_EVENT_TYPE = PropertyKey.getKey("EventType");
    protected final InteractionBroker broker;
    private ArrayList a = null;
    private final RepaintRegion b = new RepaintRegion();
    private final HashMap c = new HashMap(16, 1.0f);
    private final Object d;
    private ListenerSet e = null;
    private List f = null;

    public MouseKeyInteractor(Object object, InteractionBroker interactionBroker, Collection collection) {
        this.d = object;
        this.broker = interactionBroker;
        this.addInteractions(collection);
    }

    @Override
    public InteractionBroker getInteractionBroker() {
        return this.broker;
    }

    @Override
    public Object getInteracted() {
        return this.d;
    }

    @Override
    public Object getProperty(PropertyKey propertyKey) {
        return this.c.get(propertyKey);
    }

    @Override
    public boolean containsProperty(PropertyKey propertyKey) {
        return this.c.containsKey(propertyKey);
    }

    protected void checkInteractions(PropertyKey propertyKey, InputEvent inputEvent, boolean bl) {
        Serializable serializable;
        if (bl && this.e != null && inputEvent instanceof MouseEvent) {
            serializable = new MouseInteractionEvent((MouseEvent)inputEvent, this, propertyKey);
            this.e.fireEvent((EventObject)serializable);
            if (((MouseInteractionEvent)serializable).getConsumeLevel() >= 10002) {
                return;
            }
        }
        serializable = this.getInteractions();
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            Interaction interaction = (Interaction)((ArrayList)serializable).get(i);
            if (interaction.isExclusive() && inputEvent.isConsumed() || interaction.getTrigger() != propertyKey || !interaction.evaluate(this)) continue;
            this.broker.handleCommands(this, interaction.getCommandSet(), inputEvent);
            if (!interaction.isConsume()) continue;
            inputEvent.consume();
        }
    }

    @Override
    public void mouseEventPre(MouseEvent mouseEvent) {
        this.c.put(PROP_EVENT_TYPE, new Integer(mouseEvent.getID()));
        this.checkInteractions(MOUSE_EVENT_PRE, mouseEvent, false);
    }

    @Override
    public void mouseEventPost(MouseEvent mouseEvent) {
        this.checkInteractions(MOUSE_EVENT_POST, mouseEvent, false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        List list = this.getHitList(mouseEvent);
        this.c.put(PROP_MOUSE_PRESS_LIST, list);
        this.c.put(PROP_MOUSE_BUTTON, new Integer(mouseEvent.getButton()));
        if (mouseEvent.isPopupTrigger()) {
            this.c.put(PROP_MOUSE_POPUP_TRIGGER_LIST, list);
            this.checkInteractions(MOUSE_POPUP_TRIGGER, mouseEvent, list != null);
        }
        this.checkInteractions(MOUSE_PRESS, mouseEvent, list != null);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        List list = this.getHitList(mouseEvent);
        this.c.put(PROP_MOUSE_RELEASE_LIST, list);
        this.c.put(PROP_MOUSE_BUTTON, new Integer(mouseEvent.getButton()));
        if (mouseEvent.isPopupTrigger()) {
            this.c.put(PROP_MOUSE_POPUP_TRIGGER_LIST, list);
            this.checkInteractions(MOUSE_POPUP_TRIGGER, mouseEvent, list != null);
        }
        this.checkInteractions(MOUSE_RELEASE, mouseEvent, list != null);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        List list = this.getHitList(mouseEvent);
        this.c.put(PROP_MOUSE_OVER_LIST, list);
        this.c.put(PROP_MOUSE_MOVE_LIST, list);
        this.c.put(PROP_MOUSE_BUTTON, new Integer(mouseEvent.getButton()));
        this.a(list, mouseEvent);
        this.checkInteractions(MOUSE_MOVE, mouseEvent, list != null);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        List list = this.getHitList(mouseEvent);
        this.c.put(PROP_MOUSE_OVER_LIST, list);
        this.c.put(PROP_MOUSE_DRAG_LIST, list);
        this.c.put(PROP_MOUSE_BUTTON, new Integer(mouseEvent.getButton()));
        this.checkInteractions(MOUSE_DRAG, mouseEvent, list != null);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        List list = this.getHitList(mouseEvent);
        this.c.put(PROP_MOUSE_CLICK_LIST, list);
        if (mouseEvent.getClickCount() > 1) {
            this.c.put(PROP_MOUSE_DOUBLE_CLICK_LIST, list);
        }
        this.c.put(PROP_MOUSE_BUTTON, new Integer(mouseEvent.getButton()));
        this.checkInteractions(MOUSE_CLICK, mouseEvent, list != null);
        if (mouseEvent.getClickCount() > 1) {
            this.checkInteractions(MOUSE_DOUBLE_CLICK, mouseEvent, list != null);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.a(null, mouseEvent);
    }

    @Override
    public void keyEventPre(KeyEvent keyEvent) {
        this.c.put(PROP_EVENT_TYPE, new Integer(keyEvent.getID()));
        this.checkInteractions(KEY_EVENT_PRE, keyEvent, false);
    }

    @Override
    public void keyEventPost(KeyEvent keyEvent) {
        this.checkInteractions(KEY_EVENT_POST, keyEvent, false);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.checkInteractions(KEY_PRESS, keyEvent, false);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.checkInteractions(KEY_RELEASE, keyEvent, false);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.checkInteractions(KEY_TYPE, keyEvent, false);
    }

    private void a(List list, MouseEvent mouseEvent) {
        boolean bl;
        Object e;
        int n;
        int n2;
        ArrayList arrayList = (ArrayList)this.c.get(PROP_MOUSE_ENTER_LIST);
        ArrayList arrayList2 = (ArrayList)this.c.get(PROP_MOUSE_EXIT_LIST);
        Object v = this.c.get(PROP_MOUSE_OVER_TOPMOST_ENTER);
        if (arrayList == arrayList2 && list == null && this.f == null && v == null) {
            return;
        }
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        if (this.f != null) {
            n2 = this.f.size();
            for (n = 0; n < n2; ++n) {
                e = this.f.get(n);
                if (list != null && list.contains(e)) continue;
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList(4);
                }
                arrayList4.add(e);
            }
        }
        if (list != null) {
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                e = list.get(n);
                if (this.f != null && this.f.contains(e)) continue;
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList(4);
                }
                arrayList3.add(e);
            }
        }
        Object v2 = list != null && list.size() > 0 ? (Object)list.get(0) : null;
        int n3 = n2 = !MigUtil.equals(v, v2) ? 1 : 0;
        if (n2 != 0) {
            this.c.put(PROP_MOUSE_OVER_TOPMOST_ENTER, v2);
            this.c.put(PROP_MOUSE_OVER_TOPMOST_EXIT, v);
        }
        this.c.put(PROP_MOUSE_ENTER_LIST, arrayList3);
        this.c.put(PROP_MOUSE_EXIT_LIST, arrayList4);
        boolean bl2 = arrayList3 != null;
        boolean bl3 = bl = arrayList4 != null;
        if (bl) {
            this.checkInteractions(MOUSE_EXIT, mouseEvent, true);
        }
        if (bl2) {
            this.checkInteractions(MOUSE_ENTER, mouseEvent, true);
        }
        if (bl2 || bl) {
            this.checkInteractions(MOUSE_OVER_CHANGE, mouseEvent, true);
        }
        if (n2 != 0) {
            this.checkInteractions(MOUSE_OVER_TOPMOST_CHANGE, mouseEvent, true);
        }
        this.f = list;
    }

    protected final List getHitList(MouseEvent mouseEvent) {
        Shape shape;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.a == null || mouseEvent.isConsumed() || !this.b.contains(n2, n3)) {
            return null;
        }
        ArrayList<Object> arrayList = null;
        int n4 = this.a.size();
        for (n = 0; n < n4; ++n) {
            NameValuePair nameValuePair = (NameValuePair)this.a.get(n);
            shape = (Shape)nameValuePair.getValue();
            if (shape == null || !shape.contains(n2, n3)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(4);
            }
            arrayList.add(nameValuePair.getName());
        }
        int n5 = n = arrayList != null ? arrayList.size() : 0;
        if (n > 1) {
            n4 = 0;
            for (int i = n - 1; i > n4; ++n4, --i) {
                shape = arrayList.get(n4);
                Shape shape2 = arrayList.set(i, shape);
                arrayList.set(n4, shape2);
            }
        }
        return arrayList;
    }

    public void setHitAreas(ArrayList arrayList, ListenerSet listenerSet) {
        this.a = arrayList;
        this.b.clear();
        ListenerSet listenerSet2 = this.e = listenerSet.size() > 0 ? listenerSet : null;
        if (arrayList != null) {
            if (arrayList.size() == 0) {
                this.a = null;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Shape shape = (Shape)((NameValuePair)arrayList.get(i)).getValue();
                if (shape == null) continue;
                this.b.add(shape);
            }
        }
    }
}

