/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.shapes;

import com.miginfocom.ashape.shapes.AShape;
import com.miginfocom.ashape.shapes.AbstractAShape;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.SliceSpec;
import com.miginfocom.util.gfx.SlicedImage;
import com.miginfocom.util.gfx.XtdImage;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;

public abstract class FilterAShape
extends AbstractAShape {
    public static final PropertyKey A_FILTER_SLICE_SPEC = PropertyKey.getKey("FilterSliceSpec");
    private transient SlicedImage a = null;
    private transient BufferedImage b = null;

    protected FilterAShape() {
    }

    protected FilterAShape(String string, AShape aShape, Paint paint, SliceSpec sliceSpec) {
        super(string);
        this.setAttribute(A_WRAPPED_ASHAPE, aShape);
        this.setAttribute(A_SHADOW_TARGET_PAINT, paint);
        this.setAttribute(A_FILTER_SLICE_SPEC, sliceSpec);
    }

    @Override
    public Shape paintShape(Graphics2D graphics2D, Shape shape, Rectangle rectangle) {
        AShape aShape = (AShape)this.getAttribute(A_WRAPPED_ASHAPE);
        Paint paint = (Paint)this.getAttribute(A_SHADOW_TARGET_PAINT);
        SliceSpec sliceSpec = (SliceSpec)this.getAttribute(A_FILTER_SLICE_SPEC);
        if (aShape == null || paint == null) {
            return null;
        }
        aShape.setReferenceBounds(this.getReferenceBounds());
        Rectangle rectangle2 = aShape.getShapeBounds();
        Dimension dimension = this.getFilterMargin();
        int n = rectangle2.width + dimension.width * 2;
        int n2 = rectangle2.height + dimension.height * 2;
        if (sliceSpec != null) {
            Rectangle rectangle3 = new Rectangle(rectangle2.x - dimension.width / 2, rectangle2.y - dimension.height / 2, rectangle2.width + dimension.width, rectangle2.height + dimension.height);
            if (this.shouldRecreateSlicedImage(this.a, rectangle3)) {
                this.b = this.a(this.b, n, n2, paint);
                if (this.b != null) {
                    Graphics2D graphics2D2 = (Graphics2D)this.b.getGraphics();
                    graphics2D2.translate(-rectangle2.x + dimension.width, -rectangle2.y + dimension.height);
                    aShape.paintSubTree(graphics2D2, this.getClipShape(shape), rectangle, null);
                    graphics2D2.dispose();
                    BufferedImageOp bufferedImageOp = this.getBufferedOp();
                    if (bufferedImageOp != null) {
                        this.b = bufferedImageOp.filter(this.b, null);
                    }
                    BufferedImage bufferedImage = this.b.getSubimage(dimension.width >> 1, dimension.height >> 1, n - dimension.width, n2 - dimension.height);
                    this.a = new SlicedImage(sliceSpec, new XtdImage(bufferedImage, 1));
                }
            }
            if (graphics2D != null && this.a != null) {
                this.a.drawImage(graphics2D, rectangle3);
            }
        } else {
            this.b = this.a(this.b, n, n2, paint);
            if (this.b != null) {
                Graphics2D graphics2D3 = (Graphics2D)this.b.getGraphics();
                graphics2D3.translate(-rectangle2.x + dimension.width, -rectangle2.y + dimension.height);
                aShape.paintSubTree(graphics2D3, this.getClipShape(shape), rectangle, null);
                graphics2D3.dispose();
                if (graphics2D != null) {
                    Shape shape2 = graphics2D.getClip();
                    graphics2D.clipRect(rectangle2.x - dimension.width / 2, rectangle2.y - dimension.height / 2, n - dimension.width, n2 - dimension.height);
                    graphics2D.drawImage(this.b, this.getBufferedOp(), rectangle2.x - dimension.width, rectangle2.y - dimension.height);
                    graphics2D.setClip(shape2);
                }
            }
        }
        this.setHitShape(shape, rectangle2);
        return rectangle2;
    }

    public void invalidateCachedImage() {
        this.a = null;
    }

    @Override
    public Shape getHitBounds(boolean bl) {
        return this.getShapeBounds();
    }

    @Override
    public Dimension getNaturalSize() {
        Shape shape = (Shape)this.getAttribute(A_WRAPPED_ASHAPE);
        return shape.getBounds().getSize();
    }

    private BufferedImage a(BufferedImage bufferedImage, int n, int n2, Paint paint) {
        if (n * n2 > 250000) {
            return null;
        }
        if (bufferedImage == null || bufferedImage.getWidth() < n || bufferedImage.getHeight() < n2) {
            bufferedImage = GfxUtil.getDefaultConfiguration().createCompatibleImage((int)((float)n * 1.2f), (int)((float)n2 * 1.2f), 3);
        }
        if (paint != null) {
            this.clearBuf(bufferedImage, paint, n, n2);
        }
        return bufferedImage;
    }

    @Override
    public void addSubShape(AShape aShape) {
        this.addSubShape(null, 0);
    }

    @Override
    public void addSubShape(AShape aShape, int n) {
        throw new UnsupportedOperationException("Filter shape can only hold the shape set in the constructor.");
    }

    protected boolean shouldRecreateSlicedImage(SlicedImage slicedImage, Rectangle rectangle) {
        if (slicedImage == null || slicedImage.getCenterSize() == null) {
            return true;
        }
        Dimension dimension = slicedImage.getCenterSize();
        if (dimension.width > 0 && dimension.height > 0) {
            return false;
        }
        Insets insets = slicedImage.getSliceSpec().getSliceCuts();
        Dimension dimension2 = new Dimension(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        if (dimension.width < 1 && dimension2.width > dimension.width && (dimension.height > 0 || dimension2.height >= dimension.height)) {
            return true;
        }
        return dimension.height < 1 && dimension2.height > dimension.height && (dimension.width > 0 || dimension2.width >= dimension.width);
    }

    protected void clearBuf(BufferedImage bufferedImage, Paint paint, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(paint);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
    }

    protected abstract BufferedImageOp getBufferedOp();

    protected abstract Dimension getFilterMargin();
}

