/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.shapes;

import com.miginfocom.ashape.shapes.AbstractAShape;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.ScaleableImage;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;

public class ImageAShape
extends AbstractAShape {
    public ImageAShape() {
    }

    public ImageAShape(String string, Icon icon, PlaceRect placeRect) {
        super(string);
        this.setAttribute(A_ICON, icon);
        this.setAttribute(A_PLACE_RECT, placeRect);
    }

    public ImageAShape(String string, Image image, PlaceRect placeRect) {
        super(string);
        this.setAttribute(A_IMAGE, image);
        this.setAttribute(A_PLACE_RECT, placeRect);
    }

    @Override
    public Shape paintShape(Graphics2D graphics2D, Shape shape, Rectangle rectangle) {
        Rectangle rectangle2;
        Object object = this.getImageOrIcon();
        if (object == null) {
            return null;
        }
        Dimension dimension = this.getSize(object);
        if (dimension == null) {
            return null;
        }
        Insets insets = (Insets)this.getAttribute(A_CROP);
        PlaceRect placeRect = (PlaceRect)this.getAttribute(A_PLACE_RECT);
        Rectangle rectangle3 = this.getReferenceBounds();
        Rectangle rectangle4 = rectangle2 = placeRect != null ? placeRect.getRect(rectangle3, dimension) : new Rectangle(rectangle3.x, rectangle3.y, dimension.width, dimension.height);
        if (rectangle != null && MigUtil.isTrue(this.getAttribute(A_CROP_TO_VISIBILITY_BOUNDS))) {
            Rectangle.intersect(rectangle2, rectangle, rectangle2);
        }
        if (insets != null) {
            GfxUtil.cropRect(rectangle2, insets);
            if (graphics2D != null) {
                graphics2D.clip(rectangle2);
            }
        }
        if (graphics2D != null) {
            Shape shape2 = graphics2D.getClip();
            if (shape2 == null || shape2.intersects(rectangle2)) {
                this.drawImage(graphics2D, this.getWrappedImage(object), rectangle2);
            }
            Shape shape3 = graphics2D.getClip();
            if (insets != null) {
                graphics2D.setClip(shape3);
            }
            this.setHitShape(shape, rectangle2);
        }
        return rectangle2;
    }

    @Override
    public Shape getHitBounds(boolean bl) {
        return this.paintShape(null, null, null);
    }

    @Override
    public Dimension getNaturalSize() {
        Dimension dimension = this.getSize(this.getImageOrIcon());
        return dimension != null ? dimension : new Dimension(0, 0);
    }

    protected Object getWrappedImage(Object object) {
        return object;
    }

    protected void drawImage(Graphics2D graphics2D, Object object, Rectangle rectangle) {
        if (object instanceof Image) {
            graphics2D.drawImage((Image)object, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        } else if (object instanceof Icon) {
            if (object instanceof ScaleableImage) {
                ((ScaleableImage)object).drawImage(graphics2D, rectangle);
            } else {
                ((Icon)object).paintIcon(null, graphics2D, rectangle.x, rectangle.y);
            }
        }
    }

    protected Object getImageOrIcon() {
        Object object = this.getAttribute(A_IMAGE);
        return object != null ? object : this.getAttribute(A_ICON);
    }

    protected Dimension getSize(Object object) {
        int n = 0;
        int n2 = 0;
        if (object instanceof Image) {
            n = ((Image)object).getWidth(null);
            n2 = ((Image)object).getHeight(null);
        } else if (object instanceof Icon) {
            n = ((Icon)object).getIconWidth();
            n2 = ((Icon)object).getIconHeight();
        }
        return n > 0 && n2 > 0 ? new Dimension(n, n2) : null;
    }
}

