/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.ashape.shapes;

import com.miginfocom.ashape.shapes.AbstractAShape;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public abstract class VectorAShape
extends AbstractAShape {
    protected VectorAShape() {
    }

    protected VectorAShape(String string, Shape shape, PlaceRect placeRect, Paint paint, int n) {
        this(string, shape, null, placeRect, paint, n);
    }

    protected VectorAShape(String string, Shape shape, Shape[] shapeArray, PlaceRect placeRect, Paint paint, int n) {
        super(string);
        this.setAttribute(A_SHAPE, shape);
        this.setAttribute(A_SHAPES, shapeArray);
        this.setAttribute(A_PAINT, paint);
        this.setAttribute(A_ANTI_ALIAS, new Integer(n));
        this.setAttribute(A_PLACE_RECT, placeRect);
    }

    @Override
    public Shape paintShape(Graphics2D graphics2D, Shape shape, Rectangle rectangle) {
        Rectangle rectangle2;
        Rectangle2D rectangle2D;
        Rectangle rectangle3;
        Shape shape2 = (Shape)this.getAttribute(A_SHAPE);
        Shape[] shapeArray = (Shape[])this.getAttribute(A_SHAPES);
        if (shape2 == null) {
            return null;
        }
        graphics2D = graphics2D != null ? (Graphics2D)graphics2D.create() : null;
        PlaceRect placeRect = (PlaceRect)this.getAttribute(A_PLACE_RECT);
        Object object = this.getAttribute(A_ANTI_ALIAS);
        Insets insets = (Insets)this.getAttribute(A_CROP);
        Rectangle rectangle4 = rectangle3 = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (graphics2D != null && object != null) {
            if (object instanceof Boolean) {
                Object object2 = object = (Boolean)object != false ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
            }
            if (object instanceof Integer) {
                GfxUtil.confAntiAliasingHint(graphics2D, false, (Integer)object);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
        Rectangle rectangle5 = placeRect != null ? placeRect.getRect(this.getReferenceBounds(), new Dimension(rectangle3.width, rectangle3.height)) : (Rectangle)this.getReferenceBounds().clone();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle5.x, rectangle5.y);
        int n = this.isDraw() ? 1 : 0;
        double d = (rectangle5.getWidth() - (double)n) / (double)(rectangle3.width != 0 ? rectangle3.width : 1);
        double d2 = (rectangle5.getHeight() - (double)n) / (double)(rectangle3.height != 0 ? rectangle3.height : 1);
        affineTransform.scale(d, d2);
        affineTransform.translate(-rectangle3.x, -rectangle3.y);
        Shape shape3 = GfxUtil.getTransformedShape(affineTransform, shape2);
        Rectangle2D rectangle2D2 = rectangle2D = shape3 instanceof Rectangle2D ? (Rectangle2D)shape3 : shape3.getBounds2D();
        if (insets != null) {
            if (!(rectangle2D instanceof Rectangle)) {
                rectangle2D = rectangle2D.getBounds();
            }
            GfxUtil.cropRect((Rectangle)rectangle2D, insets);
            shape3 = GfxUtil.cropShape(rectangle2D, shape3);
        }
        if (rectangle != null && MigUtil.isTrue(this.getAttribute(A_CROP_TO_VISIBILITY_BOUNDS)) && !rectangle.contains(rectangle2D)) {
            shape3 = GfxUtil.cropShape(rectangle, shape3);
        }
        Rectangle rectangle6 = rectangle2 = graphics2D != null ? graphics2D.getClipBounds() : null;
        if (rectangle2 != null && n > 0) {
            rectangle2.grow(1, 1);
        }
        if (graphics2D != null) {
            if (rectangle2 == null || rectangle2.intersects(rectangle2D) || shape2 instanceof Line2D) {
                if (shapeArray == null) {
                    this.paintShapeImpl(graphics2D, shape3);
                } else {
                    shapeArray = GfxUtil.getTransformedShapes(affineTransform, shapeArray);
                    this.paintShapesImpl(graphics2D, shapeArray);
                }
            }
            graphics2D.dispose();
            this.setHitShape(shape, shape3);
        }
        return shape3;
    }

    @Override
    public Shape getHitBounds(boolean bl) {
        return this.paintShape(null, null, null);
    }

    @Override
    public Dimension getNaturalSize() {
        Shape shape = (Shape)this.getAttribute(A_SHAPE);
        return shape != null ? shape.getBounds().getSize() : new Dimension(0, 0);
    }

    protected abstract void paintShapeImpl(Graphics2D var1, Shape var2);

    protected abstract void paintShapesImpl(Graphics2D var1, Shape[] var2);

    protected abstract boolean isDraw();
}

