/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.beans;

import com.miginfocom.beans.PaintPanelBean;
import com.miginfocom.calendar.datearea.DateAreaContainer;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.GridARLayout;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.print.PrintSpecification;
import com.miginfocom.util.print.PrintUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.lang.ref.WeakReference;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PrintPreviewBean
extends PaintPanelBean {
    private double a = 0.1;
    private double b = 0.2;
    private double c = 100.0;
    private double d = 96.0;
    private PageFormat e = new PageFormat();
    private Border f = new MatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY);
    private WeakReference g = null;
    private PrintSpecification h = null;
    private Paint i = Color.WHITE;
    private transient a[] j = null;
    private transient PrintSpecification k = null;
    private final ChangeListener l = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            PrintPreviewBean.this.recreatePreviewPanels();
        }
    };
    private static final Font m = new Font("Arial", 1, 36);

    public PrintPreviewBean() {
        this.setLayout(new GridARLayout(1, 7, 7));
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.setBackgroundPaint(Color.WHITE);
        MigUtil.checkComponentVersion(600);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof GridARLayout) {
            super.setLayout(layoutManager);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.c();
        Dimension dimension = super.getPreferredSize();
        if (dimension.width <= 10 || dimension.height <= 10) {
            return new Dimension(100, 100);
        }
        return dimension;
    }

    @Override
    public void doLayout() {
        this.c();
        super.doLayout();
    }

    public DateAreaContainer getDateAreaContainer() {
        return this.g != null ? (DateAreaContainer)this.g.get() : null;
    }

    public void setDateAreaContainer(DateAreaContainer dateAreaContainer) {
        this.g = new WeakReference<DateAreaContainer>(dateAreaContainer);
        this.recreatePreviewPanels();
    }

    public Paint getPaperPaint() {
        return this.i;
    }

    public void setPaperPaint(Paint paint) {
        this.i = paint != null ? paint : Color.WHITE;
        this.repaint();
    }

    public PrintSpecification getPrintSpecification() {
        return this.h;
    }

    public void setPrintSpecification(PrintSpecification printSpecification) {
        if (this.h != null) {
            this.h.removeChangeListener(this.l);
        }
        this.h = printSpecification;
        if (this.h != null) {
            this.h.addChangeListener(this.l);
        }
        this.recreatePreviewPanels();
    }

    private PrintSpecification b() {
        if (this.h != null) {
            return this.h;
        }
        DateAreaContainer dateAreaContainer = this.getDateAreaContainer();
        return dateAreaContainer != null ? dateAreaContainer.getPrintSpecification() : null;
    }

    public double getZoomMinimum() {
        return this.a;
    }

    public void setZoomMinimum(double d) {
        this.a = d;
        this.c();
        this.revalidate();
        this.repaint();
    }

    public double getZoomPreferred() {
        return this.b;
    }

    public void setZoomPreferred(double d) {
        this.b = d;
        this.c();
        this.revalidate();
        this.repaint();
    }

    public double getZoomMaximum() {
        return this.c;
    }

    public void setZoomMaximum(double d) {
        this.c = d;
        this.c();
        this.revalidate();
        this.repaint();
    }

    public double getScreenDpi() {
        return this.d;
    }

    public void setScreenDpi(double d) {
        this.d = d;
        this.c();
        this.revalidate();
        this.repaint();
    }

    public boolean getFlowPages() {
        return ((GridARLayout)this.getLayout()).getFlowPages();
    }

    public void setFlowPages(boolean bl) {
        if (this.getFlowPages() != bl) {
            ((GridARLayout)this.getLayout()).setFlowPages(bl);
            this.recreatePreviewPanels();
        }
    }

    public void setLayoutAlignmentX(float f) {
        ((GridARLayout)this.getLayout()).setLayoutAlignmentX(f);
        this.c();
        this.revalidate();
        this.repaint();
    }

    public float getLayoutAlignmentX() {
        return ((GridARLayout)this.getLayout()).getLayoutAlignmentX(this);
    }

    public void setLayoutAlignmentY(float f) {
        ((GridARLayout)this.getLayout()).setLayoutAlignmentY(f);
        this.c();
        this.revalidate();
        this.repaint();
    }

    public float getLayoutAlignmentY() {
        return ((GridARLayout)this.getLayout()).getLayoutAlignmentY(this);
    }

    public Border getPreviewPanelsBorder() {
        return this.f;
    }

    public void setPreviewPanelsBorder(Border border) {
        this.f = border;
        this.c();
        this.revalidate();
        this.repaint();
    }

    public PageFormat getPageFormat() {
        return this.e;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.e = pageFormat != null ? pageFormat : new PageFormat();
        this.recreatePreviewPanels();
    }

    public int getPageGapY() {
        return ((GridARLayout)this.getLayout()).getGapY();
    }

    public void setPageGapY(int n) {
        ((GridARLayout)this.getLayout()).setGapY(n);
        this.c();
        this.revalidate();
        this.repaint();
    }

    public int getPageGapX() {
        return ((GridARLayout)this.getLayout()).getGapX();
    }

    public void setPageGapX(int n) {
        ((GridARLayout)this.getLayout()).setGapX(n);
        this.c();
        this.revalidate();
        this.repaint();
    }

    public void recreatePreviewPanels() {
        this.j = null;
        this.revalidate();
        this.repaint();
    }

    private void c() {
        PrintSpecification printSpecification = this.b();
        if (this.j == null || !MigUtil.equals(printSpecification, this.k)) {
            this.d();
        }
        this.k = printSpecification != null ? (PrintSpecification)printSpecification.clone() : null;
        this.e();
    }

    private void d() {
        DateAreaContainer dateAreaContainer = this.getDateAreaContainer();
        Dimension dimension = new Dimension(1, 1);
        if (dateAreaContainer != null) {
            Dimension dimension2 = dateAreaContainer.getPrintablePreferredSize();
            if (!(dateAreaContainer.isShowing() || dateAreaContainer.getWidth() > 0 && dateAreaContainer.getHeight() > 0)) {
                dateAreaContainer.setSize(dimension2);
            }
            PrintSpecification printSpecification = this.b();
            double d = dimension2.width == 0 || dimension2.height == 0 ? 1.0 : (double)dimension2.width / (double)dimension2.height;
            Rectangle2D rectangle2D = dateAreaContainer.getPrintablePageBounds(this.getPageFormat(), printSpecification);
            double d2 = rectangle2D.getWidth() / rectangle2D.getHeight();
            double d3 = printSpecification.getPrintableAspectRatio() != null ? printSpecification.getPrintableAspectRatio() : d;
            dimension = PrintUtil.getPageCount(printSpecification.getPageCountX(), printSpecification.getPageCountY(), d3, d2);
            ((GridARLayout)this.getLayout()).setColumns(dimension.width);
        }
        this.removeAll();
        this.j = new a[dimension.width * dimension.height];
        for (int i = 0; i < this.j.length; ++i) {
            this.j[i] = new a(i);
            this.j[i].setBorder(this.getPreviewPanelsBorder());
            this.add(this.j[i]);
        }
    }

    private void e() {
        if (this.j != null) {
            for (int i = 0; i < this.j.length; ++i) {
                this.a(this.j[i]);
            }
        }
    }

    private void a(a a2) {
        double d = this.getPageFormat().getPaper().getWidth() * this.getScreenDpi() / 72.0;
        a2.a((int)Math.round(d * this.getZoomMinimum()));
        a2.b((int)Math.round(d * this.getZoomPreferred()));
        a2.c((int)Math.round(d * this.getZoomMaximum()));
    }

    private class a
    extends JPanel {
        private final int b;
        private int c = 0;
        private int d = 100;
        private int e = Integer.MAX_VALUE;

        public a(int n) {
            this.b = n;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            PageFormat pageFormat = PrintPreviewBean.this.getPageFormat();
            graphics2D.setPaint(PrintPreviewBean.this.getPaperPaint());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.scale((double)this.getWidth() / pageFormat.getWidth(), (double)this.getHeight() / pageFormat.getHeight());
            DateAreaContainer dateAreaContainer = PrintPreviewBean.this.getDateAreaContainer();
            if (dateAreaContainer != null) {
                try {
                    dateAreaContainer.print(graphics2D, pageFormat, this.b, PrintPreviewBean.this.b());
                }
                catch (PrinterException printerException) {
                    printerException.printStackTrace();
                }
            } else {
                graphics2D.setColor(Color.GRAY);
                Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
                Rectangle rectangle = GfxUtil.getRoundedRect(double_, true);
                graphics2D.setFont(m);
                GfxUtil.drawStringInRect(graphics2D, "No DateAreaContainer Set!", rectangle, AtFraction.CENTER, AtFraction.CENTER, 0, true, 9);
            }
            graphics2D.dispose();
        }

        private void a(int n) {
            this.c = n;
        }

        private void b(int n) {
            this.d = n;
        }

        private void c(int n) {
            this.e = n;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.d(this.c);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.d(this.d);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.d(this.e);
        }

        private Dimension d(int n) {
            PageFormat pageFormat = PrintPreviewBean.this.getPageFormat();
            double d = pageFormat.getWidth() / pageFormat.getHeight();
            return new Dimension(n, (int)Math.round((double)n / d));
        }
    }
}

