/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar;

import com.miginfocom.calendar.DatePicker;
import com.miginfocom.calendar.datearea.DateAreaContainer;
import com.miginfocom.calendar.datearea.ThemeDateArea;
import com.miginfocom.calendar.datearea.ThemeDateAreaContainer;
import com.miginfocom.calendar.theme.CalendarTheme;
import com.miginfocom.theme.Theme;
import com.miginfocom.theme.Themes;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateFormatList;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

public class ThemeDatePicker
extends DatePicker
implements PropertyChangeListener {
    private String a;

    public ThemeDatePicker() {
        this((String)null);
    }

    public ThemeDatePicker(String string) {
        this.a = string;
        this.updateFromTheme();
    }

    public String getThemeContext() {
        return this.a;
    }

    public void setThemeContext(String string) {
        if (MigUtil.equals(this.a, string)) {
            return;
        }
        Theme.removePropertyChangeListener(this.a, this);
        this.a = string;
        ((ThemeDateAreaContainer)this.getDateAreaContainer()).setThemeContext(string);
        this.updateFromTheme();
        this.destroyPopup();
        this.revalidate();
        this.repaint();
    }

    public void updateFromTheme() {
        CalendarTheme calendarTheme = (CalendarTheme)Themes.getTheme(this.a);
        if (calendarTheme.getBool("Generic/autoReloadFromTheme")) {
            calendarTheme.addPropertyChangeListener(this, true);
        } else {
            Theme.removePropertyChangeListener(this.a, this);
        }
        this.setPopupBorder(calendarTheme.getBorder("Combo/Popup/border"));
        this.setMinimumPopupSize(calendarTheme.getDimension("Combo/Popup/Size/min"));
        this.setPreferredPopupSize(calendarTheme.getDimension("Combo/Popup/Size/preferred"));
        this.setMaximumPopupSize(calendarTheme.getDimension("Combo/Popup/Size/max"));
        this.setNoDateSelectedText(calendarTheme.getString("Combo/noDateText"));
        this.setRangeFormat(40, (DateFormatList)calendarTheme.getValue("Combo/DateFormat/yearWeeks"));
        this.setRangeFormat(41, (DateFormatList)calendarTheme.getValue("Combo/DateFormat/yearMonths"));
        this.setRangeFormat(42, (DateFormatList)calendarTheme.getValue("Combo/DateFormat/month"));
        this.setRangeFormat(43, (DateFormatList)calendarTheme.getValue("Combo/DateFormat/week"));
        this.setRangeFormat(44, (DateFormatList)calendarTheme.getValue("Combo/DateFormat/day"));
        this.setRangeFormat(48, (DateFormatList)calendarTheme.getValue("Combo/DateFormat/custom"));
        this.setButtonsBorder(calendarTheme.getBorder("Combo/Buttons/border"));
        this.setComboBorder(calendarTheme.getBorder("Combo/border"));
        this.setButtonsContentAreaFilled(calendarTheme.getBoolean("Combo/Buttons/contentAreaFilled"));
        this.setButtonsOpaque(calendarTheme.getBoolean("Combo/Buttons/opaqe"));
        this.setButtonsOpaque(calendarTheme.getBoolean("Combo/Buttons/opaque"));
        this.setButtonsDividerWidth(calendarTheme.getInteger("Combo/Buttons/dividerWidth"));
        this.setButtonsDividerColor(calendarTheme.getColor("Combo/Buttons/dividerColor"));
        this.setArrowColor(calendarTheme.getColor("Combo/Buttons/arrowColor"));
        this.setArrowShadowColor(calendarTheme.getColor("Combo/Buttons/arrowShadowColor"));
        this.setBigButtonsInsets(calendarTheme.getInsets("Combo/Buttons/bigInsets"));
        this.setLeftRightButtonInsets(calendarTheme.getInsets("Combo/Buttons/smallInsets"));
        this.setDropDownArrowSize(calendarTheme.getInteger("Combo/Buttons/dropArrowSize"));
        this.setLeftRightArrowSize(calendarTheme.getInteger("Combo/Buttons/leftRightArrowSize"));
        this.setHomeArrowSize(calendarTheme.getInteger("Combo/Buttons/homeArrowSize"));
        this.setHomeArrowGap(calendarTheme.getInteger("Combo/Buttons/homeArrowGap"));
        this.setEditorBorder(calendarTheme.getBorder("Combo/Editor/border"));
        Font font = calendarTheme.getFont("Combo/Editor/font");
        if (font != null) {
            this.setFont(font);
        }
        this.getEditor().setForeground(calendarTheme.getColor("Combo/Editor/foreground"));
        Boolean bl = calendarTheme.getBoolean("Combo/Editor/antiAlias");
        this.setEditorTextAntiAliasHint(bl != null && bl != false ? 5 : 2);
        this.setHideEndDate(calendarTheme.getBool("Combo/Editor/hideEndDate"));
        this.setDefaultTimeStyle(calendarTheme.getInteger("Combo/DateFormat/defaultTimeStyle"));
        this.setDefaultDateStyle(calendarTheme.getInteger("Combo/DateFormat/defaultDateStyle"));
        this.setRangeAddField(calendarTheme.getInteger("Combo/addField"));
        this.setRangeAddAmount(calendarTheme.getInt("Combo/addAmount"));
        this.setCustomRangeAddField(calendarTheme.getInt("Combo/customRangeAddField"));
        this.setCustomRangeMinType(calendarTheme.getInt("Combo/customRangeMinType"));
        this.setCustomRangeStartPrefix(calendarTheme.getString("Combo/DateFormat/CustomPrefix/start"));
        this.setCustomRangeEndPrefix(calendarTheme.getString("Combo/DateFormat/CustomPrefix/end"));
        this.setLeftRightButtonsVisible(calendarTheme.getBool("Combo/Buttons/showArrows"));
        this.setHomeButtonVisible(calendarTheme.getBool("Combo/Buttons/showHome"));
        this.setEditorParsingLenient(calendarTheme.getBool("Combo/Editor/parseLenient"));
    }

    @Override
    protected DateAreaContainer createDateAreaContainer() {
        ThemeDateArea themeDateArea = new ThemeDateArea(this.a);
        return new ThemeDateAreaContainer(themeDateArea);
    }

    @Override
    public Locale getLocale() {
        return ((CalendarTheme)Themes.getTheme(this.a)).getLocale();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == Themes.getTheme(this.a)) {
            this.updateFromTheme();
            this.destroyPopup();
            this.revalidate();
            this.repaint();
        }
    }
}

