/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity;

import com.miginfocom.calendar.activity.Activity;
import com.miginfocom.calendar.activity.recurrence.Recurrence;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.PropertyAdjustingSupport;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.PropertyValidator;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class AbstractActivity
implements Activity,
Serializable {
    public static final PropertyKey PROP_CLIENT_CREATED_MILLIS = PropertyKey.getKey("clientCreatedMillis", Long.class);
    public static final PropertyKey PROP_STORAGE_CREATED_MILLIS = PropertyKey.getKey("storageCreatedMillis", Long.class);
    public static final PropertyKey PROP_LAST_MODIFIED_MILLIS = PropertyKey.getKey("lastModifiedMillis", Long.class);
    public static final PropertyKey PROP_DESCRIPTION = PropertyKey.getKey("description", String.class);
    public static final PropertyKey PROP_LOCATION = PropertyKey.getKey("location", String.class);
    public static final PropertyKey PROP_SUMMARY = PropertyKey.getKey("summary", String.class);
    public static final PropertyKey PROP_ID_OBJECT = PropertyKey.getKey("idObject");
    public static final PropertyKey PROP_ENABLED = PropertyKey.getKey("enabled", Boolean.class);
    public static final PropertyKey BASE_DATE_RANGE = PropertyKey.getKey("baseDateRange", ImmutableDateRange.class);
    public static final PropertyKey PROP_AFFECTED_DATE_RANGE = PropertyKey.getKey("affectedDateRange", ImmutableDateRange.class);
    public static final PropertyKey PROP_PAINT_CONTEXT = PropertyKey.getKey("paintContext", String.class);
    public static final PropertyKey PROP_LAYOUT_CONTEXT = PropertyKey.getKey("layoutContext", String.class);
    public static final PropertyKey PROP_LAYER_INDEX = PropertyKey.getKey("layerIndex", Integer.class);
    public static final PropertyKey PROP_RECURRENCE = PropertyKey.getKey("recurrence", Recurrence.class);
    public static final PropertyKey PROP_CATEGORY_IDS = PropertyKey.getKey("categoryIDs", Object[].class);
    public static final PropertyKey PROP_CALENDAR_ID = PropertyKey.getKey("calendarId", Object.class);
    private static final PropertyAdjustingSupport a = new PropertyAdjustingSupport();
    private final transient IdentityHashMap b = new IdentityHashMap(8);
    private transient Object c;
    private transient ImmutableDateRange d = null;
    private transient boolean e = true;
    private static final ListenerSet f = new ListenerSet(PropertyChangeListener.class);
    private static transient PropertyValidator g = null;
    private final transient ListenerSet h = new ListenerSet(PropertyChangeListener.class);
    private static final long serialVersionUID = 1L;

    protected AbstractActivity(Map map) {
        if (g != null) {
            try {
                map = g.validateSet(this, map);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new IllegalArgumentException(propertyVetoException.getMessage());
            }
        }
        this.addPropertiesSilent(map, Boolean.FALSE);
    }

    protected AbstractActivity(ImmutableDateRange immutableDateRange) {
        if (immutableDateRange == null || !immutableDateRange.isSorted()) {
            throw new IllegalArgumentException("baseRange null or not sorted! :" + this);
        }
        this.setPropertySilent(BASE_DATE_RANGE, immutableDateRange, Boolean.FALSE);
    }

    @Override
    public boolean startAdjusting(PropertyKey propertyKey) {
        return a.startAdjusting(this.getID(), this, propertyKey);
    }

    @Override
    public boolean isAdjusting(PropertyKey propertyKey) {
        return a.isAdjusting(this.getID(), propertyKey);
    }

    @Override
    public Object rollbackAdjusting(PropertyKey propertyKey) {
        return a.rollbackAdjusting(this.getID(), this, propertyKey);
    }

    @Override
    public Object endAdjusting(PropertyKey propertyKey) {
        Object object = a.endAdjusting(this.getID(), propertyKey);
        this.firePropertyChangeEvent(propertyKey.getName(), object, this.getProperty(propertyKey));
        return object;
    }

    @Override
    public ImmutableDateRange getBaseDateRange() {
        return this.d;
    }

    @Override
    public void setBaseDateRange(ImmutableDateRange immutableDateRange) throws PropertyVetoException {
        if (!immutableDateRange.isSorted()) {
            throw new PropertyVetoException("Start date after end date!", new PropertyChangeEvent(this, BASE_DATE_RANGE.getName(), this.getBaseDateRange(), immutableDateRange));
        }
        this.setPropertySilent(BASE_DATE_RANGE, immutableDateRange, null);
    }

    private ImmutableDateRange a() {
        ImmutableDateRange immutableDateRange = (ImmutableDateRange)this.getProperty(BASE_DATE_RANGE);
        Recurrence recurrence = (Recurrence)this.getProperty(PROP_RECURRENCE);
        if (recurrence != null) {
            Long l = recurrence.getLastRecurrenceMillis(immutableDateRange, null);
            long l2 = l != null ? l : Long.MAX_VALUE;
            return new ImmutableDateRange(immutableDateRange.getStartMillis(), l2, false, immutableDateRange.getTimeZone(), immutableDateRange.getLocale());
        }
        return immutableDateRange;
    }

    @Override
    public MutableDateRange getDateRangeClone() {
        return this.getBaseDateRange().getDateRangeClone();
    }

    @Override
    public MutableDateRange getWritableDateRange() {
        throw new UnsupportedOperationException("ActivityView's date range not directly writable!");
    }

    @Override
    public DateRangeI getDateRangeForReading() {
        return this.getBaseDateRange();
    }

    @Override
    public Long getCreatedByStorageDate() {
        return (Long)this.b.get(PROP_STORAGE_CREATED_MILLIS);
    }

    @Override
    public Object[] getCategoryIDs() {
        Object[] objectArray;
        if (this.c == null || this.c instanceof Object[]) {
            objectArray = (Object[])this.c;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.c;
        }
        return objectArray;
    }

    @Override
    public void setCategoryIDs(Object[] objectArray) {
        this.setPropertySilent(PROP_CATEGORY_IDS, objectArray, null);
    }

    @Override
    public boolean isCategory(Object object) {
        if (!(this.c instanceof Object[])) {
            return object.equals(this.c);
        }
        if (this.c != null) {
            Object[] objectArray = (Object[])this.c;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addCategoryID(Object object, int n) {
        Object[] objectArray = this.getCategoryIDs();
        if (objectArray != null && this.isCategory(object)) {
            return;
        }
        objectArray = objectArray != null && objectArray.length > 0 ? MigUtil.addToArray(objectArray, object, n) : new Object[]{object};
        this.setCategoryIDs(objectArray);
    }

    @Override
    public void removeCategoryID(Object object) {
        Object[] objectArray = this.getCategoryIDs();
        if (objectArray == null || !this.isCategory(object)) {
            return;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>(Arrays.asList(objectArray));
        linkedList.remove(object);
        objectArray = linkedList.toArray(new Object[linkedList.size()]);
        this.setCategoryIDs(objectArray);
    }

    protected void setCreatedByStorageDate(Long l) throws PropertyVetoException {
        this.setProperty(PROP_STORAGE_CREATED_MILLIS, l, Boolean.FALSE);
    }

    @Override
    public Long getCreatedDateByClientDate() {
        return (Long)this.b.get(PROP_CLIENT_CREATED_MILLIS);
    }

    protected void setCreatedDateByClientDate(Long l) throws PropertyVetoException {
        this.setProperty(PROP_CLIENT_CREATED_MILLIS, l, Boolean.FALSE);
    }

    @Override
    public String getDescription() {
        return (String)this.b.get(PROP_DESCRIPTION);
    }

    @Override
    public void setDescription(String string) {
        this.setPropertySilent(PROP_DESCRIPTION, string, null);
    }

    @Override
    public String getLocation() {
        return (String)this.b.get(PROP_LOCATION);
    }

    @Override
    public void setLocation(String string) {
        this.setPropertySilent(PROP_LOCATION, string, null);
    }

    @Override
    public Object getID() {
        return this.b.get(PROP_ID_OBJECT);
    }

    @Override
    public void setID(Object object) {
        this.setPropertySilent(PROP_ID_OBJECT, object, null);
    }

    @Override
    public long getLastModified() {
        return (Long)this.b.get(PROP_LAST_MODIFIED_MILLIS);
    }

    @Override
    public void setLastModified(long l) {
        this.b.put(PROP_LAST_MODIFIED_MILLIS, new Long(l));
    }

    @Override
    public void setSummary(String string) {
        this.setPropertySilent(PROP_SUMMARY, string, null);
    }

    @Override
    public String getSummary() {
        return (String)this.b.get(PROP_SUMMARY);
    }

    @Override
    public boolean isEnabled() {
        Boolean bl = (Boolean)this.b.get(PROP_ENABLED);
        return bl == null || bl != false;
    }

    @Override
    public boolean setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            this.setPropertySilent(PROP_ENABLED, Boolean.FALSE, null);
            return true;
        }
        return false;
    }

    @Override
    public Object setPropertySilent(PropertyKey propertyKey, Object object, Boolean bl) {
        try {
            return this.setProperty(propertyKey, object, bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            return null;
        }
    }

    @Override
    public Object setProperty(PropertyKey propertyKey, Object object, Boolean bl) throws PropertyVetoException {
        propertyKey.checkTypeOfValue(object);
        if (g != null) {
            object = g.validateSet(this, propertyKey, object);
        }
        Object object2 = this.b.put(propertyKey, object);
        this.setLastUpdateMillis();
        if (propertyKey == PROP_AFFECTED_DATE_RANGE) {
            this.e = true;
        }
        if (propertyKey == BASE_DATE_RANGE) {
            this.d = (ImmutableDateRange)object;
        }
        if (propertyKey == BASE_DATE_RANGE || propertyKey == PROP_RECURRENCE) {
            this.setProperty(PROP_AFFECTED_DATE_RANGE, this.a(), Boolean.FALSE);
        }
        if (propertyKey == PROP_CATEGORY_IDS) {
            Object[] objectArray = (Object[])object;
            Object object3 = objectArray == null || objectArray.length > 1 ? objectArray : (this.c = objectArray.length > 0 ? objectArray[0] : null);
        }
        if (bl == null ? !MigUtil.equals(object2, object) : bl != false) {
            this.firePropertyChangeEvent(propertyKey.getName(), object2, object);
        }
        return object2;
    }

    @Override
    public void setPropertiesSilent(Map map, Boolean bl) {
        try {
            this.setProperties(map, bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setProperties(Map map, Boolean bl) throws PropertyVetoException {
        boolean bl2;
        for (Map.Entry entry : map.entrySet()) {
            ((PropertyKey)entry.getKey()).checkTypeOfValue(entry.getValue());
        }
        if (g != null) {
            map = g.validateSet(this, Collections.unmodifiableMap(map));
        }
        IdentityHashMap identityHashMap = (IdentityHashMap)this.b.clone();
        this.b.clear();
        this.b.putAll(map);
        this.setProperty(BASE_DATE_RANGE, map.get(BASE_DATE_RANGE), Boolean.FALSE);
        this.setProperty(PROP_AFFECTED_DATE_RANGE, this.a(), Boolean.FALSE);
        this.setProperty(PROP_CATEGORY_IDS, map.get(PROP_CATEGORY_IDS), Boolean.FALSE);
        boolean bl3 = bl == null ? !MigUtil.equals(identityHashMap, this.b) : (bl2 = bl.booleanValue());
        if (bl2) {
            this.firePropertyChangeEvent(null, Collections.unmodifiableMap(identityHashMap), Collections.unmodifiableMap(this.b));
        }
    }

    @Override
    public void addPropertiesSilent(Map map, Boolean bl) {
        try {
            this.addProperties(map, bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void addProperties(Map map, Boolean bl) throws PropertyVetoException {
        boolean bl2 = bl != null && bl != false;
        for (Map.Entry entry : map.entrySet()) {
            PropertyKey propertyKey = (PropertyKey)entry.getKey();
            Object object = entry.getValue();
            propertyKey.checkTypeOfValue(object);
            if (g != null) {
                object = g.validateSet(this, propertyKey, object);
            }
            Object v = this.b.put(propertyKey, object);
            if (bl2 || bl != null) continue;
            bl2 = MigUtil.equals(v, object);
        }
        this.setLastUpdateMillis();
        if (map.containsKey(BASE_DATE_RANGE)) {
            this.setProperty(BASE_DATE_RANGE, map.get(BASE_DATE_RANGE), Boolean.FALSE);
        }
        if (map.containsKey(BASE_DATE_RANGE) || map.containsKey(PROP_RECURRENCE)) {
            this.setProperty(PROP_AFFECTED_DATE_RANGE, this.a(), Boolean.FALSE);
        }
        if (map.containsKey(PROP_CATEGORY_IDS)) {
            this.setProperty(PROP_CATEGORY_IDS, map.get(PROP_CATEGORY_IDS), Boolean.FALSE);
        }
        if (bl2) {
            this.firePropertyChangeEvent(null, null, null);
        }
    }

    @Override
    public Object getProperty(PropertyKey propertyKey) {
        return this.b.get(propertyKey);
    }

    @Override
    public Map getProperties() {
        return new IdentityHashMap(this.b);
    }

    @Override
    public void setProperties(Map map) {
        this.setPropertiesSilent(map, null);
    }

    @Override
    public Object removeProperty(PropertyKey propertyKey) {
        return this.removePropertySilent(propertyKey, null);
    }

    @Override
    public Object removeProperty(PropertyKey propertyKey, Boolean bl) throws PropertyVetoException {
        boolean bl2;
        if (g != null) {
            g.validateRemove(this, propertyKey);
        }
        boolean bl3 = this.b.containsKey(propertyKey);
        Object v = this.b.remove(propertyKey);
        if (bl3) {
            this.setLastUpdateMillis();
        }
        if (propertyKey == PROP_RECURRENCE) {
            this.setProperty(PROP_AFFECTED_DATE_RANGE, this.a(), Boolean.FALSE);
        }
        boolean bl4 = bl2 = bl != null ? bl : bl3;
        if (bl2) {
            this.firePropertyChangeEvent(propertyKey.getName(), v, null);
        }
        return v;
    }

    @Override
    public Object removePropertySilent(PropertyKey propertyKey, Boolean bl) {
        try {
            return this.removeProperty(propertyKey, bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            return null;
        }
    }

    @Override
    public boolean containsProperty(PropertyKey propertyKey) {
        return this.b.containsKey(propertyKey);
    }

    protected void setLastUpdateMillis() {
        this.b.put(PROP_LAST_MODIFIED_MILLIS, new Long(System.currentTimeMillis()));
    }

    public int compareTo(Object object) {
        int n;
        Activity activity = (Activity)object;
        int n2 = this.getLayerIndex();
        if (n2 != (n = activity.getLayerIndex())) {
            return n - n2;
        }
        DateRangeI dateRangeI = activity.getDateRangeForReading();
        DateRangeI dateRangeI2 = this.getDateRangeForReading();
        long l = dateRangeI2.getStartMillis() - dateRangeI.getStartMillis();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        long l2 = dateRangeI2.getEndMillis() - dateRangeI.getEndMillis();
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isLayoutNeeded() {
        return this.e;
    }

    @Override
    public void clearLayoutNeededFlag() {
        this.e = false;
    }

    @Override
    public void setRecurrence(Recurrence recurrence) {
        this.setPropertySilent(PROP_RECURRENCE, recurrence, null);
    }

    @Override
    public Recurrence getRecurrence() {
        return (Recurrence)this.b.get(PROP_RECURRENCE);
    }

    @Override
    public boolean isRecurrent() {
        return this.b.get(PROP_RECURRENCE) != null;
    }

    @Override
    public String getPaintContext() {
        return (String)this.b.get(PROP_PAINT_CONTEXT);
    }

    @Override
    public void setPaintContext(String string) {
        this.setPropertySilent(PROP_PAINT_CONTEXT, string, null);
    }

    @Override
    public String getLayoutContext() {
        return (String)this.b.get(PROP_LAYOUT_CONTEXT);
    }

    @Override
    public void setLayoutContext(String string) {
        this.setPropertySilent(PROP_LAYOUT_CONTEXT, string, null);
    }

    @Override
    public int getLayerIndex() {
        Integer n = (Integer)this.b.get(PROP_LAYER_INDEX);
        return n != null ? n : 0;
    }

    @Override
    public void setLayerIndex(int n) {
        this.setPropertySilent(PROP_LAYER_INDEX, new Integer(n), null);
    }

    public int hashCode() {
        Object object = this.getID();
        return object != null ? object.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Activity)) {
            return false;
        }
        return MigUtil.equals(((Activity)object).getID(), this.getID());
    }

    @Override
    public boolean equalProperties(Activity activity) {
        if (this == activity) {
            return true;
        }
        for (Map.Entry entry : this.b.entrySet()) {
            Object object;
            Object v = entry.getValue();
            if (v == (object = activity.getProperty((PropertyKey)entry.getKey()))) continue;
            if (v == null || object == null) {
                return false;
            }
            if (!(v.getClass().isArray() && object.getClass().isArray() ? !Arrays.equals((Object[])v, (Object[])object) : !MigUtil.equals(v, object))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Set set = this.b.entrySet();
        StringBuffer stringBuffer = new StringBuffer(set.size() * 64);
        for (Map.Entry entry : set) {
            stringBuffer.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static void addStaticPropertyChangeListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        f.add(propertyChangeListener, bl);
    }

    public static void removeStaticPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        f.remove(propertyChangeListener);
    }

    public static void fireStaticPropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        f.fireEvent(propertyChangeEvent);
    }

    public static void setPropertyValidator(PropertyValidator propertyValidator) {
        MigUtil.checkComponentVersion(600);
        g = propertyValidator;
    }

    public static PropertyValidator getPropertyValidator() {
        return g;
    }

    @Override
    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyListener(propertyChangeListener, false);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        this.h.add(propertyChangeListener, bl);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener propertyChangeListener) {
        this.h.remove(propertyChangeListener);
    }

    @Override
    public boolean isIgnorePropertyEvents() {
        return this.h.isIgnoreEvents();
    }

    @Override
    public boolean setIgnorePropertyEvents(boolean bl) {
        return this.h.setIgnoreEvents(bl);
    }

    protected void firePropertyChangeEvent(String string, Object object, Object object2) {
        this.propertyChange(new PropertyChangeEvent(this, string, object, object2));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        propertyChangeEvent = new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        this.h.fireEvent(propertyChangeEvent);
        AbstractActivity.fireStaticPropertyChangeEvent(propertyChangeEvent);
    }
}

