/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity;

import com.miginfocom.ashape.interaction.InteractionListener;
import com.miginfocom.calendar.activity.AbstractActivity;
import com.miginfocom.calendar.activity.Activity;
import com.miginfocom.calendar.activity.ActivityList;
import com.miginfocom.calendar.activity.ActivityResolver;
import com.miginfocom.calendar.activity.iofilter.ActivitySubscription;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.TimeSpan;
import com.miginfocom.util.dates.TimeSpanList;
import com.miginfocom.util.dates.TimeSpanListEvent;
import com.miginfocom.util.dates.TimeSpanListListener;
import com.miginfocom.util.filter.Filter;
import com.miginfocom.util.io.IOUtil;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JComponent;

public class ActivityDepository
implements ActivityResolver,
PropertyChangeListener {
    private static final HashMap a = new HashMap();
    private Logger b = null;
    private Class c = null;
    private final ActivityList d = new ActivityList(256);
    private final HashMap e = new HashMap(256, 0.5f);
    private final ArrayList f = new ArrayList();
    private ActivityResolver g = null;
    public static final String PROP_SUBSCR_ADDED = "subscription_added";
    public static final String PROP_SUBSCR_REMOVED = "subscription_removed";
    private final ListenerSet h = new ListenerSet(PropertyChangeListener.class);
    private final ListenerSet i = new ListenerSet(PropertyChangeListener.class);
    private final ListenerSet j = new ListenerSet(TimeSpanListListener.class);

    public static final ActivityDepository getInstance() {
        return ActivityDepository.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ActivityDepository getInstance(String string) {
        HashMap hashMap = a;
        synchronized (hashMap) {
            ActivityDepository activityDepository = (ActivityDepository)a.get(string);
            if (activityDepository == null) {
                activityDepository = new ActivityDepository();
                a.put(string, activityDepository);
            }
            return activityDepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeInstance(String string) {
        HashMap hashMap = a;
        synchronized (hashMap) {
            ActivityDepository activityDepository = (ActivityDepository)a.remove(string);
            if (activityDepository != null) {
                activityDepository.a();
            }
            return activityDepository != null;
        }
    }

    public static synchronized Activity[] loadActivities(InputStream inputStream, ExceptionListener exceptionListener, boolean bl) throws IOException {
        if (IOUtil.isZippedStream(inputStream = IOUtil.bufferInputStream(inputStream, 16384), bl) && (inputStream = IOUtil.getZipEntryStream(inputStream, "activityData")) == null) {
            throw new IOException("Zipped stream does not contain entry 'activityData'");
        }
        XMLDecoder xMLDecoder = new XMLDecoder(inputStream, null, exceptionListener);
        Activity[] activityArray = (Activity[])xMLDecoder.readObject();
        xMLDecoder.close();
        return activityArray;
    }

    public static synchronized void saveActivities(Activity[] activityArray, OutputStream outputStream, ExceptionListener exceptionListener, boolean bl) throws IOException {
        outputStream = IOUtil.bufferOutputStream(outputStream, 16384);
        if (bl) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.setLevel(9);
            zipOutputStream.putNextEntry(new ZipEntry("activityData"));
            outputStream = zipOutputStream;
        }
        IOUtil.writeXMLObject(outputStream, activityArray, exceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDepository(String string, ActivityDepository activityDepository) {
        if (activityDepository == null) {
            throw new IllegalArgumentException("Depository can't be null!");
        }
        HashMap hashMap = a;
        synchronized (hashMap) {
            if (a.containsKey(string)) {
                throw new UnsupportedOperationException("ActivityDepository can't be changed after it has been created for a context!");
            }
            a.put(string, activityDepository);
        }
    }

    protected ActivityDepository() {
        AbstractActivity.addStaticPropertyChangeListener(this, true);
    }

    private void a() {
        AbstractActivity.removeStaticPropertyChangeListener(this);
        this.removeAllSubscriptions();
        this.removeAllBrokedActivities();
        this.setActivityResolver(null);
        this.setLogger(null);
    }

    public Class getEnforceIDClass() {
        return this.c;
    }

    public void setEnforceIDClass(Class clazz) {
        this.c = clazz;
    }

    public Logger getLogger() {
        return this.b;
    }

    public void setLogger(Logger logger) {
        this.b = logger;
    }

    private final void a(Object object) {
        if (this.c != null && this.c != object.getClass() || object == null || object instanceof Activity) {
            if (this.b != null) {
                this.b.warning("Wrong ID Class: " + object.getClass() + ". Should be: " + this.c);
            }
            throw new IllegalArgumentException("ID class type check failed. Id must be " + this.c + ". " + object.getClass() + " sent in.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity getActivity(Object object) {
        this.a(object);
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            return (Activity)this.e.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityList getActivities() {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            ActivityList activityList = new ActivityList(this.d.size());
            activityList.addAll(this.d);
            return activityList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBrokedActivityCount() {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            return this.d.size();
        }
    }

    public ActivityResolver getActivityResolver() {
        return this.g;
    }

    public void setActivityResolver(ActivityResolver activityResolver) {
        if (this.b != null) {
            this.b.info("Changed Resolver.");
        }
        this.g = activityResolver;
    }

    public ActivityResolver getCurrentActivityResolver() {
        return this.g != null ? this.g : this;
    }

    @Override
    public Activity resolve(Activity activity, Activity activity2, Object object) {
        if (this.b != null) {
            this.b.finer("Resolving. current: " + activity.getID() + ", adding: " + activity2.getID() + ", adder: " + object);
        }
        if (activity2.getLastModified() > activity.getLastModified()) {
            if (this.b != null) {
                this.b.finer("Resolve result: Current Activity Updated.");
            }
            activity.setPropertiesSilent(activity2.getProperties(), Boolean.TRUE);
        } else if (this.b != null) {
            this.b.finer("Resolve result: Current Activity Unchanged since it is same or newer.");
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(ActivitySubscription activitySubscription) {
        if (this.b != null) {
            this.b.info("Adding Subscription: " + activitySubscription);
        }
        ArrayList arrayList = this.f;
        synchronized (arrayList) {
            this.f.add(activitySubscription);
        }
        this.a(new PropertyChangeEvent(this, PROP_SUBSCR_ADDED, activitySubscription, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(ActivitySubscription activitySubscription) {
        if (this.b != null) {
            this.b.info("Removing Subscription: " + activitySubscription);
        }
        ArrayList arrayList = this.f;
        synchronized (arrayList) {
            this.f.remove(activitySubscription);
        }
        this.a(new PropertyChangeEvent(this, PROP_SUBSCR_REMOVED, activitySubscription, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllSubscriptions() {
        if (this.b != null) {
            this.b.info("Removing all Subscriptions");
        }
        ArrayList arrayList = this.f;
        synchronized (arrayList) {
            while (this.f.size() > 0) {
                this.f.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriptions(Object object) {
        int n;
        ArrayList<ActivitySubscription> arrayList = new ArrayList<ActivitySubscription>(4);
        ArrayList arrayList2 = this.f;
        synchronized (arrayList2) {
            int n2 = this.f.size();
            for (n = 0; n < n2; ++n) {
                ActivitySubscription activitySubscription = (ActivitySubscription)this.f.get(n);
                if (activitySubscription.getSource() != object) continue;
                arrayList.add(activitySubscription);
            }
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.removeSubscription((ActivitySubscription)arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivitySubscription[] getSubscriptions() {
        ArrayList arrayList = this.f;
        synchronized (arrayList) {
            return this.f.toArray(new ActivitySubscription[this.f.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSpanList[] getActivityViewLists(JComponent jComponent, InteractionListener interactionListener, DateRangeI dateRangeI) {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            return this.d.getActivityViewLists(jComponent, interactionListener, dateRangeI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSpanList[] getActivityViewLists(JComponent jComponent, InteractionListener interactionListener, DateRangeI dateRangeI, Filter filter) {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            return this.d.getActivityViewLists(jComponent, interactionListener, dateRangeI, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSpanList getActivityViews(JComponent jComponent, InteractionListener interactionListener, DateRangeI dateRangeI, Filter filter) {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            return this.d.getActivityViews(jComponent, interactionListener, dateRangeI, filter);
        }
    }

    public void addBrokedActivities(Collection collection, Object object) {
        this.addBrokedActivities(collection, object, 0);
    }

    public void addBrokedActivities(Collection collection, Object object, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addBrokedActivity((Activity)iterator.next(), object, n);
        }
    }

    public void addBrokedActivity(Activity activity, Object object) {
        this.addBrokedActivity(activity, object, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBrokedActivity(Activity activity, Object object, int n) {
        Object object2 = activity.getID();
        if (this.b != null) {
            this.b.fine("Adding: " + object2 + " with event type: " + n);
        }
        this.a(object2);
        Activity activity2 = (Activity)this.e.get(object2);
        if (activity2 == null) {
            HashMap hashMap = this.e;
            synchronized (hashMap) {
                this.e.put(object2, activity);
                this.d.add(activity);
            }
            this.fireDepositoryChanged(activity, object, n);
        } else {
            Activity activity3;
            if (this.b != null) {
                this.b.fine("Calling the Resolver to resolve Add conflict.");
            }
            if ((activity3 = this.getCurrentActivityResolver().resolve(activity2, activity, object)) != null && activity3 != activity2) {
                this.removeBrokedActivity(activity2, -1);
                if (activity3 != null) {
                    HashMap hashMap = this.e;
                    synchronized (hashMap) {
                        this.e.put(object2, activity3);
                        this.d.add(activity3);
                    }
                    if (n != -1) {
                        this.fireDepositoryChanged(activity, object, 2);
                    }
                }
            }
        }
    }

    public boolean removeBrokedActivity(Activity activity) {
        return this.removeBrokedActivity(activity, 1);
    }

    public boolean removeBrokedActivity(Activity activity, int n) {
        return this.removeBrokedActivityById(activity.getID(), n) != null;
    }

    public Activity removeBrokedActivityById(Object object) {
        return this.removeBrokedActivityById(object, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity removeBrokedActivityById(Object object, int n) {
        this.a(object);
        Activity activity = null;
        if (this.b != null && !this.e.containsKey(object)) {
            this.b.fine("Removing: " + object);
        }
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            activity = (Activity)this.e.remove(object);
            if (activity != null) {
                this.d.remove(activity);
            }
        }
        if (activity != null) {
            if (n != -1) {
                this.fireDepositoryChanged(activity, null, n);
            }
        } else if (this.b != null) {
            this.b.finer("Tried to Remove Activity not in depository: " + object);
        }
        return activity;
    }

    public void removeBrokedActivities(Collection collection) {
        this.removeBrokedActivities(collection, 1);
    }

    public void removeBrokedActivities(Collection collection, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeBrokedActivity((Activity)iterator.next(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBrokedActivities() {
        TimeSpan[] timeSpanArray;
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            if (this.e.size() == 0) {
                return;
            }
            timeSpanArray = this.d.toArray();
            this.e.clear();
            this.d.clear(256);
        }
        this.fireDepositoryChanged(timeSpanArray, null, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBrokedActivities() {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            return Arrays.asList(this.d.toArray());
        }
    }

    public void addSubscriptionListener(PropertyChangeListener propertyChangeListener) {
        this.addSubscriptionListener(propertyChangeListener, false);
    }

    public void addSubscriptionListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        this.h.add(propertyChangeListener, bl);
    }

    public void removeSubscriptionListener(PropertyChangeListener propertyChangeListener) {
        this.h.remove(propertyChangeListener);
    }

    private void a(PropertyChangeEvent propertyChangeEvent) {
        this.h.fireEvent(propertyChangeEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(propertyChangeListener, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        this.i.add(propertyChangeListener, bl);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.i.remove(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (this.i.size() > 0 && (object = propertyChangeEvent.getSource()) instanceof Activity && this.e.containsKey(((Activity)object).getID())) {
            this.i.fireEvent(propertyChangeEvent);
        }
    }

    public void addDepositoryListener(TimeSpanListListener timeSpanListListener) {
        this.addDepositoryListener(timeSpanListListener, false);
    }

    public void addDepositoryListener(TimeSpanListListener timeSpanListListener, boolean bl) {
        this.j.add(timeSpanListListener, bl);
    }

    public void removeDepositoryListener(TimeSpanListListener timeSpanListListener) {
        this.j.remove(timeSpanListListener);
    }

    public void fireDepositoryChanged(Activity activity, Object object, int n) {
        if (this.j.size() > 0) {
            ImmutableDateRange immutableDateRange = (ImmutableDateRange)activity.getProperty(AbstractActivity.PROP_AFFECTED_DATE_RANGE);
            TimeSpanListEvent timeSpanListEvent = new TimeSpanListEvent(this.d, n, new TimeSpan[]{activity}, immutableDateRange);
            this.j.fireEvent(timeSpanListEvent);
        }
    }

    public void fireDepositoryChanged(TimeSpan[] timeSpanArray, Object object, int n) {
        if (this.j.size() > 0) {
            this.j.fireEvent(new TimeSpanListEvent(this.d, n, timeSpanArray));
        }
    }

    public void addActivityListListener(TimeSpanListListener timeSpanListListener, boolean bl) {
        this.d.addTimeSpanListListener(timeSpanListListener, bl);
    }

    public void removeActivityListListener(TimeSpanListListener timeSpanListListener) {
        this.d.removeTimeSpanListListener(timeSpanListListener);
    }

    public void fireManualDepositoryListChanged(TimeSpan[] timeSpanArray, int n, DateRangeI dateRangeI) {
        this.d.fireDepositoryListChanged(timeSpanArray, n, dateRangeI);
    }
}

