/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity;

import com.miginfocom.ashape.interaction.InteractionListener;
import com.miginfocom.calendar.activity.Activity;
import com.miginfocom.calendar.activity.view.ActivityView;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRange;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.DateRangeRounder;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.TimeSpan;
import com.miginfocom.util.dates.TimeSpanList;
import com.miginfocom.util.filter.Filter;
import java.beans.PropertyVetoException;
import java.util.Collection;
import javax.swing.JComponent;

public class ActivityList
extends TimeSpanList {
    public ActivityList() {
    }

    public ActivityList(int n) {
        super(n);
    }

    public ActivityList(Collection collection) {
        super(collection);
    }

    public ActivityList(Activity[] activityArray) {
        super(activityArray);
    }

    public TimeSpanList[] getActivityViewLists(JComponent jComponent, InteractionListener interactionListener, DateRangeI dateRangeI) {
        return this.getActivityViewLists(jComponent, interactionListener, dateRangeI, null);
    }

    public TimeSpanList[] getActivityViewLists(JComponent jComponent, InteractionListener interactionListener, DateRangeI dateRangeI, Filter filter) {
        Object[] objectArray = new TimeSpanList[]{};
        int[] nArray = new int[]{};
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Activity activity = (Activity)this.get(i);
            if (!activity.isRecurrent() && !dateRangeI.isOverlapping(activity.getBaseDateRange()) || filter != null && !filter.accept(activity)) continue;
            int n3 = activity.getLayerIndex();
            TimeSpanList timeSpanList = null;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (nArray[n2] != n3) continue;
                timeSpanList = objectArray[n2];
                break;
            }
            if (timeSpanList == null) {
                timeSpanList = new TimeSpanList();
                for (n2 = 0; n2 < nArray.length && nArray[n2] < n3; ++n2) {
                }
                objectArray = (TimeSpanList[])MigUtil.addToArray(objectArray, timeSpanList, n2);
                nArray = MigUtil.addToArray(nArray, n3, n2);
            }
            if (!activity.isRecurrent()) {
                timeSpanList.add(activity.getBaseView(jComponent, interactionListener));
                continue;
            }
            ActivityView[] activityViewArray = activity.getViews(jComponent, interactionListener, dateRangeI);
            for (int j = 0; j < activityViewArray.length; ++j) {
                timeSpanList.add(activityViewArray[j]);
            }
        }
        return objectArray;
    }

    public TimeSpanList getActivityViews(JComponent jComponent, InteractionListener interactionListener, DateRangeI dateRangeI, Filter filter) {
        TimeSpanList timeSpanList = new TimeSpanList(this.size());
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Activity activity = (Activity)this.get(i);
            if (!activity.isRecurrent()) {
                if (!dateRangeI.isOverlapping(activity.getBaseDateRange()) || filter != null && !filter.accept(activity)) continue;
                timeSpanList.add(activity.getBaseView(jComponent, interactionListener));
                continue;
            }
            if (filter != null && !filter.accept(activity)) continue;
            ActivityView[] activityViewArray = activity.getViews(jComponent, interactionListener, dateRangeI);
            for (int j = 0; j < activityViewArray.length; ++j) {
                timeSpanList.add(activityViewArray[j]);
            }
        }
        return timeSpanList;
    }

    public Activity removeActivityById(Object object) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TimeSpan timeSpan = this.get(i);
            if (!(timeSpan instanceof Activity) || !((Activity)timeSpan).getID().equals(object)) continue;
            return (Activity)this.remove(i);
        }
        return null;
    }

    public ImmutableDateRange[] getDateRanges() {
        ImmutableDateRange[] immutableDateRangeArray = new ImmutableDateRange[this.size()];
        for (int i = 0; i < immutableDateRangeArray.length; ++i) {
            immutableDateRangeArray[i] = this.get(i).getDateRangeForReading().getImmutable();
        }
        return immutableDateRangeArray;
    }

    public boolean addMoveDateRanges(int n, int n2, boolean bl, boolean bl2, DateRangeRounder dateRangeRounder) {
        boolean bl3 = true;
        for (int i = 0; i < this.size(); ++i) {
            Activity activity = (Activity)this.get(i);
            DateRange dateRange = new DateRange(activity.getBaseDateRange());
            dateRange.add(n, n2, bl, bl2, dateRangeRounder);
            try {
                activity.setBaseDateRange(dateRange.getImmutable());
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                bl3 = false;
            }
        }
        return bl3;
    }

    public boolean setDateRanges(ImmutableDateRange[] immutableDateRangeArray) {
        boolean bl = true;
        for (int i = 0; i < immutableDateRangeArray.length; ++i) {
            try {
                ((Activity)this.get(i)).setBaseDateRange(immutableDateRangeArray[i]);
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                bl = false;
            }
        }
        return bl;
    }
}

