/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity.iofilter;

import com.miginfocom.calendar.activity.AbstractActivity;
import com.miginfocom.calendar.activity.Activity;
import com.miginfocom.calendar.activity.ActivityDepository;
import com.miginfocom.calendar.activity.DefaultActivity;
import com.miginfocom.calendar.activity.iofilter.AbstractActivityIOPlugin;
import com.miginfocom.calendar.activity.recurrence.ByXXXRuleData;
import com.miginfocom.calendar.activity.recurrence.CompositeRecurrence;
import com.miginfocom.calendar.activity.recurrence.Recurrence;
import com.miginfocom.calendar.activity.recurrence.RecurrenceRule;
import com.miginfocom.util.dates.DateRange;
import com.miginfocom.util.dates.DateUtil;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ICalendarImport
extends AbstractActivityIOPlugin {
    protected String fileName;
    protected Object[] catIDs;
    protected long lastMod = -1L;
    private static HashMap a = new HashMap(16);
    private static HashMap b;
    private static HashMap c;

    public ICalendarImport() {
    }

    public ICalendarImport(String string, Object[] objectArray) {
        this.fileName = string;
        this.catIDs = objectArray;
    }

    @Override
    public synchronized void pollUpdates() {
        File file = new File(this.fileName);
        long l = file.lastModified();
        if (l == 0L) {
            return;
        }
        if (this.lastMod != l) {
            ArrayList arrayList = this.importICal();
            ActivityDepository.getInstance().addBrokedActivities(arrayList, this, 3);
            this.lastMod = l;
        }
    }

    @Override
    public long getDefaultPollInterval() {
        return 30000L;
    }

    @Override
    public Object getID() {
        return "MiGCalendar-iCalendar-import";
    }

    @Override
    public String getName() {
        return "MiG Calendar iCalendar Import";
    }

    @Override
    public boolean isReadSupported() {
        return true;
    }

    @Override
    public boolean isWriteSupported() {
        return false;
    }

    public Object[] getCatIDs() {
        return this.catIDs;
    }

    public void setCatIDs(Object[] objectArray) {
        this.catIDs = objectArray;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.lastMod = 0L;
    }

    public ArrayList importICal() {
        String string;
        Object object;
        Object object2;
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            object2 = new BufferedReader(new FileReader(this.fileName));
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                if (((String)object).length() == 0 || ((String)object).startsWith(";") || ((String)object).startsWith("COMMENT")) continue;
                if (linkedList.size() > 0 && Character.isWhitespace(((String)object).charAt(0))) {
                    string = (String)linkedList.removeLast();
                    linkedList.add(string + ((String)object).trim());
                    continue;
                }
                linkedList.add(((String)object).trim());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            return null;
        }
        object2 = new ArrayList(40);
        object = linkedList.listIterator(0);
        block3: while (object.hasNext()) {
            string = (String)object.next();
            if (!string.equals("BEGIN:VEVENT")) continue;
            ((ArrayList)object2).clear();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!string2.equals("END:VEVENT")) {
                    ((ArrayList)object2).add(string2);
                    continue;
                }
                Activity activity = this.tranActivity((ArrayList)object2);
                if (activity == null) continue block3;
                activity.setCategoryIDs(this.catIDs);
                arrayList.add(activity);
                continue block3;
            }
        }
        return arrayList;
    }

    protected Activity tranActivity(ArrayList arrayList) {
        String string = null;
        Calendar calendar = null;
        Calendar calendar2 = null;
        Calendar calendar3 = null;
        Calendar calendar4 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Integer n = null;
        CompositeRecurrence compositeRecurrence = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string5 = (String)arrayList.get(i);
            if (string5.startsWith("UID")) {
                string = string5.substring(4);
                continue;
            }
            if (string5.startsWith("DTSTART")) {
                calendar = ICalendarImport.parseDateTime(string5.substring(8));
                continue;
            }
            if (string5.startsWith("DTEND")) {
                calendar2 = ICalendarImport.parseDateTime(string5.substring(6));
                continue;
            }
            if (string5.startsWith("SUMMARY")) {
                string2 = string5.substring(8);
                continue;
            }
            if (string5.startsWith("DESCRIPTION")) {
                string3 = string5.substring(12);
                continue;
            }
            if (string5.startsWith("LOCATION")) {
                string4 = string5.substring(9);
                continue;
            }
            if (string5.startsWith("LAST-MODIFIED")) {
                calendar3 = ICalendarImport.parseDateTime(string5.substring(14));
                continue;
            }
            if (string5.startsWith("DTSTAMP")) {
                calendar4 = ICalendarImport.parseDateTime(string5.substring(8));
                continue;
            }
            if (string5.startsWith("DURATION")) {
                n = ICalendarImport.parseDuration(string5.substring(9));
                continue;
            }
            if (!string5.startsWith("EXDATE") && !string5.startsWith("RDATE") && !string5.startsWith("RRULE") && !string5.startsWith("EXRULE")) continue;
            compositeRecurrence = this.addRecurrenceInfo(string5, compositeRecurrence);
        }
        if (string == null || calendar == null) {
            return null;
        }
        if (string2 == string3) {
            // empty if block
        }
        if (calendar2 == null) {
            calendar2 = (Calendar)calendar.clone();
            if (n != null) {
                calendar2.add(13, n);
            }
        } else if (calendar2.getTimeInMillis() < calendar.getTimeInMillis()) {
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
        }
        DefaultActivity defaultActivity = new DefaultActivity(new ImmutableDateRange(calendar.getTimeInMillis(), calendar2.getTimeInMillis(), true, null, null), string);
        defaultActivity.setIgnorePropertyEvents(true);
        if (string2 != null) {
            defaultActivity.setSummary(string2);
        }
        if (string3 != null) {
            defaultActivity.setDescription(string3);
        }
        if (string4 != null) {
            defaultActivity.setLocation(string4);
        }
        if (calendar4 != null) {
            defaultActivity.setPropertySilent(AbstractActivity.PROP_STORAGE_CREATED_MILLIS, calendar4, Boolean.FALSE);
        }
        if (compositeRecurrence != null) {
            defaultActivity.setRecurrence(compositeRecurrence);
        }
        if (calendar3 != null) {
            defaultActivity.setLastModified(calendar3.getTimeInMillis());
        }
        defaultActivity.setIgnorePropertyEvents(false);
        return defaultActivity;
    }

    public CompositeRecurrence addRecurrenceInfo(String string, CompositeRecurrence compositeRecurrence) {
        try {
            compositeRecurrence = compositeRecurrence != null ? compositeRecurrence : new CompositeRecurrence();
            string = string.toUpperCase();
            if (string.startsWith("RDATE")) {
                LinkedList linkedList = ICalendarImport.parseDateTimes(string.substring(6), false);
                if (linkedList != null) {
                    ListIterator listIterator = linkedList.listIterator(0);
                    while (listIterator.hasNext()) {
                        compositeRecurrence.addIncludingRange((ImmutableDateRange)listIterator.next());
                    }
                }
            } else if (string.startsWith("EXDATE")) {
                LinkedList linkedList = ICalendarImport.parseDateTimes(string.substring(7), true);
                if (linkedList != null) {
                    ListIterator listIterator = linkedList.listIterator(0);
                    while (listIterator.hasNext()) {
                        compositeRecurrence.addExcludingRange((ImmutableDateRange)listIterator.next());
                    }
                }
            } else if (string.startsWith("RRULE")) {
                compositeRecurrence.addIncludingRecurrence(this.parseRecurrenceRule(string.substring(6)));
            } else if (string.startsWith("EXRULE")) {
                compositeRecurrence.addExcludingRecurrence(this.parseRecurrenceRule(string.substring(7)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return compositeRecurrence;
    }

    public Recurrence parseRecurrenceRule(String string) {
        RecurrenceRule recurrenceRule = new RecurrenceRule(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            Object object3;
            Serializable serializable;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equals("FREQ")) {
                serializable = (Integer)a.get(string4);
                if (serializable == null) {
                    throw new IllegalArgumentException("Unknown freqency: " + string4);
                }
                recurrenceRule.setFrequency((Integer)serializable);
                continue;
            }
            if (string3.equals("UNTIL")) {
                recurrenceRule.setUntilDate(ICalendarImport.parseDateTime(string4));
                continue;
            }
            if (string3.equals("INTERVAL")) {
                recurrenceRule.setInterval(Integer.parseInt(string4));
                continue;
            }
            if (string3.equals("COUNT")) {
                recurrenceRule.setRepetitionCount(new Integer(string4));
                continue;
            }
            if (string3.equals("BYSETPOS")) {
                serializable = this.splitCS(string4);
                object3 = new int[((ArrayList)serializable).size()];
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    try {
                        object3[i] = Integer.parseInt((String)((ArrayList)serializable).get(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        object3[i] = 0x3FFFFFF5;
                    }
                }
                recurrenceRule.setBySetPos((int[])object3);
                continue;
            }
            serializable = (Integer)b.get(string3);
            if (serializable == null) continue;
            object3 = new ArrayList(20);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
            boolean bl = false;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",", false);
            while (stringTokenizer2.hasMoreTokens()) {
                object2 = stringTokenizer2.nextToken();
                if (string3.equals("BYDAY")) {
                    object = null;
                    if (((String)object2).length() > 2) {
                        object = ((String)object2).substring(0, ((String)object2).length() - 2);
                        object2 = ((String)object2).substring(((String)object).length());
                        bl = true;
                    }
                    ((ArrayList)object3).add(c.get(object2));
                    arrayList.add(object != null ? new Integer((String)object) : null);
                    continue;
                }
                if (string3.equals("BYMONTH")) {
                    ((ArrayList)object3).add(new Integer(Integer.parseInt((String)object2) - 1));
                } else {
                    ((ArrayList)object3).add(new Integer((String)object2));
                }
                arrayList.add(null);
            }
            int n2 = ((ArrayList)object3).size();
            object2 = new int[n2];
            object = bl ? new int[n2] : null;
            for (int i = 0; i < n2; ++i) {
                object2[i] = (Integer)((ArrayList)object3).get(i);
                if (!bl) continue;
                Integer n3 = (Integer)arrayList.get(i);
                object[i] = n3 != null ? n3 : 0;
            }
            recurrenceRule.addByXXXRule(new ByXXXRuleData((Integer)serializable, (int[])object2, (int[])object));
        }
        return recurrenceRule;
    }

    protected ArrayList splitCS(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static Calendar parseDateTime(String string) {
        try {
            TimeZone timeZone = string.startsWith("TZID") ? TimeZone.getTimeZone(string.substring(string.indexOf(61, 4) + 1, string.indexOf(58, 5))) : TimeZone.getDefault();
            String string2 = string.substring(string.lastIndexOf(58) + 1).trim();
            return ICalendarImport.parseDateTimeFields(string2, timeZone);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public static LinkedList parseDateTimes(String string, boolean bl) {
        try {
            TimeZone timeZone;
            Object object;
            int n;
            int n2 = string.indexOf("TZID");
            if (n2 != -1) {
                int n3 = string.indexOf(61, n2 + 4) + 1;
                n = string.indexOf(58, n2 + 5);
                int n4 = string.indexOf(59, n2 + 5);
                object = string.substring(n3, Math.min(n == -1 ? 0x3FFFFFF5 : n, n4 == -1 ? 0x3FFFFFF5 : n4));
                timeZone = TimeZone.getTimeZone((String)object);
            } else {
                timeZone = TimeZone.getDefault();
            }
            String string2 = string.substring(string.lastIndexOf(58) + 1).trim();
            n = string.indexOf("PERIOD");
            LinkedList<ImmutableDateRange> linkedList = new LinkedList<ImmutableDateRange>();
            object = new StringTokenizer(string2, ",", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (n == -1) {
                    Calendar calendar = ICalendarImport.parseDateTimeFields(string3, timeZone);
                    if (calendar == null) continue;
                    DateRange dateRange = new DateRange(calendar.getTimeInMillis(), timeZone, null);
                    if (string3.length() < 10) {
                        dateRange.setHasTime(false);
                        if (bl) {
                            dateRange.roundExpand(44);
                        }
                    }
                    linkedList.add(dateRange.getImmutable());
                    continue;
                }
                linkedList.add(ICalendarImport.parsePeriod(string3, timeZone).getImmutable());
            }
            return linkedList;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public static MutableDateRange parsePeriod(String string, TimeZone timeZone) {
        int n = string.indexOf(47);
        if (n == -1) {
            throw new IllegalArgumentException("No slash in period! " + string);
        }
        DateRange dateRange = new DateRange(ICalendarImport.parseDateTimeFields(string.substring(0, n).trim(), timeZone).getTimeInMillis(), timeZone, null);
        String string2 = string.substring(n + 1).trim();
        if (string2.startsWith("P")) {
            Integer n2 = ICalendarImport.parseDuration(string2);
            if (n2 == null) {
                throw new IllegalArgumentException("Period is erratic! " + string);
            }
            dateRange.setMillisSpanned((long)n2.intValue() * 1000L, false, true);
        } else {
            Calendar calendar = ICalendarImport.parseDateTimeFields(string2, timeZone);
            if (calendar == null) {
                throw new IllegalArgumentException("AtEnd is erratic! " + string);
            }
            dateRange.setEndMillis(calendar.getTimeInMillis(), true);
        }
        return dateRange;
    }

    public static Calendar parseDateTimeFields(String string, TimeZone timeZone) {
        if (string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1);
            timeZone = TimeZone.getTimeZone("UTC");
        }
        if (string.length() == 15 && string.charAt(8) == 'T') {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
            int n3 = Integer.parseInt(string.substring(6, 8));
            int n4 = Integer.parseInt(string.substring(9, 11));
            int n5 = Integer.parseInt(string.substring(11, 13));
            int n6 = Integer.parseInt(string.substring(13, 15));
            Calendar calendar = DateUtil.createCalendar(timeZone, null);
            calendar.set(n, n2, n3, n4, n5, n6);
            calendar.set(14, 0);
            return calendar;
        }
        if (string.length() == 8) {
            int n = Integer.parseInt(string.substring(0, 4));
            int n7 = Integer.parseInt(string.substring(4, 6)) - 1;
            int n8 = Integer.parseInt(string.substring(6, 8));
            Calendar calendar = DateUtil.createCalendar(timeZone, null);
            calendar.set(n, n7, n8, 0, 0, 0);
            calendar.set(14, 0);
            return calendar;
        }
        throw new IllegalArgumentException("Unknown date or date-time: '" + string + "'");
    }

    public static Integer parseDuration(String string) {
        try {
            string = string.trim();
            int n = 0;
            int n2 = string.indexOf(80);
            if (n2 == -1) {
                n2 = string.indexOf(112);
            }
            if (n2 == -1) {
                return null;
            }
            int n3 = string.indexOf(84);
            if (n3 == -1) {
                n3 = string.indexOf(116);
            }
            String string2 = n2 != -1 ? string.substring(n2 + 1, n3 != -1 ? n3 : string.length()) : "";
            String string3 = n3 != -1 ? string.substring(n3 + 1) : "";
            block10: for (int i = 0; i < 2; ++i) {
                String string4 = i == 0 ? string2 : string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "YWDHMSywdhms", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken().trim();
                    if (!stringTokenizer.hasMoreTokens()) continue block10;
                    int n4 = Integer.parseInt(string5);
                    char c2 = stringTokenizer.nextToken().trim().charAt(0);
                    switch (c2) {
                        case 'Y': 
                        case 'y': {
                            n += n4 * 365 * 24 * 60 * 60;
                            break;
                        }
                        case 'W': 
                        case 'w': {
                            n += n4 * 7 * 24 * 60 * 60;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            n += n4 * 24 * 60 * 60;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            n += n4 * 60 * 60;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            n += n4 * 60;
                            break;
                        }
                        case 'S': 
                        case 's': {
                            n += n4;
                        }
                    }
                }
            }
            return n != 0 ? new Integer(string.indexOf(45) == -1 ? n : -n) : null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    static {
        a.put("YEARLY", new Integer(1));
        a.put("MONTHLY", new Integer(2));
        a.put("WEEKLY", new Integer(3));
        a.put("DAILY", new Integer(6));
        a.put("HOURLY", new Integer(11));
        a.put("MINUTELY", new Integer(12));
        a.put("SECONDLY", new Integer(13));
        b = new HashMap(16);
        b.put("BYMONTH", new Integer(2));
        b.put("BYWEEKNO", new Integer(3));
        b.put("BYYEARDAY", new Integer(6));
        b.put("BYMONTHDAY", new Integer(5));
        b.put("BYDAY", new Integer(7));
        b.put("BYHOUR", new Integer(11));
        b.put("BYMINUTE", new Integer(12));
        b.put("BYSECOND", new Integer(13));
        c = new HashMap(16);
        c.put("SU", new Integer(1));
        c.put("MO", new Integer(2));
        c.put("TU", new Integer(3));
        c.put("WE", new Integer(4));
        c.put("TH", new Integer(5));
        c.put("FR", new Integer(6));
        c.put("SA", new Integer(7));
    }
}

