/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity.recurrence;

import com.miginfocom.calendar.activity.recurrence.Recurrence;
import com.miginfocom.util.dates.DateRange;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.DateUtil;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import java.util.ArrayList;
import java.util.Calendar;

public class CompositeRecurrence
implements Recurrence {
    private ArrayList<Recurrence> a = null;
    private ArrayList<Recurrence> b = null;
    private ArrayList<DateRangeI> c = null;
    private ArrayList<DateRangeI> d = null;
    private boolean e = false;

    @Override
    public ArrayList<MutableDateRange> getDateRanges(DateRangeI dateRangeI, DateRangeI dateRangeI2, boolean bl) {
        ArrayList<MutableDateRange> arrayList = new ArrayList<MutableDateRange>(16);
        if (this.e && dateRangeI2.isOverlapping(dateRangeI)) {
            arrayList.add(new DateRange(dateRangeI));
        }
        if (this.a != null) {
            for (Recurrence object : this.a) {
                ArrayList<MutableDateRange> arrayList2 = object.getDateRanges(dateRangeI, dateRangeI2, bl);
                if (arrayList2.size() <= 0) continue;
                this.mergeRanges(dateRangeI, arrayList2, arrayList);
            }
        }
        if (this.c != null) {
            this.mergeRanges(dateRangeI, this.c, arrayList);
        }
        if (this.b != null || this.d != null) {
            ArrayList arrayList2 = new ArrayList(16);
            if (this.b != null) {
                for (Recurrence recurrence : this.b) {
                    ArrayList<MutableDateRange> arrayList3 = recurrence.getDateRanges(dateRangeI, dateRangeI2, bl);
                    if (arrayList3.size() <= 0) continue;
                    this.mergeRanges(dateRangeI, arrayList3, arrayList2);
                }
            }
            if (this.d != null) {
                this.mergeRanges(dateRangeI, this.d, arrayList2);
            }
            if (arrayList2.size() > 0) {
                arrayList = this.removeOverlappingRanges(arrayList2, arrayList);
            }
        }
        return arrayList;
    }

    @Override
    public Long getLastRecurrenceMillis(DateRangeI dateRangeI, Calendar calendar) {
        return DateUtil.getLastRecurrenceMillis(this, dateRangeI, calendar);
    }

    @Override
    public boolean isRepeatingForever() {
        if (this.a != null) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                if (!this.a.get(i).isRepeatingForever()) continue;
                return true;
            }
        }
        return false;
    }

    protected void mergeRanges(DateRangeI dateRangeI, ArrayList<? extends DateRangeI> arrayList, ArrayList<MutableDateRange> arrayList2) {
        long l = dateRangeI != null ? dateRangeI.getMillisSpanned(false, false) : -1L;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            DateRange dateRange = new DateRange(arrayList.get(i));
            boolean bl = dateRange.getHasTime();
            if (!bl) {
                dateRange.roundExpand(44);
            }
            boolean bl2 = false;
            int n2 = arrayList2.size();
            for (int j = 0; j < n2; ++j) {
                MutableDateRange mutableDateRange = arrayList2.get(j);
                if (!mutableDateRange.isOverlapping(dateRange)) continue;
                mutableDateRange.union(dateRange);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (bl) {
                if (l >= 0L && !dateRange.isSpanningTime()) {
                    dateRange.setMillisSpanned(l, false, false);
                }
            } else if (dateRangeI != null) {
                dateRange.setTimeFromRange(dateRangeI);
                dateRange.setHasTime(true);
            }
            arrayList2.add(dateRange);
        }
    }

    protected ArrayList<MutableDateRange> removeOverlappingRanges(ArrayList<MutableDateRange> arrayList, ArrayList<MutableDateRange> arrayList2) {
        int n = 0;
        int n2 = arrayList2.size();
        block0: for (int i = 0; i < n2; ++i) {
            DateRangeI dateRangeI = arrayList2.get(i);
            if (dateRangeI == null) continue;
            int n3 = arrayList.size();
            for (int j = 0; j < n3; ++j) {
                if (!((DateRangeI)arrayList.get(j)).isOverlapping(dateRangeI)) continue;
                arrayList2.set(i, null);
                ++n;
                continue block0;
            }
        }
        if (n == 0) {
            return arrayList2;
        }
        ArrayList<MutableDateRange> arrayList3 = new ArrayList<MutableDateRange>(arrayList2.size() - n);
        int n4 = arrayList2.size();
        for (n2 = 0; n2 < n4; ++n2) {
            MutableDateRange mutableDateRange = arrayList2.get(n2);
            if (mutableDateRange == null) continue;
            arrayList3.add(mutableDateRange);
        }
        return arrayList3;
    }

    public void addIncludingRange(ImmutableDateRange immutableDateRange) {
        if (this.c == null) {
            this.c = new ArrayList();
        }
        this.c.add(immutableDateRange);
    }

    public boolean isIncludeBaseDateRange() {
        return this.e;
    }

    public void setIncludeBaseDateRange(boolean bl) {
        this.e = bl;
    }

    public void setIncludingRanges(ArrayList<DateRangeI> arrayList) {
        this.c = arrayList;
    }

    public ArrayList getIncludingRanges() {
        return this.c;
    }

    public void addExcludingRange(ImmutableDateRange immutableDateRange) {
        if (this.d == null) {
            this.d = new ArrayList();
        }
        this.d.add(immutableDateRange);
    }

    public void setExcludingRanges(ArrayList arrayList) {
        this.d = arrayList;
    }

    public ArrayList getExcludingRanges() {
        return this.d;
    }

    public void addIncludingRecurrence(Recurrence recurrence) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.add(recurrence);
    }

    public void setIncludingRecurrencies(ArrayList<Recurrence> arrayList) {
        this.a = arrayList;
    }

    public ArrayList<Recurrence> getIncludingRecurrencies() {
        return this.a;
    }

    public void addExcludingRecurrence(Recurrence recurrence) {
        if (this.b == null) {
            this.b = new ArrayList();
        }
        this.b.add(recurrence);
    }

    public void setExcludingRecurrencies(ArrayList<Recurrence> arrayList) {
        this.b = arrayList;
    }

    public ArrayList getExcludingRecurrencies() {
        return this.b;
    }
}

