/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity.view;

import com.miginfocom.ashape.interaction.AbstractInteractionBroker;
import com.miginfocom.ashape.interaction.Interaction;
import com.miginfocom.ashape.interaction.Interactor;
import com.miginfocom.calendar.activity.view.ActivityView;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.command.Command;
import com.miginfocom.util.command.DefaultCommand;
import com.miginfocom.util.states.GenericStates;
import java.awt.event.InputEvent;

public class ActivityViewInteractionBroker
extends AbstractInteractionBroker {
    public static final PropertyKey CMD_SET_STATE = PropertyKey.getKey("setState");
    public static final PropertyKey CMD_SET_PROPERTY = PropertyKey.getKey("setProperty");
    public static final PropertyKey CMD_REMOVE_PROPERTY = PropertyKey.getKey("removeProperty");
    public static final PropertyKey CMD_ADD_CATEGORY_ID = PropertyKey.getKey("addCategoryIdFirst");
    public static final PropertyKey CMD_REMOVE_CATEGORY_ID = PropertyKey.getKey("removeCategoryId");
    public static final PropertyKey CMD_TOGGLE_CATEGORY_ID = PropertyKey.getKey("toggleCategoryId");
    public static final PropertyKey CMD_INSTALL_INTERACTION = PropertyKey.getKey("installInteraction");
    protected final ActivityView activityView;

    public ActivityViewInteractionBroker(ActivityView activityView) {
        if (activityView == null) {
            throw new IllegalArgumentException("activityView is null!");
        }
        this.activityView = activityView;
    }

    @Override
    public boolean handleCommand(Interactor interactor, Command command, InputEvent inputEvent) {
        if (!(command instanceof DefaultCommand)) {
            return false;
        }
        DefaultCommand defaultCommand = (DefaultCommand)command;
        if (!defaultCommand.isEnabled()) {
            return false;
        }
        PropertyKey propertyKey = defaultCommand.getCommandKey();
        if (propertyKey == null) {
            return false;
        }
        if (propertyKey == CMD_SET_STATE) {
            int n = GenericStates.keyToBit(defaultCommand.getPropertyKey());
            this.activityView.getModel().getStates().setStates(n, MigUtil.isTrue(defaultCommand.getValue()));
        } else if (propertyKey == CMD_SET_PROPERTY) {
            this.activityView.getModel().setPropertySilent(defaultCommand.getPropertyKey(), defaultCommand.getValue(), null);
        } else if (propertyKey == CMD_REMOVE_PROPERTY) {
            this.activityView.getModel().removeProperty(defaultCommand.getPropertyKey());
        } else if (propertyKey == CMD_ADD_CATEGORY_ID) {
            this.activityView.addCategoryID(defaultCommand.getValue(), this.a(defaultCommand.getTarget()));
            this.activityView.getContainer().revalidate();
        } else if (propertyKey == CMD_REMOVE_CATEGORY_ID) {
            this.activityView.removeCategoryID(defaultCommand.getValue());
            this.activityView.getContainer().revalidate();
        } else if (propertyKey == CMD_TOGGLE_CATEGORY_ID) {
            Object object = defaultCommand.getValue();
            if (this.activityView.isCategory(object)) {
                this.activityView.removeCategoryID(object);
            } else {
                this.activityView.addCategoryID(object, this.a(defaultCommand.getTarget()));
            }
            this.activityView.getContainer().revalidate();
        } else if (propertyKey == CMD_INSTALL_INTERACTION) {
            Interactor[] interactorArray = this.activityView.getInteractors();
            for (int i = 0; i < interactorArray.length; ++i) {
                interactorArray[i].addInteraction((Interaction)defaultCommand.getValue());
            }
        } else {
            return false;
        }
        return true;
    }

    private final int a(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public ActivityView getActivityView() {
        return this.activityView;
    }
}

