/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.activity.view;

import com.miginfocom.ashape.interaction.DefaultInteractionBroker;
import com.miginfocom.ashape.interaction.InteractionListener;
import com.miginfocom.ashape.interaction.Interactor;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.command.Command;
import com.miginfocom.util.command.DefaultCommand;
import java.awt.event.InputEvent;
import javax.swing.JComponent;

public class GridRowInteractionBroker
extends DefaultInteractionBroker {
    public static final PropertyKey CMD_SET_PROPERTY = PropertyKey.getKey("GR_SetProperty");
    public static final PropertyKey CMD_REMOVE_PROPERTY = PropertyKey.getKey("GR_RemoveProperty");
    public static final PropertyKey CMD_TOGGLE_GRID_ROW_FOLDING = PropertyKey.getKey("GR_ToggleGridRowFolding");
    protected final GridRow gridRow;

    public GridRowInteractionBroker(GridRow gridRow, JComponent jComponent, InteractionListener interactionListener) {
        super(jComponent, interactionListener);
        if (gridRow == null) {
            throw new IllegalArgumentException("gridRow is null!");
        }
        this.gridRow = gridRow;
    }

    @Override
    public boolean handleCommand(Interactor interactor, Command command, InputEvent inputEvent) {
        if (!(command instanceof DefaultCommand)) {
            return false;
        }
        DefaultCommand defaultCommand = (DefaultCommand)command;
        if (!defaultCommand.isEnabled()) {
            return false;
        }
        PropertyKey propertyKey = defaultCommand.getCommandKey();
        if (propertyKey == null) {
            return false;
        }
        if (propertyKey == CMD_SET_PROPERTY) {
            this.gridRow.setProperty(defaultCommand.getPropertyKey(), defaultCommand.getValue());
        } else if (propertyKey == CMD_REMOVE_PROPERTY) {
            this.gridRow.removeProperty(defaultCommand.getPropertyKey());
        } else if (propertyKey == CMD_TOGGLE_GRID_ROW_FOLDING) {
            boolean bl = MigUtil.isTrue(this.gridRow.getProperty(GridRow.FOLDED));
            this.gridRow.setProperty(GridRow.FOLDED, !bl);
        } else {
            return super.handleCommand(interactor, command, inputEvent);
        }
        return true;
    }

    public GridRow getGridRow() {
        return this.gridRow;
    }
}

