/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.category;

import com.miginfocom.calendar.category.Category;
import com.miginfocom.calendar.category.CategoryDepository;
import com.miginfocom.calendar.category.CategoryFilter;
import com.miginfocom.calendar.grid.GridLineProvider;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.calendar.grid.SubRowCreator;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.filter.Filter;
import java.util.ArrayList;
import java.util.Arrays;

public class CategorySubRowCreator
implements SubRowCreator {
    private final Object[] a;
    private final boolean b;

    public CategorySubRowCreator(Category category, boolean bl) {
        this(new Category[]{category}, bl);
    }

    public CategorySubRowCreator(Category[] categoryArray, boolean bl) {
        if (categoryArray == null || categoryArray.length == 0) {
            throw new IllegalArgumentException("No roots: " + categoryArray);
        }
        this.a = new Object[categoryArray.length];
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = categoryArray[i].getId();
        }
        this.b = bl;
    }

    public CategorySubRowCreator(Object[] objectArray, boolean bl) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("No root IDs: " + objectArray);
        }
        this.a = objectArray;
        this.b = bl;
    }

    @Override
    public void createSubRows(GridRow gridRow, GridLineProvider gridLineProvider) {
        GridRow[] gridRowArray;
        Object[] objectArray;
        if (this.b && this.a.length == 1) {
            objectArray = this.a;
        } else {
            gridRowArray = new ArrayList();
            for (int i = 0; i < this.a.length; ++i) {
                if (this.b) {
                    gridRowArray.add(this.a[i]);
                    continue;
                }
                Category category = CategoryDepository.getCategory(this.a[i]);
                if (category == null || category.getChildCount() <= 0) continue;
                gridRowArray.addAll(Arrays.asList(category.getChildrenIDs()));
            }
            objectArray = gridRowArray.toArray(new Object[gridRowArray.size()]);
        }
        this.a(objectArray, gridRow, 0, gridLineProvider);
        gridRowArray = gridRow.getGridRows();
        if (gridRowArray != null && gridRowArray.length == 0) {
            gridRow.setGridRows(null, null);
        }
    }

    private void a(Object[] objectArray, GridRow gridRow, int n, GridLineProvider gridLineProvider) {
        Object[] objectArray2 = new GridRow[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Category category = CategoryDepository.getCategory(objectArray[i]);
            if (category != null) {
                Boolean bl = (Boolean)category.getProperty(Category.PROP_IS_HIDDEN);
                if (bl != null && bl.booleanValue()) continue;
                objectArray2[i] = new GridRow(gridRow, (Filter)new CategoryFilter(category, false, false));
                if (category.getChildCount() <= 0) continue;
                this.a(category.getChildrenIDs(), (GridRow)objectArray2[i], n + 1, gridLineProvider);
                continue;
            }
            objectArray2[i] = new GridRow(gridRow, (Filter)new CategoryFilter(category, false, false));
        }
        objectArray2 = (GridRow[])MigUtil.removeNullArrayElements(objectArray2);
        gridRow.setGridRows((GridRow[])objectArray2, n == 0 ? gridLineProvider : null);
    }
}

