/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.datearea;

import com.miginfocom.calendar.datearea.DefaultDateArea;
import com.miginfocom.calendar.grid.DateGrid;
import com.miginfocom.calendar.header.Header;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.print.PrintSpecification;
import com.miginfocom.util.print.PrintUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DateAreaContainer
extends JPanel
implements Printable {
    public static final String NORTH = "North";
    public static final String NORTH_FILL = "NorthFill";
    public static final String NORTH_LEFT = "NorthLeft";
    public static final String NORTH_RIGHT = "NorthRight";
    public static final String SOUTH = "South";
    public static final String SOUTH_FILL = "SouthFill";
    public static final String SOUTH_LEFT = "SouthLeft";
    public static final String SOUTH_RIGHT = "SouthRight";
    public static final String EAST = "East";
    public static final String EAST_FILL = "EastFill";
    public static final String EAST_TOP = "EastTop";
    public static final String EAST_BOTTOM = "EastBottom";
    public static final String WEST = "West";
    public static final String WEST_FILL = "WestFill";
    public static final String WEST_TOP = "WestTop";
    public static final String WEST_BOTTOM = "WestBottom";
    public static final String TOP_LEFT_CORNER = "TopLeftCorner";
    public static final String TOP_RIGHT_CORNER = "TopRightCorner";
    public static final String BOTTOM_LEFT_CORNER = "BottomLeftCorner";
    public static final String BOTTOM_RIGHT_CORNER = "BottomRightCorner";
    private int a = 30;
    private int b = 20;
    private final transient DefaultDateArea c;
    private final JScrollPane d;
    private final HashMap e = new HashMap();
    private static final Insets f = new Insets(0, 0, 0, 0);
    private static final HashMap g = new HashMap();
    public static final int CORNER_EXPAND_NONE = 0;
    public static final int CORNER_EXPAND_TOP_OR_LEFT = 1;
    public static final int CORNER_EXPAND_BOTTOM_OR_RIGHT = 2;
    public static final int CORNER_EXPAND_BOTH = 3;
    protected static final String[][] SIDES;
    protected static final String[] CORNERS;
    private PrintSpecification h = new PrintSpecification();

    public DateAreaContainer() {
        this(new DefaultDateArea());
    }

    public DateAreaContainer(DefaultDateArea defaultDateArea) {
        super.setLayout(new GridBagLayout());
        this.c = defaultDateArea;
        this.d = defaultDateArea.createScrollPane();
        this.d.getViewport().setBackground(this.getBackground());
        this.add((Component)this.d, new GridBagConstraints(20, 20, 1, 1, 1.0, 1.0, 10, 1, f, 0, 0));
        this.add((Component)this.d.getVerticalScrollBar(), new GridBagConstraints(40, 10, 1, 35, 0.0, 1.0, 10, 1, f, 0, 0));
        this.add((Component)this.d.getHorizontalScrollBar(), new GridBagConstraints(10, 50, 35, 1, 1.0, 0.0, 10, 1, f, 0, 0));
        this.d.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DateAreaContainer.this.setScrollBarsVisibility();
            }
        });
        defaultDateArea.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DateAreaContainer.this.setScrollBarsVisibility();
            }
        });
        this.setBackground(Color.WHITE);
        this.setScrollBarsVisibility();
    }

    @Override
    public final void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.d != null) {
            this.d.getViewport().setBackground(color);
        }
    }

    public void setScrollBarsVisibility() {
        Serializable serializable;
        JScrollBar jScrollBar = this.d.getVerticalScrollBar();
        if (this.b == 20) {
            serializable = this.d.getInsets();
            jScrollBar.setVisible(this.c.getComponent().getHeight() > this.d.getHeight() - ((Insets)serializable).top - ((Insets)serializable).bottom);
        } else {
            jScrollBar.setVisible(this.b == 22);
        }
        serializable = this.d.getHorizontalScrollBar();
        if (this.a == 30) {
            Insets insets = this.d.getInsets();
            ((JComponent)serializable).setVisible(this.c.getComponent().getWidth() > this.d.getWidth() - insets.left - insets.right);
        } else {
            ((JComponent)serializable).setVisible(this.a == 32);
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.b;
    }

    public void setVerticalScrollBarPolicy(int n) {
        this.b = n;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.a;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        this.a = n;
    }

    public DefaultDateArea getDateArea() {
        return this.c;
    }

    public void addComponent(JComponent jComponent, String string) {
        this.addComponent(jComponent, string, 0);
    }

    public void addComponent(JComponent jComponent, String string, int n) {
        if (n < -9 || n > 9) {
            throw new IllegalArgumentException("Illegal order:" + n);
        }
        GridBagConstraints gridBagConstraints = (GridBagConstraints)g.get(string);
        if (gridBagConstraints == null) {
            throw new IllegalArgumentException("Unknown side: " + string);
        }
        if (n != 0) {
            gridBagConstraints = (GridBagConstraints)gridBagConstraints.clone();
            if (string.startsWith(NORTH)) {
                gridBagConstraints.gridy += n;
            } else if (string.startsWith(WEST)) {
                gridBagConstraints.gridx += n;
            } else if (string.startsWith(SOUTH)) {
                gridBagConstraints.gridy -= n;
            } else if (string.startsWith(EAST)) {
                gridBagConstraints.gridx -= n;
            }
        }
        this.add((Component)jComponent, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    public List getHeaders(String string) {
        ArrayList<Header> arrayList = new ArrayList<Header>(2);
        for (int i = -9; i <= 9; ++i) {
            Header header = this.getHeader(string, i);
            if (header == null) continue;
            arrayList.add(header);
        }
        return arrayList;
    }

    public Header getHeader(String string) {
        return this.getHeader(string, 0);
    }

    public Header getHeader(String string, int n) {
        if (!g.containsKey(string)) {
            throw new IllegalArgumentException("Unknown side: " + string);
        }
        return (Header)this.e.get(string.substring(0, 4) + n);
    }

    public void setHeader(Header header, String string) {
        this.setHeader(header, string, 0);
    }

    public boolean isSouthOfDateArea(Component component) {
        return this.getHeaders(SOUTH).contains(component);
    }

    public boolean isEastOfDateArea(Component component) {
        return this.getHeaders(EAST).contains(component);
    }

    public void setHeader(Header header, String string, int n) {
        Header header2 = this.getHeader(string, n);
        if (header2 == header) {
            return;
        }
        if (n < -9 || n > 9) {
            throw new IllegalArgumentException("Illegal order:" + n);
        }
        if (header2 != null) {
            this.remove(header2.getScrollPane());
            header2.dispose();
        }
        this.e.put(string.substring(0, 4) + n, header);
        if (header != null) {
            this.addComponent(header.getScrollPane(), string, n);
        }
    }

    protected void moveHeader(Header header, String string, int n) {
        this.remove(header.getScrollPane());
        Set set = this.e.entrySet();
        for (Map.Entry entry : set) {
            if (entry.getValue() != header) continue;
            this.e.remove(entry.getKey());
            break;
        }
        this.setHeader(header, string, n);
    }

    public JScrollPane getDateAreaScrollPane() {
        return this.d;
    }

    public void scrollToShowRange(DateRangeI dateRangeI, float f, float f2) {
        DateGrid dateGrid = this.c.getDateGrid();
        Rectangle rectangle = dateGrid.getBoundingBoxForDateRange(dateRangeI, 0);
        if (rectangle == null) {
            return;
        }
        JViewport jViewport = this.d.getViewport();
        int n = rectangle.x - Math.round((float)(jViewport.getWidth() - rectangle.width) * f);
        int n2 = rectangle.y - Math.round((float)(jViewport.getHeight() - rectangle.height) * f2);
        Point point = new Point(Math.max(0, n), Math.max(0, n2));
        jViewport.setViewPosition(point);
        this.d.revalidate();
        this.d.repaint();
        this.repaint();
    }

    public DateRangeI getViewportViewDateRange() {
        return this.getDateArea().getDateGrid().getDateRangeForRect(this.d.getViewport().getViewRect());
    }

    public PrintSpecification getPrintSpecification() {
        return this.h;
    }

    public void setPrintSpecification(PrintSpecification printSpecification) {
        this.h = printSpecification != null ? printSpecification : new PrintSpecification();
    }

    public Dimension getPrintablePreferredSize() {
        Dimension dimension = this.c.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            dimension = this.c.getPreferredSize();
        }
        JScrollPane jScrollPane = this.getDateAreaScrollPane();
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
        Insets insets = jScrollPane.getInsets();
        int n = dimension.width + this.getWidth() - jScrollPane.getWidth() - (jScrollBar.isVisible() ? jScrollBar.getWidth() : 0) + insets.left + insets.right;
        int n2 = dimension.height + this.getHeight() - jScrollPane.getHeight() - (jScrollBar2.isVisible() ? jScrollBar2.getHeight() : 0) + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    public Rectangle2D getPrintablePageBounds(PageFormat pageFormat) {
        return this.getPrintablePageBounds(pageFormat, this.getPrintSpecification());
    }

    public Rectangle2D getPrintablePageBounds(PageFormat pageFormat, PrintSpecification printSpecification) {
        MigUtil.checkComponentVersion(600);
        printSpecification = printSpecification != null ? printSpecification : this.getPrintSpecification();
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        if (printSpecification.getPagePlaceRectangle() != null) {
            ((Rectangle2D)double_).setRect(printSpecification.getPagePlaceRectangle().getRect(GfxUtil.getRoundedRect(double_, true)));
        }
        return double_;
    }

    @Override
    public void print(Graphics graphics) {
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setImageableArea(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        paper.setSize(this.getWidth(), this.getHeight());
        pageFormat.setPaper(paper);
        try {
            this.print(graphics, pageFormat, 0);
        }
        catch (PrinterException printerException) {
            throw new RuntimeException(printerException);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.print(graphics, pageFormat, n, this.getPrintSpecification());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics graphics, PageFormat pageFormat, int n, PrintSpecification printSpecification) throws PrinterException {
        MigUtil.checkComponentVersion(600);
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        printSpecification = printSpecification != null ? printSpecification : this.getPrintSpecification();
        object = this.getPrintablePreferredSize();
        Rectangle2D rectangle2D = this.getPrintablePageBounds(pageFormat, printSpecification);
        double d = (double)((Dimension)object).width / (double)((Dimension)object).height;
        double d2 = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d3 = printSpecification.getPrintableAspectRatio() != null ? printSpecification.getPrintableAspectRatio() : d;
        Dimension dimension = PrintUtil.getPageCount(printSpecification.getPageCountX(), printSpecification.getPageCountY(), d3, d2);
        if (n < dimension.width * dimension.height) {
            double d4;
            double d5;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            double d6 = rectangle2D.getWidth() * (double)dimension.width;
            double d7 = rectangle2D.getHeight() * (double)dimension.height;
            Rectangle2D rectangle2D2 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d6, d7);
            if (printSpecification.getPlaceRectangle() != null) {
                rectangle2D2 = printSpecification.getPlaceRectangle().getRect(GfxUtil.getRoundedRect(rectangle2D2, true), (Dimension)object);
                d6 = rectangle2D2.getWidth();
                d7 = rectangle2D2.getHeight();
            }
            double d8 = d6 / d7;
            if (printSpecification.getStretchToFit() && printSpecification.getPrintableAspectRatio() == null) {
                d3 = d8;
            }
            if (d8 > d3) {
                d5 = d7 / (double)((Dimension)object).height;
                d4 = d5 * (d3 / d);
            } else {
                d4 = d6 / (double)((Dimension)object).width;
                d5 = d4 * (d / d3);
            }
            double d9 = (double)((Dimension)object).width * d4;
            double d10 = (double)((Dimension)object).height * d5;
            double d11 = printSpecification.getAlignX() != null ? (double)printSpecification.getAlignX().getValue(0.0f, (float)(d6 - d9)) : 0.0;
            double d12 = printSpecification.getAlignY() != null ? (double)printSpecification.getAlignY().getValue(0.0f, (float)(d7 - d10)) : 0.0;
            Point point = new Point(n % dimension.width, n / dimension.width);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d11 + rectangle2D.getX() - (double)point.x * rectangle2D.getWidth(), d12 + rectangle2D.getY() - (double)point.y * rectangle2D.getHeight(), d9, d10);
            graphics2D.clip(new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
            printSpecification.invokePainters(graphics2D, pageFormat, double_, point, dimension, true);
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)(-point.x) * rectangle2D.getWidth(), (double)(-point.y) * rectangle2D.getHeight());
            graphics2D.translate(rectangle2D2.getX(), rectangle2D2.getY());
            graphics2D.translate(d11, d12);
            graphics2D.scale(d4, d5);
            PrintUtil.printComponent(graphics2D, this, (Dimension)object);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            printSpecification.invokePainters(graphics2D, pageFormat, double_, point, dimension, false);
            graphics2D.dispose();
            return 0;
        }
        return 1;
    }

    static {
        g.put(NORTH, new GridBagConstraints(20, 10, 1, 1, 1.0, 0.0, 15, 1, f, 0, 0));
        g.put(NORTH_FILL, new GridBagConstraints(10, 10, 25, 1, 1.0, 0.0, 15, 1, f, 0, 0));
        g.put(NORTH_LEFT, new GridBagConstraints(10, 10, 15, 1, 1.0, 0.0, 14, 1, f, 0, 0));
        g.put(NORTH_RIGHT, new GridBagConstraints(20, 10, 15, 1, 1.0, 0.0, 16, 1, f, 0, 0));
        g.put(SOUTH, new GridBagConstraints(20, 30, 1, 1, 1.0, 0.0, 11, 1, f, 0, 0));
        g.put(SOUTH_FILL, new GridBagConstraints(10, 30, 25, 1, 1.0, 0.0, 11, 1, f, 0, 0));
        g.put(SOUTH_LEFT, new GridBagConstraints(10, 30, 15, 1, 1.0, 0.0, 12, 1, f, 0, 0));
        g.put(SOUTH_RIGHT, new GridBagConstraints(20, 30, 15, 1, 1.0, 0.0, 18, 1, f, 0, 0));
        g.put(EAST, new GridBagConstraints(30, 20, 1, 1, 0.0, 1.0, 17, 1, f, 0, 0));
        g.put(EAST_FILL, new GridBagConstraints(30, 10, 1, 25, 0.0, 1.0, 17, 1, f, 0, 0));
        g.put(EAST_TOP, new GridBagConstraints(30, 10, 1, 15, 0.0, 1.0, 16, 1, f, 0, 0));
        g.put(EAST_BOTTOM, new GridBagConstraints(30, 20, 1, 15, 0.0, 1.0, 18, 1, f, 0, 0));
        g.put(WEST, new GridBagConstraints(10, 20, 1, 1, 0.0, 1.0, 13, 1, f, 0, 0));
        g.put(WEST_FILL, new GridBagConstraints(10, 10, 1, 25, 0.0, 1.0, 13, 1, f, 0, 0));
        g.put(WEST_TOP, new GridBagConstraints(10, 10, 1, 15, 0.0, 1.0, 14, 1, f, 0, 0));
        g.put(WEST_BOTTOM, new GridBagConstraints(10, 20, 1, 15, 0.0, 1.0, 12, 1, f, 0, 0));
        g.put(TOP_LEFT_CORNER, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 14, 1, f, 0, 0));
        g.put(TOP_RIGHT_CORNER, new GridBagConstraints(30, 10, 1, 1, 0.0, 0.0, 16, 1, f, 0, 0));
        g.put(BOTTOM_LEFT_CORNER, new GridBagConstraints(10, 30, 1, 1, 0.0, 0.0, 12, 1, f, 0, 0));
        g.put(BOTTOM_RIGHT_CORNER, new GridBagConstraints(30, 30, 1, 1, 0.0, 0.0, 18, 1, f, 0, 0));
        SIDES = new String[][]{{NORTH, NORTH_LEFT, NORTH_RIGHT, NORTH_FILL}, {WEST, WEST_TOP, WEST_BOTTOM, WEST_FILL}, {SOUTH, SOUTH_LEFT, SOUTH_RIGHT, SOUTH_FILL}, {EAST, EAST_TOP, EAST_BOTTOM, EAST_FILL}};
        CORNERS = new String[]{TOP_LEFT_CORNER, TOP_RIGHT_CORNER, BOTTOM_LEFT_CORNER, BOTTOM_RIGHT_CORNER};
    }
}

