/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.datearea;

import com.miginfocom.calendar.datearea.DateArea;
import com.miginfocom.calendar.datearea.DefaultDateArea;
import com.miginfocom.calendar.grid.DefaultGridDimensionLayout;
import com.miginfocom.calendar.grid.DefaultGridLineProvider;
import com.miginfocom.calendar.grid.Grid;
import com.miginfocom.calendar.grid.GridDimensionLayout;
import com.miginfocom.calendar.grid.GridLineRepetition;
import com.miginfocom.calendar.grid.GridLineSpecification;
import com.miginfocom.calendar.grid.GridSegment;
import com.miginfocom.calendar.grid.GridSegmentSpec;
import com.miginfocom.calendar.layout.ActivityLayoutBroker;
import com.miginfocom.calendar.theme.CalendarTheme;
import com.miginfocom.theme.Theme;
import com.miginfocom.theme.Themes;
import com.miginfocom.util.KeySequence;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.BoundaryRounder;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class ThemeDateArea
extends DefaultDateArea {
    protected String themeContext;
    private boolean a = false;
    private boolean b = false;

    public ThemeDateArea() {
        this(null);
    }

    public ThemeDateArea(String string) {
        this.themeContext = string;
        if (!Themes.hasTheme(string)) {
            Themes.setTheme(string, new CalendarTheme());
        }
        this.reloadStartupStructureFromTheme();
        this.reloadFromTheme();
        CalendarTheme calendarTheme = (CalendarTheme)Themes.getTheme(string);
        int n = calendarTheme.getInt("Startup/VisualRange/rangeType");
        int n2 = calendarTheme.getInt("Startup/VisualRange/count");
        AtRefRangeNumber atRefRangeNumber = (AtRefRangeNumber)calendarTheme.getValue("Startup/VisualRange/align");
        TimeZone timeZone = (TimeZone)calendarTheme.getValue("Generic/timeZone");
        Locale locale = (Locale)calendarTheme.getValue("Generic/locale");
        this.setVisibleDateRange(new ImmutableDateRange(System.currentTimeMillis(), n, n2, atRefRangeNumber, timeZone, locale));
    }

    public void reloadStartupStructureFromTheme() {
        CalendarTheme calendarTheme = (CalendarTheme)Themes.getTheme(this.themeContext);
        this.setWrapBoundary(calendarTheme.getInteger("Startup/SecondaryDim/wrapBoundary"));
        this.setWrapBoundaryCount(calendarTheme.getInt("Startup/SecondaryDim/wrapBoundaryCount"));
        this.setPrimaryDimension(calendarTheme.getInt("Startup/PrimaryDim/direction"));
        this.setPrimaryDimensionCellType(calendarTheme.getInt("Startup/PrimaryDim/cellType"));
        this.setPrimaryDimensionCellTypeCount(calendarTheme.getInt("Startup/PrimaryDim/typeCount"));
    }

    public void reloadFromTheme() {
        Theme theme = Themes.getTheme(this.themeContext);
        if (theme.getBool("Generic/autoReloadFromTheme")) {
            theme.addPropertyChangeListener(this, true);
        } else {
            Theme.removePropertyChangeListener(this.themeContext, this);
        }
        this.setExpandDateRangeKeySequence((KeySequence)theme.getValue("Feel/Selection/expandRangeKey"));
        this.setSelectDateRangeKeySequence((KeySequence)theme.getValue("Feel/Selection/selectRangeKey"));
        Integer n = theme.getInteger("Feel/Selection/boundary");
        if (n != null) {
            Integer n2 = theme.getInteger("Feel/Selection/minCount");
            Integer n3 = theme.getInteger("Feel/Selection/maxCount");
            Integer n4 = theme.getInteger("Feel/Selection/cutAlignment");
            if (n2 != null && n3 != null && n2 > n3) {
                n2 = n3;
            }
            this.setSelectionRounder(new BoundaryRounder(n, true, true, false, n2, n3, n4));
        }
        this.setMultiSelectKeySequence((KeySequence)theme.getValue("Feel/Activity/multiSelectKey"));
        this.setMultiSelectLive(theme.getBool("Feel/Activity/multiSelectLive"));
        this.setBackgroundPaint(theme.getPaint("Generic/background"));
        this.setSnapToMillis(theme.getLong("Feel/Activity/snapToMillis"));
        this.setFallbackSnapToMillis(theme.getLong("Feel/Activity/fallbackSnapToMillis"));
        this.setNoSnapKeySequence((KeySequence)theme.getValue("Feel/Activity/noSnapKey"));
        this.setSelectionType(theme.getInt("Feel/Selection/type"));
        if (theme.getBool("Feel/Activity/Order/Layout/autoInstall")) {
            int n5 = theme.getInt("Feel/Activity/Order/Layout/mouseOverBoost");
            int n6 = theme.getInt("Feel/Activity/Order/Layout/selectedBoost");
            this.setActViewLayoutOrderComparator(new DefaultDateArea.StateOrderComparator(n5, n6));
        }
        if (theme.getBool("Feel/Activity/Order/Painting/autoInstall")) {
            int n7 = theme.getInt("Feel/Activity/Order/Painting/mouseOverBoost");
            int n8 = theme.getInt("Feel/Activity/Order/Painting/selectedBoost");
            this.setActViewPaintOrderComparator(new DefaultDateArea.StateOrderComparator(n7, n8));
        }
        if (theme.getBool("Feel/Activity/Order/Events/autoInstall")) {
            int n9 = theme.getInt("Feel/Activity/Order/Events/mouseOverBoost");
            int n10 = theme.getInt("Feel/Activity/Order/Events/selectedBoost");
            this.setActViewEventOrderComparator(new DefaultDateArea.StateOrderComparator(n9, n10));
        }
        this.setActivityLayoutBroker((ActivityLayoutBroker)theme.getValue("Layouts/layoutBroker"));
        this.setActivityLayouts(theme.getList("Layouts/AutoInstall#", true));
        this.setRepaintCellExpand(theme.getInsets("Generic/cellRepaintPadding"));
        this.setActivitiesSupported(theme.getBool("Generic/activitiesSupported"));
        this.a = theme.getBool("Generic/Debug/outlineClipBounds");
        this.b = theme.getBool("Generic/Debug/repaintAll");
    }

    public void recreateAll() {
        this.reloadStartupStructureFromTheme();
        this.reloadFromTheme();
        this.invalidateGrid();
    }

    public String getThemeContext() {
        return this.themeContext;
    }

    public void setThemeContext(String string) {
        if (MigUtil.equals(this.themeContext, string)) {
            return;
        }
        Theme.removePropertyChangeListener(this.themeContext, this);
        this.themeContext = string;
        this.recreateAll();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.a) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setColor(Color.BLUE);
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics2D.setPaint(paint);
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.b) {
            super.repaint(l, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    public GridDimensionLayout createLayout(Grid grid, int n) {
        String string = "Grid/Segments/" + CalendarTheme.SEGMENT_SUB_LIST_KEYS[n];
        Theme theme = Themes.getTheme(this.themeContext);
        List list = theme.getList(string, true);
        GridSegment[] gridSegmentArray = list.toArray(new GridSegment[list.size()]);
        GridSegmentSpec gridSegmentSpec = new GridSegmentSpec(gridSegmentArray, this.getExpectedCellCount()[n]);
        boolean bl = theme.getBool(n == 0 ? "Grid/Segments/expandPrimaryDim" : "Grid/Segments/expandSecondaryDim");
        return new DefaultGridDimensionLayout(n, gridSegmentSpec, this.getSubGridRowLayout(), bl);
    }

    @Override
    public GridLineSpecification createSpecification(DateArea dateArea) {
        DefaultGridLineProvider[] defaultGridLineProviderArray = new DefaultGridLineProvider[3];
        for (int i = 0; i < 3; ++i) {
            String string = "Grid/GridLines/" + CalendarTheme.GRIDLINE_DIM_SUB_LIST_KEYS[i];
            List list = Themes.getTheme(this.themeContext).getList(string, true);
            if (list.size() <= 0) continue;
            GridLineRepetition[] gridLineRepetitionArray = list.toArray(new GridLineRepetition[list.size()]);
            defaultGridLineProviderArray[i] = new DefaultGridLineProvider(gridLineRepetitionArray);
        }
        return new GridLineSpecification(defaultGridLineProviderArray[0], defaultGridLineProviderArray[1], defaultGridLineProviderArray[2]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == Themes.getTheme(this.themeContext)) {
            this.reloadFromTheme();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("multiKey") || string.startsWith("Grid/") || string.startsWith("Decorators/") || string.startsWith("Layouts/")) {
                this.invalidateGrid();
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }
}

