/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.decorators;

import com.miginfocom.calendar.decorators.AbstractGridDecorator;
import com.miginfocom.calendar.grid.Grid;
import com.miginfocom.calendar.grid.GridContainer;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;

public abstract class GridCellDecorator
extends AbstractGridDecorator {
    protected PlaceRect placeRect;
    private Rectangle[][] a = null;
    private Dimension b = null;
    private int c;

    protected GridCellDecorator(GridContainer gridContainer, int n) {
        this(gridContainer, n, AbsRect.FILL, 0);
    }

    protected GridCellDecorator(GridContainer gridContainer, int n, PlaceRect placeRect, int n2) {
        super(gridContainer, n);
        this.placeRect = placeRect;
        this.c = n2;
    }

    @Override
    public final void doPaint(Graphics2D graphics2D, Rectangle rectangle) {
        Grid grid = this.getGrid();
        if (grid == null) {
            return;
        }
        if (this.prePaint()) {
            graphics2D = (Graphics2D)graphics2D.create();
            Dimension dimension = grid.getSize();
            Rectangle rectangle2 = graphics2D.getClipBounds();
            if (this.b == null || this.a == null || !dimension.equals(this.b) || grid.getRowCount() != this.a.length || grid.getColumnCount() != this.a[0].length) {
                this.a = this.createCellRects(grid);
                this.b = dimension;
            }
            int n = grid.getRowCount();
            for (int i = 0; i < n; ++i) {
                int n2 = grid.getColumnCount();
                for (int j = 0; j < n2; ++j) {
                    Rectangle rectangle3 = this.a[i][j];
                    if (rectangle2 != null && !rectangle2.intersects(rectangle3)) continue;
                    this.paintCell(graphics2D, i, j, rectangle3);
                }
            }
            graphics2D.dispose();
        }
        this.postPaint();
    }

    protected abstract boolean prePaint();

    protected abstract void paintCell(Graphics2D var1, int var2, int var3, Rectangle var4);

    protected abstract void postPaint();

    protected Rectangle[][] createCellRects(Grid grid) {
        int n = grid.getRowCount();
        int n2 = grid.getColumnCount();
        Rectangle[][] rectangleArray = new Rectangle[n][];
        for (int i = 0; i < n; ++i) {
            rectangleArray[i] = new Rectangle[n2];
            for (int j = 0; j < n2; ++j) {
                Rectangle rectangle = grid.getBoundsOfCell(i, j, this.c, false);
                rectangleArray[i][j] = this.placeRect != null ? this.placeRect.getRect(rectangle) : rectangle;
            }
        }
        return rectangleArray;
    }

    public PlaceRect getPlaceRect() {
        return this.placeRect;
    }

    public void setPlaceRect(PlaceRect placeRect) {
        this.placeRect = placeRect;
        this.b = null;
    }

    public int getSizeMode() {
        return this.c;
    }

    public void setSizeMode(int n) {
        this.c = n;
        this.b = null;
    }

    @Override
    public void gridChanged(PropertyChangeEvent propertyChangeEvent) {
        this.a = null;
    }
}

