/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.decorators;

import com.miginfocom.calendar.decorators.AbstractGridDecorator;
import com.miginfocom.calendar.grid.Grid;
import com.miginfocom.calendar.grid.GridContainer;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;

public class GridCellRangeDecorator
extends AbstractGridDecorator {
    private Paint a = null;
    private Stroke b = new BasicStroke(1.0f);
    private Paint c = null;
    private int d = 1;
    private boolean e = false;
    private PlaceRect f = AbsRect.FILL;
    private PlaceRect g = null;

    public GridCellRangeDecorator(GridContainer gridContainer, int n) {
        this(gridContainer, n, null, null, null, null, 1, false);
    }

    public GridCellRangeDecorator(GridContainer gridContainer, int n, PlaceRect placeRect, Paint paint, int n2, boolean bl) {
        this(gridContainer, n, placeRect, paint, null, null, n2, bl);
    }

    public GridCellRangeDecorator(GridContainer gridContainer, int n, PlaceRect placeRect, Paint paint, Stroke stroke, Paint paint2, int n2, boolean bl) {
        super(gridContainer, n);
        this.setCellRange(placeRect);
        this.setFillPaint(paint);
        this.setStroke(stroke);
        this.setStrokePaint(paint2);
        this.setCellOutlineMode(n2);
        this.setFlowMode(bl);
    }

    @Override
    public final void doPaint(Graphics2D graphics2D, Rectangle rectangle) {
        Grid grid = this.getGrid();
        if (grid == null) {
            return;
        }
        graphics2D = (Graphics2D)graphics2D.create();
        Dimension dimension = new Dimension(grid.getColumnCount(), grid.getRowCount());
        Rectangle rectangle2 = new Rectangle(dimension);
        Rectangle rectangle3 = this.f.getRect(rectangle2, dimension);
        rectangle3 = rectangle3.intersection(rectangle2);
        if (rectangle3.width <= 0 || rectangle3.height <= 0) {
            return;
        }
        if (this.a != null) {
            graphics2D.setPaint(this.a);
            this.a(graphics2D, grid, rectangle3.y, rectangle3.x, rectangle3.y + rectangle3.height - 1, rectangle3.x + rectangle3.width - 1, false);
        }
        if (this.c != null) {
            graphics2D.setPaint(this.c);
            graphics2D.setStroke(this.b);
            this.a(graphics2D, grid, rectangle3.y, rectangle3.x, rectangle3.y + rectangle3.height - 1, rectangle3.x + rectangle3.width - 1, true);
        }
        graphics2D.dispose();
    }

    private void a(Graphics2D graphics2D, Grid grid, int n, int n2, int n3, int n4, boolean bl) {
        if (this.e) {
            Polygon polygon = grid.getCellsOutline(n, n2, n3, n4, this.d, bl);
            if (polygon != null) {
                if (bl) {
                    graphics2D.drawPolygon(polygon);
                } else {
                    graphics2D.fillPolygon(polygon);
                }
            }
        } else {
            Rectangle rectangle = grid.getBoundsOfCell(n, n2, this.d, bl);
            rectangle.add(grid.getBoundsOfCell(n3, n4, this.d, bl));
            if (this.g != null) {
                rectangle = this.g.getRect(rectangle);
            }
            if (bl) {
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    public void gridChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    public PlaceRect getBoundsCorrection() {
        return this.g;
    }

    public void setBoundsCorrection(PlaceRect placeRect) {
        this.g = placeRect;
    }

    public Paint getFillPaint() {
        return this.a;
    }

    public void setFillPaint(Paint paint) {
        this.a = paint;
    }

    public Stroke getStroke() {
        return this.b;
    }

    public void setStroke(Stroke stroke) {
        this.b = stroke != null ? stroke : new BasicStroke(1.0f);
    }

    public Paint getStrokePaint() {
        return this.c;
    }

    public void setStrokePaint(Paint paint) {
        this.c = paint;
    }

    public int getCellOutlineMode() {
        return this.d;
    }

    public void setCellOutlineMode(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Unknown CellOutlineMode: " + n);
        }
        this.d = n;
    }

    public boolean isFlowMode() {
        return this.e;
    }

    public void setFlowMode(boolean bl) {
        this.e = bl;
    }

    public PlaceRect getCellRange() {
        return this.f;
    }

    public void setCellRange(PlaceRect placeRect) {
        this.f = placeRect != null ? placeRect : AbsRect.FILL;
    }
}

