/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.decorators;

import com.miginfocom.calendar.decorators.AbstractGridDecorator;
import com.miginfocom.calendar.grid.Grid;
import com.miginfocom.calendar.grid.GridContainer;
import com.miginfocom.calendar.grid.GridLine;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;

public class GridLineDecorator
extends AbstractGridDecorator {
    private final int a;

    public GridLineDecorator(GridContainer gridContainer, int n) {
        this(gridContainer, n, 999999);
    }

    public GridLineDecorator(GridContainer gridContainer, int n, int n2) {
        super(gridContainer, n);
        this.a = n2;
    }

    @Override
    public void doPaint(Graphics2D graphics2D, Rectangle rectangle) {
        GridLine[] gridLineArray;
        int n;
        Grid grid = this.getGrid();
        if (grid == null) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        GridRow[] gridRowArray = grid.getGridRows(1);
        boolean bl = grid.getColumnDimIx() != 1;
        for (n = 0; n < gridRowArray.length; ++n) {
            gridLineArray = gridRowArray[n].getGridLines();
            if (gridLineArray == null) continue;
            this.a(graphics2D, gridLineArray, bl, rectangle);
        }
        for (n = 0; n <= 1; ++n) {
            gridLineArray = grid.getGridLines(n);
            bl = grid.getColumnDimIx() != n;
            this.a(graphics2D, gridLineArray, bl, rectangle);
        }
        graphics2D.setPaint(paint);
    }

    private void a(Graphics2D graphics2D, GridLine[] gridLineArray, boolean bl, Rectangle rectangle) {
        int n = bl ? rectangle.x : rectangle.y;
        int n2 = bl ? rectangle.width : rectangle.height;
        for (GridLine gridLine : gridLineArray) {
            AtRefRangeNumber atRefRangeNumber;
            Paint paint = gridLine.getPaint();
            int n3 = n;
            int n4 = n2;
            AtRefRangeNumber atRefRangeNumber2 = gridLine.getSecondaryStart();
            if (atRefRangeNumber2 != null) {
                n3 = atRefRangeNumber2.getIntValue(n, n + n2);
            }
            if ((atRefRangeNumber = gridLine.getSecondaryEnd()) != null) {
                n4 = atRefRangeNumber.getIntValue(n, n + n2) - n3;
            }
            if (paint == null) continue;
            graphics2D.setPaint(paint);
            int n5 = Math.min(this.a, gridLine.getSize());
            if (bl) {
                graphics2D.fillRect(n3, gridLine.getPosition(), n4, n5);
                continue;
            }
            graphics2D.fillRect(gridLine.getPosition(), n3, n5, n4);
        }
    }

    @Override
    public void gridChanged(PropertyChangeEvent propertyChangeEvent) {
    }
}

