/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.decorators;

import com.miginfocom.calendar.datearea.DateArea;
import com.miginfocom.calendar.decorators.CellLabelDecorator;
import com.miginfocom.calendar.grid.DateGrid;
import com.miginfocom.calendar.grid.Grid;
import com.miginfocom.calendar.theme.CalendarTheme;
import com.miginfocom.theme.Theme;
import com.miginfocom.theme.Themes;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateChangeEvent;
import com.miginfocom.util.dates.DateChangeListener;
import com.miginfocom.util.dates.DateFormatList;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.gfx.RepaintRegion;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class ThemeCellLabelDecorator
extends CellLabelDecorator
implements DateChangeListener,
PropertyChangeListener {
    private final transient ImmutableDateRange[] a = new ImmutableDateRange[5];
    private String b;
    private transient Object[][] c = null;
    private transient Object[][][] d = null;
    public static final String[] MAIN_KEYS = new String[]{"Decorators/CellLabel/Background/", "Decorators/CellLabel/Foreground/", "Decorators/CellLabel/Font/", "Decorators/CellLabel/Underline/", "Decorators/CellLabel/DateFormat/"};
    private static String[][] e = new String[MAIN_KEYS.length][];

    public ThemeCellLabelDecorator(DateArea dateArea, int n, String string) {
        super(dateArea, n);
        this.setThemeContext(string);
        this.a();
        dateArea.addDateChangeListener(this, true);
        this.reloadFromTheme();
        this.invalidateDateRange(dateArea.getVisibleDateRangeCorrected());
    }

    @Override
    protected void paintCell(Graphics2D graphics2D, int n, int n2, Rectangle rectangle) {
        DateGrid dateGrid = this.getDateGrid();
        if (dateGrid == null) {
            return;
        }
        this.updateTypeArray();
        int n3 = dateGrid.getCellNumber(new Point(n2, n));
        this.setBackground((Paint)this.c[0][n3]);
        this.setForeground((Paint)this.c[1][n3]);
        this.setFont((Font)this.c[2][n3]);
        this.setDateFormat((DateFormatList)this.c[4][n3]);
        Integer n4 = (Integer)this.c[3][n3];
        this.setUlWidth(n4 != null ? n4 : 0);
        super.paintCell(graphics2D, n, n2, rectangle);
    }

    @Override
    protected boolean prePaint() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        DateArea dateArea = this.getDateArea();
        if (dateArea != null) {
            dateArea.removeDateChangeListener(this);
        }
        Theme.removePropertyChangeListener(this.b, this);
    }

    public void reloadFromTheme() {
        int n;
        CalendarTheme calendarTheme = (CalendarTheme)Themes.getTheme(this.b);
        int n2 = CalendarTheme.WEEK_DAYS_SUB_KEYS.length;
        int n3 = CalendarTheme.LABEL_TYPE_SUB_FOLDER_KEYS.length;
        this.d = new Object[MAIN_KEYS.length][n3][n2];
        for (n = 0; n < MAIN_KEYS.length; ++n) {
            String[] stringArray = e[n];
            this.d[n] = new Object[n3][n2];
            for (int i = 0; i < n3; ++i) {
                this.d[n][i] = new Object[n2];
                for (int j = 0; j < n2; ++j) {
                    this.d[n][i][j] = calendarTheme.getValue(stringArray[i * n2 + j]);
                }
            }
        }
        n = calendarTheme.getBool("Decorators/CellLabel/antiAlias") ? 1 : 0;
        this.setTextAntiAlias(n != 0 ? 9 : 1);
        this.setPlaceRect(calendarTheme.getPlaceRect("Decorators/CellLabel/bounds"));
        this.setAlignX((AtRefRangeNumber)calendarTheme.getValue("Decorators/CellLabel/TextAlignment/x"));
        this.setAlignY((AtRefRangeNumber)calendarTheme.getValue("Decorators/CellLabel/TextAlignment/y"));
    }

    protected void updateTypeArray() {
        if (this.c == null || !this.hasInvalidCells()) {
            return;
        }
        RepaintRegion repaintRegion = new RepaintRegion();
        DateGrid dateGrid = this.getDateGrid();
        if (dateGrid == null) {
            return;
        }
        Locale locale = dateGrid.getDateRange().getLocale();
        TimeZone timeZone = dateGrid.getDateRange().getTimeZone();
        int n = this.getInvalidStart();
        int n2 = Math.min(this.getInvalidEnd(), dateGrid.getRowCount() * dateGrid.getColumnCount() - 1);
        Calendar calendar = ((CalendarTheme)Themes.getTheme(this.b)).createCalendar();
        int n3 = calendar.get(1);
        int n4 = calendar.get(6);
        for (int i = n; i <= n2; ++i) {
            Point point = dateGrid.getCell(i);
            ImmutableDateRange immutableDateRange = dateGrid.getDateRangeForCell(point.y, point.x);
            for (int j = 0; j < MAIN_KEYS.length; ++j) {
                int n5 = 0;
                while (!this.a(n5, immutableDateRange)) {
                    ++n5;
                }
                int n6 = immutableDateRange.getStartField(6) == n4 && immutableDateRange.getStartField(1) == n3 ? 0 : (immutableDateRange.getStartField(5) == 1 && this.d[j][n5][1] != null ? 1 : immutableDateRange.getStartField(7) + 1);
                Object object = this.c[j][i];
                Object object2 = this.d[j][n5][n6];
                if (object2 instanceof DateFormatList) {
                    DateFormatList dateFormatList = (DateFormatList)object2;
                    Locale locale2 = dateFormatList.getLocale();
                    TimeZone timeZone2 = dateFormatList.getTimeZone();
                    if (locale2 == null && locale != null || timeZone2 == null && timeZone != null) {
                        Locale locale3 = locale2 != null ? locale2 : locale;
                        TimeZone timeZone3 = timeZone2 != null ? timeZone2 : timeZone;
                        object2 = new DateFormatList(dateFormatList.getPattern(), locale3, timeZone3);
                    }
                }
                this.c[j][i] = object2;
                if (MigUtil.equals(object, object2)) continue;
                repaintRegion.add(dateGrid.getBoundingBox(point.y, point.x, point.y, point.x, 2, false));
            }
        }
        this.setCellsValid();
        if (repaintRegion.hasBounds()) {
            this.repaint(repaintRegion.getBounds());
        }
    }

    private void a() {
        Grid grid = this.getGrid();
        int n = grid != null ? grid.getColumnCount() * grid.getRowCount() : 0;
        this.c = new Object[MAIN_KEYS.length][n];
        for (int i = 0; i < MAIN_KEYS.length; ++i) {
            this.c[i] = new Object[n];
        }
    }

    @Override
    public void gridChanged(PropertyChangeEvent propertyChangeEvent) {
        super.gridChanged(propertyChangeEvent);
        this.a();
    }

    private boolean a(int n, ImmutableDateRange immutableDateRange) {
        switch (n) {
            case 0: {
                DateArea dateArea = this.getDateArea();
                return dateArea != null && !dateArea.isSelectable(immutableDateRange);
            }
            case 4: {
                return true;
            }
        }
        ImmutableDateRange immutableDateRange2 = this.a[n - 1];
        return immutableDateRange2 != null && immutableDateRange2.isOverlapping(immutableDateRange);
    }

    @Override
    public void dateRangeChanged(DateChangeEvent dateChangeEvent) {
        int n = dateChangeEvent.getType();
        if (n >= 0 && n <= 3) {
            this.a(dateChangeEvent.getNewRange(), n);
        }
    }

    private void a(ImmutableDateRange immutableDateRange, int n) {
        DateGrid dateGrid = this.getDateGrid();
        if (immutableDateRange != null && dateGrid != null) {
            immutableDateRange = immutableDateRange.createIntersection(dateGrid.getDateRange());
        }
        if (this.a[n] != null) {
            this.invalidateDateRange(this.a[n]);
        }
        if (immutableDateRange != null) {
            this.invalidateDateRange(immutableDateRange);
        }
        this.a[n] = immutableDateRange;
        if (n == 1 && this.a[0] != null) {
            this.invalidateDateRange(this.a[0]);
            this.a[0] = null;
        } else if (n == 0 && this.a[1] != null) {
            this.invalidateDateRange(this.a[1]);
            this.a[1] = null;
        }
        this.updateTypeArray();
        this.cleanStringLabelCache();
    }

    public void setThemeContext(String string) {
        Theme.removePropertyChangeListener(this.b, this);
        this.b = string;
        Themes.getTheme(this.b).addPropertyChangeListener(this, true);
    }

    public DateArea getDateArea() {
        return (DateArea)this.getDateGridContainer();
    }

    protected void repaint(Rectangle rectangle) {
        DateArea dateArea = this.getDateArea();
        if (dateArea != null) {
            dateArea.getComponent().repaint(rectangle);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Grid grid = this.getGrid();
        if (grid != null && propertyChangeEvent.getPropertyName().startsWith("Decorators/CellLabel/")) {
            this.reloadFromTheme();
            this.invalidateCells(0, grid.getColumnCount() * grid.getRowCount() - 1);
            this.repaint(new Rectangle(0, 0, grid.getWidth(), grid.getHeight()));
        }
    }

    static {
        String[] stringArray = MigUtil.flatten(new String[][]{CalendarTheme.LABEL_TYPE_SUB_FOLDER_KEYS, CalendarTheme.WEEK_DAYS_SUB_KEYS});
        for (int i = 0; i < MAIN_KEYS.length; ++i) {
            ThemeCellLabelDecorator.e[i] = new String[MAIN_KEYS.length * stringArray.length];
            for (int j = 0; j < e[i].length; ++j) {
                ThemeCellLabelDecorator.e[i] = MigUtil.flatten(new String[][]{{MAIN_KEYS[i]}, stringArray});
            }
        }
    }
}

