/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.Grid;
import com.miginfocom.calendar.grid.GridDimensionLayout;
import com.miginfocom.calendar.grid.GridLine;
import com.miginfocom.calendar.grid.GridLineSpecification;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.calendar.grid.GridUtil;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AbstractGrid
implements Grid,
PropertyChangeListener {
    private final int a;
    private final GridRow[][] b = new GridRow[2][];
    private final GridLine[][] c = new GridLine[2][];
    private GridLineSpecification d;
    private GridDimensionLayout e = null;
    private GridDimensionLayout f = null;
    private int g = -1;
    private int h = -1;
    private final int i;
    private final int j;
    private final int k;
    private final int l;
    private transient ListenerSet m = new ListenerSet(PropertyChangeListener.class);

    protected AbstractGrid(int n, int n2, int n3, GridLineSpecification gridLineSpecification) {
        this.a = n;
        this.k = n2 > 0 ? n2 : 1;
        this.l = n3 > 0 ? n3 : 1;
        this.d = gridLineSpecification;
        this.j = n == 1 ? this.k : this.l;
        this.i = n == 1 ? this.l : this.k;
    }

    public GridDimensionLayout getSecondaryDimensionLayout() {
        return this.f;
    }

    public void setSecondaryDimensionLayout(GridDimensionLayout gridDimensionLayout) {
        if (gridDimensionLayout != this.f) {
            GridDimensionLayout gridDimensionLayout2 = this.f;
            this.f = gridDimensionLayout;
            this.firePropertyChangeEvent("secondaryDimensionLayout", gridDimensionLayout2, gridDimensionLayout);
        }
    }

    public GridDimensionLayout getPrimaryDimensionLayout() {
        return this.e;
    }

    public void setPrimaryDimensionLayout(GridDimensionLayout gridDimensionLayout) {
        if (gridDimensionLayout != this.e) {
            GridDimensionLayout gridDimensionLayout2 = this.e;
            this.e = gridDimensionLayout;
            this.firePropertyChangeEvent("primaryDimensionLayout", gridDimensionLayout2, gridDimensionLayout);
        }
    }

    @Override
    public int getColumnCount() {
        return this.i;
    }

    @Override
    public int getRowCount() {
        return this.j;
    }

    @Override
    public int getCellCount(int n) {
        return n == 0 ? this.k : this.l;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.g, this.h);
    }

    @Override
    public int getSize(int n) {
        return this.getOrientationForDimIx(n) == 1 ? this.h : this.g;
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    @Override
    public int getWidth() {
        return this.g;
    }

    @Override
    public void setSize(Dimension dimension) {
        if (dimension.width == this.g && dimension.height == this.h) {
            return;
        }
        this.g = Math.min(this.getMaximumWidth(), Math.max(this.getMinimumWidth(), dimension.width));
        this.h = Math.min(this.getMaximumHeight(), Math.max(this.getMinimumHeight(), dimension.height));
    }

    @Override
    public int getMinimumWidth() {
        return (this.a == 0 ? this.e : this.f).getMinimumSize(this);
    }

    @Override
    public int getMaximumWidth() {
        Integer n = (this.a == 0 ? this.e : this.f).getMaximumSize(this);
        return n != null ? n : 0x3FFFFFF5;
    }

    @Override
    public int getMinimumHeight() {
        return (this.a == 0 ? this.f : this.e).getMinimumSize(this);
    }

    @Override
    public int getMaximumHeight() {
        Integer n = (this.a == 0 ? this.f : this.e).getMaximumSize(this);
        return n != null ? n : 0x3FFFFFF5;
    }

    @Override
    public Integer getAbsolutePreferredWidth() {
        return (this.a == 0 ? this.e : this.f).getPreferredSize(this);
    }

    @Override
    public Integer getAbsolutePreferredHeight() {
        return (this.a == 0 ? this.f : this.e).getPreferredSize(this);
    }

    @Override
    public int getX(float f) {
        return this.getRelPos(this.getColumnDimIx(), f);
    }

    @Override
    public int getY(float f) {
        return this.getRelPos(this.getRowDimIx(), f);
    }

    protected int getRelPos(int n, float f) {
        int n2 = n == 0 ? this.k : this.l;
        int n3 = (int)((float)n2 * f);
        n3 = MigUtil.toBounds(n3, 0, n2 - 1);
        float f2 = (f - (float)n3 / (float)n2) * (float)n2;
        GridLine[] gridLineArray = this.c[n];
        GridLine gridLine = gridLineArray[n3];
        int n4 = gridLine.getSize() + gridLineArray[n3 + 1].getSize();
        GridRow gridRow = this.b[n][n3];
        return gridLine.getMiddleLo() + (int)(f2 * ((float)(gridRow.getSize() + (n4 >> 1)) + 0.5f));
    }

    public int toPos(int n, Point point) {
        return this.getOrientationForDimIx(n) == 1 ? point.y : point.x;
    }

    @Override
    public Integer getColumnForX(int n, boolean bl) {
        return this.getRowIndexForPos(this.getColumnDimIx(), n, bl);
    }

    @Override
    public Integer getRowForY(int n, boolean bl) {
        return this.getRowIndexForPos(this.getRowDimIx(), n, bl);
    }

    @Override
    public GridRow[] getColumns() {
        return this.b[this.getColumnDimIx()];
    }

    @Override
    public GridRow[] getRows() {
        return this.b[this.getRowDimIx()];
    }

    @Override
    public GridRow[] getGridRows(int n) {
        return this.b[n];
    }

    @Override
    public GridLine[] getColumnGridLines() {
        return this.c[this.getColumnDimIx()];
    }

    @Override
    public GridLine[] getRowGridLines() {
        return this.c[this.getRowDimIx()];
    }

    protected void setCellRows(int n, GridRow[] gridRowArray) {
        if (this.b[n] != null) {
            GridUtil.registerRowListeners(this, this.b[n], false);
        }
        this.b[n] = gridRowArray;
        if (gridRowArray != null) {
            GridUtil.registerRowListeners(this, this.b[n], true);
        }
    }

    @Override
    public GridLine[] getGridLines(int n) {
        return this.c[n];
    }

    @Override
    public void setGridLines(int n, GridLine[] gridLineArray) {
        this.c[n] = gridLineArray;
    }

    @Override
    public GridLineSpecification getGridLineSpecification() {
        return this.d;
    }

    @Override
    public final int getColumnDimIx() {
        return this.a == 1 ? 1 : 0;
    }

    @Override
    public final int getRowDimIx() {
        return this.a == 1 ? 0 : 1;
    }

    protected final int getOrientationForDimIx(int n) {
        return n == 0 ? this.a : (this.a == 1 ? 0 : 1);
    }

    protected Integer getRowIndexForPos(int n, int n2, boolean bl) {
        return GridUtil.getGridRowIndex(n2, this.b[n], bl);
    }

    public GridRow getRowAt(int n, Point point, int n2) {
        return GridUtil.getGridRow(this.toPos(n, point), this.b[n], n2);
    }

    public GridRow getRowAt(int n, Point point, int n2, boolean bl) {
        return GridUtil.getGridRow(this.toPos(n, point), this.b[n], n2);
    }

    @Override
    public Float getPercentInsideColumn(int n, boolean bl) {
        Integer n2 = this.getColumnForX(n, bl);
        if (n2 == null) {
            return null;
        }
        Rectangle rectangle = this.getBoundsOfCell(0, n2, 1, false);
        return new Float(Math.max(0.0f, Math.min(1.0f, (float)(n - rectangle.x) / (float)rectangle.width)));
    }

    @Override
    public Float getPercentInsideRow(int n, boolean bl) {
        Integer n2 = this.getRowForY(n, bl);
        if (n2 == null) {
            return null;
        }
        Rectangle rectangle = this.getBoundsOfCell(n2, 0, 1, false);
        return new Float(Math.max(0.0f, Math.min(1.0f, (float)(n - rectangle.y) / (float)rectangle.height)));
    }

    @Override
    public int getPrimaryDimension() {
        return this.a;
    }

    @Override
    public Rectangle getBoundsOfCell(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        this.assertSize(n, n2);
        int n8 = this.getColumnDimIx();
        int n9 = this.getRowDimIx();
        if (n3 == 0) {
            GridRow gridRow = this.b[n8][n2];
            GridRow gridRow2 = this.b[n9][n];
            n7 = gridRow.getStart();
            n6 = gridRow2.getStart();
            n5 = gridRow.getSize();
            n4 = gridRow2.getSize();
        } else {
            GridLine gridLine = this.c[n8][n2];
            GridLine gridLine2 = this.c[n9][n];
            GridLine gridLine3 = this.c[n8][n2 + 1];
            GridLine gridLine4 = this.c[n9][n + 1];
            switch (n3) {
                case 1: {
                    n7 = gridLine.getMiddleLo();
                    n6 = gridLine2.getMiddleLo();
                    n5 = gridLine3.getMiddleHi() - n7;
                    n4 = gridLine4.getMiddleHi() - n6;
                    break;
                }
                case 2: {
                    n7 = gridLine.getPosition();
                    n6 = gridLine2.getPosition();
                    n5 = gridLine3.getEnd() - n7;
                    n4 = gridLine4.getEnd() - n6;
                    break;
                }
                case 3: {
                    n7 = gridLine.getPosition();
                    n6 = gridLine2.getPosition();
                    n5 = this.b[n8][n2].getEnd() - n7;
                    n4 = this.b[n9][n].getEnd() - n6;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown size mode:" + n3);
                }
            }
        }
        if (bl) {
            --n5;
            --n4;
        }
        return new Rectangle(n7, n6, n5, n4);
    }

    @Override
    public Rectangle getBoundingBox(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.assertSize(n, n2);
        this.assertSize(n3, n4);
        Rectangle rectangle = this.getBoundsOfCell(n, n2, n5, bl);
        Rectangle rectangle2 = this.getBoundsOfCell(n3, n4, n5, bl);
        if (this.a == 0) {
            if (n == n3) {
                rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
                return rectangle;
            }
            int n6 = this.getBoundsOfCell((int)0, (int)0, (int)n5, (boolean)bl).x;
            int n7 = (int)this.getBoundsOfCell(0, this.getColumnCount() - 1, n5, bl).getMaxX();
            rectangle.x = n6;
            rectangle.width = n7 - rectangle.x;
            rectangle.height = rectangle2.y + rectangle2.height - rectangle.y;
            return rectangle;
        }
        if (n2 == n4) {
            rectangle.height = rectangle2.y + rectangle2.height - rectangle.y;
            return rectangle;
        }
        int n8 = this.getBoundsOfCell((int)0, (int)0, (int)n5, (boolean)bl).y;
        int n9 = (int)this.getBoundsOfCell(this.getRowCount() - 1, 0, n5, bl).getMaxY();
        rectangle.y = n8;
        rectangle.height = n9 - rectangle.y;
        rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
        return rectangle;
    }

    @Override
    public Polygon getCellsOutline(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.assertSize(n, n2);
        this.assertSize(n3, n4);
        Polygon polygon = new Polygon();
        Rectangle rectangle = this.getBoundsOfCell(n, n2, n5, bl);
        Rectangle rectangle2 = this.getBoundsOfCell(n3, n4, n5, bl);
        if (this.a == 0) {
            int n6 = this.getBoundsOfCell((int)0, (int)0, (int)n5, (boolean)bl).x;
            int n7 = (int)this.getBoundsOfCell(0, this.getColumnCount() - 1, n5, bl).getMaxX();
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y);
            int n8 = Math.min(n7, rectangle2.x + rectangle2.width);
            int n9 = rectangle2.y + rectangle2.height;
            if (rectangle.y != rectangle2.y) {
                polygon.addPoint(n7, rectangle.y);
                polygon.addPoint(n7, rectangle2.y + 0);
                polygon.addPoint(n8 + 0, rectangle2.y + 0);
                polygon.addPoint(n8 + 0, n9);
            } else {
                polygon.addPoint(n8, rectangle2.y);
                polygon.addPoint(n8, n9);
            }
            if (rectangle.y == rectangle2.y) {
                polygon.addPoint(rectangle.x, n9);
            } else {
                polygon.addPoint(n6, n9);
                polygon.addPoint(n6, rectangle.y + rectangle.height);
            }
        } else {
            if (rectangle.x == rectangle2.x) {
                polygon.addPoint(rectangle.x, rectangle.y);
                polygon.addPoint(rectangle2.x + rectangle2.width, rectangle.y);
                polygon.addPoint(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                polygon.addPoint(rectangle.x, rectangle2.y + rectangle2.height);
                return polygon;
            }
            int n10 = this.getBoundsOfCell((int)0, (int)0, (int)n5, (boolean)bl).y;
            int n11 = (int)this.getBoundsOfCell(this.getRowCount() - 1, 0, n5, bl).getMaxY();
            polygon.addPoint(rectangle.x, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, n10);
            polygon.addPoint(rectangle2.x + rectangle2.width, n10);
            polygon.addPoint(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            polygon.addPoint(rectangle2.x, rectangle2.y + rectangle2.height);
            polygon.addPoint(rectangle2.x, n11);
            polygon.addPoint(rectangle.x, n11);
        }
        return polygon;
    }

    @Override
    public int getCellNumber(Point point) {
        this.assertSize(point.y, point.x);
        if (this.a == 1) {
            return point.y + point.x * this.j;
        }
        return point.x + point.y * this.i;
    }

    @Override
    public Point getCell(int n) {
        if (n < 0 || n >= this.j * this.i) {
            throw new IllegalArgumentException("Cell number not inside grid: " + n);
        }
        if (this.a == 1) {
            return new Point(n / this.j, n % this.j);
        }
        return new Point(n % this.i, n / this.i);
    }

    @Override
    public void layout() {
        if (this.h == -1) {
            this.setSize(new Dimension(this.getMinimumWidth(), this.getMinimumHeight()));
        }
        this.e.layout(this);
        this.f.layout(this);
    }

    protected final void assertSize(int n, int n2) {
        if (n < 0 || n > this.j - 1 || n2 < 0 || n2 > this.i - 1) {
            throw new IndexOutOfBoundsException("Illegal cell! row:" + n + " col:" + n2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.m.fireEvent(propertyChangeEvent);
    }

    protected abstract void createGridLinesAndCellRows();

    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyListener(propertyChangeListener, false);
    }

    public void addPropertyListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        this.m.add(propertyChangeListener, bl);
    }

    public void removePropertyListener(PropertyChangeListener propertyChangeListener) {
        this.m.remove(propertyChangeListener);
    }

    public boolean isIgnorePropertyEvents() {
        return this.m.isIgnoreEvents();
    }

    public boolean setIgnorePropertyEvents(boolean bl) {
        return this.m.setIgnoreEvents(bl);
    }

    protected void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (!MigUtil.equals(object, object2)) {
            this.m.fireEvent(new PropertyChangeEvent(this, string, object, object2));
        }
    }
}

