/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.GridLineException;
import com.miginfocom.calendar.grid.GridLineRepetition;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.DateUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Calendar;

public class DateBoundaryException
implements GridLineException,
Serializable {
    private transient int a = -1;
    private transient GridLineRepetition b = null;
    private static final long serialVersionUID = 1L;

    public DateBoundaryException() {
        this(44, null);
    }

    public DateBoundaryException(int n, GridLineRepetition gridLineRepetition) {
        this.setBoundaryRangeType(n);
        this.setGridLineRepetition(gridLineRepetition);
    }

    @Override
    public GridLineRepetition getException(GridRow gridRow, GridRow gridRow2, int n, int n2) {
        int n3;
        Calendar calendar;
        if (gridRow != null) {
            calendar = gridRow.getDateRange().getEnd(true);
        } else if (gridRow2 != null) {
            calendar = gridRow2.getDateRange().getStart();
        } else {
            return null;
        }
        if (!DateUtil.isOnBoundaryStart(calendar, this.a)) {
            return null;
        }
        int n4 = DateUtil.convertRangeTypeToCalField(this.a);
        int n5 = calendar.get(n4);
        return this.b.appliesTo(n5, n3 = calendar.getActualMaximum(n4)) ? this.b : null;
    }

    public int getBoundaryRangeType() {
        return this.a;
    }

    public void setBoundaryRangeType(int n) {
        if (n < 40 || n > 47) {
            throw new IllegalArgumentException("Unsupported rangeType: " + n);
        }
        this.a = n;
    }

    public GridLineRepetition getGridLineRepetition() {
        return this.b;
    }

    public void setGridLineRepetition(GridLineRepetition gridLineRepetition) {
        this.b = gridLineRepetition != null ? gridLineRepetition : new GridLineRepetition(1, Color.LIGHT_GRAY);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateBoundaryException)) {
            return false;
        }
        DateBoundaryException dateBoundaryException = (DateBoundaryException)object;
        return this.a == dateBoundaryException.a && MigUtil.equals(this.b, dateBoundaryException.b);
    }

    public String toString() {
        return "Boundary: " + DateRangeI.DATE_RANGE_NAMES[this.getBoundaryRangeType() - 40] + ", " + this.getGridLineRepetition().toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == DateBoundaryException.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }
}

