/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.AbstractGrid;
import com.miginfocom.calendar.grid.GridLineSpecification;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.calendar.grid.SubRowCreator;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRange;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.DateUtil;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class DateGrid
extends AbstractGrid {
    private final ImmutableDateRange a;
    protected final long primDimCellSpanMillis;
    protected final long secDimCellSpanMillis;
    private final transient HashMap b;
    private SubRowCreator c = null;

    public DateGrid(ImmutableDateRange immutableDateRange, int n, int n2, int n3, GridLineSpecification gridLineSpecification, SubRowCreator subRowCreator) {
        super(n, n2, n3, gridLineSpecification);
        if (immutableDateRange.getMillisSpanned(false, false) <= 0L) {
            throw new IllegalArgumentException("Date range spans no time! " + immutableDateRange);
        }
        this.a = immutableDateRange;
        this.c = subRowCreator;
        long l = immutableDateRange.getMillisSpanned(true, true);
        int n4 = this.getCellCount(0);
        int n5 = this.getCellCount(1);
        this.secDimCellSpanMillis = Math.round((double)l / (double)n5);
        this.primDimCellSpanMillis = Math.round((double)this.secDimCellSpanMillis / (double)n4);
        int n6 = n4 * n5;
        this.b = n6 <= 10000 ? new HashMap(n6 << 1, 0.5f) : null;
        this.createGridLinesAndCellRows();
    }

    public ImmutableDateRange getDateRange() {
        return this.a;
    }

    public ImmutableDateRange getDateRangeForCell(int n, int n2) {
        ImmutableDateRange immutableDateRange;
        Integer n3 = new Integer(n | n2 << 16);
        ImmutableDateRange immutableDateRange2 = immutableDateRange = this.b != null ? (immutableDateRange = (ImmutableDateRange)this.b.get(n3)) : null;
        if (immutableDateRange == null) {
            boolean bl;
            this.assertSize(n, n2);
            boolean bl2 = this.getPrimaryDimension() == 1;
            long l = bl2 ? (long)n2 * this.secDimCellSpanMillis + (long)n * this.primDimCellSpanMillis : (long)n * this.secDimCellSpanMillis + (long)n2 * this.primDimCellSpanMillis;
            TimeZone timeZone = this.a.getTimeZone();
            Locale locale = this.a.getLocale();
            int n4 = this.getCellDSTChangeType(n, n2);
            boolean bl3 = bl = (bl2 ? n : n2) > 0;
            if (n4 == 1 && bl) {
                long l2;
                ImmutableDateRange immutableDateRange3 = this.getDateRangeForCell(bl2 ? n - 1 : n, bl2 ? n2 : n2 - 1);
                if (immutableDateRange3 == null || !immutableDateRange3.isSpanningTime()) {
                    return immutableDateRange3;
                }
                long l3 = l2 = this.a.getStartMillis() + l;
                immutableDateRange = new ImmutableDateRange(l2, l3, false, timeZone, locale);
            } else if (n4 == -1 && bl) {
                if (this.getCellDSTChangeType(bl2 ? n - 1 : n, bl2 ? n2 : n2 - 1) == -1) {
                    ImmutableDateRange immutableDateRange4 = this.getDateRangeForCell(bl2 ? n - 1 : n, bl2 ? n2 : n2 - 1);
                    long l4 = immutableDateRange4.getEndMillis() + 1L;
                    immutableDateRange = new ImmutableDateRange(l4, l4 + this.primDimCellSpanMillis * 2L - 1L, false, timeZone, locale);
                } else {
                    long l5 = this.a.getStartMillis() + l;
                    immutableDateRange = new ImmutableDateRange(l5, l5 + this.primDimCellSpanMillis * 2L - 1L, false, timeZone, locale);
                }
            } else {
                long l6 = DateUtil.addMillisDSTSafe(this.a.getStartMillis(), timeZone, l);
                long l7 = DateUtil.addMillisDSTSafe(l6, timeZone, this.primDimCellSpanMillis - 1L);
                immutableDateRange = new ImmutableDateRange(l6, l7, false, timeZone, locale);
            }
            if (this.b != null) {
                this.b.put(n3, immutableDateRange);
            }
        }
        return immutableDateRange;
    }

    public int getCellDSTChangeType(int n, int n2) {
        long l = this.getPrimaryDimension() == 1 ? (long)n2 * this.secDimCellSpanMillis + (long)n * this.primDimCellSpanMillis : (long)n * this.secDimCellSpanMillis + (long)n2 * this.primDimCellSpanMillis;
        TimeZone timeZone = this.a();
        long l2 = this.a.getStartMillis();
        long l3 = l2 + l;
        int n3 = timeZone.getOffset(l3);
        int n4 = timeZone.getDSTSavings();
        if (timeZone.getOffset(l3 - (long)n4) < n3 && l3 - (long)n4 >= l2) {
            return 1;
        }
        if (timeZone.getOffset(l3 + (long)n4) < n3 && l3 + (long)n4 < this.a.getEndMillis()) {
            return -1;
        }
        return 0;
    }

    private TimeZone a() {
        TimeZone timeZone = this.a.getTimeZone();
        return timeZone != null ? timeZone : TimeZone.getDefault();
    }

    public ImmutableDateRange getCellTrimmedDateRange(ImmutableDateRange immutableDateRange) {
        TimeZone timeZone = immutableDateRange.getTimeZone();
        Point point = this.getCell(immutableDateRange.getStartMillis(), timeZone, true);
        Point point2 = this.getCell(immutableDateRange.getEndMillis(), timeZone, true);
        ImmutableDateRange immutableDateRange2 = this.getDateRangeForCell(point.y, point.x);
        ImmutableDateRange immutableDateRange3 = this.getDateRangeForCell(point2.y, point2.x);
        return new ImmutableDateRange((DateRangeI)immutableDateRange2, immutableDateRange3);
    }

    public MutableDateRange getDateRangeForRect(Rectangle rectangle) {
        if (rectangle.x + rectangle.width < 0 || rectangle.y + rectangle.height < 0 || rectangle.x >= this.getWidth() || rectangle.y >= this.getHeight()) {
            return null;
        }
        int n = this.getRowForY(rectangle.y, true);
        int n2 = this.getColumnForX(rectangle.x, true);
        int n3 = this.getRowForY(rectangle.y + rectangle.height, true);
        int n4 = this.getColumnForX(rectangle.x + rectangle.width, true);
        ImmutableDateRange immutableDateRange = this.getDateRangeForCell(n, n2);
        ImmutableDateRange immutableDateRange2 = this.getDateRangeForCell(n3, n4);
        return new DateRange(immutableDateRange.getStartMillis(), immutableDateRange2.getEndMillis(), false, this.a.getTimeZone(), this.a.getLocale());
    }

    public Point getCell(long l, TimeZone timeZone, boolean bl) {
        int n;
        if (!this.a.isContaining(l, false)) {
            if (!bl) {
                throw new IllegalArgumentException("Date not inside grid: " + new Date(l) + " grid range: " + this.a);
            }
            if (l < this.a.getStartMillis()) {
                return new Point(0, 0);
            }
            return new Point(this.getColumnCount() - 1, this.getRowCount() - 1);
        }
        if (timeZone == null) {
            timeZone = this.a.getTimeZone();
        }
        long l2 = DateUtil.getMillisSpannedDST(this.a.getStartMillis(), timeZone, l, timeZone);
        int n2 = (int)(l2 / this.secDimCellSpanMillis);
        int n3 = (int)((l2 - (long)n2 * this.secDimCellSpanMillis) / this.primDimCellSpanMillis);
        boolean bl2 = this.getPrimaryDimension() == 1;
        int n4 = bl2 ? n3 : n2;
        int n5 = n = bl2 ? n2 : n3;
        if (n >= this.getColumnCount() || n4 >= this.getRowCount()) {
            throw new IllegalArgumentException("Internal Error - Date not inside grid: " + new Date(l) + " grid range: " + this.a + " r:" + n4 + " c:" + n);
        }
        return new Point(n, n4);
    }

    public int getPrimaryDimensionPosition(long l, TimeZone timeZone, Integer n) {
        if (timeZone == null) {
            timeZone = this.a.getTimeZone();
        }
        long l2 = DateUtil.getMillisSpannedDST(this.a.getStartMillis(), this.a.getTimeZone(), l, timeZone);
        if (n == null) {
            if ((l2 %= this.secDimCellSpanMillis) < 0L) {
                l2 += this.secDimCellSpanMillis;
            }
        } else {
            l2 -= (long)n.intValue() * this.secDimCellSpanMillis;
        }
        float f = (float)l2 / (float)this.secDimCellSpanMillis;
        return this.getRelPos(0, f);
    }

    public Rectangle[] getBoundsForDateRange(DateRangeI dateRangeI, int n) {
        return this.getBoundsForDateRange(dateRangeI, n, false, false);
    }

    public Rectangle[] getBoundsForDateRange(DateRangeI dateRangeI, int n, boolean bl, boolean bl2) {
        boolean bl3 = this.getPrimaryDimension() == 0;
        Point[] pointArray = this.getCellsForDateRange(dateRangeI);
        if (pointArray == null) {
            return MigUtil.EMPTY_RECT_ARRAY;
        }
        int n2 = bl3 ? this.getWidth() : this.getHeight();
        int n3 = bl3 ? pointArray[0].y : pointArray[0].x;
        int n4 = bl3 ? pointArray[1].y : pointArray[1].x;
        Rectangle[] rectangleArray = new Rectangle[n4 - n3 + 1];
        TimeZone timeZone = dateRangeI != null ? dateRangeI.getTimeZone() : this.a.getTimeZone();
        long l = dateRangeI != null ? dateRangeI.getStartMillis() : System.currentTimeMillis();
        long l2 = dateRangeI != null ? dateRangeI.getEndMillis() : l;
        for (int i = n3; i <= n4; ++i) {
            Rectangle rectangle = this.getBoundsOfCell(bl3 ? i : 0, bl3 ? 0 : i, n, bl2);
            Integer n5 = bl ? new Integer(i) : null;
            int n6 = i == n3 || bl ? this.getPrimaryDimensionPosition(l, timeZone, n5) : 0;
            int n7 = (i == n4 || bl ? this.getPrimaryDimensionPosition(l2, timeZone, n5) : n2) - n6;
            if (bl2) {
                --n7;
            }
            rectangleArray[i - n3] = bl3 ? new Rectangle(n6, rectangle.y, n7, rectangle.height) : new Rectangle(rectangle.x, n6, rectangle.width, n7);
        }
        return rectangleArray;
    }

    public Rectangle getBoundingBoxForDateRange(DateRangeI dateRangeI, int n) {
        return this.getBoundingBoxForDateRange(dateRangeI, n, false);
    }

    public Rectangle getBoundingBoxForDateRange(DateRangeI dateRangeI, int n, boolean bl) {
        Point[] pointArray = this.getCellsForDateRange(dateRangeI);
        return pointArray != null ? this.getBoundingBox(pointArray[0].y, pointArray[0].x, pointArray[1].y, pointArray[1].x, n, bl) : null;
    }

    public Polygon getOutlineForDateRange(DateRangeI dateRangeI, int n, boolean bl) {
        Point[] pointArray = this.getCellsForDateRange(dateRangeI);
        return pointArray != null ? this.getCellsOutline(pointArray[0].y, pointArray[0].x, pointArray[1].y, pointArray[1].x, n, bl) : null;
    }

    public Point[] getCellsForDateRange(DateRangeI dateRangeI) {
        Point point;
        Point point2;
        if (dateRangeI != null) {
            if (!dateRangeI.isOverlapping(this.a)) {
                return null;
            }
            boolean bl = dateRangeI.isSorted();
            TimeZone timeZone = dateRangeI.getTimeZone();
            point2 = this.getCell(bl ? dateRangeI.getStartMillis() : dateRangeI.getEndMillis(), timeZone, true);
            point = this.getCell(bl ? dateRangeI.getEndMillis() : dateRangeI.getStartMillis(), timeZone, true);
        } else {
            long l = System.currentTimeMillis();
            if (!this.a.isContaining(l, false)) {
                return null;
            }
            point2 = point = this.getCell(l, null, true);
        }
        return new Point[]{point2, point};
    }

    @Override
    protected void createGridLinesAndCellRows() {
        this.a(0);
        this.a(1);
    }

    private void a(int n) {
        DateRange dateRange = new DateRange(this.getDateRange());
        int n2 = n == 0 ? this.getCellCount(0) : this.getCellCount(1);
        long l = n == 0 ? this.primDimCellSpanMillis : this.secDimCellSpanMillis;
        long l2 = dateRange.getStartMillis();
        TimeZone timeZone = dateRange.getTimeZone();
        l2 = n == 0 ? DateUtil.addMillisDSTSafe(l2, timeZone, this.secDimCellSpanMillis * (long)(this.getCellCount(1) - 1) + this.primDimCellSpanMillis - 1L) : DateUtil.addMillisDSTSafe(l2, timeZone, this.primDimCellSpanMillis * (long)this.getCellCount(0) - 1L);
        dateRange.setEndMillis(l2, false);
        GridRow[] gridRowArray = new GridRow[n2];
        GridLineSpecification gridLineSpecification = this.getGridLineSpecification();
        for (int i = 0; i < n2; ++i) {
            DateRange dateRange2 = new DateRange(dateRange);
            dateRange2.addMillisDSTSafe(l * (long)i);
            gridRowArray[i] = new GridRow(dateRange2.getImmutable());
            if (n != 1 || this.c == null) continue;
            this.c.createSubRows(gridRowArray[i], gridLineSpecification.getSubDimensionProvider());
        }
        this.setCellRows(n, gridRowArray);
        this.setGridLines(n, gridLineSpecification.getProvider(n).createGridLines(gridRowArray));
    }
}

