/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.GridLine;
import com.miginfocom.calendar.grid.GridLineException;
import com.miginfocom.calendar.grid.GridLineProvider;
import com.miginfocom.calendar.grid.GridLineRepetition;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.util.io.IOUtil;
import com.miginfocom.util.repetition.DefaultRepetitionSpec;
import java.awt.Paint;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class DefaultGridLineProvider
extends DefaultRepetitionSpec
implements GridLineProvider {
    private final GridLineException[] a;
    private static final long serialVersionUID = 1L;

    public DefaultGridLineProvider(int n, Paint paint) {
        this(new GridLineRepetition[]{new GridLineRepetition(0, 1, n, paint)});
    }

    public DefaultGridLineProvider(int n, int n2, int n3, Paint paint) {
        this(new GridLineRepetition[]{new GridLineRepetition(0, Integer.MAX_VALUE, n, paint), new GridLineRepetition(Integer.MAX_VALUE, 1, n3, paint), new GridLineRepetition(0, 1, n2, paint)});
    }

    public DefaultGridLineProvider(int n, int n2, int n3, int n4, Paint paint, Paint paint2) {
        this(n, n2, n3, n4, paint, paint2, null);
    }

    public DefaultGridLineProvider(int n, int n2, int n3, int n4, Paint paint, Paint paint2, GridLineException[] gridLineExceptionArray) {
        this(new GridLineRepetition[]{new GridLineRepetition(0, Integer.MAX_VALUE, n, paint), new GridLineRepetition(Integer.MAX_VALUE, 1, n4, paint2), new GridLineRepetition(0, 2, n2, paint), new GridLineRepetition(1, 2, n3, paint2)}, gridLineExceptionArray);
    }

    public DefaultGridLineProvider(GridLineRepetition[] gridLineRepetitionArray) {
        this(gridLineRepetitionArray, null);
    }

    public DefaultGridLineProvider(GridLineRepetition[] gridLineRepetitionArray, GridLineException[] gridLineExceptionArray) {
        super(gridLineRepetitionArray);
        this.a = gridLineExceptionArray;
    }

    @Override
    public GridLine[] createGridLines(GridRow[] gridRowArray) {
        GridLine[] gridLineArray = new GridLine[gridRowArray.length + 1];
        for (int i = 0; i < gridLineArray.length; ++i) {
            gridLineArray[i] = new GridLine();
        }
        return gridLineArray;
    }

    @Override
    public int configureGridLines(GridRow[] gridRowArray, GridLine[] gridLineArray) {
        int n = 0;
        for (int i = 0; i < gridLineArray.length; ++i) {
            int n2;
            GridLine gridLine = gridLineArray[i];
            GridLineRepetition gridLineRepetition = null;
            if (this.a != null) {
                for (n2 = 0; n2 < this.a.length && gridLineRepetition == null; ++n2) {
                    GridRow gridRow = i > 0 ? gridRowArray[i - 1] : null;
                    GridRow gridRow2 = i < gridRowArray.length - 1 ? gridRowArray[i] : null;
                    gridLineRepetition = this.a[n2].getException(gridRow, gridRow2, i, gridLineArray.length);
                }
            }
            if (gridLineRepetition == null) {
                gridLineRepetition = (GridLineRepetition)this.getRepetition(i, gridLineArray.length);
            }
            int n3 = n2 = gridLineRepetition != null ? gridLineRepetition.getGridLineSize() : 0;
            if (gridLineRepetition != null) {
                gridLine.setPaint(gridLineRepetition.getPaint());
                gridLine.setSecondaryStart(gridLineRepetition.getLineStart());
                gridLine.setSecondaryEnd(gridLineRepetition.getLineEnd());
            }
            gridLine.setSize(n2);
            n += n2;
        }
        return n;
    }

    @Override
    public int getGridLinesSize(GridRow[] gridRowArray) {
        int n = 0;
        int n2 = gridRowArray.length + 1;
        for (int i = 0; i < n2; ++i) {
            GridLineRepetition gridLineRepetition = (GridLineRepetition)this.getRepetition(i, n2);
            if (gridLineRepetition == null) continue;
            n += gridLineRepetition.getGridLineSize();
        }
        return n;
    }

    public GridLineException[] getExceptions() {
        return this.a;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == DefaultGridLineProvider.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(DefaultGridLineProvider.class, new DefaultPersistenceDelegate(new String[]{"repetitions", "exceptions"}));
    }
}

