/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.GridLine;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.calendar.grid.GridRowLayout;
import com.miginfocom.calendar.grid.GridUtil;
import com.miginfocom.calendar.layout.Distributor;
import com.miginfocom.util.gfx.geometry.SizeSpec;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;

public class DefaultGridRowLayout
implements GridRowLayout {
    private static final AtRefNumber[] a = new AtRefNumber[]{AtFixed.FIXED0, AtFixed.FIXED0, AtFixed.FIXED0};
    private final SizeSpec b;
    private final SizeSpec c;
    private final SizeSpec d;
    private final boolean e;

    public DefaultGridRowLayout(boolean bl) {
        this(bl, (SizeSpec)null);
    }

    public DefaultGridRowLayout(boolean bl, int n) {
        this(bl, new AtFixed(n));
    }

    public DefaultGridRowLayout(boolean bl, AtRefNumber atRefNumber) {
        this(bl, null, atRefNumber, null);
    }

    public DefaultGridRowLayout(boolean bl, AtNumber atNumber, AtRefNumber atRefNumber, AtNumber atNumber2) {
        this(bl, new SizeSpec(atNumber, atRefNumber, atNumber2));
    }

    public DefaultGridRowLayout(boolean bl, SizeSpec sizeSpec) {
        this(bl, sizeSpec, sizeSpec, sizeSpec);
    }

    public DefaultGridRowLayout(boolean bl, SizeSpec sizeSpec, SizeSpec sizeSpec2, SizeSpec sizeSpec3) {
        this.e = bl;
        this.b = sizeSpec;
        this.c = sizeSpec2;
        this.d = sizeSpec3;
    }

    @Override
    public void layout(GridRow gridRow) {
        if (gridRow.getGridRowCount() > 0) {
            GridRow[] gridRowArray = gridRow.getGridRowsDeep();
            GridLine[] gridLineArray = gridRow.getGridLines();
            int n = gridRow.getGridLineProvider().configureGridLines(gridRowArray, gridLineArray);
            AtRefNumber[][] atRefNumberArray = this.a(gridRowArray);
            float[] fArray = Distributor.distribute(atRefNumberArray, gridRow.getSize() - n, this.e);
            int[] nArray = Distributor.roundSizes(fArray);
            for (int i = 0; i < atRefNumberArray.length; ++i) {
                gridRowArray[i].setSize(nArray[i]);
            }
            GridUtil.mergePositions(gridRow.getStart(), gridRowArray, gridLineArray);
        }
    }

    private AtRefNumber[][] a(GridRow[] gridRowArray) {
        AtRefNumber[][] atRefNumberArray = new AtRefNumber[gridRowArray.length][];
        int n = 0x3FFFFFF5;
        for (int i = 0; i < atRefNumberArray.length; ++i) {
            GridRow gridRow = gridRowArray[i];
            int n2 = gridRow.getLevel();
            if (n2 == n) {
                n = 0x3FFFFFF5;
            }
            if (n2 > n) {
                atRefNumberArray[i] = a;
                continue;
            }
            if (gridRow.isLeaf()) {
                atRefNumberArray[i] = this.a(gridRow, this.b);
                continue;
            }
            if (gridRow.isFolded()) {
                n = n2;
            }
            SizeSpec sizeSpec = gridRow.isFolded() ? this.d : this.c;
            atRefNumberArray[i] = this.a(gridRow, sizeSpec);
        }
        return atRefNumberArray;
    }

    private AtRefNumber[] a(GridRow gridRow, SizeSpec sizeSpec) {
        AtRefNumber[] atRefNumberArray = gridRow.getSizes();
        if (sizeSpec != null) {
            if (atRefNumberArray[0] == null) {
                atRefNumberArray[0] = sizeSpec.getMinimumSize();
            }
            if (atRefNumberArray[1] == null) {
                atRefNumberArray[1] = sizeSpec.getPreferredSize();
            }
            if (atRefNumberArray[2] == null) {
                atRefNumberArray[2] = sizeSpec.getMaximumSize();
            }
        }
        return atRefNumberArray;
    }

    @Override
    public Integer getMinimumSize(GridRow gridRow) {
        return this.a(gridRow, 0);
    }

    @Override
    public Integer getPreferredSize(GridRow gridRow) {
        return this.a(gridRow, 1);
    }

    @Override
    public Integer getMaximumSize(GridRow gridRow) {
        return this.a(gridRow, 2);
    }

    private Integer a(GridRow gridRow, int n) {
        int n2;
        AtRefNumber atRefNumber = gridRow.getSizes()[n];
        if (atRefNumber instanceof AtNumber) {
            return new Integer(((AtNumber)atRefNumber).getIntValue(1.0f));
        }
        if (gridRow.isLeaf()) {
            return null;
        }
        GridRow[] gridRowArray = gridRow.getGridRowsDeep();
        AtRefNumber[][] atRefNumberArray = this.a(gridRowArray);
        int n3 = gridRow.getSize();
        int n4 = 0;
        for (n2 = 0; n2 < atRefNumberArray.length; ++n2) {
            AtRefNumber atRefNumber2 = atRefNumberArray[n2][n];
            if (n == 0) {
                if (atRefNumber2 == null) continue;
                n4 += atRefNumber2.getIntValue(n3);
                continue;
            }
            if (atRefNumber2 == null) {
                return null;
            }
            n4 += atRefNumber2.getIntValue(n3);
        }
        n2 = gridRow.getGridLineProvider().getGridLinesSize(gridRowArray);
        return new Integer(n4 + n2);
    }

    @Override
    public Integer[] getSizes(GridRow gridRow) {
        int n;
        if (gridRow.isLeaf()) {
            return new Integer[3];
        }
        GridRow[] gridRowArray = gridRow.getGridRowsDeep();
        AtRefNumber[][] atRefNumberArray = this.a(gridRowArray);
        int n2 = gridRow.getSize();
        int[] nArray = new int[3];
        block0: for (n = 0; n < 3; ++n) {
            for (int i = 0; i < atRefNumberArray.length; ++i) {
                AtRefNumber atRefNumber = atRefNumberArray[i][n];
                if (n == 0) {
                    if (atRefNumber == null) continue;
                    int n3 = n;
                    nArray[n3] = nArray[n3] + atRefNumber.getIntValue(n2);
                    continue;
                }
                if (atRefNumber == null) {
                    nArray[n] = -1;
                    continue block0;
                }
                int n4 = n;
                nArray[n4] = nArray[n4] + atRefNumber.getIntValue(n2);
            }
        }
        n = gridRow.getGridLineProvider().getGridLinesSize(gridRowArray);
        return new Integer[]{new Integer(nArray[0] + n), nArray[1] == -1 ? null : new Integer(nArray[1] + n), nArray[2] == -1 ? null : new Integer(nArray[2] + n)};
    }
}

