/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.GridLine;
import com.miginfocom.calendar.grid.GridLineProvider;
import com.miginfocom.calendar.grid.GridUtil;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.PropertyProvider;
import com.miginfocom.util.dates.DateRange;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import com.miginfocom.util.dates.TimeSpan;
import com.miginfocom.util.filter.Filter;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class GridRow
implements PropertyProvider,
TimeSpan,
Filter,
PropertyChangeListener {
    public static final PropertyKey FOLDED = PropertyKey.getKey("folded");
    public static final PropertyKey NAME = PropertyKey.getKey("gridRowName");
    private IdentityHashMap a = null;
    private final GridRow b;
    private ImmutableDateRange c;
    private Filter d;
    private GridRow[] e;
    private GridLine[] f;
    private GridLineProvider g = null;
    private Paint h;
    private AtRefNumber i;
    private AtRefNumber j;
    private AtRefNumber k;
    private int l = 0;
    private int m = 0;
    private final transient ListenerSet n = new ListenerSet(PropertyChangeListener.class);

    public GridRow(ImmutableDateRange immutableDateRange) {
        this(immutableDateRange, null);
    }

    public GridRow(ImmutableDateRange immutableDateRange, Filter filter) {
        if (immutableDateRange == null) {
            throw new IllegalArgumentException("dateRange is null!");
        }
        this.b = null;
        this.c = immutableDateRange;
        this.d = filter;
        if (filter != null) {
            this.setProperty(NAME, filter.getName());
        }
    }

    public GridRow(GridRow gridRow) {
        this(gridRow, null);
    }

    public GridRow(GridRow gridRow, Filter filter) {
        if (gridRow == null) {
            throw new IllegalArgumentException("parentRow is null!");
        }
        this.b = gridRow;
        this.c = gridRow.getDateRange();
        this.d = filter;
        if (filter != null) {
            this.setProperty(NAME, filter.getName());
        }
    }

    public GridRow getParent() {
        return this.b;
    }

    public AtRefNumber getMinimumSize() {
        return this.i;
    }

    public void setMinimumSize(AtRefNumber atRefNumber) {
        this.i = atRefNumber;
    }

    public AtRefNumber getPreferredSize() {
        return this.j;
    }

    public void setPreferredSize(AtRefNumber atRefNumber) {
        this.j = atRefNumber;
    }

    public AtRefNumber getMaximumSize() {
        return this.k;
    }

    public void setMaximumSize(AtRefNumber atRefNumber) {
        this.k = atRefNumber;
    }

    public AtRefNumber[] getSizes() {
        return new AtRefNumber[]{this.i, this.j, this.k};
    }

    public void setSizes(AtRefNumber[] atRefNumberArray) {
        this.i = atRefNumberArray[0];
        this.j = atRefNumberArray[1];
        this.k = atRefNumberArray[2];
    }

    public boolean isFoldedUpwards() {
        for (GridRow gridRow = this; gridRow != null; gridRow = gridRow.getParent()) {
            if (!gridRow.isFolded()) continue;
            return true;
        }
        return false;
    }

    public boolean isFoldedAbove() {
        for (GridRow gridRow = this.getParent(); gridRow != null; gridRow = gridRow.getParent()) {
            if (!gridRow.isFolded()) continue;
            return true;
        }
        return false;
    }

    public boolean isFolded() {
        return MigUtil.isTrue(this.getProperty(FOLDED));
    }

    public void setFolded(boolean bl) {
        if (bl) {
            this.setProperty(FOLDED, Boolean.TRUE);
        } else {
            this.removeProperty(FOLDED);
        }
    }

    public int getLevel() {
        GridRow gridRow = this.b;
        int n = 0;
        while (gridRow != null) {
            gridRow = gridRow.getParent();
            ++n;
        }
        return n;
    }

    public Paint getBackground() {
        return this.h;
    }

    public void setBackground(Paint paint) {
        this.h = paint;
    }

    public ImmutableDateRange getDateRange() {
        return this.c;
    }

    public void setDateRange(ImmutableDateRange immutableDateRange) {
        this.c = immutableDateRange;
    }

    public Filter getFilter() {
        return this.d;
    }

    public void setFilter(Filter filter) {
        this.d = filter;
    }

    public int getStart() {
        return this.l;
    }

    public void setStart(int n) {
        this.l = n;
    }

    public int getSize() {
        return this.m;
    }

    public void setSize(int n) {
        this.m = n;
    }

    public int getEnd() {
        return this.l + this.m;
    }

    public int getMiddleLo() {
        return this.l + (this.m >> 1);
    }

    public int getMiddleHi() {
        return this.l + (int)((float)this.m / 2.0f + 0.5f);
    }

    public int getPosition(float f) {
        return this.l + (int)((float)this.m * f + 0.5f);
    }

    public boolean contains(int n) {
        return n >= this.l && n < this.l + this.m;
    }

    public int compareTo(Object object) {
        return this.c.compareTo(object);
    }

    public int estimateExternalRow(int n) {
        if (this.m > 0) {
            if (n < this.l) {
                return (n - this.l) / this.m - 1;
            }
            int n2 = this.getEnd();
            if (n >= n2) {
                return (n - n2) / this.m + 1;
            }
        }
        return 0;
    }

    public boolean isLeaf() {
        return this.e == null || this.e.length == 0;
    }

    public GridLineProvider getGridLineProvider() {
        return this.g;
    }

    public GridLine[] getGridLines() {
        if (this.f == null && this.g != null) {
            this.f = this.g.createGridLines(this.getGridRowsDeep());
        }
        return this.f;
    }

    public GridRow[] getGridRows() {
        return this.e;
    }

    public void setGridRows(GridRow[] gridRowArray, GridLineProvider gridLineProvider) {
        if (this.e != null) {
            GridUtil.registerRowListeners(this, this.e, false);
        }
        this.e = gridRowArray;
        this.g = gridLineProvider;
        GridLine[] gridLineArray = this.f = gridLineProvider != null ? gridLineProvider.createGridLines(this.getGridRowsDeep()) : null;
        if (this.e != null) {
            GridUtil.registerRowListeners(this, this.e, true);
        }
    }

    public int getGridRowCount() {
        return this.e != null ? this.e.length : 0;
    }

    public int getIndexOfGridRow(GridRow gridRow) {
        if (this.e != null) {
            for (int i = 0; i < this.e.length; ++i) {
                if (this.e[i] != gridRow) continue;
                return i;
            }
        }
        return -1;
    }

    public GridRow[] getGridRowsDeep() {
        if (this.e != null) {
            ArrayList arrayList = this.a(true, true, new ArrayList(32));
            return arrayList.toArray(new GridRow[arrayList.size()]);
        }
        return new GridRow[0];
    }

    private ArrayList a(boolean bl, boolean bl2, ArrayList arrayList) {
        if (this.e != null) {
            for (int i = 0; i < this.e.length; ++i) {
                GridRow gridRow = this.e[i];
                boolean bl3 = gridRow.isLeaf();
                if (bl3 && bl2 || !bl3 && bl) {
                    arrayList.add(gridRow);
                }
                if (bl3) continue;
                gridRow.a(bl, bl2, arrayList);
            }
        }
        return arrayList;
    }

    @Override
    public Object getProperty(PropertyKey propertyKey) {
        return this.a != null ? this.a.get(propertyKey) : null;
    }

    @Override
    public boolean containsProperty(PropertyKey propertyKey) {
        return this.a.containsKey(propertyKey);
    }

    public Object setProperty(PropertyKey propertyKey, Object object) {
        if (this.a == null) {
            this.a = new IdentityHashMap(4);
        }
        Object object2 = this.a.put(propertyKey, object);
        this.firePropertyChangeEvent(propertyKey.getName(), object2, object);
        return object2;
    }

    public Object removeProperty(PropertyKey propertyKey) {
        Object var2_2 = null;
        if (this.a != null) {
            var2_2 = this.a.remove(propertyKey);
            this.firePropertyChangeEvent(propertyKey.getName(), var2_2, null);
        }
        return var2_2;
    }

    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyListener(propertyChangeListener, false);
    }

    public void addPropertyListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        this.n.add(propertyChangeListener, bl);
    }

    public void removePropertyListener(PropertyChangeListener propertyChangeListener) {
        this.n.remove(propertyChangeListener);
    }

    public boolean isIgnorePropertyEvents() {
        return this.n.isIgnoreEvents();
    }

    public boolean setIgnorePropertyEvents(boolean bl) {
        return this.n.setIgnoreEvents(bl);
    }

    protected void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (!MigUtil.equals(object, object2)) {
            this.n.fireEvent(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.n.fireEvent(propertyChangeEvent);
    }

    public String toString() {
        return "GridRow: " + this.getName();
    }

    @Override
    public MutableDateRange getDateRangeClone() {
        return new DateRange(this.c);
    }

    @Override
    public DateRangeI getDateRangeForReading() {
        return this.c;
    }

    @Override
    public MutableDateRange getWritableDateRange() {
        throw new UnsupportedOperationException("GridRow can't return a mutable date range");
    }

    @Override
    public String getName() {
        return this.d != null ? this.d.getName() : (String)this.getProperty(NAME);
    }

    @Override
    public boolean accept(Object object) {
        return this.d == null || this.d.accept(object);
    }
}

