/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.grid.GridSegment;
import com.miginfocom.calendar.grid.GridUtil;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;

public class GridSegmentSpec
implements Serializable {
    private final transient GridSegment[] a;
    private final transient int b;
    private final transient int c;
    private final transient Integer d;
    private final transient Integer e;
    private final transient AtRefNumber[][] f;
    private static final long serialVersionUID = 1L;

    public GridSegmentSpec(int n) {
        this(null, n);
    }

    public GridSegmentSpec(int n, AtRefNumber atRefNumber) {
        this(new GridSegment[]{new GridSegment(n, null, atRefNumber, null)}, n);
    }

    public GridSegmentSpec(GridSegment gridSegment) {
        this(new GridSegment[]{gridSegment}, gridSegment.getCellCount());
    }

    public GridSegmentSpec(GridSegment[] gridSegmentArray, int n) {
        int n2;
        if (n == 0) {
            throw new IllegalArgumentException("cellCount is 0");
        }
        if (gridSegmentArray == null || gridSegmentArray.length == 0) {
            gridSegmentArray = new GridSegment[]{new GridSegment(n, null, null, null)};
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l = 0L;
        ArrayList<AtRefNumber[]> arrayList = new ArrayList<AtRefNumber[]>(gridSegmentArray.length + 1);
        ArrayList<GridSegment> arrayList2 = new ArrayList<GridSegment>(gridSegmentArray.length + 1);
        for (n2 = 0; n2 < gridSegmentArray.length; ++n2) {
            int n6;
            GridSegment gridSegment = gridSegmentArray[n2];
            if (gridSegment == null && n2 < gridSegmentArray.length - 1) continue;
            int n7 = n6 = gridSegment != null ? gridSegment.getCellCount() : 0;
            if (n6 + n3 > n || n2 == gridSegmentArray.length - 1 && n6 + n3 < n) {
                n6 = n - n3;
                gridSegment = gridSegment != null ? new GridSegment(n6, gridSegment.getMinCellSize(), gridSegment.getPreferredCellSize(), gridSegment.getMaxCellSize()) : new GridSegment(n6, null, null, null);
            }
            n3 += n6;
            n4 = (int)((long)n4 + (long)gridSegment.getMinCellSizeI() * (long)n6);
            l += (long)gridSegment.getMaxCellSizeI() * (long)n6;
            if (n5 != -1) {
                int n8 = gridSegment.getPreferredCellSizeI();
                n5 = n8 == -1 ? -1 : (n5 + n8) * n6;
            }
            arrayList2.add(gridSegment);
            arrayList.add(gridSegment.getSegmentSizes());
            if (n3 == n) break;
        }
        this.a = arrayList2.toArray(new GridSegment[arrayList2.size()]);
        this.f = new AtRefNumber[arrayList.size()][];
        for (n2 = 0; n2 < this.f.length; ++n2) {
            this.f[n2] = (AtRefNumber[])arrayList.get(n2);
        }
        this.b = n3;
        if (MigUtil.NEW_SIZE_CALCULATIONS) {
            Integer[] integerArray = GridUtil.getCellSizeBounds(this);
            this.c = integerArray[0];
            this.d = integerArray[1];
            this.e = integerArray[2];
        } else {
            this.c = n4;
            this.d = n5 != -1 ? new Integer(n5) : null;
            this.e = l >= 0x3FFFFFF5L ? null : new Integer((int)l);
        }
    }

    public int getCellCount() {
        return this.b;
    }

    public int getMinSize() {
        return this.c;
    }

    public Integer getPreferredSize() {
        return this.d;
    }

    public Integer getMaxSize() {
        return this.e;
    }

    public GridSegment[] getSegments() {
        return this.a;
    }

    public int getSegmentIndexForCell(int n) {
        int n2 = 0;
        for (int i = 0; i < this.a.length; ++i) {
            if (n >= (n2 += this.a[i].getCellCount())) continue;
            return i;
        }
        return this.a.length - 1;
    }

    public GridSegment getSegmentForCell(int n) {
        return this.a[this.getSegmentIndexForCell(n)];
    }

    public int getFirstCellIndex(GridSegment gridSegment) {
        int n = 0;
        for (int i = 0; i < this.a.length; ++i) {
            GridSegment gridSegment2 = this.a[i];
            if (gridSegment2 == gridSegment) {
                return n;
            }
            n += gridSegment2.getCellCount();
        }
        return -1;
    }

    public AtRefNumber[][] getSizes() {
        return this.f;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == GridSegmentSpec.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(GridSegmentSpec.class, new DefaultPersistenceDelegate(new String[]{"segments", "cellCount"}));
    }
}

