/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.grid;

import com.miginfocom.calendar.category.Category;
import com.miginfocom.calendar.category.CategoryFilter;
import com.miginfocom.calendar.grid.GridLine;
import com.miginfocom.calendar.grid.GridRow;
import com.miginfocom.calendar.grid.GridRowLayout;
import com.miginfocom.calendar.grid.GridSegment;
import com.miginfocom.calendar.grid.GridSegmentSpec;
import com.miginfocom.calendar.layout.Distributor;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.filter.Filter;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import java.beans.PropertyChangeListener;

public class GridUtil {
    public static void mergePositions(int n, GridRow[] gridRowArray, GridLine[] gridLineArray) {
        int n2 = n;
        for (int i = 0; i < gridRowArray.length; ++i) {
            GridLine gridLine = gridLineArray[i];
            GridRow gridRow = gridRowArray[i];
            gridLine.setPosition(n2);
            gridRow.setStart(n2 += gridLine.getSize());
            n2 += gridRow.getSize();
        }
        gridLineArray[gridRowArray.length].setPosition(n2);
    }

    public static GridRow getGridRow(int n, GridRow[] gridRowArray, int n2) {
        for (int i = gridRowArray.length - 1; i >= 0; --i) {
            GridRow gridRow;
            GridRow gridRow2 = gridRowArray[i];
            if (gridRow2.getGridRowCount() > 0 && n2 > 0 && (gridRow = GridUtil.getGridRow(n, gridRow2.getGridRows(), n2 - 1)) != null) {
                return gridRow;
            }
            if (!gridRow2.contains(n)) continue;
            return gridRow2;
        }
        return null;
    }

    public static GridRow getGridRowWithCategory(Object object, GridRow gridRow) {
        GridRow[] gridRowArray = gridRow.getGridRowsDeep();
        for (int i = 0; i <= gridRowArray.length; ++i) {
            GridRow gridRow2 = i < gridRowArray.length ? gridRowArray[i] : gridRow;
            Filter filter = gridRow2.getFilter();
            if (!(filter instanceof CategoryFilter)) continue;
            Category[] categoryArray = ((CategoryFilter)filter).getCategories();
            for (int j = 0; j < categoryArray.length; ++j) {
                if (!object.equals(categoryArray[j].getId())) continue;
                return gridRow2;
            }
        }
        return null;
    }

    public static Integer[] getCellSizeBounds(GridSegmentSpec gridSegmentSpec) {
        GridSegment[] gridSegmentArray = gridSegmentSpec.getSegments();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < gridSegmentArray.length; ++i) {
            GridSegment gridSegment = gridSegmentArray[i];
            for (int j = 0; j < gridSegment.getCellCount(); ++j) {
                AtNumber atNumber = gridSegment.getMinCellSize();
                AtRefNumber atRefNumber = gridSegment.getPreferredCellSize();
                AtNumber atNumber2 = gridSegment.getMaxCellSize();
                if (atNumber != null) {
                    n += gridSegment.getMinCellSizeI();
                }
                if (atRefNumber != null) {
                    n2 += gridSegment.getPreferredCellSizeI();
                    bl = true;
                }
                if (n3 >= 0x3FFFFFF5) continue;
                if (atNumber2 == null) {
                    n3 = 0x3FFFFFF5;
                    continue;
                }
                n3 += gridSegment.getMaxCellSizeI();
                bl2 = true;
            }
        }
        Integer[] integerArray = new Integer[]{new Integer(n), bl ? new Integer(Math.max(n, n2)) : null, bl2 ? new Integer(Math.min(0x3FFFFFF5, n3)) : null};
        return integerArray;
    }

    public static int[] getCellSizes(GridRow[] gridRowArray, GridRowLayout gridRowLayout, GridSegmentSpec gridSegmentSpec, int n, boolean bl) {
        if (MigUtil.NEW_SIZE_CALCULATIONS) {
            if (gridRowArray.length != gridSegmentSpec.getCellCount()) {
                throw new IllegalArgumentException("Row count and cell count in spec not same! rowCount: " + gridRowArray.length + ", cellCount: " + gridSegmentSpec.getCellCount());
            }
            int[] nArray = new int[gridSegmentSpec.getCellCount()];
            AtRefNumber[][] atRefNumberArray = new AtRefNumber[nArray.length][];
            GridSegment[] gridSegmentArray = gridSegmentSpec.getSegments();
            int n2 = 0;
            for (int i = 0; i < gridSegmentArray.length; ++i) {
                GridSegment gridSegment = gridSegmentArray[i];
                int n3 = 0;
                while (n3 < gridSegment.getCellCount()) {
                    atRefNumberArray[n2] = new AtRefNumber[]{gridSegment.getMinCellSize(), gridSegment.getPreferredCellSize(), gridSegment.getMaxCellSize()};
                    Integer[] integerArray = gridRowLayout.getSizes(gridRowArray[n2]);
                    for (int j = 0; j < 3; ++j) {
                        if (atRefNumberArray[n2][j] != null || integerArray[j] == null) continue;
                        atRefNumberArray[n2][j] = new AtFixed(integerArray[j].intValue());
                    }
                    ++n3;
                    ++n2;
                }
            }
            float[] fArray = Distributor.distribute(atRefNumberArray, n, bl);
            int[] nArray2 = Distributor.roundSizes(fArray);
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[i] = nArray2[i];
            }
            return nArray;
        }
        if (gridRowArray.length != gridSegmentSpec.getCellCount()) {
            throw new IllegalArgumentException("Row count and cell count in spec not same! rowCount: " + gridRowArray.length + ", cellCount: " + gridSegmentSpec.getCellCount());
        }
        int[] nArray = new int[gridSegmentSpec.getCellCount()];
        AtRefNumber[][] atRefNumberArray = gridSegmentSpec.getSizes();
        float[] fArray = Distributor.distribute(atRefNumberArray, n, bl);
        int[] nArray3 = Distributor.roundSizes(fArray);
        GridSegment[] gridSegmentArray = gridSegmentSpec.getSegments();
        int n4 = 0;
        for (int i = 0; i < nArray3.length; ++i) {
            int n5;
            Object[] objectArray;
            GridSegment gridSegment = gridSegmentArray[i];
            AtRefNumber[][] atRefNumberArray2 = new AtRefNumber[gridSegment.getCellCount()][];
            for (int j = 0; j < atRefNumberArray2.length; ++j) {
                atRefNumberArray2[j] = gridRowArray[j + n4].getSizes();
                objectArray = gridRowLayout.getSizes(gridRowArray[j]);
                for (n5 = 0; n5 < 3; ++n5) {
                    if (atRefNumberArray2[j][n5] != null || objectArray[n5] == null) continue;
                    atRefNumberArray2[j][n5] = new AtFixed(objectArray[n5].intValue());
                }
            }
            float[] fArray2 = Distributor.distribute(atRefNumberArray2, nArray3[i], true);
            objectArray = Distributor.roundSizes(fArray2);
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                nArray[n4++] = objectArray[n5];
            }
        }
        return nArray;
    }

    public static Integer getGridRowIndex(int n, GridRow[] gridRowArray, boolean bl) {
        if (gridRowArray.length == 0) {
            return null;
        }
        if (n < gridRowArray[0].getStart()) {
            return bl ? new Integer(0) : null;
        }
        if (n >= gridRowArray[gridRowArray.length - 1].getEnd()) {
            return bl ? new Integer(gridRowArray.length - 1) : null;
        }
        for (int i = 0; i < gridRowArray.length; ++i) {
            if (n > gridRowArray[i].getEnd()) continue;
            return new Integer(i);
        }
        return new Integer(gridRowArray.length - 1);
    }

    public static void registerRowListeners(PropertyChangeListener propertyChangeListener, GridRow[] gridRowArray, boolean bl) {
        if (bl) {
            for (int i = 0; i < gridRowArray.length; ++i) {
                gridRowArray[i].addPropertyListener(propertyChangeListener, false);
            }
        } else {
            for (int i = 0; i < gridRowArray.length; ++i) {
                gridRowArray[i].removePropertyListener(propertyChangeListener);
            }
        }
    }
}

