/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.header;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.ImmutableDateRange;

public class DateCellRange {
    private final int a;
    private final int b;
    private final int c;
    private DateCellRange d;
    private final ImmutableDateRange e;

    public DateCellRange(int n, int n2, int n3, ImmutableDateRange immutableDateRange) {
        if (n > n2) {
            throw new IllegalArgumentException("sCol > eCol! sCol:" + n + "  eCol:" + n2);
        }
        this.a = n;
        this.b = n2;
        this.c = n3;
        this.e = immutableDateRange;
    }

    public ImmutableDateRange getUnionDateRange() {
        if (this.d == null) {
            return this.e;
        }
        return new ImmutableDateRange((DateRangeI)this.e, this.d.getUnionDateRange());
    }

    public boolean setTempUnion(DateCellRange dateCellRange) {
        if (dateCellRange.d != null) {
            throw new IllegalArgumentException("tempRange can't have temp range itself.");
        }
        if (MigUtil.equals(this.d, dateCellRange)) {
            return false;
        }
        this.d = dateCellRange;
        return true;
    }

    public DateCellRange getFullDateRange() {
        return new DateCellRange(this.getStart(true), this.getEnd(true), this.c, this.getUnionDateRange());
    }

    public boolean overlaps(DateCellRange dateCellRange, boolean bl) {
        if (dateCellRange.c != this.c) {
            return false;
        }
        return this.getStart(bl) <= dateCellRange.b && this.getEnd(bl) >= dateCellRange.a;
    }

    public int getLength(boolean bl) {
        return this.getEnd(bl) - this.getStart(bl) + 1;
    }

    public int getStart(boolean bl) {
        return !bl || this.d == null || this.a < this.d.a ? this.a : this.d.a;
    }

    public int getEnd(boolean bl) {
        return !bl || this.d == null || this.b > this.d.b ? this.b : this.d.b;
    }

    public int getRowCol() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateCellRange)) {
            return false;
        }
        DateCellRange dateCellRange = (DateCellRange)object;
        return dateCellRange.a == this.a && dateCellRange.b == this.b && dateCellRange.c == this.c;
    }

    public DateCellRange cloneRange() {
        DateCellRange dateCellRange = new DateCellRange(this.a, this.b, this.c, this.e);
        if (this.d != null) {
            dateCellRange.d = this.d.cloneRange();
        }
        return dateCellRange;
    }

    public String toString() {
        return "start: " + this.a + ", end: " + this.b + ", on row/col: " + this.c + "\nTemp == [" + this.d + "]";
    }
}

