/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.header;

import com.miginfocom.calendar.datearea.DateArea;
import com.miginfocom.calendar.grid.DateGrid;
import com.miginfocom.calendar.grid.DefaultGridDimensionLayout;
import com.miginfocom.calendar.grid.GridDimensionLayout;
import com.miginfocom.calendar.grid.GridLineSpecification;
import com.miginfocom.calendar.grid.GridSegment;
import com.miginfocom.calendar.grid.GridSegmentSpec;
import com.miginfocom.calendar.grid.TrackingGridDimensionLayout;
import com.miginfocom.calendar.header.AbstractGridHeader;
import com.miginfocom.calendar.header.DateCellRange;
import com.miginfocom.calendar.header.DateHeaderGrid;
import com.miginfocom.calendar.header.HeaderGrid;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateChangeEvent;
import com.miginfocom.util.dates.DateChangeListener;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class DateGridHeader
extends AbstractGridHeader
implements MouseListener,
MouseMotionListener {
    public static final int DEFAULT_ROW_SIZE = 15;
    public static final AtFixed DEF_FIXED = new AtFixed(15.0f);
    protected AtRefNumber[] sizes;
    protected int[] rangeTypes;
    protected transient DateGrid trackedGrid = null;
    protected GridLineSpecification gridLineSpec;
    private DateHeaderGrid a = null;
    private boolean b = false;
    private final transient ListenerSet c = new ListenerSet(DateChangeListener.class);
    private ImmutableDateRange d = null;
    private DateCellRange e = null;
    private DateCellRange f = null;

    public DateGridHeader(DateArea dateArea, int n, Paint paint, int n2, AtRefNumber atRefNumber, int n3) {
        this(dateArea, new GridLineSpecification(n, paint), new int[]{n2}, new AtRefNumber[]{atRefNumber}, n3);
    }

    public DateGridHeader(DateArea dateArea, int n, Paint paint, int[] nArray, AtRefNumber[] atRefNumberArray, int n2) {
        this(dateArea, new GridLineSpecification(n, paint), nArray, atRefNumberArray, n2);
    }

    public DateGridHeader(DateArea dateArea, GridLineSpecification gridLineSpecification, int[] nArray, AtRefNumber[] atRefNumberArray, int n) {
        super(dateArea, dateArea.getComponent(), n);
        this.gridLineSpec = gridLineSpecification;
        this.sizes = atRefNumberArray;
        this.rangeTypes = nArray;
        this.setCacheWithBackBuffer(true);
    }

    @Override
    public void dispose() {
    }

    public DateArea getTrackedDateArea() {
        return (DateArea)((Object)this.getTrackedComponent());
    }

    public boolean isMouseOverEffectsEnabled() {
        return this.b;
    }

    public void setMouseOverEffectsEnabled(boolean bl) {
        if (bl == this.b) {
            return;
        }
        if (bl) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        this.b = bl;
    }

    public void setGridLineSpecification(GridLineSpecification gridLineSpecification) {
        this.gridLineSpec = gridLineSpecification;
        this.revalidateGrid();
    }

    public void setRangeTypes(int[] nArray) {
        this.rangeTypes = nArray;
        this.revalidateGrid();
    }

    public void setSizes(AtRefNumber[] atRefNumberArray) {
        this.sizes = atRefNumberArray;
        this.revalidateGrid();
    }

    @Override
    public HeaderGrid getHeaderGrid() {
        return this.getDateHeaderGrid();
    }

    public DateHeaderGrid getDateHeaderGrid() {
        this.checkGrid();
        return this.a;
    }

    public void revalidateGrid() {
        this.a = null;
        this.revalidate();
    }

    protected void checkGrid() {
        DateGrid dateGrid = ((DateArea)((Object)this.getTrackedComponent())).getDateGrid();
        if (this.a == null || this.trackedGrid != dateGrid) {
            Object object;
            int n;
            this.trackedGrid = dateGrid;
            GridSegment[] gridSegmentArray = new GridSegment[this.rangeTypes.length];
            for (n = 0; n < gridSegmentArray.length; ++n) {
                object = this.sizes != null ? (this.sizes.length > n ? this.sizes[n] : DEF_FIXED) : null;
                gridSegmentArray[n] = new GridSegment(1, null, (AtRefNumber)object, null);
            }
            n = this.getPrimaryDimension() == this.trackedGrid.getPrimaryDimension() ? 0 : 1;
            object = new TrackingGridDimensionLayout(0, n, this.trackedGrid, this, this.getTrackedComponent());
            DefaultGridDimensionLayout defaultGridDimensionLayout = new DefaultGridDimensionLayout(1, new GridSegmentSpec(gridSegmentArray, this.rangeTypes.length), true);
            this.a = new DateHeaderGrid(this.trackedGrid, this.getPrimaryDimension(), this.rangeTypes, this.gridLineSpec);
            this.a.setPrimaryDimensionLayout((GridDimensionLayout)object);
            this.a.setSecondaryDimensionLayout(defaultGridDimensionLayout);
            this.setGridBoundsAndLayout(this.a);
            this.clearBackBuffer();
            this.fireStructureChanged("gridStructure", null, null);
        }
    }

    public DateCellRange getCellRange(int n, int n2, boolean bl) {
        DateHeaderGrid dateHeaderGrid = (DateHeaderGrid)this.getHeaderGrid();
        Integer n3 = dateHeaderGrid.getRowForY(n2, bl);
        Integer n4 = dateHeaderGrid.getColumnForX(n, bl);
        if (!(bl || n4 != null && n3 != null)) {
            return null;
        }
        return dateHeaderGrid.getMergeRange(n3, n4, this.isBeforeGrid());
    }

    public void addDateChangeListener(DateChangeListener dateChangeListener) {
        this.addDateChangeListener(dateChangeListener, false);
    }

    public void addDateChangeListener(DateChangeListener dateChangeListener, boolean bl) {
        this.c.add(dateChangeListener, bl);
    }

    public void removeDateChangeListener(DateChangeListener dateChangeListener) {
        this.c.remove(dateChangeListener);
    }

    protected void fireDateChangeEvent(DateChangeEvent dateChangeEvent) {
        this.c.fireEvent(dateChangeEvent);
    }

    public DateCellRange getMouseOverRange() {
        return this.e;
    }

    public DateCellRange getPressedRange() {
        return this.f;
    }

    public ImmutableDateRange getSelectedDateRange() {
        return this.d;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.f != null && this.f.setTempUnion(this.getCellRange(mouseEvent.getX(), mouseEvent.getY(), true))) {
            this.clearBackBuffer();
            this.fireDateChangeEvent(new DateChangeEvent(this, null, this.f.getUnionDateRange(), 1));
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        DateCellRange dateCellRange = this.getCellRange(mouseEvent.getX(), mouseEvent.getY(), false);
        if (MigUtil.equals(dateCellRange, this.e)) {
            return;
        }
        this.clearBackBuffer();
        this.e = dateCellRange;
        this.fireDateChangeEvent(new DateChangeEvent(this, null, dateCellRange != null ? dateCellRange.getUnionDateRange() : null, 0));
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        this.clearBackBuffer();
        this.e = null;
        this.fireDateChangeEvent(new DateChangeEvent(this, null, null, 0));
        this.f = this.getCellRange(mouseEvent.getX(), mouseEvent.getY(), false);
        if (this.f != null) {
            this.fireDateChangeEvent(new DateChangeEvent(this, null, this.f.getUnionDateRange(), 1));
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.f == null) {
            return;
        }
        this.clearBackBuffer();
        this.d = this.a.getCellDateRange(this.f, true, this.isBeforeGrid());
        this.f = null;
        this.fireDateChangeEvent(new DateChangeEvent(this, null, null, 1));
        this.fireDateChangeEvent(new DateChangeEvent(this, null, this.d, 2));
        this.mouseMoved(mouseEvent);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.clearBackBuffer();
        this.e = null;
        this.fireDateChangeEvent(new DateChangeEvent(this, null, null, 0));
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

