/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.calendar.theme;

import com.miginfocom.calendar.grid.GridLineRepetition;
import com.miginfocom.calendar.grid.GridSegment;
import com.miginfocom.calendar.header.CellDecorationRow;
import com.miginfocom.calendar.layout.ActivityLayout;
import com.miginfocom.calendar.layout.ActivityLayoutBroker;
import com.miginfocom.calendar.layout.FlexGridLayout;
import com.miginfocom.calendar.layout.HideLayout;
import com.miginfocom.calendar.layout.TimeBoundsLayout;
import com.miginfocom.theme.PropertyCapability;
import com.miginfocom.theme.Theme;
import com.miginfocom.theme.ThemeKeyLink;
import com.miginfocom.theme.Themes;
import com.miginfocom.util.KeySequence;
import com.miginfocom.util.NameValuePair;
import com.miginfocom.util.dates.DateFormatList;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.DateUtil;
import com.miginfocom.util.dates.MutableDateRange;
import com.miginfocom.util.gfx.UIColor;
import com.miginfocom.util.gfx.XtdImage;
import com.miginfocom.util.gfx.XtdTexturePaint;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.numbers.AtEnd;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarTheme
extends Theme {
    protected static final PropertyCapability CAP_KEY_SEQUENCE = new PropertyCapability(KeySequence.class);
    protected static final PropertyCapability CAP_XTD_IMAGE = new PropertyCapability(XtdImage.class);
    protected static final PropertyCapability CAP_DATE_FORMAT_LIST = new PropertyCapability(DateFormatList.class);
    protected static final PropertyCapability CAP_XTD_TEXTURE_PAINT = new PropertyCapability(XtdTexturePaint.class);
    protected static final PropertyCapability CAP_GRID_SEGMENT = new PropertyCapability(GridSegment.class);
    protected static final PropertyCapability CAP_GRID_LINE_REP = new PropertyCapability(GridLineRepetition.class);
    protected static final PropertyCapability CAP_CELL_DECORATION_ROW = new PropertyCapability(CellDecorationRow.class);
    protected static final PropertyCapability CAP_ABS_RECT = new PropertyCapability(AbsRect.class);
    protected static final PropertyCapability CAP_UI_COLOR = new PropertyCapability(UIColor.class);
    protected static final PropertyCapability[] CAP_PAINT_ALL = new PropertyCapability[]{CAP_NULL, CAP_UI_COLOR, CAP_COLOR, CAP_XTD_TEXTURE_PAINT, CAP_PAINT};
    private static final NameValuePair[] a = new NameValuePair[]{new NameValuePair<Integer>("Year", new Integer(1)), new NameValuePair<Integer>("Month", new Integer(2)), new NameValuePair<Integer>("Week", new Integer(3)), new NameValuePair<Integer>("Day", new Integer(6)), new NameValuePair<Integer>("Hour", new Integer(11)), new NameValuePair<Integer>("Minute", new Integer(12)), new NameValuePair<Integer>("Second", new Integer(13)), new NameValuePair<Integer>("Millisecond", new Integer(14))};
    protected static final NameValuePair[] WRAP_TYPE_DATE_RANGES = new NameValuePair[]{DateRangeI.MINUTE_NVP, DateRangeI.HOUR_NVP, DateRangeI.DAY_NVP, DateRangeI.WEEK_NVP};
    protected static final NameValuePair[] CAP_REF_RANGE_NUMBER_CLASSES = new NameValuePair[]{new NameValuePair<Class<AtStart>>("Start", AtStart.class), new NameValuePair<Class<AtFraction>>("Fraction", AtFraction.class), new NameValuePair<Class<AtEnd>>("End", AtEnd.class)};
    protected static final PropertyCapability CAP_REF_RANGE_NUMBER = new PropertyCapability(AtRefRangeNumber.class, CAP_REF_RANGE_NUMBER_CLASSES);
    protected static final NameValuePair[] CAP_REF_NUMBER_CLASSES = new NameValuePair[]{new NameValuePair<Class<AtFixed>>("Fixed", AtFixed.class), new NameValuePair<Class<AtFraction>>("Fraction", AtFraction.class)};
    protected static final PropertyCapability CAP_REF_NUMBER = new PropertyCapability(AtRefNumber.class, CAP_REF_NUMBER_CLASSES);
    public static final String KEY_NAME = "Name";
    public static final String KEY_GENERIC_prefix = "Generic/";
    public static final String KEY_GENERIC_AUTO_RELOAD_FROM_THEME = "Generic/autoReloadFromTheme";
    public static final String KEY_GENERIC_BACKGROUND = "Generic/background";
    public static final String KEY_GENERIC_MINIMAL_DAYS_IN_FIRST_WEEK = "Generic/minimalDaysInFirstWeek";
    public static final String KEY_GENERIC_LOCALE = "Generic/locale";
    public static final String KEY_GENERIC_TIME_ZONE = "Generic/timeZone";
    public static final String KEY_GENERIC_CRYPTO_KEY = "Generic/cryptoKey";
    public static final String KEY_GENERIC_INFO_AUTHOR = "Generic/Info/author";
    public static final String KEY_GENERIC_INFO_THEME = "Generic/Info/theme";
    public static final String KEY_GENERIC_INFO_VERSION = "Generic/Info/version";
    public static final String KEY_GENERIC_INFO_DATE = "Generic/Info/date";
    public static final String KEY_GENERIC_CELL_REPAINT_PADDING = "Generic/cellRepaintPadding";
    public static final String KEY_GENERIC_DEBUG_REPAINT_ALL = "Generic/Debug/repaintAll";
    public static final String KEY_GENERIC_DEBUG_OUTLINE_CLIP_BOUNDS_DEBUG = "Generic/Debug/outlineClipBounds";
    public static final String KEY_GENERIC_ACTIVITIES_SUPPORTED = "Generic/activitiesSupported";
    public static final String KEY_STARTUP_PRIMARY_DIM_DIRECTION = "Startup/PrimaryDim/direction";
    public static final String KEY_STARTUP_PRIMARY_DIM_CELL_TYPE = "Startup/PrimaryDim/cellType";
    public static final String KEY_STARTUP_PRIMARY_DIM_TYPE_COUNT = "Startup/PrimaryDim/typeCount";
    public static final String KEY_STARTUP_SECONDARY_DIM_WRAP_BOUNDARY = "Startup/SecondaryDim/wrapBoundary";
    public static final String KEY_STARTUP_SECONDARY_DIM_WRAP_BOUNDARY_COUNT = "Startup/SecondaryDim/wrapBoundaryCount";
    public static final String KEY_STARTUP_VISUAL_RANGE_TYPE = "Startup/VisualRange/rangeType";
    public static final String KEY_STARTUP_VISUAL_RANGE_COUNT = "Startup/VisualRange/count";
    public static final String KEY_STARTUP_VISUAL_RANGE_ALIGN = "Startup/VisualRange/align";
    public static final String KEY_FEEL_prefix = "Feel/";
    public static final String KEY_FEEL_SELECTION_SHOW_SELECTED_WHEN_SELECTING = "Feel/Selection/showSelectedWhenSelecting";
    public static final String KEY_FEEL_SELECTION_HIDE_WHEN_NOT_EXACT_CELL_DATE_RANGE = "Feel/Selection/hideWhenNotExactCellDateRange";
    public static final String KEY_FEEL_SELECTION_TYPE_KEY = "Feel/Selection/type";
    public static final String KEY_FEEL_SELECTION_EXPAND_RANGE_KEY = "Feel/Selection/expandRangeKey";
    public static final String KEY_FEEL_SELECTION_SELECT_RANGE_KEY = "Feel/Selection/selectRangeKey";
    public static final String KEY_FEEL_SELECTION_BOUNDARY = "Feel/Selection/boundary";
    public static final String KEY_FEEL_SELECTION_MIN_COUNT = "Feel/Selection/minCount";
    public static final String KEY_FEEL_SELECTION_MAX_COUNT = "Feel/Selection/maxCount";
    public static final String KEY_FEEL_SELECTION_CUT_ALIGNMENT = "Feel/Selection/cutAlignment";
    public static final String KEY_FEEL_ACTIVITY_MULTI_SELECT_KEY = "Feel/Activity/multiSelectKey";
    public static final String KEY_FEEL_ACTIVITY_MULTI_SELECT_LIVE = "Feel/Activity/multiSelectLive";
    public static final String KEY_FEEL_ACTIVITY_SNAP_TO_MILLIS = "Feel/Activity/snapToMillis";
    public static final String KEY_FEEL_ACTIVITY_FALLBACK_SNAP_TO_MILLIS = "Feel/Activity/fallbackSnapToMillis";
    public static final String KEY_FEEL_ACTIVITY_NO_SNAP_KEY = "Feel/Activity/noSnapKey";
    public static final String KEY_FEEL_ACTIVITY_ORDER_ = "Feel/Activity/Order/";
    public static final String KEY_DECORATORS_prefix = "Decorators/";
    public static final String KEY_DECORATORS_IMAGE_IMAGE = "Decorators/Image/image";
    public static final String KEY_DECORATORS_IMAGE_BOUNDS = "Decorators/Image/bounds";
    public static final String KEY_DECORATORS_IMAGE_REPEAT = "Decorators/Image/repeat";
    public static final String KEY_DECORATORS_IMAGE_INSTALL_IN_LAYER = "Decorators/Image/installInLayer";
    public static final String KEY_DECORATORS_DIVIDERS_FOREGROUND = "Decorators/Dividers/foreground";
    public static final String KEY_DECORATORS_DIVIDERS_RANGE_TYPE = "Decorators/Dividers/rangeType";
    public static final String KEY_DECORATORS_DIVIDERS_MAX_PAINT_WIDTH = "Decorators/Dividers/maxPaintWidth";
    public static final String KEY_DECORATORS_DIVIDERS_INSTALL_IN_LAYER = "Decorators/Dividers/installInLayer";
    public static final String KEY_DECORATORS_SELECTION_prefix = "Decorators/Selection/";
    public static final String KEY_DECORATORS_SELECTION_STROKE_ = "Decorators/Selection/Stroke/";
    public static final String KEY_DECORATORS_SELECTION_STROKE_PAINT_ = "Decorators/Selection/StrokePaint/";
    public static final String KEY_DECORATORS_SELECTION_PAINT_ = "Decorators/Selection/Paint/";
    public static final String KEY_DECORATORS_SELECTION_INSTALL_IN_LAYER = "Decorators/Selection/installInLayer";
    public static final String KEY_DECORATORS_GRIDLINES_MAX_PAINT_WIDTH = "Decorators/GridLines/maxPaintWidth";
    public static final String KEY_DECORATORS_GRIDLINES_INSTALL_IN_LAYER = "Decorators/GridLines/installInLayer";
    public static final String KEY_DECORATORS_ACTIVITY_VIEWS_INSTALL_IN_LAYER = "Decorators/ActivityViews/installInLayer";
    public static final String KEY_DECORATORS_MULTI_SELECT_RECTANGLE_INSTALL_IN_LAYER = "Decorators/MultiSelectRectangleDecorator/installInLayer";
    public static final String KEY_DECORATORS_CELL_LABEL_prefix = "Decorators/CellLabel/";
    public static final String KEY_DECORATORS_CELL_LABEL_BACKGROUND_ = "Decorators/CellLabel/Background/";
    public static final String KEY_DECORATORS_CELL_LABEL_BACKGROUND_DEFAULT = "Decorators/CellLabel/Background/default";
    public static final String KEY_DECORATORS_CELL_LABEL_FOREGROUND_ = "Decorators/CellLabel/Foreground/";
    public static final String KEY_DECORATORS_CELL_LABEL_FOREGROUND_DEFAULT = "Decorators/CellLabel/Foreground/default";
    public static final String KEY_DECORATORS_CELL_LABEL_FONT_ = "Decorators/CellLabel/Font/";
    public static final String KEY_DECORATORS_CELL_LABEL_FONT_DEFAULT = "Decorators/CellLabel/Font/default";
    public static final String KEY_DECORATORS_CELL_LABEL_UNDERLINE_ = "Decorators/CellLabel/Underline/";
    public static final String KEY_DECORATORS_CELL_LABEL_UNDERLINE_DEFAULT = "Decorators/CellLabel/Underline/default";
    public static final String KEY_DECORATORS_CELL_LABEL_DATE_FORMAT_ = "Decorators/CellLabel/DateFormat/";
    public static final String KEY_DECORATORS_CELL_LABEL_DATE_FORMAT_DEFAULT = "Decorators/CellLabel/DateFormat/default";
    public static final String KEY_DECORATORS_CELL_LABEL_TEXT_ALIGNMENT_ = "Decorators/CellLabel/TextAlignment/";
    public static final String KEY_DECORATORS_CELL_LABEL_ANTI_ALIAS = "Decorators/CellLabel/antiAlias";
    public static final String KEY_DECORATORS_CELL_LABEL_BOUNDS = "Decorators/CellLabel/bounds";
    public static final String KEY_DECORATORS_CELL_LABEL_INSTALL_IN_LAYER = "Decorators/CellLabel/installInLayer";
    public static final String KEY_DECORATORS_OCCUPIED_prefix = "Decorators/Occupied/";
    public static final String KEY_DECORATORS_OCCUPIED_ROUND_TO_RANGE = "Decorators/Occupied/roundToRange";
    public static final String KEY_DECORATORS_OCCUPIED_FILL = "Decorators/Occupied/fill";
    public static final String KEY_DECORATORS_OCCUPIED_NOT_FILL = "Decorators/Occupied/notFill";
    public static final String KEY_DECORATORS_OCCUPIED_OUTLINE = "Decorators/Occupied/outline";
    public static final String KEY_DECORATORS_OCCUPIED_BOUNDS = "Decorators/Occupied/bounds";
    public static final String KEY_DECORATORS_OCCUPIED_MERGE_OVERLAPPING = "Decorators/Occupied/mergeOverlapping";
    public static final String KEY_DECORATORS_OCCUPIED_INSTALL_IN_LAYER = "Decorators/Occupied/installInLayer";
    public static final String KEY_DECORATORS_NO_FIT_INSTALL_IN_LAYER = "Decorators/NoFit/installInLayer";
    public static final String KEY_DECORATORS_EVEN_FILL_RANGE_TYPE = "Decorators/EvenFill/rangeType";
    public static final String KEY_DECORATORS_EVEN_FILL_PAINT = "Decorators/EvenFill/paint";
    public static final String KEY_DECORATORS_EVEN_FILL_INSTALL_IN_LAYER = "Decorators/EvenFill/installInLayer";
    public static final String KEY_GRID_prefix = "Grid/";
    public static final String KEY_GRID_GRIDLINES_ = "Grid/GridLines/";
    public static final String KEY_GRID_SEGMENTS_ = "Grid/Segments/";
    public static final String KEY_GRID_EXPAND_PRIMARY_DIM = "Grid/Segments/expandPrimaryDim";
    public static final String KEY_GRID_EXPAND_SECONDARY_DIM = "Grid/Segments/expandSecondaryDim";
    public static final String KEY_HEADER_prefix = "Headers/";
    public static final String KEY_HEADER_ = "Headers/";
    public static final String KEY_HEADER_CORNERS_ = "Headers/Corners/";
    public static final String KEY_COMBO_prefix = "Combo/";
    public static final String KEY_COMBO_DATEFORMAT_ = "Combo/DateFormat/";
    public static final String KEY_COMBO_DATEFORMAT_DEFAULT_TIME_STYLE = "Combo/DateFormat/defaultTimeStyle";
    public static final String KEY_COMBO_DATEFORMAT_DEFAULT_DATE_STYLE = "Combo/DateFormat/defaultDateStyle";
    public static final String KEY_COMBO_CUSTOM_PREFIX_ = "Combo/DateFormat/CustomPrefix/";
    public static final String KEY_COMBO_BUTTONS_SHOW_ARROWS = "Combo/Buttons/showArrows";
    public static final String KEY_COMBO_BUTTONS_SHOW_HOME = "Combo/Buttons/showHome";
    public static final String KEY_COMBO_BUTTONS_BORDER = "Combo/Buttons/border";
    public static final String KEY_COMBO_BUTTONS_CONTENT_AREA_FILLED = "Combo/Buttons/contentAreaFilled";
    public static final String KEY_COMBO_BUTTONS_OPAQE = "Combo/Buttons/opaqe";
    public static final String KEY_COMBO_BUTTONS_OPAQUE = "Combo/Buttons/opaque";
    public static final String KEY_COMBO_BUTTONS_DIVIDER_WIDTH = "Combo/Buttons/dividerWidth";
    public static final String KEY_COMBO_BUTTONS_DIVIDER_COLOR = "Combo/Buttons/dividerColor";
    public static final String KEY_COMBO_BUTTONS_ARROW_COLOR = "Combo/Buttons/arrowColor";
    public static final String KEY_COMBO_BUTTONS_ARROW_SHADOW_COLOR = "Combo/Buttons/arrowShadowColor";
    public static final String KEY_COMBO_BUTTONS_BIG_INSETS = "Combo/Buttons/bigInsets";
    public static final String KEY_COMBO_BUTTONS_SMALL_INSETS = "Combo/Buttons/smallInsets";
    public static final String KEY_COMBO_BUTTONS_DROP_ARROW_SIZE = "Combo/Buttons/dropArrowSize";
    public static final String KEY_COMBO_BUTTONS_LEFT_RIGHT_ARROW_SIZE = "Combo/Buttons/leftRightArrowSize";
    public static final String KEY_COMBO_BUTTONS_HOME_ARROW_SIZE = "Combo/Buttons/homeArrowSize";
    public static final String KEY_COMBO_BUTTONS_HOME_ARROW_GAP = "Combo/Buttons/homeArrowGap";
    public static final String KEY_COMBO_POPUP_SIZE_ = "Combo/Popup/Size/";
    public static final String KEY_COMBO_POPUP_BORDER = "Combo/Popup/border";
    public static final String KEY_COMBO_EDITOR_BORDER = "Combo/Editor/border";
    public static final String KEY_COMBO_EDITOR_FONT = "Combo/Editor/font";
    public static final String KEY_COMBO_EDITOR_ANTI_ALIAS = "Combo/Editor/antiAlias";
    public static final String KEY_COMBO_EDITOR_PARSE_LENIENT = "Combo/Editor/parseLenient";
    public static final String KEY_COMBO_EDITOR_FOREGROUND = "Combo/Editor/foreground";
    public static final String KEY_COMBO_EDITOR_HIDE_END_DATE = "Combo/Editor/hideEndDate";
    public static final String KEY_COMBO_BORDER = "Combo/border";
    public static final String KEY_COMBO_NO_DATE_TEXT = "Combo/noDateText";
    public static final String KEY_COMBO_ADD_FIELD = "Combo/addField";
    public static final String KEY_COMBO_ADD_AMOUNT = "Combo/addAmount";
    public static final String KEY_COMBO_CUSTOM_RANGE_ADD_FIELD = "Combo/customRangeAddField";
    public static final String KEY_COMBO_CUSTOM_RANGE_MIN_TYPE = "Combo/customRangeMinType";
    public static final String KEY_LAYOUTS_prefix = "Layouts/";
    public static final String KEY_LAYOUTS_BROKER = "Layouts/layoutBroker";
    public static final String KEY_LAYOUTS_AUTO_INSTALL = "Layouts/AutoInstall#";
    public static final String[] ALL_SEL_SUB_KEYS;
    public static final String[] X_Y_SUB_KEYS;
    public static final String[] ORDER_MAIN_KEYS;
    public static final String[] WEEK_DAYS_SUB_KEYS;
    public static final String[] M_P_M_SUB_KEYS;
    public static final String[] LABEL_TYPE_SUB_FOLDER_KEYS;
    public static final String[] N_W_S_E_SUB_FOLDER_KEYS;
    public static final String[] CORNER_SUB_FOLDER_KEYS;
    public static final String[] SEGMENT_SUB_LIST_KEYS;
    public static final String[] GRIDLINE_DIM_SUB_LIST_KEYS;
    public static final String[][] CORNER_EXPAND_SUB_KEYS;
    public static final String[][] CELL_DEC_SUB_KEYS;
    public static final String[][] BG_SUB_KEYS;
    public static final String[][] AA_SUB_KEYS;
    public static final String[][] LAB_ROT_SUB_KEYS;
    public static final String[][] HEADER_LINES_SUB_KEYS;
    public static final String[][] CELL_LABEL_SUB_KEYS;
    public static final String[][] CORNER_SUB_KEYS;
    public static final String[][] ORDER_BOOST_KEYS;
    public static final String[][] ORDER_AUTO_INSTALL_KEYS;
    private static final NameValuePair[] b;
    private static final NameValuePair[] c;
    private static final NameValuePair[] d;
    private static final NameValuePair[] e;
    private static final NameValuePair[] f;

    public CalendarTheme() {
        this.a();
        this.b();
        this.transferDefaultsToTheme();
    }

    public CalendarTheme(String string) {
        this();
        Themes.setTheme(string, this);
    }

    private void a() {
        this.setPropertyCapabilities(KEY_NAME, CAP_NULL, CAP_STRING);
        this.setPropertyCapabilities(KEY_GENERIC_AUTO_RELOAD_FROM_THEME, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_GENERIC_BACKGROUND, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_GENERIC_MINIMAL_DAYS_IN_FIRST_WEEK, CAP_NULL, CalendarTheme.getIntegerCap(1, 7, 1));
        this.setPropertyCapabilities(KEY_GENERIC_LOCALE, CAP_NULL, new PropertyCapability(Locale.class));
        this.setPropertyCapabilities(KEY_GENERIC_TIME_ZONE, CAP_NULL, new PropertyCapability(TimeZone.class));
        this.setPropertyCapabilities(KEY_GENERIC_CRYPTO_KEY, CAP_NULL, CAP_STRING);
        this.setPropertyCapabilities(KEY_GENERIC_INFO_AUTHOR, CAP_STRING);
        this.setPropertyCapabilities(KEY_GENERIC_INFO_THEME, CAP_STRING);
        this.setPropertyCapabilities(KEY_GENERIC_INFO_VERSION, CAP_STRING);
        this.setPropertyCapabilities(KEY_GENERIC_INFO_DATE, CAP_STRING);
        this.setPropertyCapabilities(KEY_GENERIC_CELL_REPAINT_PADDING, CAP_NULL, CAP_INSETS);
        this.setPropertyCapabilities(KEY_GENERIC_DEBUG_REPAINT_ALL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_GENERIC_DEBUG_OUTLINE_CLIP_BOUNDS_DEBUG, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_GENERIC_ACTIVITIES_SUPPORTED, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_STARTUP_PRIMARY_DIM_DIRECTION, new PropertyCapability(e));
        this.setPropertyCapabilities(KEY_STARTUP_PRIMARY_DIM_CELL_TYPE, new PropertyCapability(DateRangeI.DATE_RANGES));
        this.setPropertyCapabilities(KEY_STARTUP_PRIMARY_DIM_TYPE_COUNT, CalendarTheme.getIntegerCap(1, 10000, 1));
        this.setPropertyCapabilities(KEY_STARTUP_SECONDARY_DIM_WRAP_BOUNDARY, CAP_NULL, new PropertyCapability(WRAP_TYPE_DATE_RANGES));
        this.setPropertyCapabilities(KEY_STARTUP_SECONDARY_DIM_WRAP_BOUNDARY_COUNT, CalendarTheme.getIntegerCap(1, 10000, 1));
        this.setPropertyCapabilities(KEY_STARTUP_VISUAL_RANGE_TYPE, new PropertyCapability(DateRangeI.DATE_RANGES));
        this.setPropertyCapabilities(KEY_STARTUP_VISUAL_RANGE_COUNT, CalendarTheme.getIntegerCap(1, 10000, 1));
        this.setPropertyCapabilities(KEY_STARTUP_VISUAL_RANGE_ALIGN, CAP_NULL, CAP_REF_RANGE_NUMBER);
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_SHOW_SELECTED_WHEN_SELECTING, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_HIDE_WHEN_NOT_EXACT_CELL_DATE_RANGE, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_TYPE_KEY, new PropertyCapability(f));
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_EXPAND_RANGE_KEY, CAP_NULL, CAP_KEY_SEQUENCE);
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_SELECT_RANGE_KEY, CAP_NULL, CAP_KEY_SEQUENCE);
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_BOUNDARY, CAP_NULL, new PropertyCapability(DateRangeI.DATE_RANGES));
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_MIN_COUNT, CAP_NULL, CalendarTheme.getIntegerCap(1, 1000, 1));
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_MAX_COUNT, CAP_NULL, CalendarTheme.getIntegerCap(1, 1000, 1));
        this.setPropertyCapabilities(KEY_FEEL_SELECTION_CUT_ALIGNMENT, CAP_NULL, new PropertyCapability(MutableDateRange.ALIGN_VNPS));
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_MULTI_SELECT_KEY, CAP_NULL, CAP_KEY_SEQUENCE);
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_MULTI_SELECT_LIVE, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_SNAP_TO_MILLIS, CalendarTheme.getLongCap(0L, 0x3FFFFFFFFFFFFFF5L, 1000L));
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_FALLBACK_SNAP_TO_MILLIS, CalendarTheme.getLongCap(0L, 0x3FFFFFFFFFFFFFF5L, 1000L));
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_NO_SNAP_KEY, CAP_NULL, CAP_KEY_SEQUENCE);
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_ORDER_, ORDER_BOOST_KEYS, new PropertyCapability[]{CAP_NULL, CalendarTheme.getIntegerCap(-128, 128, 1)});
        this.setPropertyCapabilities(KEY_FEEL_ACTIVITY_ORDER_, ORDER_AUTO_INSTALL_KEYS, new PropertyCapability[]{CAP_BOOLEAN});
        this.setPropertyCapabilities(KEY_DECORATORS_DIVIDERS_FOREGROUND, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_DIVIDERS_RANGE_TYPE, CAP_NULL, new PropertyCapability(DateRangeI.DATE_RANGES_FROM_DAY));
        this.setPropertyCapabilities(KEY_DECORATORS_DIVIDERS_MAX_PAINT_WIDTH, CAP_NULL, CalendarTheme.getIntegerCap(1, 9999, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_DIVIDERS_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_IMAGE_IMAGE, CAP_NULL, CAP_XTD_IMAGE);
        this.setPropertyCapabilities(KEY_DECORATORS_IMAGE_BOUNDS, CAP_NULL, CAP_ABS_RECT);
        this.setPropertyCapabilities(KEY_DECORATORS_IMAGE_REPEAT, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_DECORATORS_IMAGE_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_BACKGROUND_, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_FOREGROUND_, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_FONT_, new PropertyCapability[]{CAP_NULL, CAP_FONT});
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_UNDERLINE_, new PropertyCapability[]{CAP_NULL, CalendarTheme.getIntegerCap(0, 100, 1)});
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_DATE_FORMAT_, new PropertyCapability[]{CAP_NULL, CAP_DATE_FORMAT_LIST});
        this.setPropertyCapabilities(KEY_DECORATORS_SELECTION_STROKE_, CAP_NULL, CAP_BASIC_STROKE);
        this.setPropertyCapabilities(KEY_DECORATORS_SELECTION_STROKE_PAINT_, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_SELECTION_PAINT_, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_SELECTION_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_GRIDLINES_MAX_PAINT_WIDTH, CAP_NULL, CalendarTheme.getIntegerCap(1, 9999, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_GRIDLINES_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_ACTIVITY_VIEWS_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_MULTI_SELECT_RECTANGLE_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_TEXT_ALIGNMENT_, CAP_NULL, CAP_REF_RANGE_NUMBER);
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_BOUNDS, CAP_NULL, CAP_ABS_RECT);
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_FOREGROUND_, CAP_NULL, CAP_COLOR, CAP_UI_COLOR);
        this.setPropertyCapabilities(KEY_DECORATORS_CELL_LABEL_ANTI_ALIAS, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_ROUND_TO_RANGE, CAP_NULL, new PropertyCapability(DateRangeI.DATE_RANGES));
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_FILL, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_NOT_FILL, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_OUTLINE, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_BOUNDS, CAP_NULL, CAP_ABS_RECT);
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_MERGE_OVERLAPPING, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_DECORATORS_OCCUPIED_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_NO_FIT_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_DECORATORS_EVEN_FILL_RANGE_TYPE, CAP_NULL, new PropertyCapability(DateRangeI.DATE_RANGES_FROM_DAY));
        this.setPropertyCapabilities(KEY_DECORATORS_EVEN_FILL_PAINT, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_DECORATORS_EVEN_FILL_INSTALL_IN_LAYER, CAP_NULL, CalendarTheme.getIntegerCap(-1000, 1000, 1));
        this.setPropertyCapabilities(KEY_GRID_SEGMENTS_, new PropertyCapability[]{CAP_NULL, CAP_GRID_SEGMENT});
        this.setPropertyCapabilities(KEY_GRID_GRIDLINES_, new PropertyCapability[]{CAP_NULL, CAP_GRID_LINE_REP});
        this.setPropertyCapabilities(KEY_GRID_EXPAND_PRIMARY_DIM, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_GRID_EXPAND_SECONDARY_DIM, CAP_BOOLEAN);
        this.setPropertyCapabilities("Headers/", CORNER_EXPAND_SUB_KEYS, new PropertyCapability[]{CAP_NULL, new PropertyCapability(d)});
        this.setPropertyCapabilities("Headers/", BG_SUB_KEYS, CAP_PAINT_ALL);
        this.setPropertyCapabilities("Headers/", CELL_DEC_SUB_KEYS, new PropertyCapability[]{CAP_NULL, CAP_CELL_DECORATION_ROW});
        this.setPropertyCapabilities("Headers/", AA_SUB_KEYS, new PropertyCapability[]{CAP_NULL, CAP_BOOLEAN});
        this.setPropertyCapabilities("Headers/", LAB_ROT_SUB_KEYS, new PropertyCapability[]{CAP_NULL, new PropertyCapability(c)});
        this.setPropertyCapabilities("Headers/", HEADER_LINES_SUB_KEYS, new PropertyCapability[]{CAP_NULL, CAP_GRID_LINE_REP});
        this.setPropertyCapabilities(KEY_HEADER_CORNERS_, CAP_PAINT_ALL);
        this.setPropertyCapabilities(KEY_COMBO_DATEFORMAT_, CAP_NULL, CAP_DATE_FORMAT_LIST);
        this.setPropertyCapabilities(KEY_COMBO_DATEFORMAT_DEFAULT_DATE_STYLE, CAP_NULL, new PropertyCapability(b));
        this.setPropertyCapabilities(KEY_COMBO_DATEFORMAT_DEFAULT_TIME_STYLE, CAP_NULL, new PropertyCapability(b));
        this.setPropertyCapabilities(KEY_COMBO_CUSTOM_PREFIX_, CAP_STRING);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_SHOW_ARROWS, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_SHOW_HOME, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_POPUP_SIZE_, CAP_NULL, CAP_DIMENSION);
        this.setPropertyCapabilities(KEY_COMBO_POPUP_BORDER, CAP_NULL, CAP_BORDER);
        this.setPropertyCapabilities(KEY_COMBO_NO_DATE_TEXT, CAP_STRING);
        this.setPropertyCapabilities(KEY_COMBO_BORDER, CAP_NULL, CAP_BORDER);
        this.setPropertyCapabilities(KEY_COMBO_ADD_FIELD, CAP_NULL, new PropertyCapability(a));
        this.setPropertyCapabilities(KEY_COMBO_ADD_AMOUNT, CalendarTheme.getIntegerCap(1, 400, 1));
        this.setPropertyCapabilities(KEY_COMBO_CUSTOM_RANGE_ADD_FIELD, new PropertyCapability(a));
        this.setPropertyCapabilities(KEY_COMBO_CUSTOM_RANGE_MIN_TYPE, new PropertyCapability(DateRangeI.DATE_RANGES));
        this.setPropertyCapabilities(KEY_COMBO_EDITOR_BORDER, CAP_NULL, CAP_BORDER);
        this.setPropertyCapabilities(KEY_COMBO_EDITOR_FONT, CAP_NULL, CAP_FONT);
        this.setPropertyCapabilities(KEY_COMBO_EDITOR_FOREGROUND, CAP_NULL, CAP_COLOR);
        this.setPropertyCapabilities(KEY_COMBO_EDITOR_ANTI_ALIAS, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_EDITOR_PARSE_LENIENT, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_EDITOR_HIDE_END_DATE, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_BORDER, CAP_NULL, CAP_BORDER);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_CONTENT_AREA_FILLED, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_OPAQUE, CAP_NULL, CAP_BOOLEAN);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_DIVIDER_WIDTH, CAP_NULL, CalendarTheme.getIntegerCap(0, 20, 1));
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_DIVIDER_COLOR, CAP_NULL, CAP_COLOR);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_ARROW_COLOR, CAP_NULL, CAP_COLOR);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_ARROW_SHADOW_COLOR, CAP_NULL, CAP_COLOR);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_BIG_INSETS, CAP_NULL, CAP_INSETS);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_SMALL_INSETS, CAP_NULL, CAP_INSETS);
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_DROP_ARROW_SIZE, CAP_NULL, CalendarTheme.getIntegerCap(0, 50, 1));
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_LEFT_RIGHT_ARROW_SIZE, CAP_NULL, CalendarTheme.getIntegerCap(0, 50, 1));
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_HOME_ARROW_SIZE, CAP_NULL, CalendarTheme.getIntegerCap(0, 50, 1));
        this.setPropertyCapabilities(KEY_COMBO_BUTTONS_HOME_ARROW_GAP, CAP_NULL, CalendarTheme.getIntegerCap(0, 50, 1));
        this.setPropertyCapabilities(KEY_LAYOUTS_BROKER, CAP_NULL, new PropertyCapability(ActivityLayoutBroker.class));
        this.setPropertyCapabilities(KEY_LAYOUTS_AUTO_INSTALL, new PropertyCapability[]{CAP_NULL, new PropertyCapability(HideLayout.class), new PropertyCapability(TimeBoundsLayout.class), new PropertyCapability(FlexGridLayout.class), new PropertyCapability(ActivityLayout.class)});
    }

    private void b() {
        this.setDefaultValue(KEY_NAME, "NO_NAME");
        this.setDefaultValue(KEY_GENERIC_AUTO_RELOAD_FROM_THEME, Boolean.TRUE);
        this.setDefaultValue(KEY_GENERIC_BACKGROUND, Color.WHITE);
        this.setDefaultValue(KEY_GENERIC_MINIMAL_DAYS_IN_FIRST_WEEK, null);
        this.setDefaultValue(KEY_GENERIC_LOCALE, null);
        this.setDefaultValue(KEY_GENERIC_TIME_ZONE, null);
        this.setDefaultValue(KEY_GENERIC_CRYPTO_KEY, null);
        this.setDefaultValue(KEY_GENERIC_INFO_AUTHOR, "MiG InfoCom AB");
        this.setDefaultValue(KEY_GENERIC_INFO_THEME, "Default Theme");
        this.setDefaultValue(KEY_GENERIC_INFO_VERSION, "1.0");
        this.setDefaultValue(KEY_GENERIC_INFO_DATE, "2005-01-10 21:05");
        this.setDefaultValue(KEY_GENERIC_CELL_REPAINT_PADDING, null);
        this.setDefaultValue(KEY_GENERIC_DEBUG_REPAINT_ALL, Boolean.FALSE);
        this.setDefaultValue(KEY_GENERIC_DEBUG_OUTLINE_CLIP_BOUNDS_DEBUG, Boolean.FALSE);
        this.setDefaultValue(KEY_GENERIC_ACTIVITIES_SUPPORTED, Boolean.FALSE);
        this.setDefaultValue(KEY_STARTUP_PRIMARY_DIM_DIRECTION, new Integer(1));
        this.setDefaultValue(KEY_STARTUP_PRIMARY_DIM_CELL_TYPE, new Integer(46));
        this.setDefaultValue(KEY_STARTUP_PRIMARY_DIM_TYPE_COUNT, new Integer(30));
        this.setDefaultValue(KEY_STARTUP_SECONDARY_DIM_WRAP_BOUNDARY, new Integer(44));
        this.setDefaultValue(KEY_STARTUP_SECONDARY_DIM_WRAP_BOUNDARY_COUNT, new Integer(1));
        this.setDefaultValue(KEY_STARTUP_VISUAL_RANGE_TYPE, new Integer(43));
        this.setDefaultValue(KEY_STARTUP_VISUAL_RANGE_COUNT, new Integer(1));
        this.setDefaultValue(KEY_STARTUP_VISUAL_RANGE_ALIGN, null);
        this.setDefaultValue(KEY_FEEL_SELECTION_SHOW_SELECTED_WHEN_SELECTING, null);
        this.setDefaultValue(KEY_FEEL_SELECTION_HIDE_WHEN_NOT_EXACT_CELL_DATE_RANGE, null);
        this.setDefaultValue(KEY_FEEL_SELECTION_TYPE_KEY, new Integer(0));
        this.setDefaultValue(KEY_FEEL_SELECTION_EXPAND_RANGE_KEY, new KeySequence());
        this.setDefaultValue(KEY_FEEL_SELECTION_SELECT_RANGE_KEY, new KeySequence());
        this.setDefaultValue(KEY_FEEL_SELECTION_BOUNDARY, null);
        this.setDefaultValue(KEY_FEEL_SELECTION_MIN_COUNT, null);
        this.setDefaultValue(KEY_FEEL_SELECTION_MAX_COUNT, null);
        this.setDefaultValue(KEY_FEEL_SELECTION_CUT_ALIGNMENT, null);
        this.setDefaultValue(KEY_FEEL_ACTIVITY_MULTI_SELECT_KEY, new KeySequence(16));
        this.setDefaultValue(KEY_FEEL_ACTIVITY_MULTI_SELECT_LIVE, Boolean.TRUE);
        this.setDefaultValue(KEY_FEEL_ACTIVITY_SNAP_TO_MILLIS, new Long(300000L));
        this.setDefaultValue(KEY_FEEL_ACTIVITY_FALLBACK_SNAP_TO_MILLIS, new Long(60000L));
        this.setDefaultValue(KEY_FEEL_ACTIVITY_NO_SNAP_KEY, new KeySequence(17));
        this.setDefaultValue(KEY_FEEL_ACTIVITY_ORDER_, ORDER_BOOST_KEYS, new Object[]{null, null, new Integer(2), new Integer(1), new Integer(2), new Integer(1)});
        this.setDefaultValue(KEY_FEEL_ACTIVITY_ORDER_, ORDER_AUTO_INSTALL_KEYS, new Object[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE});
        this.setDefaultValue(KEY_DECORATORS_IMAGE_IMAGE, null);
        this.setDefaultValue(KEY_DECORATORS_IMAGE_BOUNDS, null);
        this.setDefaultValue(KEY_DECORATORS_IMAGE_REPEAT, Boolean.FALSE);
        this.setDefaultValue(KEY_DECORATORS_IMAGE_INSTALL_IN_LAYER, new Integer(10));
        this.setDefaultValue(KEY_DECORATORS_DIVIDERS_FOREGROUND, new Color(100, 100, 100));
        this.setDefaultValue(KEY_DECORATORS_DIVIDERS_RANGE_TYPE, new Integer(42));
        this.setDefaultValue(KEY_DECORATORS_DIVIDERS_MAX_PAINT_WIDTH, null);
        this.setDefaultValue(KEY_DECORATORS_DIVIDERS_INSTALL_IN_LAYER, new Integer(70));
        this.setDefaultValue(KEY_DECORATORS_SELECTION_STROKE_, ALL_SEL_SUB_KEYS, null);
        this.setDefaultValue(KEY_DECORATORS_SELECTION_STROKE_PAINT_, ALL_SEL_SUB_KEYS, null);
        this.setDefaultValue(KEY_DECORATORS_SELECTION_PAINT_, ALL_SEL_SUB_KEYS, null);
        this.setDefaultValue(KEY_DECORATORS_SELECTION_INSTALL_IN_LAYER, new Integer(30));
        this.setDefaultValue(KEY_DECORATORS_GRIDLINES_MAX_PAINT_WIDTH, null);
        this.setDefaultValue(KEY_DECORATORS_GRIDLINES_INSTALL_IN_LAYER, new Integer(50));
        this.setDefaultValue(KEY_DECORATORS_ACTIVITY_VIEWS_INSTALL_IN_LAYER, new Integer(100));
        this.setDefaultValue(KEY_DECORATORS_MULTI_SELECT_RECTANGLE_INSTALL_IN_LAYER, new Integer(110));
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_BACKGROUND_DEFAULT, null);
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_BACKGROUND_, CELL_LABEL_SUB_KEYS, new Object[]{new ThemeKeyLink(KEY_DECORATORS_CELL_LABEL_BACKGROUND_DEFAULT)});
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_FOREGROUND_DEFAULT, Color.BLACK);
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_FOREGROUND_, CELL_LABEL_SUB_KEYS, new Object[]{new ThemeKeyLink(KEY_DECORATORS_CELL_LABEL_FOREGROUND_DEFAULT)});
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_FONT_DEFAULT, new Font("SansSerif", 0, 11));
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_FONT_, CELL_LABEL_SUB_KEYS, new Object[]{new ThemeKeyLink(KEY_DECORATORS_CELL_LABEL_FONT_DEFAULT)});
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_UNDERLINE_DEFAULT, new Integer(0));
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_UNDERLINE_, CELL_LABEL_SUB_KEYS, new Object[]{new ThemeKeyLink(KEY_DECORATORS_CELL_LABEL_UNDERLINE_DEFAULT)});
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_DATE_FORMAT_DEFAULT, new DateFormatList("d"));
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_DATE_FORMAT_, CELL_LABEL_SUB_KEYS, new Object[]{new ThemeKeyLink(KEY_DECORATORS_CELL_LABEL_DATE_FORMAT_DEFAULT)});
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_TEXT_ALIGNMENT_, X_Y_SUB_KEYS, new Object[]{new AtFraction(0.5f)});
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_BOUNDS, new AbsRect(new AtStart(0.0f), new AtStart(0.0f), new AtEnd(0.0f), new AtStart(14.0f)));
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_INSTALL_IN_LAYER, null);
        this.setDefaultValue(KEY_DECORATORS_CELL_LABEL_ANTI_ALIAS, Boolean.FALSE);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_ROUND_TO_RANGE, null);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_FILL, Color.LIGHT_GRAY);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_NOT_FILL, Color.WHITE);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_OUTLINE, Color.GRAY);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_BOUNDS, null);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_MERGE_OVERLAPPING, Boolean.TRUE);
        this.setDefaultValue(KEY_DECORATORS_OCCUPIED_INSTALL_IN_LAYER, null);
        this.setDefaultValue(KEY_DECORATORS_NO_FIT_INSTALL_IN_LAYER, new Integer(120));
        this.setDefaultValue(KEY_DECORATORS_EVEN_FILL_RANGE_TYPE, null);
        this.setDefaultValue(KEY_DECORATORS_EVEN_FILL_PAINT, null);
        this.setDefaultValue(KEY_DECORATORS_EVEN_FILL_INSTALL_IN_LAYER, null);
        this.setDefaultValueAsList(KEY_GRID_SEGMENTS_, SEGMENT_SUB_LIST_KEYS, new Object[]{new GridSegment(1, new AtFixed(1.0f), null, null)});
        this.setDefaultValue(KEY_GRID_EXPAND_PRIMARY_DIM, Boolean.TRUE);
        this.setDefaultValue(KEY_GRID_EXPAND_SECONDARY_DIM, Boolean.TRUE);
        this.setDefaultValueAsList(KEY_GRID_GRIDLINES_ + GRIDLINE_DIM_SUB_LIST_KEYS[0], new Object[]{new GridLineRepetition(0, 1, 1, new Color(230, 230, 230))});
        this.setDefaultValueAsList(KEY_GRID_GRIDLINES_ + GRIDLINE_DIM_SUB_LIST_KEYS[1], new Object[]{new GridLineRepetition(0, 1, 1, new Color(230, 230, 230))});
        this.setDefaultValueAsList(KEY_GRID_GRIDLINES_ + GRIDLINE_DIM_SUB_LIST_KEYS[2], new Object[]{new GridLineRepetition(0, 1, new AtStart(1.0f), new AtEnd(-2.0f), 1, new Color(240, 240, 255))});
        this.setDefaultValue("Headers/", CORNER_EXPAND_SUB_KEYS, null);
        this.setDefaultValue("Headers/", BG_SUB_KEYS, null);
        this.setDefaultValue("Headers/", AA_SUB_KEYS, null);
        this.setDefaultValue("Headers/", LAB_ROT_SUB_KEYS, null);
        this.setDefaultValueAsList("Headers/", CELL_DEC_SUB_KEYS, null);
        this.setDefaultValueAsList("Headers/", HEADER_LINES_SUB_KEYS, null);
        this.setDefaultValue(KEY_HEADER_CORNERS_, CORNER_SUB_KEYS, null);
        this.setDefaultValue(KEY_COMBO_POPUP_SIZE_, M_P_M_SUB_KEYS, new Object[]{new Dimension(100, 100), null, new Dimension(200, 500)});
        this.setDefaultValue("Combo/DateFormat/day", null);
        this.setDefaultValue("Combo/DateFormat/week", new DateFormatList("'Week 'ww' of 'yyyy"));
        this.setDefaultValue("Combo/DateFormat/month", new DateFormatList("MMMM' -'yy"));
        this.setDefaultValue("Combo/DateFormat/yearMonths", new DateFormatList("'Year' yyyy"));
        this.setDefaultValue("Combo/DateFormat/yearWeeks", new DateFormatList("'Year' yyyy '(weeks)'"));
        this.setDefaultValue("Combo/DateFormat/custom", null);
        this.setDefaultValue(KEY_COMBO_DATEFORMAT_DEFAULT_TIME_STYLE, null);
        this.setDefaultValue(KEY_COMBO_DATEFORMAT_DEFAULT_DATE_STYLE, new Integer(2));
        this.setDefaultValue(KEY_COMBO_CUSTOM_PREFIX_, new String[]{"start", "end"}, new Object[]{"", "  -  "});
        this.setDefaultValue(KEY_COMBO_BUTTONS_SHOW_ARROWS, Boolean.TRUE);
        this.setDefaultValue(KEY_COMBO_BUTTONS_SHOW_HOME, Boolean.TRUE);
        this.setDefaultValue(KEY_COMBO_NO_DATE_TEXT, "<Select Date>");
        this.setDefaultValue(KEY_COMBO_POPUP_BORDER, null);
        this.setDefaultValue(KEY_COMBO_BORDER, null);
        this.setDefaultValue(KEY_COMBO_ADD_FIELD, null);
        this.setDefaultValue(KEY_COMBO_ADD_AMOUNT, new Integer(1));
        this.setDefaultValue(KEY_COMBO_CUSTOM_RANGE_ADD_FIELD, new Integer(6));
        this.setDefaultValue(KEY_COMBO_CUSTOM_RANGE_MIN_TYPE, new Integer(44));
        this.setDefaultValue(KEY_COMBO_EDITOR_BORDER, null);
        this.setDefaultValue(KEY_COMBO_EDITOR_FONT, null);
        this.setDefaultValue(KEY_COMBO_EDITOR_FOREGROUND, null);
        this.setDefaultValue(KEY_COMBO_EDITOR_HIDE_END_DATE, null);
        this.setDefaultValue(KEY_COMBO_EDITOR_ANTI_ALIAS, null);
        this.setDefaultValue(KEY_COMBO_EDITOR_PARSE_LENIENT, Boolean.TRUE);
        this.setDefaultValue(KEY_COMBO_BUTTONS_BORDER, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_CONTENT_AREA_FILLED, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_OPAQUE, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_DIVIDER_WIDTH, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_DIVIDER_COLOR, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_ARROW_COLOR, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_ARROW_SHADOW_COLOR, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_BIG_INSETS, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_SMALL_INSETS, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_DROP_ARROW_SIZE, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_LEFT_RIGHT_ARROW_SIZE, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_HOME_ARROW_SIZE, null);
        this.setDefaultValue(KEY_COMBO_BUTTONS_HOME_ARROW_GAP, null);
        this.setDefaultValue(KEY_LAYOUTS_BROKER, null);
        this.setDefaultValueAsList(KEY_LAYOUTS_AUTO_INSTALL, new Object[]{new HideLayout(), new FlexGridLayout(), new TimeBoundsLayout()});
    }

    public Locale getLocale() {
        Object object = this.getValue(KEY_GENERIC_LOCALE);
        return object == null ? Locale.getDefault() : (Locale)object;
    }

    public TimeZone getTimeZone() {
        Object object = this.getValue(KEY_GENERIC_TIME_ZONE);
        return object == null ? TimeZone.getDefault() : (TimeZone)object;
    }

    public Calendar createCalendar() {
        Calendar calendar = DateUtil.createCalendar(this.getTimeZone(), this.getLocale());
        Integer n = (Integer)this.getValue(KEY_GENERIC_MINIMAL_DAYS_IN_FIRST_WEEK);
        if (n != null) {
            calendar.setMinimalDaysInFirstWeek(n);
        }
        return calendar;
    }

    public PlaceRect getPlaceRect(String string) {
        return (PlaceRect)this.getValue(string);
    }

    public SimpleDateFormat getSimpleDateFormat(String string) {
        DateFormatList dateFormatList = (DateFormatList)this.getValue(string);
        return dateFormatList != null ? dateFormatList.toSimpleDateFormat(this.getLocale()) : null;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CalendarTheme && super.equals(object);
    }

    public String toString() {
        return String.valueOf(this.getValue(KEY_NAME));
    }

    static {
        deprecatedKeys.add("Combo/showHome");
        deprecatedKeys.add("Combo/showArrows");
        deprecatedKeys.add("Combo/editorBorder");
        deprecatedKeys.add("Combo/PopupSize/min");
        deprecatedKeys.add("Combo/PopupSize/preferred");
        deprecatedKeys.add("Combo/PopupSize/max");
        deprecatedKeys.add(KEY_COMBO_BUTTONS_OPAQE);
        ALL_SEL_SUB_KEYS = new String[]{"mouseOver", "pressed", "selected", "selectable"};
        X_Y_SUB_KEYS = new String[]{"x", "y"};
        ORDER_MAIN_KEYS = new String[]{"Layout/", "Painting/", "Events/"};
        WEEK_DAYS_SUB_KEYS = new String[]{"today", "firstDayOfMonth", "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
        M_P_M_SUB_KEYS = new String[]{"min", "preferred", "max"};
        LABEL_TYPE_SUB_FOLDER_KEYS = new String[]{"NotSelectable/", "MouseOver/", "Pressed/", "Selected/", "Normal/"};
        N_W_S_E_SUB_FOLDER_KEYS = new String[]{"North/", "West/", "South/", "East/"};
        CORNER_SUB_FOLDER_KEYS = new String[]{"TopLeft/", "TopRight/", "BottomLeft/", "BottomRight/"};
        SEGMENT_SUB_LIST_KEYS = new String[]{"PrimaryDim#", "SecondaryDim#"};
        GRIDLINE_DIM_SUB_LIST_KEYS = new String[]{"PrimaryDim#", "SecondaryDim#", "SubDim#"};
        CORNER_EXPAND_SUB_KEYS = new String[][]{N_W_S_E_SUB_FOLDER_KEYS, {"expandToCorner"}};
        CELL_DEC_SUB_KEYS = new String[][]{N_W_S_E_SUB_FOLDER_KEYS, {"CellDecorationRows#"}};
        BG_SUB_KEYS = new String[][]{N_W_S_E_SUB_FOLDER_KEYS, {"background"}};
        AA_SUB_KEYS = new String[][]{N_W_S_E_SUB_FOLDER_KEYS, {"antiAlias"}};
        LAB_ROT_SUB_KEYS = new String[][]{N_W_S_E_SUB_FOLDER_KEYS, {"labelRotation"}};
        HEADER_LINES_SUB_KEYS = new String[][]{N_W_S_E_SUB_FOLDER_KEYS, {"GridLines/PrimaryDim#", "GridLines/SecondaryDim#"}};
        CELL_LABEL_SUB_KEYS = new String[][]{LABEL_TYPE_SUB_FOLDER_KEYS, WEEK_DAYS_SUB_KEYS};
        CORNER_SUB_KEYS = new String[][]{CORNER_SUB_FOLDER_KEYS, {"background"}};
        ORDER_BOOST_KEYS = new String[][]{ORDER_MAIN_KEYS, {"mouseOverBoost", "selectedBoost"}};
        ORDER_AUTO_INSTALL_KEYS = new String[][]{ORDER_MAIN_KEYS, {"autoInstall"}};
        b = new NameValuePair[]{new NameValuePair<Integer>("Short", new Integer(3)), new NameValuePair<Integer>("Medium", new Integer(2)), new NameValuePair<Integer>("Long", new Integer(1)), new NameValuePair<Integer>("Full", new Integer(0))};
        c = new NameValuePair[]{new NameValuePair<Integer>("Normal", new Integer(1)), new NameValuePair<Integer>("Left 90", new Integer(3)), new NameValuePair<Integer>("Right 90", new Integer(2))};
        d = new NameValuePair[]{new NameValuePair<Integer>("None", new Integer(0)), new NameValuePair<Integer>("Top/Left Corner", new Integer(1)), new NameValuePair<Integer>("Bottom/Right Corner", new Integer(2)), new NameValuePair<Integer>("Both Corners", new Integer(3))};
        e = new NameValuePair[]{new NameValuePair<Integer>("Horizontal", new Integer(0)), new NameValuePair<Integer>("Vertical", new Integer(1))};
        f = new NameValuePair[]{new NameValuePair<Integer>("None (disabled)", new Integer(0)), new NameValuePair<Integer>("Normal", new Integer(1))};
    }
}

