/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.theme;

import com.miginfocom.theme.PropertyCapability;
import com.miginfocom.theme.ThemeKeyLink;
import com.miginfocom.theme.Themes;
import com.miginfocom.theme.ValidateException;
import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.border.Border;

public abstract class Theme {
    public static final boolean validateDefaults = true;
    protected static int INITIAL_MAP_SIZE = 1024;
    public static final int VALIDATE_MODE_NONE = 0;
    public static final int VALIDATE_MODE_LENIENT = 1;
    public static final int VALIDATE_MODE_STRICT = 2;
    private transient int a = 2;
    public static final char FOLDER_CHAR = '/';
    public static final char LIST_CHAR = '#';
    protected static HashSet deprecatedKeys = new HashSet();
    protected transient int modifiedCount = 0;
    protected static final PropertyCapability CAP_NULL;
    protected static final PropertyCapability CAP_BORDER;
    protected static final PropertyCapability CAP_BASIC_STROKE;
    protected static final PropertyCapability CAP_COLOR;
    protected static final PropertyCapability CAP_STRING;
    protected static final PropertyCapability CAP_BOOLEAN;
    protected static final PropertyCapability CAP_FONT;
    protected static final PropertyCapability CAP_INSETS;
    protected static final PropertyCapability CAP_DIMENSION;
    protected static final PropertyCapability CAP_PAINT;
    private final HashMap b = new HashMap(INITIAL_MAP_SIZE, 0.5f);
    private final LinkedHashMap c = new LinkedHashMap(INITIAL_MAP_SIZE, 0.5f);
    private final HashMap d = new HashMap(INITIAL_MAP_SIZE, 0.5f);
    private static final List e;
    public static final String MULTI_KEY_PROP_NAME = "multiKey";
    private final transient ListenerSet f = new ListenerSet(PropertyChangeListener.class);

    protected static final PropertyCapability getIntegerCap(int n, int n2, int n3) {
        return new PropertyCapability(Integer.class, new Integer(n), new Integer(n2), new Integer(n3));
    }

    protected static final PropertyCapability getLongCap(long l, long l2, long l3) {
        return new PropertyCapability(Long.class, new Long(l), new Long(l2), new Long(l3));
    }

    protected static final PropertyCapability getFloatCap(float f, float f2, float f3) {
        return new PropertyCapability(Float.class, new Float(f), new Float(f2), new Float(f3));
    }

    protected static final PropertyCapability getDoubleCap(double d, double d2, double d3) {
        return new PropertyCapability(Double.class, new Double(d), new Double(d2), new Double(d3));
    }

    protected Theme() {
    }

    public HashMap getPropertyMap() {
        return (HashMap)this.d.clone();
    }

    public void setPropertyMap(HashMap hashMap) {
        this.d.putAll(hashMap);
    }

    public Iterator getKeyIterator() {
        return this.d.keySet().iterator();
    }

    public void resetToDefaults() {
        boolean bl = this.setIgnorePropertyChangeEvents(true);
        this.d.clear();
        this.transferDefaultsToTheme();
        this.setIgnorePropertyChangeEvents(bl);
    }

    protected void transferDefaultsToTheme() {
        boolean bl = this.setIgnorePropertyChangeEvents(true);
        for (String string : this.c.keySet()) {
            ArrayList arrayList = this.getDefaultValue(string, false);
            if (arrayList instanceof ArrayList) {
                arrayList = new ArrayList(arrayList);
            }
            this.putValue(string, arrayList);
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, MULTI_KEY_PROP_NAME, null, null));
        this.setIgnorePropertyChangeEvents(bl);
    }

    public Object getDefaultValue(String string, boolean bl) {
        Object v = this.c.get(string);
        if (bl && v instanceof ThemeKeyLink) {
            return this.getDefaultValue(((ThemeKeyLink)v).getLinkedKey(), true);
        }
        return v;
    }

    public int getModifiedCount() {
        return this.modifiedCount;
    }

    public void validateTheme(boolean bl) {
        if (this.a == 0) {
            return;
        }
        StringBuffer stringBuffer = null;
        Iterator iterator = this.d.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.getValue(string);
            try {
                this.validate(string, object);
            }
            catch (ValidateException validateException) {
                if (bl) {
                    iterator.remove();
                    continue;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(200);
                }
                stringBuffer.append(validateException.getMessage()).append('\n');
            }
        }
        if (stringBuffer != null) {
            throw new ValidateException(stringBuffer.toString());
        }
    }

    public void validate(String string, Object object) {
        if (this.a == 0) {
            return;
        }
        if (this.a == 1) {
            this.validateAllowDefault(string, object);
        } else {
            this.validateDontAllowDefault(string, object);
        }
    }

    protected void validateAllowDefault(String string, Object object) {
        try {
            this.validateDontAllowDefault(string, object);
        }
        catch (ValidateException validateException) {
            try {
                this.validateDontAllowDefault(string, this.getDefaultValue(string, false));
            }
            catch (ValidateException validateException2) {
                System.err.println("Resetted Key: " + string + " to default value because of illegal value: " + object);
                throw validateException;
            }
        }
    }

    protected void validateDontAllowDefault(String string, Object object) {
        int n;
        if (this.a == 0) {
            return;
        }
        if (object instanceof ThemeKeyLink) {
            String string2 = ((ThemeKeyLink)object).getLinkedKey();
            if (!Arrays.equals(this.getPropertyCapabilities(string), this.getPropertyCapabilities(string2))) {
                throw new ValidateException("Validation: Can not link to key that have a different set if capabilities! key: " + string);
            }
            return;
        }
        PropertyCapability[] propertyCapabilityArray = this.getPropertyCapabilities(string);
        if (propertyCapabilityArray == null) {
            if (deprecatedKeys.contains(string)) {
                return;
            }
            throw new ValidateException("Validation: No PropertyCapability for key '" + string + "'");
        }
        if (!Theme.isListKey(string)) {
            for (int i = 0; i < propertyCapabilityArray.length; ++i) {
                if (propertyCapabilityArray[i].validate(object) != null) continue;
                return;
            }
        } else {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList == null) {
                return;
            }
            n = 1;
            ListIterator listIterator = arrayList.listIterator(0);
            while (n == 1 && listIterator.hasNext()) {
                Object e = listIterator.next();
                n = 0;
                for (int i = 0; n == 0 && i < propertyCapabilityArray.length; ++i) {
                    if (propertyCapabilityArray[i].validate(e) != null) continue;
                    n = 1;
                }
            }
            if (n != 0) {
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("Validation: The key '" + string + "' with value '" + object + "' was NOT validated ok by any of the following possible types and ranges:\n");
        for (n = 0; n < propertyCapabilityArray.length; ++n) {
            stringBuffer.append(String.valueOf(propertyCapabilityArray[n])).append('\n');
        }
        throw new ValidateException(stringBuffer.toString());
    }

    public PropertyCapability[] getPropertyCapabilities(String string) {
        int n;
        PropertyCapability[] propertyCapabilityArray = (PropertyCapability[])this.b.get(string);
        while (propertyCapabilityArray == null && (n = string.lastIndexOf(47, string.length() - 2)) != -1) {
            string = string.substring(0, n + 1);
            propertyCapabilityArray = (PropertyCapability[])this.b.get(string);
        }
        return propertyCapabilityArray;
    }

    protected final void setPropertyCapabilities(String string, PropertyCapability propertyCapability) {
        this.setPropertyCapabilities(string, new PropertyCapability[]{propertyCapability});
    }

    protected final void setPropertyCapabilities(String string, PropertyCapability propertyCapability, PropertyCapability propertyCapability2) {
        this.setPropertyCapabilities(string, new PropertyCapability[]{propertyCapability, propertyCapability2});
    }

    protected final void setPropertyCapabilities(String string, PropertyCapability propertyCapability, PropertyCapability propertyCapability2, PropertyCapability propertyCapability3) {
        this.setPropertyCapabilities(string, new PropertyCapability[]{propertyCapability, propertyCapability2, propertyCapability3});
    }

    protected final void setPropertyCapabilities(String string, PropertyCapability propertyCapability, PropertyCapability propertyCapability2, PropertyCapability propertyCapability3, PropertyCapability propertyCapability4) {
        this.setPropertyCapabilities(string, new PropertyCapability[]{propertyCapability, propertyCapability2, propertyCapability3, propertyCapability4});
    }

    protected final void setPropertyCapabilities(String string, PropertyCapability[] propertyCapabilityArray) {
        this.b.put(string, propertyCapabilityArray);
    }

    protected final void setPropertyCapabilities(String string, String[][] stringArray, PropertyCapability[] propertyCapabilityArray) {
        this.setPropertyCapabilities(string, MigUtil.flatten(stringArray), propertyCapabilityArray);
    }

    protected final void setPropertyCapabilities(String string, String[] stringArray, PropertyCapability[] propertyCapabilityArray) {
        Theme.assertIsFolderKey(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setPropertyCapabilities(string + stringArray[i], propertyCapabilityArray);
        }
    }

    protected final void setDefaultValue(String string, Object object) {
        Theme.assertIsNotFolderKey(string);
        this.validateDontAllowDefault(string, object);
        this.c.put(string, object);
    }

    protected final void setDefaultValue(String string, String[] stringArray, Object object) {
        Theme.assertIsFolderKey(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setDefaultValue(string + stringArray[i], object);
        }
    }

    protected final void setDefaultValue(String string, String[] stringArray, Object[] objectArray) {
        Theme.assertIsFolderKey(string);
        int n = objectArray != null ? objectArray.length - 1 : 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = objectArray != null ? objectArray[i > n ? n : i] : null;
            this.setDefaultValue(string + stringArray[i], object);
        }
    }

    protected final void setDefaultValue(String string, String[][] stringArray, Object[] objectArray) {
        this.setDefaultValue(string, MigUtil.flatten(stringArray), objectArray);
    }

    protected final void setDefaultValueAsList(String string, Object[] objectArray) {
        List<Object> list = objectArray != null ? Arrays.asList(objectArray) : null;
        this.setDefaultValue(Theme.assertIsListKey(string), list != null ? new ArrayList<Object>(list) : null);
    }

    protected final void setDefaultValueAsList(String string, String[] stringArray, Object[] objectArray) {
        Theme.assertIsFolderKey(string);
        List<Object> list = objectArray != null ? Arrays.asList(objectArray) : null;
        for (int i = 0; i < stringArray.length; ++i) {
            this.setDefaultValue(Theme.assertIsListKey(string + stringArray[i]), list != null ? new ArrayList<Object>(list) : null);
        }
    }

    protected final void setDefaultValueAsList(String string, String[][] stringArray, Object[] objectArray) {
        this.setDefaultValueAsList(string, MigUtil.flatten(stringArray), objectArray);
    }

    public Object putValue(String string, int n) {
        return this.putValue(string, new Integer(n));
    }

    public Object putValue(String string, Object object) {
        this.validateAllowDefault(string, object);
        Object object2 = this.d.put(string, object);
        if (!MigUtil.equals(object2, object)) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, object2, object));
        }
        return object2;
    }

    public void putAll(Map map) {
        if (this.getValidateMode() != 0) {
            for (Map.Entry entry : map.entrySet()) {
                this.validateAllowDefault((String)entry.getKey(), entry.getValue());
            }
        }
        this.d.putAll(map);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, MULTI_KEY_PROP_NAME, null, null));
    }

    public static final boolean isListKey(String string) {
        int n = string.length();
        return n > 0 && string.charAt(n - 1) == '#';
    }

    public static final boolean isFolderKey(String string) {
        int n = string.length();
        return n > 0 && string.charAt(n - 1) == '/';
    }

    public static final String assertIsListKey(String string) {
        if (!Theme.isListKey(string)) {
            throw new IllegalArgumentException(string + "is not a list key! I.e. does not end with a hash '#' !");
        }
        return string;
    }

    public static final void assertIsFolderKey(String string) {
        if (!Theme.isFolderKey(string)) {
            throw new IllegalArgumentException(string + "is not a folder key! I.e. does not end with a slash '/' !");
        }
    }

    public static final void assertIsNotFolderKey(String string) {
        if (Theme.isFolderKey(string)) {
            throw new IllegalArgumentException(string + "is a folder key! Ends with a slash '/' !");
        }
    }

    public boolean isLinked(String string) {
        return this.d.get(string) instanceof ThemeKeyLink;
    }

    public ThemeKeyLink getLink(String string) {
        Object v = this.d.get(string);
        return v instanceof ThemeKeyLink ? (ThemeKeyLink)v : null;
    }

    public boolean isKeysConnectable(String string, String string2) {
        return Arrays.equals(this.getPropertyCapabilities(string), this.getPropertyCapabilities(string2));
    }

    public Object getValue(String string) {
        Object object = this.d.get(string);
        if (this.a != 0 && object == null && !this.d.containsKey(string) && !deprecatedKeys.contains(string)) {
            throw new ValidateException("Validation: There is no Property Key in the theme named: '" + string + "'    in " + this);
        }
        if (object instanceof ThemeKeyLink) {
            object = this.getValue(((ThemeKeyLink)object).getLinkedKey());
        }
        return object;
    }

    public List getList(String string, boolean bl) {
        Theme.assertIsListKey(string);
        ArrayList arrayList = (ArrayList)this.getValue(string);
        if (arrayList != null && bl) {
            arrayList = new ArrayList(arrayList);
            while (arrayList.remove(null)) {
            }
        }
        return arrayList != null ? arrayList : e;
    }

    public int addToList(String string, Object object) {
        return this.addToList(string, 0x3FFFFFF5, object);
    }

    public int addToList(String string, int n, Object object) {
        int n2;
        Theme.assertIsListKey(string);
        ArrayList<Object> arrayList = (ArrayList<Object>)this.getValue(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.d.put(string, arrayList);
        }
        int n3 = n >= (n2 = arrayList.size()) ? n2 : n;
        arrayList.add(n3, object);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, null, object));
        return n3;
    }

    public Object getFromList(String string, int n) {
        Theme.assertIsListKey(string);
        return ((List)this.getValue(string)).get(n);
    }

    public Object setInList(String string, int n, Object object) {
        Theme.assertIsListKey(string);
        Object object2 = ((List)this.getValue(string)).set(n, object);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, object2, object));
        return object2;
    }

    public List setList(String string, Object[] objectArray) {
        Theme.assertIsListKey(string);
        List list = (List)this.getValue(string);
        Object[] objectArray2 = list != null ? list.toArray() : new Object[]{};
        this.d.put(string, Arrays.asList(objectArray));
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, objectArray2, objectArray));
        return list;
    }

    public Object removeFromList(String string, int n) {
        Theme.assertIsListKey(string);
        List list = (List)this.getValue(string);
        Object e = list.remove(n);
        if (list.size() == 0) {
            this.putValue(string, null);
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, e, null));
        return e;
    }

    public List removeAllFromList(String string) {
        Theme.assertIsListKey(string);
        List list = (List)this.getValue(string);
        if (list != null && list.size() > 0) {
            Object object = this.putValue(string, null);
            this.d.put(string, null);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, object, null));
        }
        return list;
    }

    public int moveListKey(String string, int n, int n2) {
        Theme.assertIsListKey(string);
        List list = (List)this.getValue(string);
        Object e = list.remove(n);
        int n3 = Math.max(Math.min(n + n2, list.size()), 0);
        list.add(n3, e);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, string, e, null));
        return n3;
    }

    public String getString(String string) {
        return (String)this.getValue(string);
    }

    public Color getColor(String string) {
        return (Color)this.getValue(string);
    }

    public Stroke getStroke(String string) {
        return (Stroke)this.getValue(string);
    }

    public Integer getInteger(String string) {
        return (Integer)this.getValue(string);
    }

    public Long getLong(String string) {
        return (Long)this.getValue(string);
    }

    public Dimension getDimension(String string) {
        return (Dimension)this.getValue(string);
    }

    public int getInt(String string) {
        Integer n = (Integer)this.getValue(string);
        return n != null ? n : 0;
    }

    public Float getFloat(String string) {
        return (Float)this.getValue(string);
    }

    public Number getNumber(String string) {
        return (Number)this.getValue(string);
    }

    public Font getFont(String string) {
        return (Font)this.getValue(string);
    }

    public boolean getBool(String string) {
        Boolean bl = (Boolean)this.getValue(string);
        return bl != null ? bl : false;
    }

    public Boolean getBoolean(String string) {
        return (Boolean)this.getValue(string);
    }

    public Border getBorder(String string) {
        return (Border)this.getValue(string);
    }

    public Paint getPaint(String string) {
        return (Paint)this.getValue(string);
    }

    public Insets getInsets(String string) {
        return (Insets)this.getValue(string);
    }

    public int setValidateMode(int n) {
        if (this.a != n) {
            int n2 = this.a;
            this.a = n;
            return n2;
        }
        return this.a;
    }

    public int getValidateMode() {
        return this.a;
    }

    public static void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (Themes.hasTheme(string)) {
            Themes.getTheme(string).removePropertyChangeListener(propertyChangeListener);
        }
    }

    public boolean setIgnorePropertyChangeEvents(boolean bl) {
        return this.f.setIgnoreEvents(bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(propertyChangeListener, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        this.f.add(propertyChangeListener, bl);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.f.remove(propertyChangeListener);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        ++this.modifiedCount;
        this.f.fireEvent(propertyChangeEvent);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Theme)) {
            return false;
        }
        return ((Theme)object).d.equals(this.d);
    }

    public static PersistenceDelegate getDelegateInstance() {
        return new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                Theme theme = (Theme)object;
                HashMap hashMap = theme.getPropertyMap();
                return new Expression(object, object.getClass(), "putAll", new Object[]{hashMap});
            }
        };
    }

    static {
        deprecatedKeys.add("Feel/Activity/minLength");
        deprecatedKeys.add("Feel/Activity/fallbackMinLength");
        deprecatedKeys.add("Feel/Activity/noMinLengthKey");
        CAP_NULL = new PropertyCapability((Class)null);
        CAP_BORDER = new PropertyCapability(Border.class);
        CAP_BASIC_STROKE = new PropertyCapability(BasicStroke.class);
        CAP_COLOR = new PropertyCapability(Color.class);
        CAP_STRING = new PropertyCapability(String.class);
        CAP_BOOLEAN = new PropertyCapability(Boolean.class);
        CAP_FONT = new PropertyCapability(Font.class);
        CAP_INSETS = new PropertyCapability(Insets.class);
        CAP_DIMENSION = new PropertyCapability(Dimension.class);
        CAP_PAINT = new PropertyCapability(Paint.class);
        e = Collections.unmodifiableList(new ArrayList(0));
    }
}

