/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.theme;

import com.miginfocom.theme.Theme;
import com.miginfocom.util.io.IOUtil;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeEvent;
import java.beans.XMLDecoder;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Themes {
    private static final HashMap a = new HashMap();

    private Themes() {
    }

    public static synchronized Theme getTheme(String string) {
        Theme theme = (Theme)a.get(string);
        if (theme == null) {
            throw new IllegalArgumentException("Unknown Context: " + string);
        }
        return theme;
    }

    public static synchronized Theme setTheme(String string, Theme theme) {
        return a.put(string, theme);
    }

    public static synchronized boolean hasTheme(String string) {
        return a.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme loadTheme(String string, String string2, boolean bl) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            Theme theme = Themes.loadTheme(fileInputStream, string2, bl, true);
            return theme;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme loadTheme(URL uRL, String string, boolean bl) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Theme theme = Themes.loadTheme(inputStream, string, bl, true);
            return theme;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Theme loadTheme(InputStream inputStream, String string, boolean bl, boolean bl2) throws IOException {
        inputStream = IOUtil.bufferInputStream(inputStream, 16384);
        try {
            if (IOUtil.isZippedStream(inputStream, bl2) && (inputStream = IOUtil.getZipEntryStream(inputStream, "ThemeXML")) == null) {
                throw new IOException("Theme does't contain an entry 'ThemeXML'");
            }
        }
        catch (IOException iOException) {
            throw new IOException("Theme file not found!");
        }
        XMLDecoder xMLDecoder = new XMLDecoder(inputStream, null, new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception exception) {
                System.err.println(exception.getLocalizedMessage());
                exception.printStackTrace();
            }
        });
        Theme theme = (Theme)xMLDecoder.readObject();
        if (theme == null) {
            throw new IOException("XMLDecoder error!");
        }
        if (bl) {
            theme.validateTheme(false);
        }
        Themes.setTheme(string, theme);
        theme.firePropertyChangeEvent(new PropertyChangeEvent(theme, "multiKey", null, null));
        return theme;
    }

    public static void saveTheme(Theme theme, String string, boolean bl) throws IOException {
        Themes.saveTheme(theme, new FileOutputStream(string), bl);
    }

    public static void saveTheme(Theme theme, OutputStream outputStream, boolean bl) throws IOException {
        outputStream = IOUtil.bufferOutputStream(outputStream, 16384);
        if (bl) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.setLevel(9);
            zipOutputStream.putNextEntry(new ZipEntry("ThemeXML"));
            outputStream = zipOutputStream;
        }
        IOUtil.writeXMLObject(outputStream, theme);
    }
}

