/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor;

import com.miginfocom.calendar.grid.DateBoundaryException;
import com.miginfocom.calendar.grid.GridLineException;
import com.miginfocom.calendar.grid.GridLineRepetition;
import com.miginfocom.calendar.grid.OffsetException;
import com.miginfocom.calendar.header.CellDecorationRow;
import com.miginfocom.calendar.header.DefaultSubRowLevel;
import com.miginfocom.calendar.layout.ActivityLayout;
import com.miginfocom.calendar.layout.FlexGridLayout;
import com.miginfocom.calendar.layout.HideLayout;
import com.miginfocom.calendar.layout.TimeBoundsLayout;
import com.miginfocom.themeeditor.ThemeEditor;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.dates.BoundaryRounder;
import com.miginfocom.util.dates.DateFormatList;
import com.miginfocom.util.dates.DateRangeRounder;
import com.miginfocom.util.dates.MillisRounder;
import com.miginfocom.util.dates.RangeCount;
import com.miginfocom.util.gfx.ShapeGradientPaint;
import com.miginfocom.util.gfx.UIColor;
import com.miginfocom.util.gfx.XtdImage;
import com.miginfocom.util.gfx.XtdTexturePaint;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.AlignRect;
import com.miginfocom.util.gfx.geometry.AspectRatioRect;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.SizeSpec;
import com.miginfocom.util.gfx.geometry.filters.OperFilter;
import com.miginfocom.util.gfx.geometry.filters.RefOperFilter;
import com.miginfocom.util.gfx.geometry.filters.RefRangeOperFilter;
import com.miginfocom.util.gfx.geometry.filters.SizeConstraint;
import com.miginfocom.util.gfx.geometry.numbers.AtEnd;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtFollow;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtOffset;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import com.miginfocom.util.repetition.DefaultRepetition;
import com.miginfocom.util.repetition.Repetition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;

public class EditorUtil {
    public static final int RANGE_TYPE_YEAR_WEEKS = 40;
    public static final int RANGE_TYPE_YEAR_MONTHS = 41;
    public static final int RANGE_TYPE_MONTH = 42;
    public static final int RANGE_TYPE_WEEK = 43;
    public static final int RANGE_TYPE_DAY = 44;
    public static final int RANGE_TYPE_HOUR = 45;
    public static final int RANGE_TYPE_MINUTE = 46;
    public static final int RANGE_TYPE_SECOND = 47;
    public static final int RANGE_TYPE_CUSTOM = 48;

    public static PropertyDescriptor createDescriptor(Class clazz, String string, Class clazz2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IntrospectionException {
        return EditorUtil.createDescriptor(clazz, string, clazz2, bl, bl2, bl3, bl4, false);
    }

    public static PropertyDescriptor createDescriptor(Class clazz, String string, Class clazz2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, clazz);
        if (clazz2 != null) {
            propertyDescriptor.setPropertyEditorClass(clazz2);
        }
        propertyDescriptor.setHidden(bl5);
        propertyDescriptor.setBound(bl);
        propertyDescriptor.setConstrained(bl2);
        propertyDescriptor.setExpert(bl3);
        propertyDescriptor.setPreferred(bl4);
        propertyDescriptor.setName(string);
        propertyDescriptor.setValue("visualUpdate", Boolean.TRUE);
        return propertyDescriptor;
    }

    public static String escapeText(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        return string.replaceAll("\r?\n", "\\\\n\" + \n\t\t\t\"");
    }

    public static String getInitString(Color color) {
        if (color == null) {
            return "null";
        }
        if (color instanceof UIColor) {
            UIColor uIColor = (UIColor)color;
            return "new " + color.getClass().getName() + "(\"" + uIColor.getColorName() + "\", " + EditorUtil.getInitString(uIColor.getTint()) + ", " + EditorUtil.getInitString(uIColor.getForcedAlpha()) + ")";
        }
        String string = "new " + color.getClass().getName() + "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        if (color.getAlpha() != 255) {
            return string + ", " + color.getAlpha() + ")";
        }
        return string + ")";
    }

    public static String getInitString(XtdTexturePaint xtdTexturePaint) {
        if (xtdTexturePaint == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("new ");
        stringBuffer.append(XtdTexturePaint.class.getName());
        stringBuffer.append('(');
        stringBuffer.append(EditorUtil.getInitString(xtdTexturePaint.getXtdImage()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(xtdTexturePaint.getOffset()));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getInitString(DefaultSubRowLevel defaultSubRowLevel) {
        if (defaultSubRowLevel == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("new ");
        stringBuffer.append(defaultSubRowLevel.getClass().getName());
        stringBuffer.append("(\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getText()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getSize()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getCellLabelBounds()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append("(java.awt.Paint[]) ");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getCellBackground()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getLabelForeground()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getLabelRepetition()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(defaultSubRowLevel.getExpandLevels());
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getFont()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString((Object[])defaultSubRowLevel.getUnderlineWidth()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getAlignX()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(defaultSubRowLevel.getAlignY()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(defaultSubRowLevel.getTextType());
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(defaultSubRowLevel.getAppliesTo());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getInitString(CellDecorationRow cellDecorationRow) {
        if (cellDecorationRow == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("new ");
        stringBuffer.append(cellDecorationRow.getClass().getName());
        stringBuffer.append("(\n\t\t\t");
        stringBuffer.append(EditorUtil.getRangeTypeInitString(cellDecorationRow.getMergeBoundaryType()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getDateFormats()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getSize()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getCellLabelBounds()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append("(java.awt.Paint[]) ");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getCellBackground()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getLabelForeground()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getLabelRepetition()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getFont()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString((Object[])cellDecorationRow.getUnderlineWidth()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getAlignX()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(cellDecorationRow.getAlignY()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getRangeTypeInitString(int n) {
        switch (n) {
            case 40: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_YEAR_WEEKS";
            }
            case 41: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_YEAR_MONTHS";
            }
            case 42: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_MONTH";
            }
            case 43: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_WEEK";
            }
            case 44: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_DAY";
            }
            case 45: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_HOUR";
            }
            case 46: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_MINUTE";
            }
            case 47: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_SECOND";
            }
            case 48: {
                return "com.miginfocom.util.dates.DateRangeI.RANGE_TYPE_CUSTOM";
            }
        }
        return "" + n;
    }

    public static String getInitString(Repetition repetition) {
        if (repetition == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("new ");
        stringBuffer.append(repetition.getClass().getName());
        stringBuffer.append('(');
        if (repetition instanceof GridLineRepetition) {
            GridLineRepetition gridLineRepetition = (GridLineRepetition)repetition;
            stringBuffer.append(gridLineRepetition.getOffset());
            stringBuffer.append(", ");
            stringBuffer.append(gridLineRepetition.getInterval());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(gridLineRepetition.getStartIndex()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(gridLineRepetition.getEndIndex()));
            stringBuffer.append(", ");
            stringBuffer.append(gridLineRepetition.getGridLineSize());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(gridLineRepetition.getPaint()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(gridLineRepetition.getLineStart()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(gridLineRepetition.getLineEnd()));
        } else if (repetition instanceof DefaultRepetition) {
            DefaultRepetition defaultRepetition = (DefaultRepetition)repetition;
            stringBuffer.append(defaultRepetition.getOffset());
            stringBuffer.append(", ");
            stringBuffer.append(defaultRepetition.getInterval());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(defaultRepetition.getStartIndex()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(defaultRepetition.getEndIndex()));
        } else {
            return "new " + repetition.getClass().getName() + "()";
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getInitString(GridLineException gridLineException) {
        if (gridLineException == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("new ");
        stringBuffer.append(gridLineException.getClass().getName());
        stringBuffer.append('(');
        if (gridLineException instanceof DateBoundaryException) {
            DateBoundaryException dateBoundaryException = (DateBoundaryException)gridLineException;
            stringBuffer.append(EditorUtil.getRangeTypeInitString(dateBoundaryException.getBoundaryRangeType()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(dateBoundaryException.getGridLineRepetition()));
        } else if (gridLineException instanceof OffsetException) {
            OffsetException offsetException = (OffsetException)gridLineException;
            stringBuffer.append(EditorUtil.getInitString(offsetException.getGridLineRepetition()));
        } else {
            return "new " + gridLineException.getClass().getName() + "()";
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getInitString(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + EditorUtil.escapeText(string) + "\"";
    }

    public static String getInitString(SizeConstraint sizeConstraint) {
        if (sizeConstraint == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("new ");
        stringBuffer.append(sizeConstraint.getClass().getName());
        stringBuffer.append('(');
        stringBuffer.append(EditorUtil.getInitString(sizeConstraint.getConstraint()));
        stringBuffer.append(", ");
        stringBuffer.append(sizeConstraint.getSizeAlign());
        stringBuffer.append("f)");
        return stringBuffer.toString();
    }

    public static String getInitString(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("new ");
        stringBuffer.append(basicStroke.getClass().getName());
        stringBuffer.append('(');
        stringBuffer.append(basicStroke.getLineWidth());
        stringBuffer.append("f, ");
        stringBuffer.append(basicStroke.getEndCap());
        stringBuffer.append(", ");
        stringBuffer.append(basicStroke.getLineJoin());
        stringBuffer.append(", ");
        stringBuffer.append(basicStroke.getMiterLimit());
        stringBuffer.append("f, ");
        stringBuffer.append(EditorUtil.getInitString(basicStroke.getDashArray()));
        stringBuffer.append(", ");
        stringBuffer.append(basicStroke.getDashPhase());
        stringBuffer.append("f)");
        return stringBuffer.toString();
    }

    public static String getInitString(SizeSpec sizeSpec) {
        if (sizeSpec == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("new ");
        stringBuffer.append(sizeSpec.getClass().getName());
        stringBuffer.append('(');
        stringBuffer.append(EditorUtil.getInitString(sizeSpec.getMinimumSize()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(sizeSpec.getPreferredSize()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(sizeSpec.getMaximumSize()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getInitString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            Method method = EditorUtil.class.getMethod("getInitString", object.getClass());
            return (String)method.invoke(null, object);
        }
        catch (Exception exception) {
            return "type: " + object.getClass().getName();
        }
    }

    public static String getInitString(PropertyKey propertyKey) {
        if (propertyKey == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(propertyKey.getClass().getName());
        stringBuffer.append(".getKey(\"");
        stringBuffer.append(propertyKey.getName());
        stringBuffer.append("\"");
        if (propertyKey.getValueClass() != null) {
            stringBuffer.append(", ");
            stringBuffer.append(propertyKey.getValueClass().getName());
            stringBuffer.append(".class");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getInitString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("new ");
        stringBuffer.append(objectArray.getClass().getComponentType().getName());
        stringBuffer.append("[] {\n");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("\t\t\t");
            Object object = objectArray[i];
            if (object != null) {
                ArrayList arrayList = EditorUtil.a(object.getClass());
                for (int j = 0; j < arrayList.size(); ++j) {
                    try {
                        Method method = EditorUtil.class.getDeclaredMethod("getInitString", (Class)arrayList.get(j));
                        stringBuffer.append(method.invoke(null, object));
                        break;
                    }
                    catch (Throwable throwable) {
                        if (j != arrayList.size() - 1) continue;
                        stringBuffer.append("new ").append(object.getClass().getName()).append("(unknown parameters)");
                        continue;
                    }
                }
            } else {
                stringBuffer.append("null");
            }
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", \n");
        }
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        if (stringBuffer.length() <= 100) {
            string = string.replaceAll("\\t", "");
            string = string.replaceAll("\\n", "");
        }
        return string;
    }

    private static ArrayList a(Class clazz) {
        ArrayList<Class<Object>> arrayList = new ArrayList<Class<Object>>(4);
        do {
            arrayList.add(clazz);
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        ArrayList arrayList2 = new ArrayList(4);
        for (int i = 0; i < arrayList.size(); ++i) {
            EditorUtil.a((Class)arrayList.get(i), arrayList2);
        }
        if (arrayList2.size() > 0) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static void a(Class clazz, ArrayList arrayList) {
        if (clazz.isInterface()) {
            arrayList.add(clazz);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            EditorUtil.a(classArray[i], arrayList);
        }
    }

    public static String getInitString(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        return "new String[] {" + MigUtil.toCSString(stringArray, "\"", "\"") + "}";
    }

    public static String getInitString(Paint paint) {
        if (paint == null) {
            return "null";
        }
        if (paint instanceof UIColor) {
            return EditorUtil.getInitString((UIColor)paint);
        }
        if (paint instanceof Color) {
            return EditorUtil.getInitString((Color)paint);
        }
        if (paint instanceof ShapeGradientPaint) {
            return EditorUtil.getInitString((ShapeGradientPaint)paint);
        }
        if (paint instanceof XtdTexturePaint) {
            return EditorUtil.getInitString((XtdTexturePaint)paint);
        }
        return "new " + paint.getClass().getName() + "()";
    }

    public static String getInitString(ActivityLayout activityLayout) {
        if (activityLayout == null) {
            return "null";
        }
        if (activityLayout instanceof TimeBoundsLayout) {
            return EditorUtil.getInitString((TimeBoundsLayout)activityLayout);
        }
        if (activityLayout instanceof FlexGridLayout) {
            return EditorUtil.getInitString((FlexGridLayout)activityLayout);
        }
        if (activityLayout instanceof HideLayout) {
            return EditorUtil.getInitString((HideLayout)activityLayout);
        }
        return "new " + activityLayout.getClass().getName() + "()";
    }

    public static String getInitString(TimeBoundsLayout timeBoundsLayout) {
        if (timeBoundsLayout == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("new ");
        stringBuffer.append(timeBoundsLayout.getClass().getName());
        stringBuffer.append('(');
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getShapeGap()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getPrimaryDimCellStart()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getPrimaryDimCellEnd()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getStart()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getEnd()));
        stringBuffer.append(", ");
        stringBuffer.append(timeBoundsLayout.getCategoryGap());
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getPreferredRectangleSize()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getMinimumRectangleSize()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getMaximumRectangleSize()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getLayoutContexts()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(timeBoundsLayout.getVisualDateRangeRounder()));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getInitString(DateRangeRounder dateRangeRounder) {
        if (dateRangeRounder == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("new ");
        stringBuffer.append(dateRangeRounder.getClass().getName());
        stringBuffer.append('(');
        if (dateRangeRounder instanceof BoundaryRounder) {
            BoundaryRounder boundaryRounder = (BoundaryRounder)dateRangeRounder;
            stringBuffer.append(EditorUtil.getRangeTypeInitString(boundaryRounder.getBoundaryType()));
            stringBuffer.append(", ");
            stringBuffer.append(boundaryRounder.getRoundStart());
            stringBuffer.append(", ");
            stringBuffer.append(boundaryRounder.getRoundEnd());
            stringBuffer.append(", ");
            stringBuffer.append(boundaryRounder.getKeepSameLength());
            stringBuffer.append(", ");
            stringBuffer.append(boundaryRounder.getMinimumSize() > -1073741814 ? EditorUtil.getInitString(new Integer(boundaryRounder.getMinimumSize())) : "null");
            stringBuffer.append(", ");
            stringBuffer.append(boundaryRounder.getMaximumSize() < 0x3FFFFFF5 ? EditorUtil.getInitString(new Integer(boundaryRounder.getMaximumSize())) : "null");
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(new Integer(boundaryRounder.getCutAlignment())));
            stringBuffer.append(")");
        } else if (dateRangeRounder instanceof MillisRounder) {
            MillisRounder millisRounder = (MillisRounder)dateRangeRounder;
            stringBuffer.append(millisRounder.getMillis());
            stringBuffer.append(", ");
            stringBuffer.append(millisRounder.getRoundStart());
            stringBuffer.append(", ");
            stringBuffer.append(millisRounder.getRoundEnd());
            stringBuffer.append(", ");
            stringBuffer.append(millisRounder.getKeepSameLength());
            stringBuffer.append(")");
        } else {
            return "new " + dateRangeRounder.getClass().getName() + "()";
        }
        return stringBuffer.toString();
    }

    public static String getInitString(FlexGridLayout flexGridLayout) {
        if (flexGridLayout == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("new ");
        stringBuffer.append(flexGridLayout.getClass().getName());
        stringBuffer.append('(');
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getStartX()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getStartY()));
        stringBuffer.append(", ");
        stringBuffer.append(flexGridLayout.isGoRight());
        stringBuffer.append(", ");
        stringBuffer.append(flexGridLayout.isGoDown());
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getWrapGeometry()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getCellWidth()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getCellHeight()));
        stringBuffer.append(", ");
        stringBuffer.append(flexGridLayout.getVerticalGap());
        stringBuffer.append(", ");
        stringBuffer.append(flexGridLayout.getHorizontalGap());
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getPlaceRect()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(flexGridLayout.getLayoutContexts()));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getInitString(HideLayout hideLayout) {
        if (hideLayout == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("new ");
        stringBuffer.append(hideLayout.getClass().getName());
        stringBuffer.append('(');
        stringBuffer.append(EditorUtil.getInitString(hideLayout.getHideBelow()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(hideLayout.getHideAbove()));
        stringBuffer.append(", ");
        stringBuffer.append(EditorUtil.getInitString(hideLayout.getLayoutContexts()));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getInitString(RangeCount rangeCount) {
        if (rangeCount == null) {
            return "null";
        }
        return "new " + rangeCount.getClass().getName() + "(" + rangeCount.getCount() + ", " + rangeCount.getType() + ")";
    }

    public static String getInitString(Font font) {
        if (font == null) {
            return "null";
        }
        String string = "\"" + font.getName() + "\"";
        return "new " + font.getClass().getName() + "(" + string + ", " + font.getStyle() + ", " + font.getSize() + ")";
    }

    public static String getInitString(Locale locale) {
        if (locale == null) {
            return "null";
        }
        return "new " + locale.getClass().getName() + "(" + locale.getLanguage() + ", " + locale.getCountry() + ", " + locale.getVariant() + ")";
    }

    public static String getInitString(DateFormatList dateFormatList) {
        if (dateFormatList == null) {
            return "null";
        }
        String string = "\"" + dateFormatList.getPattern() + "\"";
        return "new " + dateFormatList.getClass().getName() + "(" + string + ", " + dateFormatList.getLocale() + ")";
    }

    public static String getInitString(ShapeGradientPaint shapeGradientPaint) {
        if (shapeGradientPaint == null) {
            return "null";
        }
        Color color = shapeGradientPaint.getColor1();
        Color color2 = shapeGradientPaint.getColor2();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("new ");
        stringBuffer.append(ShapeGradientPaint.class.getName());
        stringBuffer.append('(');
        if (shapeGradientPaint.getMode() == 0) {
            stringBuffer.append(EditorUtil.getInitString(color));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(color2));
            stringBuffer.append(", ");
            stringBuffer.append(shapeGradientPaint.getAngle());
            stringBuffer.append("f, ");
            stringBuffer.append(shapeGradientPaint.getLength());
            stringBuffer.append("f, ");
            stringBuffer.append(shapeGradientPaint.getAlignment());
            stringBuffer.append(shapeGradientPaint.isCyclic() ? "f, true)" : "f, false)");
        } else {
            stringBuffer.append(EditorUtil.getInitString(shapeGradientPaint.getX1())).append(", ");
            stringBuffer.append(EditorUtil.getInitString(shapeGradientPaint.getY1())).append(", ");
            stringBuffer.append(EditorUtil.getInitString(color)).append(", ");
            stringBuffer.append(EditorUtil.getInitString(shapeGradientPaint.getX2())).append(", ");
            stringBuffer.append(EditorUtil.getInitString(shapeGradientPaint.getY2())).append(", ");
            stringBuffer.append(EditorUtil.getInitString(color2));
            stringBuffer.append(shapeGradientPaint.isCyclic() ? ", true)" : ", false)");
        }
        return stringBuffer.toString();
    }

    public static String getInitString(AtRefRangeNumber atRefRangeNumber) {
        if (atRefRangeNumber == null) {
            return "null";
        }
        Class<?> clazz = atRefRangeNumber.getClass();
        if (clazz == AtFollow.class) {
            return "AtFollow.instance";
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("new ");
        stringBuffer.append(clazz.getName());
        stringBuffer.append('(');
        if (clazz == AtFixed.class) {
            stringBuffer.append(((AtFixed)atRefRangeNumber).getValue());
            stringBuffer.append("f)");
        } else if (clazz == AtFraction.class) {
            stringBuffer.append(((AtFraction)atRefRangeNumber).getFraction());
            stringBuffer.append("f)");
        } else if (clazz == AtOffset.class) {
            stringBuffer.append(((AtOffset)atRefRangeNumber).getOffset());
            stringBuffer.append("f)");
        } else if (clazz == AtStart.class) {
            stringBuffer.append(((AtStart)atRefRangeNumber).getOffset());
            stringBuffer.append("f)");
        } else if (clazz == AtEnd.class) {
            stringBuffer.append(((AtEnd)atRefRangeNumber).getOffset());
            stringBuffer.append("f)");
        } else if (clazz == OperFilter.class) {
            OperFilter operFilter = (OperFilter)atRefRangeNumber;
            stringBuffer.append(EditorUtil.getInitString(operFilter.getWrapped()));
            stringBuffer.append(", ");
            stringBuffer.append(operFilter.getOperation());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(operFilter.getConstraint()));
            stringBuffer.append(", ");
            stringBuffer.append(operFilter.getValue());
            stringBuffer.append("f)");
        } else if (clazz == RefOperFilter.class) {
            RefOperFilter refOperFilter = (RefOperFilter)atRefRangeNumber;
            stringBuffer.append(EditorUtil.getInitString(refOperFilter.getRefWrapped()));
            stringBuffer.append(", ");
            stringBuffer.append(refOperFilter.getOperation());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(refOperFilter.getRefConstraint()));
            stringBuffer.append(", ");
            stringBuffer.append(refOperFilter.getAuxValue());
            stringBuffer.append("f)");
        } else if (clazz == RefRangeOperFilter.class) {
            RefRangeOperFilter refRangeOperFilter = (RefRangeOperFilter)atRefRangeNumber;
            stringBuffer.append(EditorUtil.getInitString(refRangeOperFilter.getRefRangeWrapped()));
            stringBuffer.append(", ");
            stringBuffer.append(refRangeOperFilter.getOperation());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(refRangeOperFilter.getRefRangeConstraint()));
            stringBuffer.append(", ");
            stringBuffer.append(refRangeOperFilter.getAuxValue());
            stringBuffer.append("f)");
        } else {
            return "new " + atRefRangeNumber.getClass().getName() + "()";
        }
        return stringBuffer.toString();
    }

    public static String getInitString(PlaceRect placeRect) {
        if (placeRect == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("new ");
        stringBuffer.append(placeRect.getClass().getName());
        stringBuffer.append('(');
        if (placeRect instanceof AbsRect) {
            AbsRect absRect = (AbsRect)placeRect;
            stringBuffer.append(EditorUtil.getInitString(absRect.getX1()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(absRect.getY1()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(absRect.getX2()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(absRect.getY2()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(absRect.getHorizontalSizeConstraint()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(absRect.getVerticalSizeConstraint()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(absRect.getResize()));
            stringBuffer.append(")");
        } else if (placeRect instanceof AlignRect) {
            AlignRect alignRect = (AlignRect)placeRect;
            stringBuffer.append(EditorUtil.getInitString(alignRect.getXAlign()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(alignRect.getYAlign()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(alignRect.getResize()));
            stringBuffer.append(")");
        } else if (placeRect instanceof AspectRatioRect) {
            AspectRatioRect aspectRatioRect = (AspectRatioRect)placeRect;
            stringBuffer.append(EditorUtil.getInitString(aspectRatioRect.getPlaceRect()));
            stringBuffer.append(", ");
            stringBuffer.append(aspectRatioRect.getMinAspectRatio());
            stringBuffer.append("f, ");
            stringBuffer.append(aspectRatioRect.getMaxAspectRatio());
            stringBuffer.append("f, ");
            stringBuffer.append(aspectRatioRect.getPercent());
            stringBuffer.append("f, ");
            stringBuffer.append(aspectRatioRect.getMode());
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(aspectRatioRect.getAlignmentX()));
            stringBuffer.append(", ");
            stringBuffer.append(EditorUtil.getInitString(aspectRatioRect.getAlignmentY()));
            stringBuffer.append(")");
        } else {
            return "new " + placeRect.getClass().getName() + "()";
        }
        return stringBuffer.toString();
    }

    public static String getInitString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(fArray.length * 6);
        stringBuffer.append("new float[] {");
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(fArray[i]).append('f');
            if (i >= fArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getInitString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(blArray.length * 6);
        stringBuffer.append("new boolean[] {");
        for (int i = 0; i < blArray.length; ++i) {
            stringBuffer.append(blArray[i]);
            if (i >= blArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getInitString(Integer n) {
        return n != null ? "new Integer(" + n + ")" : "null";
    }

    public static String getInitString(Double d) {
        return d != null ? "new Double(" + d + "d)" : "null";
    }

    public static String getInitString(Float f) {
        return f != null ? "new Float(" + f.intValue() + "f)" : "null";
    }

    public static String getInitString(Long l) {
        return l != null ? "new Long(" + l + ")" : "null";
    }

    public static String getInitString(Short s) {
        return s != null ? "new Short(" + s + ")" : "null";
    }

    public static String getInitString(Byte by) {
        return by != null ? "new Byte(" + by + ")" : "null";
    }

    public static String getInitString(Number number) {
        if (number == null) {
            return "null";
        }
        if (number instanceof Integer) {
            return EditorUtil.getInitString((Integer)number);
        }
        if (number instanceof Float) {
            return EditorUtil.getInitString((Float)number);
        }
        if (number instanceof Double) {
            return EditorUtil.getInitString((Double)number);
        }
        if (number instanceof Long) {
            return EditorUtil.getInitString((Long)number);
        }
        if (number instanceof Short) {
            return EditorUtil.getInitString((Short)number);
        }
        if (number instanceof Byte) {
            return EditorUtil.getInitString((Byte)number);
        }
        return "new " + number.getClass().getName() + "(" + number.doubleValue() + "d)";
    }

    public static String getInitString(Insets insets) {
        return insets != null ? "new java.awt.Insets(" + insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + ")" : "null";
    }

    public static String getInitString(XtdImage xtdImage) {
        if (xtdImage == null) {
            return "null";
        }
        String string = xtdImage.getImageContext();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        stringBuffer.append("new ");
        stringBuffer.append(XtdImage.class.getName());
        stringBuffer.append("(\n\t\t\t\"");
        stringBuffer.append(EditorUtil.escapeText(string));
        stringBuffer.append("\",\n\t\t\t");
        stringBuffer.append(xtdImage.getCacheScaledImages());
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(xtdImage.getForceTransparency()));
        stringBuffer.append(",\n\t\t\t");
        stringBuffer.append(EditorUtil.getInitString(xtdImage.getScaleQuality()));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getInitString(Point point) {
        return point != null ? "new java.awt.Point(" + point.x + ", " + point.y + ")" : "null";
    }

    public static void fillSquares(Graphics2D graphics2D, Rectangle rectangle, int n, Color color, Color color2) {
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.setColor(color);
        graphics2D.clip(rectangle);
        graphics2D.fill(rectangle);
        graphics2D.setColor(color2);
        int n2 = 0;
        for (int i = rectangle.x; i < rectangle.width; i += n) {
            n2 = n2 != 0 ? 0 : n;
            for (int j = rectangle.y; j < rectangle.height; j += n << 1) {
                graphics2D.fillRect(i, j + n2, n, n);
            }
        }
        graphics2D.dispose();
    }

    public static boolean addItemExclusive(JComboBox jComboBox, Object object) {
        if (!EditorUtil.hasItem(jComboBox, object)) {
            jComboBox.addItem(object);
            return true;
        }
        return false;
    }

    public static boolean selectAddItem(JComboBox jComboBox, Object object) {
        if (EditorUtil.hasItem(jComboBox, object)) {
            jComboBox.setSelectedItem(object);
            return false;
        }
        jComboBox.addItem(object);
        jComboBox.setSelectedItem(object);
        return true;
    }

    public static void enableDeep(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                EditorUtil.enableDeep(componentArray[i], bl);
            }
        }
    }

    public static boolean hasItem(JComboBox jComboBox, Object object) {
        return ((DefaultComboBoxModel)jComboBox.getModel()).getIndexOf(object) != -1;
    }

    public static InputStream getInputStreamSafe(Component component, StringBuffer stringBuffer) {
        String string = EditorUtil.getPreference("defaultDir", (String)null);
        try {
            if (stringBuffer.length() == 0) {
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setFileFilter(new ThemeEditor.b("tme"));
                if (jFileChooser.showOpenDialog(component) != 0) {
                    return null;
                }
                EditorUtil.setPreference("defaultDir", jFileChooser.getSelectedFile().getAbsolutePath());
                File file = jFileChooser.getSelectedFile();
                stringBuffer.append(file.getAbsolutePath());
            }
            try {
                return new FileInputStream(stringBuffer.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        catch (SecurityException securityException) {
            FileOpenService fileOpenService = null;
            FileContents fileContents = null;
            try {
                fileOpenService = (FileOpenService)ServiceManager.lookup("javax.jnlp.FileOpenService");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            try {
                fileContents = fileOpenService.openFileDialog(string, new String[]{"tme"});
                if (fileContents == null) {
                    return null;
                }
                stringBuffer.append(fileContents.getName());
                EditorUtil.setPreference("defaultDir", fileContents.getName());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            try {
                return fileContents.getInputStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
    }

    public static String saveContentSafe(Component component, String string, byte[] byArray) {
        String string2 = EditorUtil.getPreference("defaultDir", (String)null);
        try {
            Object object;
            if (string == null) {
                object = new JFileChooser(string2);
                ((JFileChooser)object).setFileFilter(new ThemeEditor.b("tme"));
                if (((JFileChooser)object).showSaveDialog(component) != 0) {
                    return null;
                }
                EditorUtil.setPreference("defaultDir", ((JFileChooser)object).getSelectedFile().getAbsolutePath());
                File file = ((JFileChooser)object).getSelectedFile();
                string = file.getAbsolutePath();
                if (string.indexOf(46, Math.max(0, string.length() - 8)) == -1) {
                    string = string + ".tme";
                }
            }
            try {
                object = new FileOutputStream(string);
                ((FileOutputStream)object).write(byArray);
                ((FileOutputStream)object).close();
                return string;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        catch (SecurityException securityException) {
            FileSaveService fileSaveService = null;
            FileContents fileContents = null;
            try {
                fileSaveService = (FileSaveService)ServiceManager.lookup("javax.jnlp.FileSaveService");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            try {
                fileContents = fileSaveService.saveFileDialog(string2, new String[]{"tme"}, new ByteArrayInputStream(byArray), string);
                return fileContents != null ? fileContents.getName() : null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
    }

    public static Rectangle getPreference(String string, Rectangle rectangle) {
        try {
            Preferences preferences = Preferences.userRoot();
            return new Rectangle(preferences.getInt(string + "x", rectangle.x), preferences.getInt(string + "y", rectangle.y), preferences.getInt(string + "w", rectangle.width), preferences.getInt(string + "h", rectangle.height));
        }
        catch (Exception exception) {
            return rectangle;
        }
    }

    public static boolean setPreference(String string, Rectangle rectangle) {
        try {
            Preferences preferences = Preferences.userRoot();
            preferences.putInt(string + "x", rectangle.x);
            preferences.putInt(string + "y", rectangle.y);
            preferences.putInt(string + "w", rectangle.width);
            preferences.putInt(string + "h", rectangle.height);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getPreference(String string, String string2) {
        try {
            return Preferences.userRoot().get(string, string2);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static boolean setPreference(String string, String string2) {
        try {
            if (string2 != null) {
                Preferences.userRoot().put(string, string2);
            } else {
                Preferences.userRoot().remove(string);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

