/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor;

import com.miginfocom.theme.Theme;
import com.miginfocom.theme.ThemeKeyLink;
import com.miginfocom.themeeditor.EditorContainer;
import com.miginfocom.themeeditor.ThemeEditor;
import com.miginfocom.themeeditor.ThemeTreeModel;
import com.miginfocom.util.MigUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ThemeTree
extends JTree
implements MouseListener,
PropertyChangeListener {
    protected ThemeTreeModel themeTreeModel;
    protected final EditorContainer editorContainer;
    private TreePath a = null;

    public ThemeTree(EditorContainer editorContainer, Theme theme) {
        super(new ThemeTreeModel(theme));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.themeTreeModel = (ThemeTreeModel)this.getModel();
        this.editorContainer = editorContainer;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new a());
        editorContainer.addValueChangeListener(this, true);
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ThemeTree.this.setEditorFromSelected();
            }
        });
        this.addMouseListener(this);
    }

    public void setEditorFromSelected() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            String string = (String)treePath.getLastPathComponent();
            ThemeTreeModel themeTreeModel = this.getThemeModel();
            if (themeTreeModel.isLeaf(string)) {
                String string2 = this.getThemeModel().getKeyForPath(treePath);
                Object object = this.getThemeModel().getValueForPath(treePath);
                this.editorContainer.setEditors(ThemeEditor.getPropEditors(string2), object);
                return;
            }
        }
        this.editorContainer.setEditors(null, null);
    }

    public void setTheme(Theme theme) {
        this.themeTreeModel.setTheme(theme);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.getThemeModel().putValueForPath(this.getSelectionPath(), propertyChangeEvent.getNewValue());
        this.repaint();
    }

    public void dispatchMenuCommand(String string, TreePath treePath) {
        if (string.equals("Add Sub Key")) {
            int n = this.getThemeModel().addListKey((String)treePath.getLastPathComponent(), 0x3FFFFFF5, null);
            this.expandPath(treePath);
            this.setSelectionRow(this.getRowForPath(treePath) + n + 1);
        } else if (string.equals("Add Before")) {
            int n = this.addNode(treePath, true);
            this.expandPath(treePath.getParentPath());
            this.setSelectionRow(this.getRowForPath(treePath.getParentPath()) + n + 1);
        } else if (string.equals("Add After")) {
            int n = this.addNode(treePath, false);
            this.expandPath(treePath.getParentPath());
            this.setSelectionRow(this.getRowForPath(treePath.getParentPath()) + n + 1);
        } else if (string.equals("Move Down") || string.equals("Move Up")) {
            String string2 = this.getThemeModel().getKeyForPath(treePath);
            int n = this.getThemeModel().getIndexOfChild(string2, treePath.getLastPathComponent());
            int n2 = this.getThemeModel().moveListKey(string2, n, string.equals("Move Down") ? 1 : -1);
            this.expandPath(treePath.getParentPath());
            this.setSelectionRow(this.getRowForPath(treePath.getParentPath()) + n2 + 1);
        } else if (string.equals("Remove")) {
            String string3 = this.getThemeModel().getKeyForPath(treePath);
            int n = this.getThemeModel().getIndexOfChild(string3, treePath.getLastPathComponent());
            this.getThemeModel().removeListKey(string3, n);
            this.expandPath(treePath.getParentPath());
            this.setSelectionRow(this.getRowForPath(treePath.getParentPath()) + n);
        } else if (string.equals("Set to Default Value")) {
            this.getThemeModel().setToDefault(treePath, false);
            this.setEditorFromSelected();
        } else if (string.equals("Break Link")) {
            ThemeTreeModel themeTreeModel = this.getThemeModel();
            themeTreeModel.putValueForPath(treePath, themeTreeModel.getValueForPath(treePath));
            this.setEditorFromSelected();
        } else if (string.equals("Link to Other Key")) {
            this.a = treePath;
            this.setCursor(DragSource.DefaultLinkDrop);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TreePath treePath = ThemeTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        ThemeTree.this.a = null;
                    } else if (ThemeTree.this.a != null && treePath != null) {
                        String string;
                        String string2 = ThemeTree.this.getThemeModel().getKeyForPath(ThemeTree.this.a);
                        if (!string2.equals(string = ThemeTree.this.getThemeModel().getKeyForPath(treePath)) && ThemeTree.this.getThemeModel().isKeyLinkConnectable(string2, string)) {
                            ThemeTree.this.getThemeModel().putValueForPath(ThemeTree.this.a, new ThemeKeyLink(string));
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        ThemeTree.this.a = null;
                    }
                    if (ThemeTree.this.a == null) {
                        ThemeTree.this.removeMouseListener(this);
                        ThemeTree.this.setCursor(Cursor.getDefaultCursor());
                    }
                    ThemeTree.this.repaint();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (ThemeTree.this.a == null) {
                        ThemeTree.this.removeKeyListener(this);
                    } else if (keyEvent.getKeyCode() == 27) {
                        ThemeTree.this.a = null;
                        ThemeTree.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    String string;
                    String string2;
                    if (ThemeTree.this.a == null) {
                        ThemeTree.this.removeMouseMotionListener(this);
                        return;
                    }
                    TreePath treePath = ThemeTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null && ((string2 = ThemeTree.this.getThemeModel().getKeyForPath(ThemeTree.this.a)).equals(string = ThemeTree.this.getThemeModel().getKeyForPath(treePath)) || !ThemeTree.this.getThemeModel().isKeyLinkConnectable(string2, string))) {
                        ThemeTree.this.setCursor(DragSource.DefaultLinkNoDrop);
                        return;
                    }
                    ThemeTree.this.setCursor(DragSource.DefaultLinkDrop);
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                }
            });
        } else if (string.equals("Goto Linked Key")) {
            this.a(treePath);
        }
    }

    public ThemeTreeModel getThemeModel() {
        return (ThemeTreeModel)this.getModel();
    }

    public int getNodeType(int n) {
        ThemeTreeModel themeTreeModel = this.getThemeModel();
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            Object object = treePath.getLastPathComponent();
            if (themeTreeModel.isLeaf(object)) {
                if (themeTreeModel.isKeyLinked(object)) {
                    return 5;
                }
                Object object2 = themeTreeModel.getValueForPath(treePath);
                if (object2 == null) {
                    return 3;
                }
                String string = themeTreeModel.getKeyForPath(treePath);
                if (!MigUtil.equals(themeTreeModel.getTheme().getDefaultValue(string, true), object2)) {
                    return 4;
                }
                return 2;
            }
            return this.a(n) ? 1 : 0;
        }
        return 2;
    }

    boolean a(int n) {
        String string;
        ThemeTreeModel themeTreeModel = this.getThemeModel();
        TreePath treePath = this.getPathForRow(n);
        if (treePath == null || treePath.getPathCount() < 2) {
            return false;
        }
        Object[] objectArray = treePath.getPath();
        String string2 = (String)objectArray[objectArray.length - 2];
        if (treePath != null && (string = themeTreeModel.getKeyForPath(treePath)) != null) {
            return Theme.isListKey(string) && !Theme.isListKey(string2);
        }
        return false;
    }

    public int addNode(TreePath treePath, boolean bl) {
        Object[] objectArray = treePath.getPath();
        String string = (String)objectArray[objectArray.length - 1];
        String string2 = (String)objectArray[objectArray.length - 2];
        int n = this.getThemeModel().getIndexOfChild(string2, string) + (bl ? 0 : 1);
        this.getThemeModel().addListKey(string2, n, null);
        return n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.a(treePath);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.a(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.a(mouseEvent);
    }

    private void a(MouseEvent mouseEvent) {
        boolean bl;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        final TreePath treePath = this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        Object[] objectArray = treePath.getPath();
        if (objectArray.length < 2) {
            return;
        }
        String string = (String)objectArray[objectArray.length - 1];
        String string2 = (String)objectArray[objectArray.length - 2];
        int n = this.getNodeType(this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()));
        boolean bl2 = Theme.isListKey(string);
        boolean bl3 = Theme.isListKey(string2);
        boolean bl4 = ((ThemeTreeModel)this.getModel()).isLeaf(string);
        boolean bl5 = bl = n == 5;
        if (bl2 || bl4) {
            this.setSelectionPath(treePath);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThemeTree.this.dispatchMenuCommand(actionEvent.getActionCommand(), treePath);
                }
            };
            JMenuItem jMenuItem = null;
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (!bl4 && bl2) {
                jMenuItem = new JMenuItem("Add Sub Key");
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
            }
            if (bl4) {
                jMenuItem = new JMenuItem("Set to Default Value");
                if (n == 4) {
                    jMenuItem.addActionListener(actionListener);
                } else {
                    jMenuItem.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem);
            }
            if (bl3 && bl4) {
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Add Before");
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Add After");
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Move Up");
                jMenuItem.addActionListener(actionListener);
                jMenuItem.setEnabled(this.getThemeModel().getIndexOfChild(string2, string) > 0);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Move Down");
                jMenuItem.addActionListener(actionListener);
                jMenuItem.setEnabled(this.getThemeModel().getIndexOfChild(string2, string) < this.getThemeModel().getChildCount(string2) - 1);
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Remove");
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
            }
            if (bl4 && !bl2 && !bl3) {
                jPopupMenu.addSeparator();
                if (!bl) {
                    jMenuItem = new JMenuItem("Link to Other Key");
                    jMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jMenuItem);
                } else {
                    jMenuItem = new JMenuItem("Goto Linked Key");
                    jMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jMenuItem);
                    jMenuItem = new JMenuItem("Break Link");
                    jMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jMenuItem);
                }
            }
            if (jMenuItem != null) {
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return null;
        }
        ThemeTreeModel themeTreeModel = this.getThemeModel();
        if (themeTreeModel.isKeyLinked(object = treePath.getLastPathComponent())) {
            ThemeKeyLink themeKeyLink = themeTreeModel.getKeyLink(object);
            return "<html>Linked to: <b>" + themeKeyLink.getLinkedKey();
        }
        return null;
    }

    private void a(TreePath treePath) {
        ThemeKeyLink themeKeyLink;
        Object object;
        ThemeTreeModel themeTreeModel = this.getThemeModel();
        if (themeTreeModel.isKeyLinked(object = treePath.getLastPathComponent()) && (themeKeyLink = themeTreeModel.getKeyLink(object)) != null) {
            TreePath treePath2 = themeTreeModel.getPathForKey(themeKeyLink.getLinkedKey());
            this.makeVisible(treePath2);
            this.setSelectionPath(treePath2);
            this.scrollRowToVisible(this.getRowForPath(treePath2));
        }
    }

    static class a
    extends DefaultTreeCellRenderer {
        private static final String[] a = new String[]{"folder.png", "folder_list.png", "leaf.png", "leaf_null.png", "leaf_changed.png", "leaf_link.png"};
        private static Icon[] b = null;
        private final Color c = UIManager.getColor("Label.disabledForeground");

        public a() {
            this.a();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            String string = (String)object;
            int n2 = ((ThemeTree)jTree).getNodeType(n);
            Icon icon = b[n2];
            if (icon != null) {
                jLabel.setIcon(icon);
            }
            if (n2 == 5) {
                jLabel.setForeground(this.c);
            }
            for (int i = string.length() - 2; i >= 0; --i) {
                char c2 = string.charAt(i);
                if (c2 != '/' && c2 != '#') continue;
                string = string.substring(i + 1);
                break;
            }
            if (string.length() > 2 && (string.charAt(string.length() - 1) == '/' || string.charAt(string.length() - 1) == '#')) {
                string = string.substring(0, string.length() - 1);
            }
            jLabel.setText(string);
            return jLabel;
        }

        private synchronized void a() {
            if (b == null) {
                b = new Icon[a.length];
                for (int i = 0; i < b.length; ++i) {
                    URL uRL = this.getClass().getResource("/resources/icons/tree/" + a[i]);
                    if (uRL == null) continue;
                    com.miginfocom.themeeditor.ThemeTree$a.b[i] = new ImageIcon(uRL);
                }
            }
        }
    }
}

