/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor;

import com.miginfocom.theme.Theme;
import com.miginfocom.theme.ThemeKeyLink;
import com.miginfocom.util.ListenerSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ThemeTreeModel
implements TreeModel {
    protected static final String ROOT = "/";
    protected Theme theme;
    private final transient ListenerSet a = new ListenerSet(TreeModelListener.class);

    public ThemeTreeModel(Theme theme) {
        this.theme = theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.fireStructureChanged();
    }

    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public int getChildCount(Object object) {
        if (this.isLeaf(object)) {
            return 0;
        }
        return this.getChildren(object).size();
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getSortedChildList(object).get(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getSortedChildList(object).indexOf(object2);
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object object) {
        String string = object.toString();
        if (string.length() == 0) {
            return false;
        }
        char c2 = string.charAt(string.length() - 1);
        return c2 != '/' && c2 != '#';
    }

    public boolean isKeyLinked(Object object) {
        return this.theme.isLinked(object.toString());
    }

    public ThemeKeyLink getKeyLink(Object object) {
        return this.theme.getLink(object.toString());
    }

    public void removeListKey(String string, int n) {
        this.theme.removeFromList(string, n);
        this.fireStructureChanged();
    }

    public int moveListKey(String string, int n, int n2) {
        int n3 = this.theme.moveListKey(string, n, n2);
        this.fireStructureChanged();
        return n3;
    }

    public int addListKey(String string, int n, Object object) {
        int n2 = this.theme.addToList(string, n, object);
        this.fireStructureChanged();
        return n2;
    }

    protected List getSortedChildList(Object object) {
        ArrayList arrayList = new ArrayList(this.getChildren(object));
        Collections.sort(arrayList);
        return arrayList;
    }

    public void setToDefault(TreePath treePath, boolean bl) {
        this.putValueForPath(treePath, this.getTheme().getDefaultValue((String)treePath.getLastPathComponent(), bl));
    }

    public void putValueForPath(TreePath treePath, Object object) {
        Object[] objectArray = treePath.getPath();
        String string = (String)objectArray[objectArray.length - 1];
        if (string == ROOT) {
            return;
        }
        String string2 = (String)objectArray[objectArray.length - 2];
        if (Theme.isListKey(string2)) {
            this.theme.setInList(string2, this.getIndexOfChild(string2, string), object);
        } else {
            this.theme.putValue(string, object);
        }
    }

    public Object getValueForPath(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        String string = (String)objectArray[objectArray.length - 1];
        if (string == ROOT) {
            return null;
        }
        String string2 = (String)objectArray[objectArray.length - 2];
        if (Theme.isListKey(string2)) {
            return this.theme.getFromList(string2, this.getIndexOfChild(string2, string));
        }
        return this.theme.getValue(string);
    }

    public TreePath getPathForKey(String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add(ROOT);
        while (true) {
            int n2 = string.indexOf(35, n);
            int n3 = string.indexOf(47, n);
            if (n2 == -1 && n3 == -1) break;
            if (n2 == -1) {
                n = n3 + 1;
                arrayList.add(string.substring(0, n));
                continue;
            }
            if (n3 == -1) {
                n = n2 + 1;
                arrayList.add(string.substring(0, n));
                continue;
            }
            n = Math.min(n2, n3) + 1;
            arrayList.add(string.substring(0, n));
        }
        arrayList.add(string);
        return new TreePath(arrayList.toArray(new String[arrayList.size()]));
    }

    public boolean isKeyLinkConnectable(String string, String string2) {
        return this.getTheme().isKeysConnectable(string, string2);
    }

    public String getKeyForPath(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        String string = (String)objectArray[objectArray.length - 1];
        if (string == ROOT) {
            return ROOT;
        }
        String string2 = (String)objectArray[objectArray.length - 2];
        return Theme.isListKey(string2) ? string2 : string;
    }

    protected Set getChildren(Object object) {
        HashSet<String> hashSet;
        block3: {
            int n;
            String string;
            block2: {
                string = object.toString();
                n = object == ROOT ? 0 : string.length();
                hashSet = new HashSet<String>(30);
                if (!Theme.isListKey(string)) break block2;
                List list = this.theme.getList(string, false);
                if (list == null) break block3;
                for (int i = 0; i < list.size(); ++i) {
                    hashSet.add(String.valueOf(i));
                }
                break block3;
            }
            Iterator iterator = this.theme.getKeyIterator();
            while (iterator.hasNext()) {
                int n2;
                String string2;
                String string3 = iterator.next().toString();
                if (object != ROOT && !string3.startsWith(string) || hashSet.contains(string2 = string3.substring(0, (n2 = this.a(string3.substring(n))) + n))) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    private final int a(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 != '/' && c2 != '#') continue;
            return i + 1;
        }
        return n;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.a.add(treeModelListener, false);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener, boolean bl) {
        this.a.add(treeModelListener, bl);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.a.remove(treeModelListener);
    }

    protected void fireStructureChanged() {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{ROOT});
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            ((TreeModelListener)iterator.next()).treeStructureChanged(treeModelEvent);
        }
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

