/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.editors;

import com.miginfocom.theme.PropertyCapability;
import com.miginfocom.themeeditor.DividerBorder;
import com.miginfocom.themeeditor.EditorConfig;
import com.miginfocom.themeeditor.editors.AbstractEditorComponent;
import com.miginfocom.themeeditor.editors.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberEditor
extends AbstractPropertyEditor {
    private static HashMap a = new HashMap();

    public NumberEditor() {
        super(Number.class, true);
    }

    @Override
    public AbstractPropertyEditor getEditorInstance(PropertyCapability propertyCapability) {
        Class clazz = propertyCapability.getType();
        if (clazz != null && Number.class.isAssignableFrom(clazz)) {
            AbstractPropertyEditor abstractPropertyEditor = (AbstractPropertyEditor)a.get(clazz);
            if (abstractPropertyEditor == null) {
                abstractPropertyEditor = new NumberEditor();
                a.put(clazz, abstractPropertyEditor);
            }
            abstractPropertyEditor.setPropertyCapabilities(propertyCapability);
            return abstractPropertyEditor;
        }
        return null;
    }

    @Override
    protected AbstractEditorComponent createEditorComponent() {
        return new a(this.getPropertyCapabilities().getType());
    }

    private class a
    extends AbstractEditorComponent {
        private final JSpinner b;
        private final JSlider c;
        private final JLabel d;
        private final JLabel e;
        private Class f;
        private boolean g;

        private a(final Class clazz) {
            super(new GridBagLayout());
            this.b = new JSpinner();
            this.c = new JSlider(0);
            this.d = new JLabel();
            this.e = new JLabel();
            this.f = clazz;
            this.setBorder(new DividerBorder("Number Properties", 0));
            this.b.setPreferredSize(new Dimension(70, this.b.getPreferredSize().height));
            this.c.setFocusable(false);
            this.c.setPaintLabels(true);
            this.add((Component)this.d, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.add((Component)this.b, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.add((Component)this.e, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0E-4f, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.add((Component)this.c, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 11, 2, new Insets(30, 10, 10, 10), 0, 0));
            this.c();
            this.b.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    a.this.b();
                    ((AbstractPropertyEditor)a.get(clazz)).commitFromComponent();
                }
            });
            this.c.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (!EditorConfig.adjustLive && a.this.c.getModel().getValueIsAdjusting()) {
                        return;
                    }
                    if (!a.this.g) {
                        a.this.a();
                    }
                }
            });
        }

        private void a() {
            if (!this.c.isEnabled()) {
                return;
            }
            int n = this.c.getValue();
            if (this.f == Integer.class) {
                this.b.setValue(new Integer(n));
            } else if (this.f == Long.class) {
                this.b.setValue(new Long(n));
            } else {
                double d = Double.valueOf(NumberEditor.this.getPropertyCapabilities().getMin().toString());
                double d2 = Double.valueOf(NumberEditor.this.getPropertyCapabilities().getMax().toString());
                double d3 = (double)n / 1000.0;
                double d4 = (d2 - d) * d3 + d;
                this.b.setValue(this.f == Double.class ? (Number)new Double(d4) : (Number)new Float(d4));
            }
        }

        private void b() {
            if (!this.c.isEnabled()) {
                return;
            }
            this.g = true;
            float f = ((SpinnerNumberModel)this.b.getModel()).getNumber().floatValue();
            if (this.f == Integer.class || this.f == Long.class) {
                this.c.setValue(Math.round(f));
            } else {
                float f2 = Float.valueOf(NumberEditor.this.getPropertyCapabilities().getMin().toString()).floatValue();
                float f3 = Float.valueOf(NumberEditor.this.getPropertyCapabilities().getMax().toString()).floatValue();
                float f4 = 1000.0f / (f3 - f2);
                this.c.setValue(Math.round((f - f2) * f4));
            }
            this.g = false;
        }

        @Override
        public void setValue(Object object) {
            this.b.setValue(object);
        }

        @Override
        public Object getValue() {
            return this.b.getValue();
        }

        @Override
        public void resetEditorComponent() {
            this.c();
        }

        private void c() {
            PropertyCapability propertyCapability = NumberEditor.this.getPropertyCapabilities();
            Number number = (Number)this.d();
            Comparable comparable = propertyCapability.getMin();
            Comparable comparable2 = propertyCapability.getMax();
            Number number2 = propertyCapability.getStepSize();
            this.c.setEnabled(true);
            if (comparable != null && comparable2 != null) {
                if (this.f == Integer.class) {
                    this.c.setMinimum(((Number)((Object)comparable)).intValue());
                    this.c.setMaximum(((Number)((Object)comparable2)).intValue());
                    this.c.setValue(number.intValue());
                } else if (this.f == Long.class) {
                    if (((Number)((Object)comparable)).longValue() < Integer.MIN_VALUE || ((Number)((Object)comparable2)).longValue() > Integer.MAX_VALUE) {
                        this.c.setEnabled(false);
                        this.c.setValue(0);
                        this.c.setMinimum(0);
                        this.c.setMaximum(0);
                    } else {
                        this.c.setMinimum(((Number)((Object)comparable)).intValue());
                        this.c.setMaximum(((Number)((Object)comparable2)).intValue());
                        this.c.setValue(number.intValue());
                    }
                } else if (this.f == Float.class || this.f == Double.class) {
                    this.c.setMinimum(0);
                    this.c.setMaximum(1000);
                    this.c.setValue(0);
                } else {
                    throw new IllegalArgumentException("Mixed types for AbstractPropertyEditor " + NumberEditor.this.getFriendlyName());
                }
                if (this.c.isEnabled()) {
                    Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                    hashtable.put(new Integer(this.c.getMinimum()), new JLabel(comparable.toString()));
                    hashtable.put(new Integer(0), new JLabel("0"));
                    hashtable.put(new Integer(this.c.getMaximum()), new JLabel(comparable2.toString()));
                    this.c.setLabelTable(hashtable);
                } else {
                    this.c.setLabelTable(null);
                }
            }
            this.b.setModel(new SpinnerNumberModel(number, comparable, comparable2, number2));
            if (this.f == Integer.class || this.f == Long.class) {
                this.b.setEditor(new JSpinner.NumberEditor(this.b, "#"));
            }
            this.d.setText("Value (" + NumberEditor.this.getFriendlyName() + ") :");
            this.e.setText(" (Min: " + (comparable != null ? comparable.toString() : "N/A") + "  Max: " + (comparable2 != null ? comparable2.toString() : "N/A") + ')');
        }

        private Object d() {
            PropertyCapability propertyCapability = NumberEditor.this.getPropertyCapabilities();
            String string = propertyCapability.getMin() != null ? propertyCapability.getMin().toString() : (propertyCapability.getMax() != null ? propertyCapability.getMax().toString() : "10");
            try {
                return propertyCapability.getType().getConstructor(String.class).newInstance(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Wrong format of number: " + string + "  for class: " + propertyCapability.getType());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unknown Number or no (String s) constructor for class: " + propertyCapability.getType());
            }
        }
    }
}

