/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.panels;

import com.miginfocom.themeeditor.panels.ColorPanel;
import com.miginfocom.themeeditor.panels.InsetsPanel;
import com.miginfocom.themeeditor.panels.XtdImagePanel;
import com.miginfocom.util.NameValuePair;
import com.miginfocom.util.gfx.ImageBorder;
import com.miginfocom.util.gfx.SliceSpec;
import com.miginfocom.util.gfx.SoftLineBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BorderPanel
extends JPanel {
    protected static final NameValuePair[] PAINT_TYPES = new NameValuePair[]{new NameValuePair<Integer>("Tile/Shrink", new Integer(100)), new NameValuePair<Integer>("Tile/Cut", new Integer(101)), new NameValuePair<Integer>("Stretch", new Integer(102))};
    public static final String PROP_NAME = "Border";
    public static final String MATTE_BORDER = "MatteBorder";
    public static final String SOFT_LINE_BORDER = "SoftLineBorder";
    public static final String LINE_BORDER = "LineBorder";
    public static final String EMPTY_BORDER = "EmptyBorder";
    public static final String IMAGE_BORDER = "ImageBorder";
    private final JPanel a = new JPanel(new GridBagLayout());
    private final JComboBox b;
    private final ColorPanel c;
    private final JSpinner d;
    private final JSpinner e;
    private final JLabel f = new JLabel("Border Type:");
    private final JLabel g = new JLabel("Thickness:");
    private final JLabel h = new JLabel("Corner Tint (%):");
    private final JLabel i = new JLabel("Border type isn't known and can't be edited. It is preserved and will be saved if selected.");
    private final JCheckBox j = new JCheckBox("Icon:", false);
    private final JButton k = new JButton("");
    private final InsetsPanel l = new InsetsPanel(0);
    private final JCheckBox m = new JCheckBox("Transparent corner", true);
    private final JLabel n = new JLabel("Resize:");
    private final JComboBox o = new JComboBox<NameValuePair>(PAINT_TYPES);
    private final JCheckBox p = new JCheckBox("Paint Center", false);
    private final XtdImagePanel q = new XtdImagePanel();
    private Icon r = null;
    private Border s = null;

    public BorderPanel() {
        super(new GridBagLayout());
        this.setBackground(null);
        this.setBorder(new CompoundBorder(new TitledBorder("Border Properties"), new EmptyBorder(5, 5, 5, 5)));
        this.setBackground(null);
        this.l.setBorder(new CompoundBorder(new TitledBorder("Insets"), new EmptyBorder(0, 10, 10, 10)));
        this.q.setBorder(new CompoundBorder(new TitledBorder("Image Properties"), new EmptyBorder(10, 10, 10, 10)));
        this.b = new JComboBox<String>(new String[]{LINE_BORDER, MATTE_BORDER, SOFT_LINE_BORDER, EMPTY_BORDER, IMAGE_BORDER});
        this.i.setFont(new Font("sansserif", 1, 12));
        this.c = new ColorPanel("Color");
        this.d = new JSpinner(new SpinnerNumberModel(new Integer(1), new Integer(0), new Integer(99), new Integer(1)));
        this.d.setPreferredSize(new Dimension(45, this.d.getPreferredSize().height));
        this.e = new JSpinner(new SpinnerNumberModel(new Integer(20), new Integer(-99), new Integer(99), new Integer(1)));
        this.e.setPreferredSize(new Dimension(45, this.e.getPreferredSize().height));
        this.k.setMaximumSize(new Dimension(40, 30));
        this.k.setPreferredSize(new Dimension(40, 30));
        this.k.setBackground(null);
        this.j.setBackground(null);
        this.m.setBackground(null);
        this.p.setBackground(null);
        this.a.setBackground(null);
        this.a.add((Component)this.f, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.a.add((Component)this.b, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.a, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.l, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.c, new GridBagConstraints(2, 2, 1, 6, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.q, new GridBagConstraints(2, 2, 1, 6, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.g, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.d, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 3, 0, 10), 0, 0));
        this.add((Component)this.h, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.e, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 3, 0, 10), 0, 0));
        this.add((Component)this.j, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.k, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 3, 0, 10), 0, 0));
        this.add((Component)this.m, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.i, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 11, 2, new Insets(30, 5, 0, 10), 0, 0));
        this.add((Component)this.n, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.o, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 3, 0, 10), 0, 0));
        this.add((Component)this.p, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 10), 0, 0));
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Color") || propertyChangeEvent.getPropertyName().equals("Insets")) {
                    BorderPanel.this.firePropertyChange(BorderPanel.PROP_NAME, null, null);
                }
            }
        };
        this.c.addPropertyChangeListener(propertyChangeListener);
        this.l.addPropertyChangeListener(propertyChangeListener);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BorderPanel.this.firePropertyChange(BorderPanel.PROP_NAME, null, null);
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BorderPanel.this.firePropertyChange(BorderPanel.PROP_NAME, null, null);
            }
        };
        this.j.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BorderPanel.this.k.setEnabled(BorderPanel.this.j.isSelected());
                BorderPanel.this.c.setEnabled(!BorderPanel.this.j.isSelected());
                BorderPanel.this.firePropertyChange(BorderPanel.PROP_NAME, null, null);
            }
        });
        this.k.setEnabled(false);
        this.d.addChangeListener(changeListener);
        this.e.addChangeListener(changeListener);
        this.p.addItemListener(itemListener);
        this.m.addItemListener(itemListener);
        this.o.addItemListener(itemListener);
        this.b.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BorderPanel.this.a();
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                if (jFileChooser.showOpenDialog(BorderPanel.this.k) != 0) {
                    return;
                }
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                BorderPanel.this.r = new ImageIcon(string);
                BorderPanel.this.k.setIcon(BorderPanel.this.r);
                BorderPanel.this.firePropertyChange(BorderPanel.PROP_NAME, null, null);
            }
        });
        this.a();
    }

    public Border getBorderValue() {
        String string = this.b.getSelectedItem().toString();
        if (string.equals(LINE_BORDER)) {
            return new LineBorder(this.c.getRBGSpinnerColor(), (Integer)this.d.getValue());
        }
        if (string.equals(MATTE_BORDER)) {
            Insets insets = this.l.getInsetsValue();
            if (this.r != null && this.j.isSelected()) {
                return new MatteBorder(insets, this.r);
            }
            return new MatteBorder(insets, this.c.getRBGSpinnerColor());
        }
        if (string.equals(SOFT_LINE_BORDER)) {
            return new SoftLineBorder(this.c.getRBGSpinnerColor(), ((Integer)this.e.getValue()).floatValue() / 100.0f, this.m.isSelected());
        }
        if (string.equals(EMPTY_BORDER)) {
            return new EmptyBorder(this.l.getInsetsValue());
        }
        if (string.equals(IMAGE_BORDER)) {
            int n = ((NameValuePair)this.o.getSelectedItem()).getValueAsInt();
            boolean[] blArray = this.p.isSelected() ? SliceSpec.OPT_ALL : SliceSpec.OPT_BORDER;
            SliceSpec sliceSpec = new SliceSpec(this.l.getInsetsValue(), n, blArray);
            return new ImageBorder(sliceSpec, this.q.getXtdImage());
        }
        return this.s;
    }

    public String setBorderValue(Border border) {
        if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            this.c.setColor(lineBorder.getLineColor());
            this.d.setValue(new Integer(lineBorder.getThickness()));
            this.b.setSelectedItem(LINE_BORDER);
        } else if (border instanceof SoftLineBorder) {
            SoftLineBorder softLineBorder = (SoftLineBorder)border;
            this.c.setColor(softLineBorder.getColor());
            this.e.setValue(new Integer(Math.round(softLineBorder.getTintPercent() * 100.0f)));
            this.m.setSelected(softLineBorder.isTransparentCorner());
            this.b.setSelectedItem(SOFT_LINE_BORDER);
        } else if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            if (matteBorder.getMatteColor() != null) {
                this.c.setColor(matteBorder.getMatteColor());
            }
            this.l.setInsetsValue(matteBorder.getBorderInsets());
            this.b.setSelectedItem(MATTE_BORDER);
            this.r = matteBorder.getTileIcon();
            this.j.setSelected(this.r != null);
            this.c.setEnabled(this.r == null);
            this.k.setIcon(this.r);
        } else if (border instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)border;
            this.l.setInsetsValue(emptyBorder.getBorderInsets());
            this.b.setSelectedItem(EMPTY_BORDER);
        } else if (border instanceof ImageBorder) {
            ImageBorder imageBorder = (ImageBorder)border;
            this.l.setInsetsValue(imageBorder.getBorderInsets(this));
            this.b.setSelectedItem(IMAGE_BORDER);
        } else {
            String string = border.getClass().getName();
            if (((DefaultComboBoxModel)this.b.getModel()).getIndexOf(string) == -1) {
                this.b.addItem(string);
            }
            this.b.setSelectedItem(string);
            this.s = border;
        }
        return null;
    }

    private void a() {
        Object object = this.b.getSelectedItem();
        boolean bl = object.equals(LINE_BORDER);
        boolean bl2 = object.equals(SOFT_LINE_BORDER);
        boolean bl3 = object.equals(MATTE_BORDER);
        boolean bl4 = object.equals(EMPTY_BORDER);
        boolean bl5 = object.equals(IMAGE_BORDER);
        boolean bl6 = !bl && !bl2 && !bl3 && !bl4 && !bl5;
        this.c.setVisible(bl || bl2 || bl3);
        this.d.setVisible(bl);
        this.g.setVisible(bl);
        this.h.setVisible(bl2);
        this.e.setVisible(bl2);
        this.m.setVisible(bl2);
        this.l.setVisible(bl3 || bl4 || bl5);
        this.q.setVisible(bl5);
        this.p.setVisible(bl5);
        this.o.setVisible(bl5);
        this.n.setVisible(bl5);
        this.j.setVisible(bl3);
        this.k.setVisible(bl3);
        this.i.setVisible(bl6);
        this.firePropertyChange(PROP_NAME, null, null);
    }
}

