/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.panels;

import com.miginfocom.themeeditor.EditorConfig;
import com.miginfocom.themeeditor.panels.PaintButton;
import com.miginfocom.themeeditor.panels.PaintPanel;
import com.miginfocom.util.LicenseValidator;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.UIColor;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorPanel
extends JPanel
implements KeyEventDispatcher {
    public static final String PROP_NAME = "Color";
    private JPanel a = new JPanel(new FlowLayout(2, 0, 2));
    private PaintButton b = new PaintButton("Store Color ->", Color.GRAY);
    private final JComboBox c = new JComboBox<Object>(new Object[]{Color.WHITE});
    private PaintPanel d = new PaintPanel(false, Color.WHITE);
    private JLabel e = new JLabel("R:");
    private JLabel f = new JLabel("G:");
    private JLabel g = new JLabel("B:");
    private JLabel h = new JLabel("A:");
    private JLabel i = new JLabel("H:");
    private JLabel j = new JLabel("S:");
    private JLabel k = new JLabel("B:");
    private JSpinner l = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSpinner m = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSpinner n = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSpinner o = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSpinner p = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSpinner q = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSpinner r = new JSpinner(new SpinnerNumberModel(new Integer(255), new Integer(0), new Integer(255), new Integer(1)));
    private JSlider s = new JSlider(0, 0, 255, 0);
    private JSlider t = new JSlider(0, 0, 255, 0);
    private JSlider u = new JSlider(0, 0, 255, 0);
    private JSlider v = new JSlider(0, 0, 255, 0);
    private TitledBorder w = null;
    private Preferences x = null;
    private boolean y = false;
    private boolean z = false;

    public ColorPanel() {
        this((String)null);
    }

    public ColorPanel(String string) {
        super(new GridBagLayout());
        this.setBackground(null);
        if (string != null) {
            this.w = new TitledBorder(string);
            this.setBorder(new CompoundBorder(this.w, new EmptyBorder(0, 10, 10, 10)));
        }
        this.s.setMinimumSize(new Dimension(128, this.s.getPreferredSize().height));
        this.t.setMinimumSize(new Dimension(128, this.t.getPreferredSize().height));
        this.u.setMinimumSize(new Dimension(128, this.u.getPreferredSize().height));
        this.v.setMinimumSize(new Dimension(128, this.v.getPreferredSize().height));
        this.s.setBackground(null);
        this.t.setBackground(null);
        this.u.setBackground(null);
        this.v.setBackground(null);
        this.h.setToolTipText("Alpha != 255 may reduce performance");
        this.d.setBorder(new LineBorder(Color.DARK_GRAY));
        this.d.setToolTipText("Click to show the Color Chooser");
        this.d.setMinimumSize(new Dimension(100, 70));
        this.c.setRenderer(new a(this.b.getPreferredSize().height - 6));
        try {
            this.x = Preferences.userRoot().node("MigCalendar");
            this.x.addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    ColorPanel.this.a();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a();
        this.a.add(this.b);
        this.a.add(Box.createHorizontalStrut(5));
        this.a.add(this.c);
        if (LicenseValidator.getComponentVersionInt() < 600) {
            this.b.setEnabled(false);
            this.c.setEnabled(false);
        }
        this.add((Component)this.a, new GridBagConstraints(1, 0, 10, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.d, new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 20));
        this.add((Component)this.e, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 2, 0, 0), 0, 0));
        this.add((Component)this.f, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 2, 0, 0), 0, 0));
        this.add((Component)this.g, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 2, 0, 0), 0, 0));
        this.add((Component)this.h, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 2, 0, 0), 0, 0));
        this.add((Component)this.l, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.m, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.n, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.o, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.s, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 3), 0, 0));
        this.add((Component)this.t, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 3), 0, 0));
        this.add((Component)this.u, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 3), 0, 0));
        this.add((Component)this.v, new GridBagConstraints(3, 5, 10, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 3), 0, 0));
        this.add((Component)this.i, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.p, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 3, 0, 5), 0, 0));
        this.add((Component)this.j, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        this.add((Component)this.q, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 5), 0, 0));
        this.add((Component)this.k, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        this.add((Component)this.r, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 5), 0, 0));
        this.a(Color.WHITE, false, false);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ColorPanel.this.z) {
                    ColorPanel.this.a(ColorPanel.this.getRBGSpinnerColor(), true, false);
                }
            }
        };
        ChangeListener changeListener2 = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ColorPanel.this.z) {
                    ColorPanel.this.a(ColorPanel.this.getHSLSpinnerColor(), false, true);
                }
            }
        };
        this.l.addChangeListener(changeListener);
        this.m.addChangeListener(changeListener);
        this.n.addChangeListener(changeListener);
        this.o.addChangeListener(changeListener);
        this.p.addChangeListener(changeListener2);
        this.q.addChangeListener(changeListener2);
        this.r.addChangeListener(changeListener2);
        ChangeListener changeListener3 = new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!EditorConfig.adjustLive && ((JSlider)changeEvent.getSource()).getModel().getValueIsAdjusting()) {
                    return;
                }
                if (ColorPanel.this.z) {
                    return;
                }
                Color color = (Color)ColorPanel.this.d.getPaint();
                Color color2 = ColorPanel.this.getSliderColor();
                if (ColorPanel.this.y) {
                    if (color.getRed() != color2.getRed()) {
                        color2 = GfxUtil.tintColor(color, color2.getRed() - color.getRed());
                    } else if (color.getBlue() != color2.getBlue()) {
                        color2 = GfxUtil.tintColor(color, color2.getBlue() - color.getBlue());
                    } else if (color.getGreen() != color2.getGreen()) {
                        color2 = GfxUtil.tintColor(color, color2.getGreen() - color.getGreen());
                    }
                }
                try {
                    ColorPanel.this.z = true;
                    ColorPanel.this.a(color2, false, false);
                }
                finally {
                    ColorPanel.this.z = false;
                }
            }
        };
        this.s.addChangeListener(changeListener3);
        this.t.addChangeListener(changeListener3);
        this.u.addChangeListener(changeListener3);
        this.v.addChangeListener(changeListener3);
        if (this.x != null) {
            this.b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MigUtil.equals(ColorPanel.this.c.getItemAt(0), ColorPanel.this.d.getPaint())) {
                        return;
                    }
                    ColorPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ColorPanel.this.c.insertItemAt(ColorPanel.this.d.getPaint(), 0);
                    ColorPanel.this.c.setSelectedIndex(0);
                    Paint[] paintArray = new Paint[Math.min(ColorPanel.this.c.getItemCount(), 10)];
                    for (int i = 0; i < paintArray.length; ++i) {
                        paintArray[i] = (Paint)ColorPanel.this.c.getItemAt(i);
                    }
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                        IOUtil.writeXMLObject(byteArrayOutputStream, paintArray);
                        ColorPanel.this.x.putByteArray("stored_colors", byteArrayOutputStream.toByteArray());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ColorPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        this.c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = itemEvent.getItem()) instanceof Color) {
                    ColorPanel.this.a((Color)object, false, false);
                    ColorPanel.this.c.setSelectedItem(null);
                }
            }
        });
        this.d.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Color color;
                if (ColorPanel.this.d.isEnabled() && (color = JColorChooser.showDialog(ColorPanel.this, "Choose a Color...", ColorPanel.this.getRBGSpinnerColor())) != null) {
                    ColorPanel.this.a(color, false, false);
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeNotify() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.removeNotify();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.y = keyEvent.getID() == 401;
        }
        return false;
    }

    private void a() {
        if (this.x == null) {
            return;
        }
        try {
            byte[] byArray = this.x.getByteArray("stored_colors", null);
            if (byArray != null) {
                Object[] objectArray = (Object[])new XMLDecoder(new ByteArrayInputStream(byArray)).readObject();
                this.c.setModel(new DefaultComboBoxModel<Object>(objectArray));
                this.c.setSelectedItem(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Color getRBGSpinnerColor() {
        return new Color((Integer)this.l.getValue(), (Integer)this.m.getValue(), (Integer)this.n.getValue(), (Integer)this.o.getValue());
    }

    public Color getHSLSpinnerColor() {
        return new Color(GfxUtil.HSLtoRGB((float)((Integer)this.p.getValue()).intValue() / 255.0f, (float)((Integer)this.q.getValue()).intValue() / 255.0f, (float)((Integer)this.r.getValue()).intValue() / 255.0f));
    }

    public void setColor(Color color) {
        this.a(color, false, false);
    }

    private void a(Color color, boolean bl, boolean bl2) {
        this.z = true;
        Color color2 = (Color)this.d.getPaint();
        if (!bl) {
            this.l.setValue(new Integer(color.getRed()));
            this.m.setValue(new Integer(color.getGreen()));
            this.n.setValue(new Integer(color.getBlue()));
            this.o.setValue(new Integer(color.getAlpha()));
        }
        if (!bl2) {
            float[] fArray = GfxUtil.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue());
            this.p.setValue(new Integer(Math.round(fArray[0] * 255.0f)));
            this.q.setValue(new Integer(Math.round(fArray[1] * 255.0f)));
            this.r.setValue(new Integer(Math.round(fArray[2] * 255.0f)));
        }
        this.setSliderColor(color);
        this.d.setPaint(color);
        this.b.setIconPaint(color);
        this.firePropertyChange(PROP_NAME, color2, color);
        this.z = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.l.setEnabled(bl);
        this.m.setEnabled(bl);
        this.n.setEnabled(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.q.setEnabled(bl);
        this.r.setEnabled(bl);
        this.s.setEnabled(bl);
        this.t.setEnabled(bl);
        this.u.setEnabled(bl);
        this.v.setEnabled(bl);
        this.e.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.d.setEnabled(bl);
        this.d.setBorder(bl ? new LineBorder(Color.DARK_GRAY) : new LineBorder(Color.GRAY));
        this.w.setTitleColor(bl ? UIManager.getColor("TitledBorder.titleColor") : UIManager.getColor("inactiveCaption"));
    }

    protected Color getSliderColor() {
        return new Color(this.s.getValue(), this.t.getValue(), this.u.getValue(), this.v.getValue());
    }

    protected void setSliderColor(Color color) {
        this.s.setValue(color.getRed());
        this.t.setValue(color.getGreen());
        this.u.setValue(color.getBlue());
        this.v.setValue(color.getAlpha());
    }

    static class a
    implements ListCellRenderer {
        PaintPanel a = new PaintPanel(false);
        Border b = new MatteBorder(1, 1, 1, 1, UIColor.decodeToColor("control"));
        Border c;

        public a(int n) {
            this.a.setPreferredSize(new Dimension(80, n));
            this.a.setBackdropSquareSize(new Dimension(5, 5));
            this.a.setNullString("Stored Colors");
            this.c = new MatteBorder(1, 0, 0, 0, Color.WHITE);
            this.a.setBorder(new LineBorder(Color.GRAY));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Paint paint = (Paint)object;
            this.a.setPaint(paint);
            this.a.setBorder(bl ? this.b : this.c);
            return this.a;
        }
    }
}

