/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.panels;

import com.miginfocom.themeeditor.EditorUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;

public class ImagePanel
extends JComponent {
    LineBorder a = new LineBorder(Color.DARK_GRAY);
    LineBorder b = new LineBorder(Color.GRAY);
    protected Icon image;
    private Integer c = new Integer(10);
    private static final AtRefRangeNumber d = new AtFraction(0.5f);

    public ImagePanel() {
        this(null);
    }

    public ImagePanel(Icon icon) {
        this.setImage(icon);
        this.setBorder(this.a);
        this.setBackground(null);
    }

    public void setImage(Icon icon) {
        if (this.image != icon) {
            this.image = icon;
            this.repaint();
        }
    }

    public Icon getImage() {
        return this.image;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setBorder(bl ? this.a : this.b);
    }

    public Integer getBackdropSquareSize() {
        return this.c;
    }

    public void setBackdropSquareSize(Integer n) {
        this.c = n;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.isEnabled() && this.image != null) {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            if (this.c != null && this.image != null) {
                EditorUtil.fillSquares(graphics2D, rectangle, this.c, Color.WHITE, Color.GRAY);
            } else {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            int n = (this.getWidth() - this.image.getIconWidth()) / 2;
            int n2 = (this.getHeight() - this.image.getIconHeight()) / 2;
            this.image.paintIcon(null, graphics2D, n, n2);
            if (this.image == null) {
                graphics2D.setColor(Color.BLACK);
                GfxUtil.drawStringInRect(graphics2D, "null", rectangle, d, d, 0, true, 9);
            }
        } else {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.isEnabled() ? Color.BLACK : Color.GRAY);
            graphics2D.drawLine(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            graphics2D.drawLine(1, this.getHeight() - 2, this.getWidth() - 2, 1);
        }
        graphics2D.dispose();
    }
}

